//=============================================================================
// VisuStella MZ - Battle Core
// VisuMZ_1_BattleCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_BattleCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.BattleCore = VisuMZ.BattleCore || {};
VisuMZ.BattleCore.version = 1.85;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 1] [Version 1.85] [BattleCore]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Battle_Core_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Battle Core plugin revamps the battle engine provided by RPG Maker MZ to
 * become more flexible, streamlined, and support a variety of features. The
 * updated battle engine allows for custom Action Sequences, battle layout
 * styles, and a lot of control over the battle mechanics, too.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Action Sequence Plugin Commands to give you full control over what happens
 *   during the course of a skill or item.
 * * Animated Sideview Battler support for enemies!
 * * Auto Battle options for party-wide and actor-only instances.
 * * Base Troop Events to quickly streamline events for all Troop events.
 * * Battle Command control to let you change which commands appear for actors.
 * * Battle Layout styles to change the way the battle scene looks.
 * * Casting animation support for skills.
 * * Critical Hit control over the success rate formula and damage multipliers.
 * * Custom target scopes added for skills and items.
 * * Damage formula control, including Damage Styles.
 * * Damage caps, both hard caps and soft caps.
 * * Damage traits such Armor Penetration/Reduction to bypass defenses.
 * * Elements & Status Menu Core support for traits.
 * * Multitude of JavaScript notetags and global Plugin Parameters to let you
 *   make a variety of effects across various instances during battle.
 * * Party Command window can be skipped/disabled entirely.
 * * Weather effects now show in battle.
 * * Streamlined Battle Log to remove redundant information and improve the
 *   flow of battle.
 * * Visual HP Gauges can be displayed above the heads of actors and/or enemies
 *   with a possible requirement for enemies to be defeated at least once first
 *   in order for them to show.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 1 ------
 *
 * This plugin is a Tier 1 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin will overwrite some core parts of the RPG Maker MZ base code in
 * order to ensure the Battle Core plugin will work at full capacity. The
 * following are explanations of what has been changed.
 *
 * ---
 *
 * Action Sequences
 *
 * - Action sequences are now done either entirely by the Battle Log Window or
 * through common events if the <Custom Action Sequence> notetag is used.
 * In RPG Maker MZ by default, Action Sequences would be a mixture of using the
 * Battle Log Window, the Battle Manager, and the Battle Scene, making it hard
 * to fully grab control of the situation.
 *
 * ---
 *
 * Action Speed
 *
 * - Action speeds determine the turn order in the default battle system. The
 * AGI of a battle unit is also taken into consideration. However, the random
 * variance applied to the action speed system makes the turn order extremely
 * chaotic and hard for the player to determine. Thus, the random variance
 * aspect of it has been turned off. This can be reenabled by default through
 * Plugin Parameters => Mechanics Settings => Allow Random Speed?
 *
 * ---
 *
 * Animated Sideview Battler Support For Enemies
 *
 * - Enemies can now use Sideview Actor sprites for themselves! They will
 * behave like actors and can even carry their own set of weapons for physical
 * attacks. These must be set up using notetags. More information can be found
 * in the notetag section.
 *
 * - As the sprites are normally used for actors, some changes have been made
 * to Sprite_Actor to be able to support both actors and enemies. These changes
 * should have minimal impact on other plugins.
 *
 * ---
 *
 * Battle Sprite Updates
 *
 * - A lot of functions in Sprite_Battler, Sprite_Actor, and Sprite_Enemy have
 * been overwritten to make the new Action Sequence system added by this plugin
 * possible. These changes make it possible for the sprites to move anywhere on
 * the screen, jump, float, change visibility, and more.
 *
 * ---
 *
 * Change Battle Back in Battle
 * 
 * - By default, the Change Battle Back event command does not work in battle.
 * Any settings made to it will only reflect in the following battle. Now, if
 * the battle back event command is used during battle, it will reflect upon
 * any new changes immediately.
 *
 * ---
 *
 * Critical Hit - LUK Influence
 *
 * - The LUK Buffs now affect the critical hit rate based off how the formula
 * is now calculated. Each stack of a LUK Buff will double the critical hit
 * rate and compound upon that. That means a x1 LUK Buff stack will raise it by
 * x2, a x2 LUK Buff stack will raise the critical hit rate by x4, a x3 LUK
 * Buff Stack will raise the critical hit rate stack by x8, and so on.
 *
 * - LUK also plays a role in how much damage is dealt with critical hits. The
 * default critical hit multiplier has been reduced from x3 to x2. However, a
 * percentage of LUK will added on (based off the user's CRI rate) onto the
 * finalized critical damage. If the user's CRI rate is 4%, then 4% of the user
 * LUK value will also be added onto the damage.
 *
 * - This change can be altered through Plugin Parameters => Damage Settings =>
 * Critical Hits => JS: Rate Formula and JS: Damage Formula.
 *
 * ---
 * 
 * Damage Popups
 * 
 * - Damage popups are now formatted with + and - to determine healing and
 * damage. MP Damage will also include "MP" at the back. This is to make it
 * clearer what each colored variant of the damage popup means as well as help
 * color blind players read the on-screen data properly.
 * 
 * - Damage popups have also been rewritten to show all changed aspects instead
 * of just one. Previously with RPG Maker MZ, if an action would deal both HP
 * and MP damage, only one of them would show. Now, everything is separated and
 * both HP and MP changes will at a time.
 * 
 * ---
 * 
 * Dual Wielding
 * 
 * - Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 * animations at once, with the combined ATK of each weapon. It's confusing to
 * look at and does not portray the nature of "Dual Wielding".
 * 
 * - Dual Wielding, or in the case of users adding in third and fourth weapons,
 * Multi Wielding is now changed. Each weapon is displayed individually, each
 * producing its own attack animation, showing each weapon type, and applying
 * only that weapon's ATK, Traits, and related effects. It is no longer a
 * combined effect to display everything at once like RPG Maker MZ default.
 * 
 * - If an actor has multiple weapon slots but some of them are unequipped,
 * then the action will treat the attack as a single attack. There will be no
 * barehanded attack to add on top of it. This is to match RPG Maker MZ's
 * decision to omit a second animation if the same scenario is applied.
 * 
 * ---
 *
 * Force Action
 *
 * - Previously, Forced Actions would interrupt the middle of an event to
 * perform an action. However, with the addition of more flexible Action
 * Sequences, the pre-existing Force Action system would not be able to exist
 * and would require being remade.
 *
 * - Forced Actions now are instead, added to a separate queue from the action
 * battler list. Whenever an action and/or common event is completed, then if
 * there's a Forced Action battler queued, then the Forced Action battler will
 * have its turn. This is the cleanest method available and avoids the most
 * conflicts possible.
 *
 * - This means if you planned to make cinematic sequences with Forced Actions,
 * you will need to account for the queued Force Actions. However, in the case
 * of battle cinematics, we would highly recommend that you use the newly added
 * Action Sequence Plugin Commands instead as those give you more control than
 * any Force Action ever could.
 *
 * ---
 *
 * Random Scope
 *
 * - The skill and item targeting scopes for Random Enemy, 2 Random Enemies,
 * 3 Random Enemies, 4 Random Enemies will now ignore TGR and utilize true
 * randomness.
 *
 * ---
 *
 * Spriteset_Battle Update
 *
 * - The spriteset now has extra containers to separate battlers (actors and
 * enemies), animations, and damage. This is to make actors and enemy battler
 * sprites more efficient to sort (if enabled), so that animations won't
 * interfere with and cover damage sprites, and to make sure damage sprites are
 * unaffected by screen tints in order to ensure the player will always have a
 * clear read on the information relaying sprites.
 *
 * ---
 * 
 * TPB/ATB Active Battle Actor Shifting
 * 
 * - Pressing cancel on the Actor Command Window no longer switches between
 * actors with a full TPB/ATB gauge before reaching the Party Command Window.
 * This is to accomplish a couple of things: 1) reduce the number of button
 * presses to reach the Party Command Window and 2) to prevent motion resets
 * and disrupting action sequences. If this feature is vital to your battle
 * system, we recommend that you do not use this plugin or any of the Battle
 * Core-required plugins.
 * 
 * ---
 *
 * Weather Displayed in Battle
 *
 * - Previously, weather has not been displayed in battle. This means that any
 * weather effects placed on the map do not transfer over to battle and causes
 * a huge disconnect for players. The Battle Core plugin will add weather
 * effects to match the map's weather conditions. Any changes made to weather
 * through event commands midway through battle will also be reflected.
 *
 * ---
 *
 * ============================================================================
 * Base Troops
 * ============================================================================
 *
 * Base Troops can be found, declared, and modified in the Plugin Parameters =>
 * Mechanics Settings => Base Troop ID's. All of the listed Troop ID's here
 * will have their page events replicated and placed under all other troops
 * found in the database.
 *
 * ---
 *
 * This means that if you have an event that runs on Turn 1 of a Base Troop,
 * then for every troop out there, that same event will also run on Turn 1,
 * as well. This is useful for those who wish to customize their battle system
 * further and to reduce the amount of work needed to copy/paste said event
 * pages into every database troop object manually.
 *
 * ---
 *
 * ============================================================================
 * Damage Styles
 * ============================================================================
 *
 * Damage Styles are a new feature added through the Battle Core plugin. When
 * using certain Battle Styles, you can completely ignore typing in the whole
 * damage formula inside the damage formula input box, and instead, insert
 * either a power amount or a multiplier depending on the Damage Style. The
 * plugin will then automatically calculate damage using that value factoring
 * in ATK, DEF, MAT, MDF values.
 *
 * ---
 *
 * Here is a list of the Damage Styles that come with this plugin by default.
 * You can add in your own and even edit them to your liking.
 * Or just remove them if you want.
 *
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Style          Use Formula As   PH/MA Disparity   Stat Scale   Damage Scale
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Standard       Formula          No                Varies       Varies
 * ArmorScaling   Formula          No                Varies       Varies
 * CT             Multiplier       Yes               Low          Normal
 * D4             Multiplier       No                High         Normal
 * DQ             Multiplier       No                Low          Low
 * FF7            Power            Yes               Low          High
 * FF8            Power            Yes               Medium       Normal
 * FF9            Power            Yes               Low          Normal
 * FF10           Power            Yes               Medium       High
 * MK             Multiplier       No                Medium       Low
 * MOBA           Multiplier       No                Medium       Normal
 * PKMN           Power            No                Low          Normal
 *
 * Use the above chart to figure out which Damage Style best fits your game,
 * if you plan on using them.
 *
 * The 'Standard' style is the same as the 'Manual' formula input, except that
 * it allows for the support of <Armor Penetration> and <Armor Reduction>
 * notetags.
 *
 * The 'Armor Scaling' style allows you to type in the base damage calculation
 * without the need to type in any defending modifiers.
 *
 * NOTE: While these are based off the damage formulas found in other games,
 * not all of them are exact replicas. Many of them are adapted for use in
 * RPG Maker MZ since not all RPG's use the same set of parameters and not all
 * external multipliers function the same way as RPG Maker MZ.
 * 
 * ---
 *
 * Style:
 * - This is what the Damage Style is.
 *
 * Use Formula As:
 * - This is what you insert into the formula box.
 * - Formula: Type in the formula for the action just as you would normally.
 * - Multiplier: Type in the multiplier for the action.
 *     Use float values. This means 250% is typed out as 2.50
 * - Power: Type in the power constant for the action.
 *     Use whole numbers. Type in something like 16 for a power constant.
 * 
 * PH/MA Disparity:
 * - Is there a disparity between how Physical Attacks and Magical Attacks
 *   are calculated?
 * - If yes, then physical attacks and magical attacks will have different
 *   formulas used.
 * - If no, then physical attacks and magical attacks will share similar
 *   formulas for how they're calculated.
 *
 * Stat Scale:
 * - How much should stats scale throughout the game?
 * - Low: Keep them under 100 for the best results.
 * - Medium: Numbers work from low to mid 400's for best results.
 * - High: The numbers really shine once they're higher.
 *
 * Damage Scale:
 * - How much does damage vary depending on small parameter changes?
 * - Low: Very little increase from parameter changes.
 * - Normal: Damage scales close to proportionally with parameter changes.
 * - High: Damage can boost itself drastically with parameter changes.
 *
 * ---
 *
 * To determine what kind of parameters are used for the Damage Styles, they
 * will depend on two things: the action's 'Hit Type' (ie Physical Attack,
 * Magical Attack, and Certain Hit) and the action's 'Damage Type' (ie. Damage,
 * Recovery, or Drain).
 *
 * Certain Hit tends to use whichever value is higher: ATK or MAT, and then
 * ignores the target's defense values. Use Certain Hits for 'True Damage'.
 *
 * Use the chart below to figure out everything else:
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Hit Type      Damage Type   Attacker Parameter   Defender Parameter
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Physical      Damage        ATK                  DEF
 * Magical       Damage        MAT                  MDF
 * Certain Hit   Damage        Larger (ATK, MAT)    -Ignores-
 * Physical      Recover       DEF                  -Ignores-
 * Magical       Recover       MDF                  -Ignores-
 * Certain Hit   Recover       Larger (ATK, MAT)    -Ignores-
 * Physical      Drain         ATK                  DEF
 * Magical       Drain         MAT                  MDF
 * Certain Hit   Drain         Larger (ATK, MAT)    -Ignores-
 *
 * These can be modified within the Plugin Parameters in the individual
 * Damage Styles themselves.
 *
 * ---
 *
 * Skills and Items can use different Damage Styles from the setting you've
 * selected in the Plugin Parameters. They can be altered to have different
 * Damage Styles through the usage of a notetag:
 *
 * <Damage Style: name>
 *
 * This will use whichever style is found in the Plugin Parameters.
 *
 * If "Manual" is used, then no style will be used and all calculations will be
 * made strictly based off the formula found inside the formula box.
 *
 * ---
 *
 * ============================================================================
 * VisuStella MZ Compatibility
 * ============================================================================
 *
 * While this plugin is compatible with the majority of the VisuStella MZ
 * plugin library, it is not compatible with specific plugins or specific
 * features. This section will highlight the main plugins/features that will
 * not be compatible with this plugin or put focus on how the make certain
 * features compatible.
 *
 * ---
 * 
 * VisuMZ_1_BattleCore
 * 
 * When using Action Sequences, Boost effects for damage, turn extensions,
 * analyze, etc. will not occur for anything other than the Action Sequence:
 * "MECH: Action Effect" in order to maintain controlled effects. However, if
 * you do want to apply bonuses for Boosts, utilize "MECH: Boost Store Data" to
 * store inside a variable how many times Boosts were used. This can be used
 * however which way you want it to as long as it is manageable through events
 * and Common Events.
 * 
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 * 
 * ---
 * 
 * === HP Gauge-Related Notetags ===
 * 
 * The following notetags allow you to set whether or not HP Gauges can be
 * displayed by enemies regardless of Plugin Parameter settings.
 * 
 * ---
 *
 * <Show HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always show the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * - This does not bypass disabling enemy HP Gauges as a whole.
 * 
 * ---
 *
 * <Hide HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always hide the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * 
 * ---
 * 
 * <Battle UI Offset: +x, +y>
 * <Battle UI Offset: -x, -y>
 * 
 * <Battle UI Offset X: +x>
 * <Battle UI Offset X: -x>
 * 
 * <Battle UI Offset Y: +y>
 * <Battle UI Offset Y: -y>
 * 
 * - Used for: Actor and Enemy Notetags
 * - Adjusts the offset of HP Gauges and State Icons above the heads of actors
 *   and enemies.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 * 
 * ---
 *
 * === Animation-Related Notetags ===
 *
 * The following notetags allow you to set animations to play at certain
 * instances and/or conditions.
 *
 * ---
 *
 * <Slip Animation: x>
 *
 * - Requires VisuMZ_0_CoreEngine!
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - During the phase at which the user regenerates HP, MP, or TP, this
 *   animation will play as long as the user is alive and visible.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Cast Animation: x>
 *
 * - Used for: Skill Notetags
 * - Plays a battle animation at the start of the skill.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Attack Animation: x>
 *
 * - Used for: Enemy Notetags
 * - Gives an enemy an attack animation to play for its basic attack.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * === Battleback-Related Notetags ===
 *
 * You can apply these notetags to have some control over the battlebacks that
 * appear in different regions of the map for random or touch encounters.
 *
 * ---
 *
 * <Region x Battleback1: filename>
 * <Region x Battleback2: filename>
 * 
 * - Used for: Map Notetags
 * - If the player starts a battle while standing on 'x' region, then the
 *   'filename' battleback will be used.
 * - Replace 'x' with a number representing the region ID you wish to use.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Castle1.png' will be only inserted
 *   as 'Castle1' without the '.png' at the end.
 * - *NOTE: This will override any specified battleback settings.
 *
 * ---
 *
 * === Battle Command-Related Notetags ===
 *
 * You can use notetags to change how the battle commands of playable
 * characters appear in battle as well as whether or not they can be used.
 *
 * ---
 *
 * <Seal Attack>
 * <Seal Guard>
 * <Seal Item>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Prevents specific battle commands from being able to be used.
 *
 * ---
 *
 * <Battle Commands>
 *  Attack
 *  Skills
 *  SType: x
 *  SType: name
 *  All Skills
 *  Skill: x
 *  Skill: name
 *  Guard
 *  Item
 *  Status
 *  Party
 *  Escape
 *  Auto Battle
 *  Combat Log
 *  Talk
 *  Weapon Swap
 * </Battle Commands>
 *
 * - Used for: Class Notetags
 * - Changes which commands appear in the Actor Command Window in battle.
 *   If this notetag is not used, then the default commands determined in
 *   Plugin Parameters => Actor Command Window => Command List will be used.
 * - Add/remove/modify entries as needed.
 *
 * - Attack 
 *   - Adds the basic attack command.
 * 
 * - Skills
 *   - Displays all the skill types available to the actor.
 * 
 * - SType: x
 * - Stype: name
 *   - Adds in a specific skill type.
 *   - Replace 'x' with the ID of the skill type.
 *   - Replace 'name' with the name of the skill type (without text codes).
 *
 * - All Skills
 *   - Adds all usable battle skills as individual actions.
 * 
 * - Skill: x
 * - Skill: name
 *   - Adds in a specific skill as a usable action.
 *   - Replace 'x' with the ID of the skill.
 *   - Replace 'name' with the name of the skill.
 * 
 * - Guard
 *   - Adds the basic guard command.
 * 
 * - Item
 *   - Adds the basic item command.
 * 
 * - Status
 *   - Adds a status command to view the current inputting actor's status.
 *
 * - Party
 *   - Requires VisuMZ_2_PartySystem.
 *   - Allows this actor to switch out with a different party member.
 * 
 * - Escape
 *   - Adds the escape command.
 * 
 * - Auto Battle
 *   - Adds the auto battle command.
 * 
 * - Combat Log
 *   - Requires VisuMZ_4_CombatLog.
 *   - Opens up the combat log.
 * 
 * - Talk
 *   - Requires VisuMZ_3_BattleCmdTalk!
 *   - Shows talk command if applicable.
 * 
 * - Weapon Swap
 *   - Requires VisuMZ_2_WeaponSwapSystem.
 *   - Swaps the current weapon.
 *
 * Example:
 *
 * <Battle Commands>
 *  Attack
 *  Skill: Heal
 *  Skills
 *  Guard
 *  Item
 *  Escape
 * </Battle Commands>
 *
 * ---
 *
 * <Command Text: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill name text that appears to something else.
 * - Replace 'x' with the skill's name you want to shown in the Actor Battle
 *   Command window.
 * - Recommended Usage: Shorten skill names that are otherwise too big to fit
 *   inside of the Actor Battle Command window.
 *
 * ---
 *
 * <Command Icon: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill icon that appears to something else.
 * - Replace 'x' with the ID of icon you want shown in the Actor Battle Command
 *   window to represent the skill.
 * 
 * ---
 * 
 * <Command Require Learn>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   learned the skill.
 * - Learning the skill is a requirement. Acquiring the skill through traits
 *   does not count as learning the skill.
 * 
 * ---
 * 
 * <Command Require Access>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   access to the skill.
 * - Having access to the skill can come through either learning the skill or
 *   temporarily acquiring it through trait objects.
 * 
 * ---
 * 
 * <Command Show Switch: x>
 * 
 * <Command Show All Switches: x,x,x>
 * <Command Show Any Switches: x,x,x>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be hidden until all
 *   switches are ON. Then, it would be shown.
 * - If 'Any' notetag variant is used, item will be shown if any of the
 *   switches are ON. Otherwise, it would be hidden.
 * - This can be applied to Attack and Guard commands, too.
 * 
 * ---
 * 
 * <Command Hide Switch: x>
 * 
 * <Command Hide All Switches: x,x,x>
 * <Command Hide Any Switches: x,x,x>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be shown until all
 *   switches are ON. Then, it would be hidden.
 * - If 'Any' notetag variant is used, item will be hidden if any of the
 *   switches are ON. Otherwise, it would be shown.
 * - This can be applied to Attack and Guard commands, too.
 * 
 * ---
 * 
 * <Battle Portrait: filename>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" Battle Layout.
 * - Sets the battle portrait image for the actor to 'filename'.
 * - Replace 'filename' with a picture found within your game project's
 *   img/pictures/ folder. Filenames are case sensitive. Leave out the filename
 *   extension from the notetag.
 * - This will override any menu images used for battle only.
 * 
 * ---
 * 
 * <Battle Portrait Offset: +x, +y>
 * <Battle Portrait Offset: -x, -y>
 * 
 * <Battle Portrait Offset X: +x>
 * <Battle Portrait Offset X: -x>
 * 
 * <Battle Portrait Offset Y: +y>
 * <Battle Portrait Offset Y: -y>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" and "Border" Battle Layouts.
 * - Offsets the X and Y coordinates for the battle portrait.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 * 
 * ---
 *
 * <Help Description>
 *  text
 *  text
 * </Help Description>
 *
 * - Used for: State Notetags
 * - Assigns a help description for the state that's displayed under the
 *   "Status" actor command.
 * - Replace 'text' with text you want displayed for the help window.
 * - This best works with one line for compatibility with other plugins.
 * - Insert %1 into the help description to show any data that would otherwise
 *   be shown as the state display, such as Absorption Barrier count.
 * - This is used as a common notetag between Battle Core's state descriptions
 *   and State Tooltips' state descriptions.
 * 
 * ---
 * 
 * <In-Battle Status Description>
 *  text
 *  text
 * </In-Battle Status Description>
 * - Assigns a help description for the state that's displayed under the
 *   "Status" actor command.
 * - Replace 'text' with text you want displayed for the help window.
 * - This best works with one line for compatibility with other plugins.
 * - Insert %1 into the help description to show any data that would otherwise
 *   be shown as the state display, such as Absorption Barrier count.
 * - The description used here will not be used for State Tooltips.
 * - If both <Help Description> and <In-Battle Status Description> notetags
 *   exist in the same state, priority will be given to this one for the
 *   In-Battle Status Window.
 *
 * ---
 * 
 * <Exclude From Status Listing>
 * 
 * - Used for: State Notetags
 * - Excludes the state from being displayed in the status listing.
 * 
 * ---
 * 
 * === JavaScript Notetag: Battle Command-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine if skill-based battle commands are visible or hidden.
 * 
 * ---
 * 
 * <JS Command Visible>
 *  code
 *  code
 *  visible = code;
 * </JS Command Visible>
 * 
 * - Used for: Skill Notetags
 * - The 'visible' variable is the final returned variable to determine the
 *   skill's visibility in the Battle Command Window.
 * - Replace 'code' with JavaScript code to determine the skill's visibility in
 *   the Battle Command Window.
 * - The 'user' variable represents the user who will perform the skill.
 * - The 'skill' variable represents the skill to be used.
 * 
 * ---
 *
 * === Targeting-Related Notetags ===
 *
 * The following notetags are related to the targeting aspect of skills and
 * items and may adjust the scope of how certain skills/items work.
 *
 * ---
 *
 * <Always Hit>
 *
 * <Always Hit Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - Causes the action to always hit or to always have a hit rate of exactly
 *   the marked x%.
 * - Replace 'x' with a number value representing the hit success percentage.
 *
 * ---
 *
 * <Repeat Hits: x>
 *
 * - Used for: Skill, Item Notetags
 * - Changes the number of hits the action will produce.
 * - Replace 'x' with a number value representing the number of hits to incur.
 *
 * ---
 *
 * <Target: x Random Any>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - Targets can be both actors and enemies.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Enemies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Targets are only enemies.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Allies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Targets are only actors.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: All Allies But User>
 *
 * - Used for: Skill, Item Notetags
 * - Targets all allies with the exception of the user.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 *
 * ---
 * 
 * <Target: Ally or Enemy>
 * 
 * - Used for: Skill, Item Notetags
 * - Allows the player to target allies or enemies with the skill/item.
 *   - Keep in mind this does NOT allow you to select dead party members.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Target selection emphasis will go to allies first.
 * - Ignored when used by enemies and will be treated as an ally scope.
 * - Auto-battle actors will also treat this action as an ally scope.
 * - For certain battle layouts in frontview, this will open the Actor Select
 *   window in order for Touch Input to be able to select actors.
 * 
 * ---
 * 
 * <Target: Enemy or Ally>
 * 
 * - Used for: Skill, Item Notetags
 * - Allows the player to target enemies or allies with the skill/item.
 *   - Keep in mind this does NOT allow you to select dead party members.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Target selection emphasis will go to enemies first.
 * - Ignored when used by enemies and will be treated as an enemy scope.
 * - Auto-battle actors will also treat this action as an enemy scope.
 * - For certain battle layouts in frontview, this will open the Actor Select
 *   window in order for Touch Input to be able to select actors.
 * 
 * ---
 * 
 * <Single or Multiple Select>
 * 
 * - Used for: Skill, Item Notetags
 * - Requires an original scope that can select individual targets.
 * - This will allow the skill/item to be able to select either single targets
 *   or multiple targets at once.
 *   - In order to select "all enemies", the player must press the "Page Up"
 *     keyboard button or the visual on screen "All Enemies" button.
 *   - In order to select "all allies", the player must press the "Page Down"
 *     keyboard button or the visual on screen "All Allies" button.
 *   - Those wondering why this isn't regulated to a command left or right of
 *     the enemies and actors is because mouse controls and touch controls
 *     would not be able to select all enemies or all allies that way.
 *   - This can NOT be used with single dead ally scopes.
 * - If there is an enemy with Taunt or Provoke, the option to select
 *   "All Enemies" does not become possible.
 * - The enemy AI and Auto-Battle actor AI will NOT make use of the ability to
 *   toggle between single and multiple target scopes. They will only use the
 *   single target versions of these skills.
 * 
 * ---
 * 
 * <Disperse Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - This will cause any damage dealt by this skill to be split equally amongst
 *   all targets of the skill including repeats.
 *   - For basic attacks, any damage reduction added attack trait totals will
 *     by reverted.
 * - This does NOT have to be used with <Single or Multiple Select> notetag and
 *   can be used by itself for an "All" scope, making the skill/item deal less
 *   damage if there's more enemies and more damage if there's less enemies.
 * 
 * ---
 * 
 * <Cannot Target User>
 * 
 * - Used for: Skill, Item Notetags
 * - This will cause the action to be unable to select the user as the target.
 * - This is not a targeting scope. Instead, it is used in addition to any
 *   other targeting scopes out there.
 * - When used with "All" scopes, the user is removed from the target pool.
 * - This is also applied outside of battle.
 * - If the user somehow enters the target pool, the user is then replaced by
 *   a random ally found in the party.
 * 
 * ---
 *
 * === JavaScript Notetag: Targeting-Related ===
 *
 * ---
 * 
 * <JS Accuracy>
 *  code
 *  code
 *  rate = code;
 * </JS Accuracy>
 * 
 * - Used for: Skill, Item Notetags
 * - Only applies during battle.
 * - The 'rate' variable is the final returned amount to determine the
 *   accuracy hit success rate.
 *   - Base value comes from Game_Action.itemHit
 *   - Skill/Item <JS Accuracy> runs
 *   - Then <JS Accuracy as User/Target> notetags run
 * - Replace 'code' with JavaScript code to determine the final 'rate' to be
 *   returned as the accuracy hit success rate.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - Works best with VisuMZ Core Engine's "Improved Accuracy" QoL formula in
 *   order to consolidate both HIT and EVA.
 * 
 * ---
 * 
 * <JS Accuracy as User>
 *  code
 *  code
 *  rate = code;
 * </JS Accuracy as User>
 * 
 * <JS Accuracy as Target>
 *  code
 *  code
 *  rate = code;
 * </JS Accuracy as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Only applies during battle.
 * - The 'rate' variable is the final returned amount to determine the
 *   accuracy hit success rate.
 *   - Base value comes from Game_Action.itemHit
 *   - Skill/Item <JS Accuracy> runs
 *   - Then <JS Accuracy as User/Target> notetags run
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * 
 * ---
 * 
 * <JS Targets>
 *  code
 *  code
 *  targets = [code];
 * </JS Targets>
 *
 * - Used for: Skill, Item Notetags
 * - The 'targets' variable is an array that is returned to be used as a
 *   container for all the valid action targets.
 * - The 'targets' variable will include the original set of targets determined
 *   by the skill/item's original scale.
 * - If you wish to clear it out, simply do 'targets = []' first.
 * - Replace 'code' with JavaScript code to determine valid targets.
 *
 * ---
 *
 * === Damage-Related Notetags ===
 *
 * ---
 *
 * <Damage Style: name>
 *
 * - Used for: Skill, Item Notetags
 * - Replace 'name' with a Damage Style name to change the way calculations are
 *   made using the damage formula input box.
 * - Names can be found in Plugin Parameters => Damage Settings => Style List
 *
 * ---
 *
 * <Armor Reduction: x>
 * <Armor Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Armor Penetration: x>
 * <Armor Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Magic Reduction: x>
 * <Magic Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Magic Penetration: x>
 * <Magic Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Bypass Damage Cap>
 * 
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage capped.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage capped.
 *
 * ---
 *
 * <Damage Cap: x>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will declare the hard damage cap to
 *   be the 'x' value.
 * - If used on trait objects, this will raise the affect unit's hard damage
 *   cap to 'x' value. If another trait object has a higher value, use that
 *   value instead.
 *
 * ---
 *
 * <Bypass Soft Damage Cap>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage scaled downward to the soft cap.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage scaled downward to the soft cap.
 *
 * ---
 *
 * <Soft Damage Cap: +x%>
 * <Soft Damage Cap: -x%>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will increase/decrease the action's
 *   soft cap by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 * - If used on trait objects, this will raise the affect unit's soft damage
 *   limit by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 *
 * ---
 *
 * <Unblockable>
 *
 * - Used for: Skill, Item Notetags
 * - Using "Guard" against this skill will not reduce any damage.
 *
 * ---
 * 
 * <Popup Position: Head>
 * <Popup Position: Center>
 * <Popup Position: Base>
 * 
 * - Used for: Enemy Notetags
 * - Determines the popup starting position for this enemy.
 *   - Head makes the popups start at the top of the ennemy.
 *   - Center makes the popups start at the center of the ennemy.
 *   - Base makes the popups start at the bottom of the ennemy.
 * - If this notetag is not used, refer to the default Plugin Parameter setting
 *   found in Damage Settings.
 * 
 * ---
 * 
 * <Popup Offset X: +x>
 * <Popup Offset X: -x>
 * <Popup Offset Y: +y>
 * <Popup Offset Y: -y>
 * 
 * - Used for: Enemy Notetags
 * - Alters the popup x/y position offset for this enemy.
 * - Replace 'x' with a number representing the horizontal position x offset.
 *   - Negative: left. Positive: right.
 * - Replace 'y' with a number representing the vertical position y offset.
 *   - Negative: up. Positive: down.
 * - If these notetags are not used, refer to the default Plugin Parameter
 *   settings found in Damage Settings.
 * 
 * ---
 *
 * === Critical-Related Notetags ===
 *
 * The following notetags affect skill and item critical hit rates and the
 * critical damage multiplier.
 *
 * ---
 *
 * <Always Critical>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always land a critical hit regardless of the
 *   user's CRI parameter value.
 *
 * ---
 *
 * <Set Critical Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always have a x% change to land a critical hit
 *   regardless of user's CRI parameter value.
 * - Replace 'x' with a percerntage value representing the success rate.
 *
 * ---
 *
 * <Modify Critical Rate: x%>
 * <Modify Critical Rate: +x%>
 * <Modify Critical Rate: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - Modifies the user's CRI parameter calculation for this skill/item.
 * - The 'x%' notetag variant will multiply the user's CRI parameter value
 *   for this skill/item.
 * - The '+x%' and '-x%' notetag variants will incremenetally increase/decrease
 *   the user's CRI parameter value for this skill/item.
 *
 * ---
 *
 * <Modify Critical Multiplier: x%>
 * <Modify Critical Multiplier: +x%>
 * <Modify Critical Multiplier: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the damage multiplier when a critical hit lands.
 * - The 'x%' notetag variant multiply the multiplier to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the multiplier with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * <Modify Critical Bonus Damage: x%>
 * <Modify Critical Bonus Damage: +x%>
 * <Modify Critical Bonus Damage: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the bonus damage added when a critical hit lands.
 * - The 'x%' notetag variant multiply the damage to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the bonus damage with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * === JavaScript Notetags: Critical-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine how critical hit-related aspects are calculated.
 *
 * ---
 *
 * <JS Critical Rate>
 *  code
 *  code
 *  rate = code;
 * </JS Critical Rate>
 *
 * - Used for: Skill, Item Notetags
 * - The 'rate' variable is the final returned amount to determine the
 *   critical hit success rate.
 *   - Base value comes from Game_Action.itemCri
 *   - Skill/Item <JS Critical Rate> runs
 *   - Then <JS Critical Rate as User/Target> notetags run
 * - Replace 'code' with JavaScript code to determine the final 'rate' to be
 *   returned as the critical hit success rate.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Critical Rate as User>
 *  code
 *  code
 *  rate = code;
 * </JS Critical Rate as User>
 *
 * <JS Critical Rate as Target>
 *  code
 *  code
 *  rate = code;
 * </JS Critical Rate as Target>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Only applies during battle.
 * - The 'rate' variable is the final returned amount to determine the
 *   critical hit success rate.
 *   - Base value comes from Game_Action.itemCri
 *   - Skill/Item <JS Critical Rate> runs
 *   - Then <JS Critical Rate as User/Target> notetags run
 * - Replace 'code' with JavaScript code to determine the final 'rate' to be
 *   returned as the critical hit success rate.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Critical Damage>
 *  code
 *  code
 *  multiplier = code;
 *  bonusDamage = code;
 * </JS Critical Damage>
 *
 * - Used for: Skill, Item Notetags
 * - The 'multiplier' variable is returned later and used as the damage
 *   multiplier used to amplify the critical damage amount.
 * - The 'bonusDamage' variable is returned later and used as extra added
 *   damage for the critical damage amount.
 * - Replace 'code' with JavaScript code to determine how the 'multiplier' and
 *   'bonusDamage' variables are calculated.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 * 
 * === Life Steal-Related Notetags ===
 * 
 * ---
 * 
 * <HP Life Steal: x%>
 * <MP Life Steal: x%>
 * 
 * - Used for: Skill, Item Notetags
 * - Causes this skill/item to have Life Steal properties, allowing the user to
 *   take x% of the HP/MP Damage as recovered HP/MP.
 *   - HP Life Steal can only take HP from dealt HP damage.
 *   - MP Life Steal can only take MP from dealt MP damage.
 * - Replace 'x' with a number representing the percentage of the dealt damage
 *   used as HP/MP recovery.
 * - This cannot be used with skills/items with HP Drain/MP Drain. Life Steal
 *   is a different mechanic from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <HP Life Steal Certain Hit: +x%>
 * <HP Life Steal Physical Hit: +x%>
 * <HP Life Steal Magical Hit: +x%>
 * 
 * <HP Life Steal Certain Hit: -x%>
 * <HP Life Steal Physical Hit: -x%>
 * <HP Life Steal Magical Hit: -x%>
 * 
 * <MP Life Steal Certain Hit: +x%>
 * <MP Life Steal Physical Hit: +x%>
 * <MP Life Steal Magical Hit: +x%>
 * 
 * <MP Life Steal Certain Hit: -x%>
 * <MP Life Steal Physical Hit: -x%>
 * <MP Life Steal Magical Hit: -x%>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - The related battler's various trait properties can have passive life steal
 *   properties that will trigger upon using skills/items with matching hit
 *   types regardless of whether or not the skill/item innately has Life Steal.
 *   - Notetag variants with "Certain Hit" will only trigger from "Certain Hit"
 *     skill and item types. Same with "Physical" and "Magical" variants.
 *   - HP Life Steal can only take HP from dealt HP damage.
 *   - MP Life Steal can only take HP from dealt MP damage.
 * - Replace 'x' with a number representing the additive stacking percentage
 *   boost of the dealt damage used as HP/MP recovery. The effects will stack
 *   additively with other trait objects.
 * - This cannot be used with skills/items with HP Drain/MP Drain. Life Steal
 *   is a different mechanic from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Cancel Life Steal>
 * 
 * <Cancel HP Life Steal>
 * <Cancel MP Life Steal>
 * 
 * - Used for: Skill, Item Notetags
 * - Prevents this skill from allowing Life Steal effects to occur including
 *   the passive life steal calculators from the skill/item user.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Guard Life Steal>
 * 
 * <Guard HP Life Steal>
 * <Guard MP Life Steal>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - If the related battler becomes the target of Life Steal, this will prevent
 *   the Life Steal effects from taking effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Disarm Life Steal>
 * 
 * <Disarm HP Life Steal>
 * <Disarm MP Life Steal>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - Makes the related battler unable to HP/MP Life Steal regardless of the
 *   skill/item and its related properties like equipment.
 * - This does not prevent skills/items with innate Life Steal from being used.
 *   Only the Life Steal part of the skill/item will have no effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Negative Life Steal>
 * 
 * <Negative HP Life Steal>
 * <Negative MP Life Steal>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - If the related battler becomes the target of Life Steal, this will invert
 *   the healing properties of Life Steal, causing the Life Steal user to
 *   instead take HP/MP damage.
 *   - This does NOT heal the target related battler.
 * - This does not prevent skills/items with innate Life Steal from being used.
 *   Only the Life Steal part of the skill/item will have no effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 *
 * === Action Sequence-Related Notetags ===
 *
 * Action Sequences allow you full control over how a skill and/or item plays
 * through its course. These notetags give you control over various aspects of
 * those Action Sequences. More information is found in the Action Sequences
 * help section.
 *
 * ---
 *
 * <Custom Action Sequence>
 *
 * - Used for: Skill, Item Notetags
 * - Removes all automated Action Sequence parts from the skill.
 * - Everything Action Sequence-related will be done by Common Events.
 * - Insert Common Event(s) into the skill/item's effects list to make use of
 *   the Custom Action Sequences.
 * - This will prevent common events from loading in the Item Scene and Skill
 *   Scene when used outside of battle.
 *
 * ---
 * 
 * <Auto Action Sequence>
 * 
 * - Used for: Skill, Item Notetags
 * - If the Action Sequence Plugin Parameter "Auto Notetag" is enabled, this
 *   plugin will prevent custom action sequences from happening for the skill
 *   or item, and instead, use an Automatic Action Sequence instead.
 * - Ignore this if you have "Auto Notetag" disabled or set to false. By
 *   default, this setting is set to false. Please be aware of the changes
 *   you've made to your game before using it.
 * 
 * ---
 * 
 * <Bypass Auto Action Sequence>
 * 
 * - Used for: Skill, Item Notetags
 * - This notetag is used for the game devs that have the Action Sequence
 *   Plugin Parameter "Auto Notetag" on for applying <Custom Action Sequence>
 *   to everything.
 * - This will allow items and skills to be able to launch their common
 *   events from the menu scene regardless of the inherent restriction to
 *   prevent action sequence based skills/items with common events from
 *   launching.
 * - Ignore this if you have "Auto Notetag" disabled or set to false. By
 *   default, this setting is set to false. Please be aware of the changes
 *   you've made to your game before using it.
 * 
 * ---
 * 
 * <Common Event: name>
 *
 * - Used for: Skill, Item Notetags
 * - Battle only: calls forth a Common Event of a matching name.
 * - Replace 'name' with the name of a Common Event to call from when this
 *   skill/item is used in battle.
 *   - Remove any \I[x] in the name.
 * - Insert multiple notetags to call multiple Common Events in succession.
 * - This will occur after any Common Event Trait Effects for the skill/item's
 *   database entry.
 * - This is primarily used for users who are reorganizing around their Common
 *   Events and would still like to have their skills/items perform the correct
 *   Action Sequences in case the ID's are different.
 * 
 * ---
 *
 * <Display Icon: x>
 * <Display Text: string>
 *
 * - Used for: Skill, Item Notetags
 * - When displaying the skill/item name in the Action Sequence, determine the
 *   icon and/or text displayed.
 * - Replace 'x' with a number value representing the icon ID to be displayed.
 * - Replace 'string' with a text value representing the displayed name.
 *
 * ---
 * 
 * <Common Event Key: name>
 * <Common Event Keys: name, name, name>
 * 
 * <Common Event Keys>
 *  key
 *  key
 *  key
 * </Common Event Keys>
 * 
 * - Used for: Skill, Item Notetags
 * - Will generate Common Events for the skill/item with a corresponding key.
 * - Replace 'name' with the name of the Common Event's key that you want to
 *   reference. That key will be converted into a Common Event effect for the
 *   skill/item and be treated as an action sequence.
 *   - The notetag variants that use multiple keys will have the keys added in
 *     the order they are listed.
 *   - If keys do not reference any Common Events, no Common Events will be
 *     added for that key.
 * - To mark a Common Event with a key, insert inside a Common Event's name the
 *   [ and ] brackets around the text that will be used as the Common Event's
 *   key text.
 *   - For example, if Common Event's name is "Penta Slash [PENTA]", then the
 *     key used is "PENTA" without the quotes.
 *   - This key could then be referenced by <Common Event Key: PENTA> notetag.
 *   - Do not use commas (,) inside the key text as it will be automatically
 *     removed for the sake of consistency.
 * - This feature is made for make the process of sharing Action Sequences to
 *   become easier without needing to line up Common Event ID's.
 * 
 * ---
 *
 * === Animated Sideview Battler-Related Notetags ===
 *
 * Enemies can use Animated Sideview Actor graphics thanks to this plugin.
 * These notetags give you control over that aspect. Some of these also affect
 * actors in addition to enemies.
 *
 * ---
 *
 * <Sideview Battler: filename>
 *
 * <Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Replaces the enemy's battler graphic with an animated Sideview Actor
 *   graphic found in the img/sv_actors/ folder.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Sideview Battlers>
 *
 * ---
 *
 * <Sideview Anchor: x, y>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets the sprite anchor positions for the sideview sprite.
 * - Replace 'x' and 'y' with numbers depicting where the anchors should be for
 *   the sideview sprite.
 * - By default, the x and y anchors are 0.5 and 1.0.
 *
 * ---
 * 
 * <Sideview Home Offset: +x, +y>
 * <Sideview Home Offset: -x, -y>
 * 
 * - Used for: Actor, Class, Weapon, Armor, State Notetags
 * - Offsets the sideview actor sprite's home position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * - This notetag will not work if you remove it from the JavaScript code in
 *   Plugin Parameters > Actor > JS:  Home Position
 * 
 * ---
 * 
 * <Sideview Weapon Offset: +x, +y>
 * <Sideview Weapon Offset: -x, -y>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy State Notetags
 * - Offsets the sideview weapon sprite's position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * 
 * ---
 *
 * <Sideview Show Shadow>
 * <Sideview Hide Shadow>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets it so the sideview battler's shadow will be visible or hidden.
 *
 * ---
 * 
 * <Sideview Shadow Scale: x%>
 * <Sideview Shadow Scale: x.y>
 * 
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - This affects both the X and Y scale.
 * 
 * ---
 * 
 * <Sideview Shadow Scale X: x%>
 * <Sideview Shadow Scale X: x.y>
 * 
 * <Sideview Shadow Scale Y: x%>
 * <Sideview Shadow Scale Y: x.y>
 * 
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - These affect their respective X and Y scales separately.
 * 
 * ---
 *
 * <Sideview Collapse>
 * <Sideview No Collapse>
 *
 * - Used for: Enemy Notetags
 * - Either shows the collapse graphic or does not show the collapse graphic.
 * - Collapse graphic means the enemy will 'fade away' once it's defeated.
 * - No collapse graphic means the enemy's corpse will remain on the screen.
 *
 * ---
 *
 * <Sideview Idle Motion: name>
 *
 * <Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Changes the default idle motion for the enemy.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Idle Motions>
 *  walk: 25
 *  wait: 50
 *  guard
 *  victory
 *  abnormal
 * </Sideview Idle Motions>
 *
 * ---
 *
 * <Sideview Size: width, height>
 *
 * - Used for: Enemy Notetags
 * - When using a sideview battler, its width and height will default to the
 *   setting made in Plugin Parameters => Enemy Settings => Size: Width/Height.
 * - This notetag lets you change that value to something else.
 * - Replace 'width' and 'height' with numbers representing how many pixels
 *   wide/tall the sprite will be treated as.
 * - This does NOT change the image size. This only changes the HITBOX size.
 *
 * ---
 *
 * <Sideview Weapon: weapontype>
 *
 * <Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Give your sideview enemies weapons to use.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Sideview Weapons>
 *
 * ---
 *
 * <traitname Sideview Battler: filename>
 *
 * <traitname Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </traitname Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have a unique appearance.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Male Sideview Battlers>
 *
 * <Female Sideview Battlers>
 *  Actor1_2: 25
 *  Actor1_4: 10
 *  Actor1_6
 *  Actor1_8
 * </Female Sideview Battlers>
 *
 * ---
 *
 * <traitname Sideview Idle Motion: name>
 *
 * <traitname Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </traitname Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique idle motions.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Jolly Sideview Idle Motions>
 *  wait: 25
 *  victory: 10
 *  walk
 * </Jolly Sideview Idle Motions>
 *
 * <Serious Sideview Idle Motions>
 *  walk: 25
 *  guard: 10
 *  wait
 * </Jolly Sideview Idle Motions>
 *
 * ---
 *
 * <traitname Sideview Weapon: weapontype>
 *
 * <traitname Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </traitname Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique weapons.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Male Sideview Weapons>
 *
 * <Female Sideview Weapons>
 *  Dagger: 25
 *  Spear: 25
 *  Cane
 * </Female Sideview Weapons>
 *
 * ---
 *
 * === Enemy-Related Notetags ===
 *
 * ---
 *
 * <Battler Sprite Cannot Move>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to move, jump, and/or float due to
 *   Action Sequences. Useful for rooted enemies.
 *
 * ---
 * 
 * <Battler Sprite Grounded>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to jumping and/or floating due to
 *   Action Sequences but still able to move. Useful for rooted enemies.
 * 
 * ---
 *
 * <Swap Enemies>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Swap Enemies>
 *
 * - Used for: Enemy Notetags
 * - Causes this enemy database object to function as a randomizer for any of
 *   the listed enemies inside the notetag. When the enemy is loaded into the
 *   battle scene, the enemy is immediately replaced with one of the enemies
 *   listed. The randomization is based off the 'weight' given to each of the
 *   enemy 'names'.
 * - Replace 'name' with the database enemy of the enemy you wish to replace
 *   the enemy with.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Swap Enemies>
 *  Bat: 50
 *  Slime: 25
 *  Orc
 *  Minotaur
 * </Swap Enemies>
 *
 * ---
 * 
 * <Aspect Name: name>
 * 
 * - Used for: Enemy Notetags
 * - Changes enemy's aspect name shown in the In-Battle Status and other
 *   supported plugin menus.
 *   - Requires <Aspect Description> in order to show.
 * - Replace 'name' with text for how enemy aspect should be renamed.
 * 
 * ---
 * 
 * <Aspect Color: color>
 * 
 * - Used for: Enemy Notetags
 * - Changes enemy's aspect name color shown in the In-Battle Status and other
 *   supported plugin menus.
 *   - Requires <Aspect Description> in order to show.
 * - Replace 'color' with either a number from 0 to 31 representing the text
 *   color or in the format of '#rrggbb' to custom pick a hex color.
 * 
 * ---
 * 
 * <Aspect Icon: x>
 * 
 * - Used for: Enemy Notetags
 * - Changes enemy's aspect icon shown in the In-Battle Status and other
 *   supported plugin menus.
 *   - Requires <Aspect Description> in order to show.
 * - Replace 'x' with a number representing the icon index used to represent
 *   the enemy aspect.
 * 
 * ---
 * 
 * <Aspect Description>
 *  text
 *  text
 * </Aspect Description>
 * 
 * - Used for: Enemy Notetags
 * - Changes enemy's aspect description shown in the In-Battle Status and other
 *   supported plugin menus.
 * - Replace 'text' with the text you would like to appear as a description for
 *   the enemy's aspect.
 * 
 * ---
 *
 * === JavaScript Notetags: Mechanics-Related ===
 *
 * These JavaScript notetags allow you to run code at specific instances during
 * battle provided that the unit has that code associated with them in a trait
 * object (actor, class, weapon, armor, enemy, or state). How you use these is
 * entirely up to you and will depend on your ability to understand the code
 * used and driven for each case.
 *
 * ---
 *
 * <JS Pre-Start Battle>
 *  code
 *  code
 *  code
 * </JS Pre-Start Battle>
 *
 * <JS Post-Start Battle>
 *  code
 *  code
 *  code
 * </JS Post-Start Battle>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of battle aimed at the function:
 *   BattleManager.startBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Turn>
 *  code
 *  code
 *  code
 * </JS Pre-Start Turn>
 *
 * <JS Post-Start Turn>
 *  code
 *  code
 *  code
 * </JS Post-Start Turn>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of a turn aimed at the function:
 *   BattleManager.startTurn()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Action>
 *  code
 *  code
 *  code
 * </JS Pre-Start Action>
 *
 * <JS Post-Start Action>
 *  code
 *  code
 *  code
 * </JS Post-Start Action>
 * 
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action aimed at the function:
 *   BattleManager.startAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Apply>
 *  code
 *  code
 *  code
 * </JS Pre-Apply>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Apply as User>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as User>
 *
 * <JS Pre-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Damage>
 *  code
 *  code
 *  code
 * </JS Pre-Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage being calculated up to this
 *   point (if any) and any changes made to the 'value' variable will reflect
 *   on the damage dealt/healed, too.
 *
 * ---
 *
 * <JS Pre-Damage as User>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as User>
 *
 * <JS Pre-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage being calculated up to this
 *   point (if any) and any changes made to the 'value' variable will reflect
 *   on the damage dealt/healed, too.
 *
 * ---
 *
 * <JS Post-Damage>
 *  code
 *  code
 *  code
 * </JS Post-Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage/healing that has been last
 *   dealt through this action.
 *
 * ---
 *
 * <JS Post-Damage as User>
 *  code
 *  code
 *  code
 * </JS Post-Damage as User>
 *
 * <JS Post-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Post-Damage as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage/healing that has been last
 *   dealt through this action.
 *
 * ---
 *
 * <JS Post-Apply>
 *  code
 *  code
 *  code
 * </JS Post-Apply>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Apply as User>
 *  code
 *  code
 *  code
 * </JS Post-Apply as User>
 *
 * <JS Post-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Post-Apply as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 *
 * ---
 *
 * <JS Pre-End Action>
 *  code
 *  code
 *  code
 * </JS Pre-End Action>
 *
 * <JS Post-End Action>
 *  code
 *  code
 *  code
 * </JS Post-End Action>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action aimed at the function:
 *   BattleManager.endAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Turn>
 *  code
 *  code
 *  code
 * </JS Pre-End Turn>
 *
 * <JS Post-End Turn>
 *  code
 *  code
 *  code
 * </JS Post-End Turn>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of a turn aimed at the function:
 *   Game_Battler.prototype.onTurnEnd()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Regenerate>
 *  code
 *  code
 *  code
 * </JS Pre-Regenerate>
 *
 * <JS Post-Regenerate>
 *  code
 *  code
 *  code
 * </JS Post-Regenerate>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a unit regenerates HP/MP aimed at the function:
 *   Game_Battler.prototype.regenerateAll()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Victory>
 *  code
 *  code
 *  code
 * </JS Battle Victory>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is won aimed at the function:
 *   BattleManager.processVictory()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Success>
 *  code
 *  code
 *  code
 * </JS Escape Success>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping succeeds aimed at the function:
 *   BattleManager.onEscapeSuccess()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Failure>
 *  code
 *  code
 *  code
 * </JS Escape Failure>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping fails aimed at the function:
 *   BattleManager.onEscapeFailure()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Defeat>
 *  code
 *  code
 *  code
 * </JS Battle Defeat>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is lost aimed at the function:
 *   BattleManager.processDefeat()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Battle>
 *  code
 *  code
 *  code
 * </JS Pre-End Battle>
 *
 * <JS Post-End Battle>
 *  code
 *  code
 *  code
 * </JS Post-End Battle>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when the battle is over aimed at the function:
 *   BattleManager.endBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 * 
 * === Battle Layout-Related Notetags ===
 * 
 * These tags will change the battle layout for a troop regardless of how the
 * plugin parameters are set up normally. Insert these tags in either the
 * noteboxes of maps or the names of troops for them to take effect. If both
 * are present for a specific battle, then priority goes to the setting found
 * in the troop name.
 * 
 * ---
 * 
 * <Layout: type>
 * <Battle Layout: type>
 * 
 * - Used for: Map Notetags, Troop Name Tags, and Troop Comment Tags
 * - Changes the battle layout style used for this specific map or battle.
 * - Replace 'type' with 'default', 'list', 'xp', 'portrait', or 'border'.
 * - Those with VisuMZ_3_FrontviewBattleUI can use 'frontview'.
 * - Those with VisuMZ_3_SideviewBattleUI can use 'sideview'.
 * - If using Troop Comment Tags, then as long as the tag appears in a comment
 *   found on any of the Troop's pages (even if they don't run), the tag will
 *   be considered in effect.
 * 
 * ---
 * 
 * === Troop Size Tags ===
 * 
 * ---
 * 
 * <Extend: x>
 * <Extend: x, x, x>
 * 
 * - Used for: Troop Name Tags and Troop Comment Tags
 * - Adds enemies from another troop to the current troop.
 * - Enemies from another troop will retain their database positions.
 * - Replace 'x' with the ID of the database troop entry you wish to add enemy
 *   members from.
 *   - Insert multiple x's to add from more troops.
 * - Extended troop members will be added in the order they're listed.
 * - Be cautious of how many enemies you add as too many will lag the battle
 *   system. We are not responsible for frame drops due to this.
 * 
 * ---
 * 
 * === Troop Comment Tags ===
 * 
 * Place these tags inside of a comment found in a troop page's event list.
 * 
 * ---
 * 
 * <Once Parallel When Start Battle>
 * 
 * - Used for: Troop Page Comment Tags
 * - Causes the troop page to immediately load the moment the battle scene
 *   begins to fade in (not after it fades in). This is faster than a turn 0
 *   condition troop page. Troop page conditions are ignored.
 * - This can be used for things like the Action Sequence Camera plugin, the
 *   Visual Battle Environment plugin, and/or initial battle poses and such in
 *   order to provide a near seamless battle transition experience.
 * - This does NOT trigger when coming out of the options menu or party menu.
 * - This WILL trigger when going from battle to battle nonstop via plugins
 *   like VisuStella MZ's Chain Battles.
 * - When actors are moving towards their home positions, it will take around
 *   30 frames by default. Use this information however you like.
 * 
 * ---
 *
 * ============================================================================
 * Action Sequence - Plugin Commands
 * ============================================================================
 *
 * Skills and items, when used in battle, have a pre-determined series of
 * actions to display to the player as a means of representing what's going on
 * with the action. For some game devs, this may not be enough and they would
 * like to get more involved with the actions themselves.
 *
 * Action Sequences, added through this plugin, enable this. To give a skill or
 * item a Custom Action Sequence, a couple of steps must be followed:
 *
 * ---
 *
 * 1. Insert the <Custom Action Sequence> notetag into the skill or item's
 *    notebox (or else this would not work as intended).
 * 2. Give that skill/item a Common Event through the Effects box. The selected
 *    Common Event will contain all the Action Sequence data.
 * 3. Create the Common Event with Action Sequence Plugin Commands and/or event
 *    commands to make the skill/item do what you want it to do.
 *
 * ---
 *
 * The Plugin Commands added through the Battle Core plugin focus entirely on
 * Action Sequences. However, despite the fact that they're made for skills and
 * items, some of these Action Sequence Plugin Commands can still be used for
 * regular Troop events and Common Events.
 *
 * ---
 *
 * === Action Sequence - Action Sets ===
 *
 * Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * ---
 *
 * ACSET: Setup Action Set
 * - The generic start to most actions.
 *
 *   Display Action:
 *   Immortal: On:
 *   Battle Step:
 *   Wait For Movement:
 *   Cast Animation:
 *   Wait For Animation:
 *   - Use this part of the action sequence?
 *
 * ---
 *
 * ACSET: All Targets Action Set
 * - Affects all targets simultaneously performing the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 * 
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait For Animation:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Each Target Action Set
 * - Goes through each target one by one to perform the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 *
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait Count:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Finish Action
 * - The generic ending to most actions.
 *
 *   Wait For New Line:
 *   Wait For Effects:
 *   Clear Battle Log:
 *   Home Reset:
 *   Wait For Movement:
 *   - Use this part of the action sequence?
 *
 * ---
 * 
 * === Action Sequences - Angle ===
 * 
 * These action sequences allow you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * ---
 *
 * ANGLE: Change Angle
 * - Changes the camera angle.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Angle:
 *   - Change the camera angle to this many degrees.
 *
 *   Duration:
 *   - Duration in frames to change camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Reset Angle
 * - Reset any angle settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Wait For Angle
 * - Waits for angle changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Animations ===
 *
 * These Action Sequences are related to the 'Animations' that can be found in
 * the Animations tab of the Database.
 *
 * ---
 *
 * ANIM: Action Animation
 * - Plays the animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation
 * - Plays the animation associated with the user's weapon.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation 2+
 * - Plays the animation associated with the user's other weapons.
 * - Plays nothing if there is no other weapon equipped.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Slot:
 *   - Which weapon slot to get this data from?
 *   - Main-hand weapon is weapon slot 1.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 * 
 * ANIM: Balloon Animation
 * - Plays a balloon animation on target(s).
 * 
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Balloon Type:
 *   - What kind of balloon should be played on target(s)?
 * 
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 * 
 * ---
 * 
 * ANIM: Balloon Icon (Single)
 * - Plays a balloon animation using an icon on target(s).
 * - Requires VisuMZ_4_IconBalloons!
 * 
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Icon Index:
 *   - Insert the ID of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 * 
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 * 
 * ---
 * 
 * ANIM: Balloon Icon (Range)
 * - Plays a balloon animation an icon range on target(s).
 * - Requires VisuMZ_4_IconBalloons!
 * 
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Starting Icon Index:
 *   - Insert the ID of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 * 
 *   Ending Icon Index:
 *   - Insert the ID of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 * 
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 * 
 * ---
 * 
 * ANIM: Balloon Icon (Specific)
 * - Plays a balloon animation with specific icons on target(s).
 * - Requires VisuMZ_4_IconBalloons!
 * 
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Icons:
 *   - Insert the ID(s) of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 * 
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 * 
 * ---
 *
 * ANIM: Cast Animation
 * - Plays the cast animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Change Battle Portrait
 * - Changes the battle portrait of the actor (if it's an actor).
 * - Can be used outside of battle/action sequences.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *   - Valid units can only be actors.
 *
 *   Filename:
 *   - Select the file to change the actor's portrait to.
 * 
 * ---
 *
 * ANIM: Change Battle Portrait (JS)
 * - Changes the battle portrait of the actor through JavaScript.
 * - Can be used outside of battle/action sequences.
 * 
 *   JS: Actor ID:
 *   - Enter which Actor ID to affect.
 *   - Uses JavaScript code.
 * 
 *   JS: Filename:
 *   - Enter the filename you wish to use.
 *   - Uses JavaScript code.
 * 
 * ---
 *
 * ANIM: Guard Animation
 * - Plays the animation associated with the user's guard action (if any).
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Item Animation
 * - Plays the animation associated with a specific item.
 * 
 *   Item ID:
 *   - Which item ID will the animation come from?
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Play at Coordinate
 * - Plays an animation on the screen at a specific x, y coordinate.
 * - Requires VisuMZ_0_CoreEngine!
 * 
 *   Animation ID:
 *   - Plays this animation.
 * 
 *   Coordinates:
 * 
 *     X:
 *     Y:
 *     - X/Y coordinate used for the animation.
 *       You may use JavaScript code.
 * 
 *   Mirror Animation?:
 *   - Mirror the animation?
 * 
 *   Mute Animation?:
 *   - Mute the animation?
 * 
 *   Wait for Completion?:
 *   - Wait the animation to finish before continuing?
 *
 * ---
 *
 * ANIM: Show Animation
 * - Plays the a specific animation on unit(s).
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Animation ID:
 *   - Select which animation to play on unit(s).
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Show Animation JS
 * - Plays the a specific animation on unit(s).
 * - Uses JavaScript to determine animation ID.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   JS: Animation ID:
 *   - Select which animation to play on unit(s).
 *   - Uses JavaScript to determine animation ID.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Skill Animation
 * - Plays the animation associated with a specific skill.
 * 
 *   Skill ID:
 *   - Which skill ID will the animation come from?
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Wait For Animation
 * - Causes the interpreter to wait for any animation(s) to finish.
 *
 * ---
 *
 * === Action Sequences - Battle Log ===
 *
 * These Action Sequences are related to the Battle Log Window, the window
 * found at the top of the battle screen.
 *
 * ---
 *
 * BTLOG: Add Text
 * - Adds a new line of text into the Battle Log.
 *
 *   Text:
 *   - Add this text into the Battle Log.
 *   - Text codes allowed.
 * 
 *   Copy to Combat Log?:
 *   - Copies text to the Combat Log.
 *   - Requires VisuMZ_4_CombatLog
 * 
 *     Combat Log Icon:
 *     - What icon would you like to bind to this entry?
 *     - Requires VisuMZ_4_CombatLog
 *
 * ---
 *
 * BTLOG: Clear Battle Log
 * - Clears all the text in the Battle Log.
 *
 * ---
 *
 * BTLOG: Display Action
 * - plays the current action in the Battle Log.
 *
 * ---
 *
 * BTLOG: Pop Base Line
 * - Removes the Battle Log's last added base line and  all text up to its
 *   former location.
 *
 * ---
 *
 * BTLOG: Push Base Line
 * - Adds a new base line to where the Battle Log currently is at.
 *
 * ---
 *
 * BTLOG: Refresh Battle Log
 * - Refreshes the Battle Log.
 *
 * ---
 *
 * BTLOG: UI Show/Hide
 * - Shows or hides the Battle UI (including the Battle Log).
 *
 *   Show/Hide?:
 *   - Shows/hides the Battle UI.
 *
 * ---
 *
 * BTLOG: Wait For Battle Log
 * - Causes the interpreter to wait for the Battle Log to finish.
 *
 * ---
 *
 * BTLOG: Wait For New Line
 * - Causes the interpreter to wait for a new line in the Battle Log.
 *
 * ---
 *
 * === Action Sequences - Camera ===
 *
 * These Action Sequences are battle camera-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * CAMERA: Clamp ON/OFF
 * - Turns battle camera clamping on/off.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Setting:
 *   - Turns camera clamping on/off.
 *
 * ---
 *
 * CAMERA: Focus Point
 * - Focus the battle camera on a certain point in the screen.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   X Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Y Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Focus Target(s)
 * - Focus the battle camera on certain battler target(s).
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Targets:
 *   - Select unit(s) to focus the battle camera on.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Offset
 * - Offset the battle camera from the focus target.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Offset X:
 *   - How much to offset the camera X by.
 *   - Negative: left. Positive: right.
 *
 *   Offset Y:
 *   - How much to offset the camera Y by.
 *   - Negative: up. Positive: down.
 *
 *   Duration:
 *   - Duration in frames for offset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Reset
 * - Reset the battle camera settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Reset Focus?:
 *   - Reset the focus point?
 *
 *   Reset Offset?:
 *   - Reset the camera offset?
 *
 *   Duration:
 *   - Duration in frames for reset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Wait For Camera
 * - Waits for camera changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 * 
 * === Action Sequences - Cutins ===
 * 
 * Allows you to have control over Visual Cutin Effects.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * ---
 * 
 * CUTIN: Add Visual Cutin Effect
 * - Adds the Visual Cutin Effect using these desired settings.
 * - Only one of each cutin-style type can be present at a time.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 *   Basic Settings:
 * 
 *     Cutin Style Type:
 *     - What Visual Cutin Effect style type do you wish to use?
 *     - Only one of each cutin-style type can be present.
 *     - Refer to VisuMZ wiki for visuals on styles.
 * 
 *     Portrait Target:
 *     - Select unit(s) to grab the Visual Cutin Effect portrait data from.
 *     - First unit will be used to make portrait.
 * 
 *     Parallax Filename:
 *     - Pick a parallax to use for the Visual Cutin Effect.
 *     - Pick (None) to not use a parallax.
 * 
 *     Background Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors from
 *       the Window Skin.
 *
 *   Extra Settings:
 *   - Extra Plugin Command settings pertaining to this Visual Cutin Effect.
 *   - An explanation for these settings are found in the Visual Cutin Effect
 *     help file and documentation.
 *   - Extra parameters are added for Parallax Scroll Inversion when the target
 *     is an enemy.
 * 
 *   Wait for Entrance:
 *   - Wait until cutin entrance is finished before performing the next
 *     event command?
 * 
 * ---
 *
 * CUTIN: End Visual Cutin Effect (All)
 * - Ends all Visual Cutin Effects currently present.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 *   Wait for Exit:
 *   - Wait until cutin exit is finished before performing the next
 *     event command?
 *
 * ---
 *
 * CUTIN: End Visual Cutin Effect (Type)
 * - Ends the Visual Cutin Effect with the matching type.
 * - Requires VisuMZ_3_VisualCutinEffect!
 *
 *   Cutin Style Type:
 *   - What Visual Cutin Effect style type do you wish to end?
 * 
 *   Wait for Exit:
 *   - Wait until cutin exit is finished before performing the next
 *     event command?
 *
 * ---
 * 
 * CUTIN: Wait for Cutin Entrance
 * - Wait until all cutin entrances are finished before performing the next
 *   event command.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 * ---
 * 
 * CUTIN: Wait for Cutin Exit
 * - Wait until all cutin exits are finished before performing the next
 *   event command.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 * ---
 *
 * === Action Sequences - Dragonbones ===
 *
 * These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * ---
 *
 * DB: Dragonbones Animation
 * - Causes the unit(s) to play a Dragonbones motion animation.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Motion Animation:
 *   - What is the name of the Dragonbones motion animation you wish to play?
 *
 * ---
 *
 * DB: Dragonbones Time Scale
 * - Causes the unit(s) to change their Dragonbones time scale.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Time Scale:
 *   - Change the value of the Dragonbones time scale to this.
 *
 * ---
 *
 * === Action Sequences - Elements ===
 *
 * These Action Sequences can change up the element(s) used for the action's
 * damage calculation midway through an action.
 *
 * They also require the VisuMZ_1_ElementStatusCore plugin to be present in
 * order for them to work.
 *
 * ---
 *
 * ELE: Add Elements
 * - Adds element(s) to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to add onto the action.
 *   - Insert multiple element ID's to add multiple at once.
 *
 * ---
 *
 * ELE: Clear Element Changes
 * - Clears all element changes made through Action Sequences.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 *
 * ELE: Force Elements
 * - Forces only specific element(s) when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to force in the action.
 *   - Insert multiple element ID's to force multiple at once.
 *
 * ---
 *
 * ELE: Null Element
 * - Forces no element to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 * 
 * === Action Sequences - Grid ===
 * 
 * These Action Sequences are Battle Grid System-related.
 * Requires VisuMZ_2_BattleGridSystem!
 * 
 * ---
 * 
 * GRID: Action Animation at Node
 * - Plays action animation at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 * 
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 *
 * GRID: Add Passive State(s) to Node
 * - Adds Passive State(s) at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   State ID(s):
 *   - Select which State ID(s) to add as a Passive State.
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to add the Passive State Node effect for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to add a
 *       Passive State(s) to.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to add a
 *       Passive State(s) to.
 *
 * ---
 * 
 * GRID: Add Trigger to Node
 * - Adds Trigger to target node.
 * - Target node cannot have battler.
 * - Each node can only contain ONE trigger! 
 * - Otherwise, newly placed triggers will overwrite the old ones.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Skill ID:
 *   - Select which Skill ID(s) to add as the trigger.
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit do you want to add the Trigger Node effect for?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to add a
 *       Trigger to.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to add a
 *       Trigger to.
 * 
 * ---
 * 
 * GRID: Add Trigger to Node JS
 * - Adds JS Trigger to target node.
 * - Target node cannot have battler.
 * - Each node can only contain ONE trigger! 
 * - Otherwise, newly placed triggers will overwrite the old ones.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   JS: Skill ID:
 *   - Use JavaScript to determine what skill ID to add to this node.
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit do you want to add the Trigger Node effect for?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to add a
 *       Trigger to.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to add a
 *       Trigger to.
 * 
 * ---
 * 
 * GRID: Animation ID at Node
 * - Plays specific animation ID at target node.
 * 
 *   Animation ID:
 *   - Play this animation at target node.
 * 
 *     Mirror?:
 *     - Mirror this animation?
 * 
 *     Mute?:
 *     - Mute this animation?
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 * 
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 * 
 * GRID: Animation JS at Node
 * - Uses JS to calculate which animation to play at target node.
 * 
 *   JS: Animation ID:
 *   - Calculate which animation to play on unit(s).
 *   - Uses JavaScript to determine animation ID.
 * 
 *     Mirror?:
 *     - Mirror this animation?
 * 
 *     Mute?:
 *     - Mute this animation?
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 * 
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 * 
 * GRID: Animation Type at Node
 * - Plays certain animation type at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Type:
 *   - What is the animation type you would like to play?
 *     - Attack
 *     - Guard
 *     - Item
 *     - Skill
 * 
 *     Slot (Attack Type):
 *     - Which weapon slot to get this data from?
 *     - Main-hand weapon is weapon slot 1.
 * 
 *     Item ID (Item Type):
 *     - Which item ID will the animation come from?
 * 
 *     Skill ID (Skill Type):
 *     - Which skill ID will the animation come from?
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 * 
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 * 
 * GRID: Move Target(s) In Direction
 * - Moves target(s) in a specific direction to other Nodes.
 * - Requires VisuMZ_2_BattleGridSystem!
 * - This will bypass the "once per action" condition used for both the
 *   <rule Move User Node direction: x> & <rule Move Target Node direction: x>
 *   notetags as this is not a notetag effect.
 * 
 *   Targets:
 *   - Select unit(s) to move.
 * 
 *   Movement Type:
 *   - Select the Movement type rulings.
 *   - See VisuMZ_2_BattleGridSystem help file for details.
 * 
 *     Direction:
 *     - Select the movement direction.
 * 
 *     Distance:
 *     - The number of nodes to be moved.
 *     - You may use JavaScript code.
 * 
 *   Duration:
 *   - Input the number representing the frames used to move.
 * 
 *   Silent Change?:
 *   - Silent: Discreet changes shown. More apparent later.
 *   - Visual: Instant changes shown.
 * 
 * ---
 * 
 * GRID: Pull To Target Node
 * - Pulls battlers towards target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *
 *     Unit:
 *     - Which unit do you want to pull on?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to
 *       pull to.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to
 *       pull to.
 * 
 *   Strength:
 *   - Input the strength level of the pull.
 * 
 *   Duration:
 *   - Input the number representing the frames used to move.
 * 
 * ---
 * 
 * GRID: Push From Target Node
 * - Pushes battlers away from target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *
 *     Unit:
 *     - Which unit do you want to push from?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to
 *       push from.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to
 *       push from.
 * 
 *   Strength:
 *   - Input the strength level of the push.
 * 
 *   Duration:
 *   - Input the number representing the frames used to move.
 * 
 * ---
 *
 * GRID: Remove All Passive States from Node
 * - Removes all Passive State effects at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to clear the Node for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to clear
 *       Passive States from.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to clear
 *       Passive States from.
 *
 * ---
 *
 * GRID: Remove Passive State(s) from Node
 * - Remove Passive State(s) at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   State ID(s):
 *   - Select which State ID(s) to remove as a Passive State.
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to remove the Passive State Node effect for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to remove
 *       a Passive State(s) from.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to remove
 *       a Passive State(s) from.
 *
 * ---
 * 
 * GRID: Remove Trigger from Node
 * - Removes Trigger at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit do you want to clear Triggers for?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to clear
 *       Triggers from.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to clear
 *       Triggers from.
 * 
 * ---
 * 
 * === Action Sequences - Horror Effects ===
 * 
 * These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 * 
 * ---
 *
 * HORROR: Clear All Filters
 * - Clear all Horror Effects filters on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove Horror Effects for.
 *
 * ---
 *
 * HORROR: Glitch Create
 * - Creates the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Glitch Slices:
 *   - Glitch slices to be used with the target.
 *
 *   Glitch Offset:
 *   - Default offset value.
 *
 *   Glitch Animated?:
 *   - Animate the glitch effect?
 *
 *   Glitch Frequency:
 *   - If animated, how frequent to make the glitch effect?
 *   - Lower = often     Higher = rarer
 *
 *   Glitch Strength:
 *   - If animated, how strong is the glitch effect?
 *   - Lower = weaker     Higher = stronger
 *
 * ---
 *
 * HORROR: Glitch Remove
 * - Removes the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: Noise Create
 * - Creates the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Noise Rate:
 *   - Noise rate to be used with the target.
 *
 *   Noise Animated:
 *   - Animate the noise for the target?
 *
 * ---
 *
 * HORROR: Noise Remove
 * - Removes the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: TV Create
 * - Creates the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   TV Line Thickness:
 *   - Default TV line thickness
 *   - Lower = thinner     Higher = thicker
 *
 *   TV Corner Size:
 *   - Default TV line corner size
 *   - Lower = smaller     Higher = bigger
 *
 *   TV Animated:
 *   - Animate the TV?
 *
 *   TV Speed:
 *   - Speed used to animate the TV if animated
 *   - Lower = slower     Higher = faster
 *
 * ---
 *
 * HORROR: TV Remove
 * - Removes the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 * 
 * === Action Sequences - Impact ===
 * 
 * These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * ---
 *
 * IMPACT: Bizarro Inversion
 * - Swaps blue/red colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Bizarro?:
 *   - Enable Bizarro Inversion effect?
 *
 * ---
 *
 * IMPACT: Color Break
 * - Breaks the colors on the screen before reassembling.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Intensity:
 *   - What is the intensity of the color break effect?
 *
 *   Duration:
 *   - What is the duration of the color break effect?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Desaturation
 * - Desaturates all colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Desaturate?:
 *   - Enable Desaturation effect?
 *
 * ---
 *
 * IMPACT: Motion Blur Screen
 * - Creates a motion blur on the whole screen.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Blur Target(s)
 * - Creates a motion blur on selected target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion blur effects for.
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Trail Create
 * - Creates a motion trail effect for the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion trail effects for.
 *
 *   Delay:
 *   - How many frames to delay by when creating a motion trail?
 *   - The higher the delay, the less motion trails there are.
 *
 *   Duration:
 *   - How many frames should the motion trail last?
 *   - What do you want to be its duration?
 *
 *   Hue:
 *   - What do you want to be the hue for the motion trail?
 *
 *   Starting Opacity:
 *   - What starting opacity value do you want for the motion trail?
 *   - Opacity values decrease over time.
 *
 *   Tone:
 *   - What tone do you want for the motion trail?
 *   - Format: [Red, Green, Blue, Gray]
 *
 * ---
 *
 * IMPACT: Motion Trail Remove
 * - Removes the motion trail effect from the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to clear motion trail effects for.
 *
 * ---
 *
 * IMPACT: Negative Inversion
 * - Inverts all the colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Negative?:
 *   - Enable Negative Inversion effect?
 *
 * ---
 *
 * IMPACT: Oversaturation
 * - Oversaturates colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Oversaturate?:
 *   - Enable Oversaturation effect?
 *
 * ---
 *
 * IMPACT: Shockwave at Point
 * - Creates a shockwave at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to create a shockwave at?
 *   - You can use JavaScript code.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Each Target(s)
 * - Creates a shockwave at each of the target(s) location(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Target(s) Center
 * - Creates a shockwave from the center of the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Time Scale
 * - Adjust time to go faster or slower!
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Scale:
 *   - Adjusts how fast/slow time goes.
 *   - 1.00 is normal. Lower is slower. Higher is faster.
 *
 * ---
 *
 * IMPACT: Time Stop
 * - Stops time for a set amount of milliseconds.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Milliseconds:
 *   - How many milliseconds should time stop for?
 *   - 1000 milliseconds = 1 second.
 *
 * ---
 *
 * IMPACT: Zoom Blur at Point
 * - Creates a zoom blur at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to focus the zoom at?
 *   - You can use JavaScript code.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Zoom Blur at Target(s) Center
 * - Creates a zoom blur at the center of targets.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a zoom blur from.
 *
 *   Target Location:
 *   - Select which part target group to start a zoom blur from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the zoom blur X/Y point by.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * === Action Sequences - Inject ===
 *
 * These Action Sequences are related to injecting sprite animations.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * ---
 * 
 * INJECT: Animation Begin
 * - Injects and plays a whole spritesheet animation.
 * - The spritesheet animation will play over the battler until it is finished.
 * - The battler's original sprite will be invisible until finished.
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 *   Targets:
 *   - Select unit(s) to inject the animation on.
 * 
 *   Filename:
 *   - Select the animation spritesheet file.
 *   - Located in the /img/sv_actors/ folder.
 * 
 *     Horizontal Cells:
 *     - How many horizontal cells (or columns) are there?
 * 
 *     Vertical Cells:
 *     - How many vertical cells (or rows) are there?
 * 
 *     Frame Delay:
 *     - How many frames are played inbetween cells?
 * 
 *     Smooth Bitmap?:
 *     - Smooth the spritesheet graphic?
 * 
 *   Offset:
 * 
 *     Offset X:
 *     - Offsets the X position of the injected animation.
 *     - Negative: left. Positive: right.
 * 
 *     Offset Y:
 *     - Offsets the Y position of the injected animation.
 *     - Negative: up. Positive: down.
 * 
 * ---
 * 
 * INJECT: Animation End
 * - Stops and ends any injected animations on target(s).
 * - Any inject animation will be prematurely terminated.
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 *   Targets:
 *   - Select unit(s) to stop injected animation(s).
 * 
 * ---
 * 
 * INJECT: Animation Pause/Resume
 * - Pauses/resumes any injected animations on target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 *   Targets:
 *   - Select unit(s) to pause/resume injected animation(s).
 * 
 *   Pause?:
 *   - Pause the injected animation?
 * 
 * ---
 * 
 * INJECT: Wait For Injected Animation
 * - Waits for injected animations to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 * ---
 *
 * === Action Sequences - Mechanics ===
 *
 * These Action Sequences are related to various mechanics related to the
 * battle system.
 *
 * ---
 *
 * MECH: Action Effect
 * - Causes the unit(s) to take damage/healing from action and incurs any
 *   changes made such as buffs and states.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 * ---
 * 
 * MECH: Active Chain Input Disable
 * - Disables input for Active Chain Skills at this time.
 * - Requires VisuMZ_3_ActiveChainSkills!
 * 
 * ---
 *
 * MECH: Add Buff/Debuff
 * - Adds buff(s)/debuff(s) to unit(s). 
 * - Determine which parameters are affected and their durations.
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s) and/or debuff(s).
 *
 *   Buff Parameters:
 *   - Select which parameter(s) to buff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Debuff Parameters:
 *   - Select which parameter(s) to debuff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Turns:
 *   - Number of turns to set the parameter(s) buffs to.
 *   - You may use JavaScript code.
 *
 * ---
 *
 * MECH: Add State
 * - Adds state(s) to unit(s).
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s).
 *
 *   States:
 *   - Select which state ID(s) to add to unit(s).
 *   - Insert multiple state ID's to add multiple at once.
 *
 * ---
 * 
 * MECH: Analyze Weakness
 * - Reveal elemental weakness(es) from target(s).
 * - Requires VisuMZ_3_WeaknessDisplay!
 * 
 *   Targets:
 *   - Select unit(s) to reveal elemental weaknesses for.
 * 
 *   Reveal:
 *   - How many elemental weaknesses do you wish to reveal?
 *   - You may use JavaScript code.
 * 
 * ---
 *
 * MECH: Armor Penetration
 * - Adds an extra layer of defensive penetration/reduction.
 * - You may use JavaScript code for any of these.
 *
 *   Armor/Magic Penetration:
 *
 *     Rate:
 *     - Penetrates an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Penetrates a flat amount of armor by this value.
 *
 *   Armor/Magic Reduction:
 *
 *     Rate:
 *     - Reduces an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Reduces a flat amount of armor by this value.
 *
 * ---
 * 
 * MECH: ATB Gauge
 * - Alters the ATB/TPB Gauges.
 * - Requires VisuMZ_2_BattleSystemATB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 * 
 *   Charging:
 *   
 *     Charge Rate:
 *     - Changes made to the ATB Gauge if it is currently charging.
 * 
 *   Casting:
 *   
 *     Cast Rate:
 *     - Changes made to the ATB Gauge if it is currently casting.
 *   
 *     Interrupt?:
 *     - Interrupt the ATB Gauge if it is currently casting?
 * 
 * ---
 * 
 * MECH: Boost Points Change
 * - Changes Boost Points for target(s).
 * - Requires VisuMZ_3_BoostAction!
 * 
 *   Targets:
 *   - Select unit(s) to alter the Boost Points for.
 * 
 *   Alter Boost Points By:
 *   - Alters the unit(s) Boost Points.
 *   - Positive for gaining points. Negative for losing points.
 * 
 * ---
 * 
 * MECH: Boost Store Data
 * - Stores the number of Boosts used this action inside a variable.
 * - Requires VisuMZ_3_BoostAction!
 * 
 *   Variable ID:
 *   - Which variable do you want to store the data inside?
 * 
 * ---
 * 
 * MECH: Break Shield Change
 * - Changes Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 * 
 *   Targets:
 *   - Select unit(s) to alter the Break Shields for.
 * 
 *   Alter Break Shields By:
 *   - Alters the unit(s) Break Shields.
 *   - Positive for gaining shields. Negative for losing shields.
 * 
 * ---
 * 
 * MECH: Break Shield Reset
 * - Resets Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 * 
 *   Targets:
 *   - Select unit(s) to reset the Break Shields for.
 * 
 * ---
 * 
 * MECH: BTB Brave Points
 * - Alters the target(s) Brave Points to an exact value.
 * - Requires VisuMZ_2_BattleSystemBTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 * 
 *   Alter Brave Points By:
 *   - Alters the target(s) Brave Points.
 *   - Positive for gaining BP.
 *   - Negative for losing BP.
 * 
 * ---
 *
 * MECH: Collapse
 * - Causes the unit(s) to perform its collapse animation if the unit(s)
 *   has died.
 *
 *   Targets:
 *   - Select unit(s) to process a death collapse.
 *
 *   Force Death:
 *   - Force death even if the unit has not reached 0 HP?
 *   - This will remove immortality.
 *
 *   Wait For Effect?:
 *   - Wait for the collapse effect to complete before performing next command?
 *
 * ---
 * 
 * MECH: CTB Order
 * - Alters the CTB Turn Order.
 * - Requires VisuMZ_2_BattleSystemCTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the CTB Turn Order for.
 * 
 *   Change Order By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 * ---
 * 
 * MECH: CTB Speed
 * - Alters the CTB Speed.
 * - Requires VisuMZ_2_BattleSystemCTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the CTB Speed for.
 * 
 *   Charge Rate:
 *   - Changes made to the CTB Speed if it is currently charging.
 * 
 *   Cast Rate:
 *   - Changes made to the CTB Speed if it is currently casting.
 * 
 * ---
 * 
 * MECH: Custom Damage Formula
 * - Changes the current action's damage formula to custom.
 * - This will assume the MANUAL damage style.
 * 
 *   Formula:
 *   - Changes the current action's damage formula to custom.
 *   - Use 'default' to revert the damage formula.
 * 
 * ---
 *
 * MECH: Damage Popup
 * - Causes the unit(s) to display the current state of damage received
 *   or healed.
 *
 *   Targets:
 *   - Select unit(s) to prompt a damage popup.
 *
 * ---
 *
 * MECH: Dead Label Jump
 * - If the active battler is dead, jump to a specific label in the
 *   common event.
 *
 *   Jump To Label:
 *   - If the active battler is dead, jump to this specific label in the
 *     common event.
 *
 * ---
 * 
 * MECH: Emulate Attack Effect
 * - Emulate an "Action Effect" but using a the user's attack skill instead of
 *   the current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 * 
 * ---
 * 
 * MECH: Emulate Guard Effect
 * - Emulate an "Action Effect" but using a the user's guard skill instead of
 *   the current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 * 
 * ---
 * 
 * MECH: Emulate Item Effect
 * - Emulate an "Action Effect" but using a specific item instead of the
 *   current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 * 
 *   Item ID:
 *   - Which item ID will be emulated?
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 * 
 * ---
 * 
 * MECH: Emulate Skill Cost
 * - Pick a skill for target(s) to emulate paying the cost of.
 * - Lets you cause characters to perform paying the costs of a specific skill
 *   without needing to actually use them.
 * - This will include Skill Cooldowns and Limited Skill Uses.
 * 
 *   Skill ID:
 *   - Which skill ID will have its cost paid for?
 *   - Use 0 for current action's skill.
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 * ---
 * 
 * MECH: Emulate Skill Effect
 * - Emulate an "Action Effect" but using a specific skill instead of the
 *   current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 * 
 *   Skill ID:
 *   - Which skill ID will be emulated?
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 * 
 * ---
 *
 * MECH: Enemy Escape
 * - Causes the enemy unit(s) to escape.
 *
 *   Targets:
 *   - Select unit(s) to escape.
 *
 * ---
 *
 * MECH: ETB Energy Count
 * - Alters the subject team's available Energy Count.
 * - Requires VisuMZ_2_BattleSystemETB!
 *
 *   Energy Count:
 *   - Alters the subject team's available Energy Count.
 *   - Positive for gaining energy. Negative for losing energy.
 *
 * ---
 *
 * MECH: FTB Action Count
 * - Alters the subject team's available Action Count.
 * - Requires VisuMZ_2_BattleSystemFTB!
 *
 *   Action Count:
 *   - Alters the subject team's available Action Count.
 *   - Positive for gaining actions. Negative for losing actions.
 *
 * ---
 *
 * MECH: HP, MP, TP
 * - Alters the HP, MP, and TP values for unit(s).
 * - Positive values for healing. Negative values for damage.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 *   HP, MP, TP:
 *
 *     Rate:
 *     - Changes made to the parameter based on rate.
 *     - Positive values for healing. Negative values for damage.
 *
 *     Flat:
 *     - Flat changes made to the parameter.
 *     - Positive values for healing. Negative values for damage.
 *
 *   Damage Popup?:
 *   - Display a damage popup after?
 *
 * ---
 *
 * MECH: Immortal
 * - Changes the immortal flag of targets. If immortal flag is removed and a
 *   unit would die, collapse that unit.
 *
 *   Targets:
 *   - Alter the immortal flag of these groups. If immortal flag is removed and
 *     a unit would die, collapse that unit.
 *
 *   Immortal:
 *   - Turn immortal flag for unit(s) on/off?
 *
 * ---
 *
 * MECH: Multipliers
 * - Changes the multipliers for the current action.
 * - You may use JavaScript code for any of these.
 *
 *   Critical Hit%:
 *
 *     Rate:
 *     - Affects chance to land a critical hit by this multiplier.
 *
 *     Flat:
 *     - Affects chance to land a critical hit by this flat bonus.
 *
 *   Critical Damage
 *
 *     Rate:
 *     - Affects critical damage by this multiplier.
 *
 *     Flat:
 *     - Affects critical damage by this flat bonus.
 *
 *   Damage/Healing
 *
 *     Rate:
 *     - Sets the damage/healing multiplier for current action.
 *
 *     Flat:
 *     - Sets the damage/healing bonus for current action.
 *
 *   Hit Rate
 *
 *     Rate:
 *     - Affects chance to connect attack by this multiplier.
 *
 *     Flat:
 *     - Affects chance to connect attack by this flat bonus.
 *
 * ---
 * 
 * MECH: Once Parallel
 * - Plays a Common Event parallel to the battle event once without repeating
 *   itself when done.
 * 
 *   Common Event ID:
 *   - The ID of the parallel Common Event to play.
 *   - Does NOT repeat itself when finished.
 *   - When exiting battle scene, all Once Parallels are cleared.
 *   - Once Parallels are not retained upon reentering the scene.
 *   - Once Parallels are not stored in memory and cannot be saved.
 * 
 * ---
 * 
 * MECH: OTB Order
 * - Alters the OTB Turn Order. Best used with single targets.
 * - Requires VisuMZ_2_BattleSystemOTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the OTB Turn Order for.
 * 
 *   Current Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 *   Next Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 *   Follow Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 * ---
 * 
 * MECH: PTB Alter Cost
 * - Alters the action's cost settings.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Override?:
 *   - Overrides any 'permanent' settings for Changeability?
 * 
 *   Alter Changeability:
 *   - Allow the cost type and value to be changeable?
 * 
 *   Alter Cost Type:
 *   - Change the cost type to this scenario.
 *   - Use 'Unchanged' for no changes.
 * 
 *   Alter Cost Value:
 *   - What is the default action cost for this scenario?
 * 
 *   Priority:
 *   - What is this scenario's priority? Scenario outcomes with equal or lower
 *     priorities cannot override types and costs.
 * 
 * ---
 * 
 * MECH: PTB Conversion
 * - Converts full actions into half actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Conversion Count:
 *   - Converts full actions into half actions.
 *   - If not enough, consume half actions.
 * 
 * ---
 * 
 * MECH: PTB Full/Half Action(s)
 * - Alters the subject team's available Full/Half Actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Full Actions:
 *   - Alters the subject team's available Full Actions.
 *   - Positive for gaining. Negative for losing.
 * 
 *   Half Actions:
 *   - Alters the subject team's available Half Actions.
 *   - Positive for gaining. Negative for losing.
 * 
 * ---
 *
 * MECH: Remove Buff/Debuff
 * - Removes buff(s)/debuff(s) from unit(s). 
 * - Determine which parameters are removed.
 *
 *   Targets:
 *   - Select unit(s) to have the buff(s) and/or debuff(s) removed.
 *
 *   Buff Parameters:
 *   - Select which buffed parameter(s) to remove.
 *
 *   Debuff Parameters:
 *   - Select which debuffed parameter(s) to remove.
 *
 * ---
 *
 * MECH: Remove State
 * - Remove state(s) from unit(s).
 *
 *   Targets:
 *   - Select unit(s) to have states removed from.
 *
 *   States:
 *   - Select which state ID(s) to remove from unit(s).
 *   - Insert multiple state ID's to remove multiple at once.
 *
 * ---
 * 
 * MECH: State Turns Change By
 * - Changes target(s) state turns by an amount.
 * - Requires VisuMZ_1_SkillsStatesCore!
 * 
 *   Targets:
 *   - Select unit(s) to affect state turns for.
 * 
 *   State ID:
 *   - What is the ID of the state you wish to change turns for?
 *   - Only works on states that can have turns.
 * 
 *   Change Turns By:
 *   - How many turns should the state be changed to?
 *   - You may use JavaScript code.
 * 
 *   Auto-Add State?:
 *   - Automatically adds state if actor(s) does not have it applied?
 * 
 * ---
 * 
 * MECH: State Turns Change To
 * - Changes target(s) state turns to a specific value.
 * - Requires VisuMZ_1_SkillsStatesCore!
 * 
 *   Targets:
 *   - Select unit(s) to affect state turns for.
 * 
 *   State ID:
 *   - What is the ID of the state you wish to change turns for?
 *   - Only works on states that can have turns.
 * 
 *   Change Turns To:
 *   - How many turns should the state be changed to?
 *   - You may use JavaScript code.
 * 
 *   Auto-Add State?:
 *   - Automatically adds state if target(s) does not have it applied?
 * 
 * ---
 * 
 * MECH: STB Exploit Effect
 * - Utilize the STB Exploitation mechanics!
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Target(s) Exploited?:
 *   - Exploit the below targets?
 * 
 *     Targets:
 *     - Select unit(s) to become exploited.
 * 
 *     Force Exploitation:
 *     - Force the exploited status?
 * 
 *   User Exploiter?:
 *   - Allow the user to become the exploiter?
 * 
 *     Force Exploitation:
 *     - Force the exploiter status?
 * 
 * ---
 * 
 * MECH: STB Extra Action
 * - Adds an extra action for the currently active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Extra Actions:
 *   - How many extra actions should the active battler gain?
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * MECH: STB Remove Excess Actions
 * - Removes excess actions from the active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Remove Actions:
 *   - How many actions to remove from the active battler?
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * MECH: Swap Weapon
 * - Causes the unit(s) to swap their weapon for another.
 * - Requires VisuMZ_2_WeaponSwapSystem!
 * 
 *   Targets:
 *   - Select unit(s) to swap weapons for.
 * 
 *   Weapon Type ID:
 *   - Which weapon type to swap to?
 *   - This is NOT the weapon's ID.
 *   - It's the weapon TYPE.
 * 
 * ---
 * 
 * MECH: Text Popup
 * - Causes the unit(s) to display a text popup.
 * 
 *   Targets:
 *   - Select unit(s) to prompt a text popup.
 * 
 *   Text:
 *   - What text do you wish to display?
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 * 
 * ---
 * 
 * MECH: Variable Popup
 * - Causes the unit(s) to display a popup using the data stored inside
 *   a variable.
 * 
 *   Targets:
 *   - Select unit(s) to prompt a text popup.
 * 
 *   Variable:
 *   - Get data from which variable to display as a popup?
 * 
 *   Digit Grouping:
 *   - Use digit grouping to separate numbers?
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 * 
 * ---
 *
 * MECH: Wait For Effect
 * - Waits for the effects to complete before performing next command.
 *
 * ---
 *
 * === Action Sequences - Motion ===
 *
 * These Action Sequences allow you the ability to control the motions of
 * sideview sprites.
 *
 * ---
 * 
 * MOTION: Clear Freeze Frame
 * - Clears any freeze frames from the unit(s).
 * - Only applies to sprite sheets.
 * - Does NOT work with Dragonbones.
 * - Use "DB: Dragonbones Time Scale" instead.
 * 
 *   Targets:
 *   - Select which unit(s) to clear freeze frames for.
 * 
 * ---
 * 
 * MOTION: Freeze Motion Frame
 * - Forces a freeze frame instantly at the selected motion.
 * - Automatically clears with a new motion.
 * - Only applies to sprite sheets.
 * - Does NOT work with Dragonbones.
 * - Use "DB: Dragonbones Time Scale" instead.
 * 
 *   Targets:
 *   - Select which unit(s) to freeze motions for.
 * 
 *   Motion Type:
 *   - Freeze this motion for the unit(s).
 * 
 *   Frame Index:
 *   - Which frame do you want to freeze the motion on?
 *   - Frame index values start at 0.
 * 
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 * 
 * ---
 *
 * MOTION: Motion Type
 * - Causes the unit(s) to play the selected motion.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 *   Motion Type:
 *   - Play this motion for the unit(s).
 *
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 *
 * ---
 *
 * MOTION: Perform Action
 * - Causes the unit(s) to play the proper motion based on the current action.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 * ---
 *
 * MOTION: Refresh Motion
 * - Cancels any set motions unit(s) has to do and use their most natural
 *   motion at the moment.
 *
 *   Targets:
 *   - Select which unit(s) to refresh their motion state.
 *
 * ---
 *
 * MOTION: Wait By Motion Frame
 * - Creates a wait equal to the number of motion frames passing.
 * - Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 *   Motion Frames to Wait?:
 *   - Each "frame" is equal to the value found in 
 *     Plugin Parameters => Actors => Motion Speed
 *
 * ---
 *
 * === Action Sequences - Movement ===
 *
 * These Action Sequences allow you the ability to control the sprites of
 * actors and enemies in battle.
 *
 * ---
 *
 * MOVE: Battle Step
 * - Causes the unit(s) to move forward past their home position to prepare
 *   for action.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home By Distance
 * - Change unit(s)'s home position by a distance from their current home
 *   position(s).
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Distance Adjustment:
 *   - Makes adjustments to distance values to determine which direction to
 *     change by.
 *     - Normal - No adjustments made
 *     - Horizontal - Actors adjust left, Enemies adjust right
 *     - Vertical - Actors adjust Up, Enemies adjust down
 *     - Both - Applies both Horizontal and Vertical
 *
 *     Distance: X:
 *     - Horizontal distance to move.
 *     - You may use JavaScript code.
 *
 *     Distance: Y:
 *     - Vertical distance to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To JS Coordinates
 * - Change home position(s) to specified JS Coordinates.
 * - Sideview-only! Uses JavaScript!
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   JS: Coordinates:
 *   - Code used to determine the coordinates for the target(s)'s new home
 *     position.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To Point
 * - Change home position(s) to a target point on the screen.
 * - Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Destination Point:
 *   - Select which point to face.
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To Target(s)
 * - Moves unit(s) to another unit(s) on the battle field.
 * - Sideview-only!
 *
 *   Targets (Moving):
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Targets (Destination):
 *   - Select which unit(s) to change home position to.
 *
 *     Target Location:
 *     - Select which part target group to change home position to.
 *       - front head
 *       - front center
 *       - front base
 *       - middle head
 *       - middle center
 *       - middle base
 *       - back head
 *       - back center
 *       - back base
 *
 *     Melee Distance:
 *     - The melee distance away from the target location in addition to the
 *       battler's width.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Face Direction
 * - Causes the unit(s) to face forward or backward.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Direction:
 *   - Select which direction to face.
 *
 * ---
 *
 * MOVE: Face JS Coordinates
 * - Causes the unit(s) to face specified JS Coordinates.
 * - Sideview-only! Uses JavaScript!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   JS: Coordinates:
 *   - Code used to determine the coordinates for the target(s) to face
 *     towards.
 *
 *   Face Away From?:
 *   - Face away from the point instead?
 *
 * ---
 *
 * MOVE: Face Point
 * - Causes the unit(s) to face a point on the screen.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Face Away From?:
 *   - Face away from the point instead?
 *
 * ---
 *
 * MOVE: Face Target(s)
 * - Causes the unit(s) to face other targets on the screen.
 * - Sideview-only!
 *
 *   Targets (facing):
 *   - Select which unit(s) to change direction.
 *
 *   Targets (destination):
 *   - Select which unit(s) for the turning unit(s) to face.
 *
 *   Face Away From?:
 *   - Face away from the unit(s) instead?
 *
 * ---
 *
 * MOVE: Float
 * - Causes the unit(s) to float above the ground.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make float.
 *
 *   Desired Height:
 *   - Vertical distance to float upward.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total float amount.
 *
 *   Float Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Float?:
 *   - Wait for floating to complete before performing next command?
 *
 * ---
 *
 * MOVE: Home Reset
 * - Causes the unit(s) to move back to their home position(s) and face back to
 *   their original direction(s).
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Jump
 * - Causes the unit(s) to jump into the air.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make jump.
 *
 *   Desired Height:
 *   - Max jump height to go above the ground
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total jump amount.
 *
 *   Wait For Jump?:
 *   - Wait for jumping to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move Distance
 * - Moves unit(s) by a distance from their current position(s).
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Distance Adjustment:
 *   - Makes adjustments to distance values to determine which direction to
 *     move unit(s).
 *     - Normal - No adjustments made
 *     - Horizontal - Actors adjust left, Enemies adjust right
 *     - Vertical - Actors adjust Up, Enemies adjust down
 *     - Both - Applies both Horizontal and Vertical
 *
 *     Distance: X:
 *     - Horizontal distance to move.
 *     - You may use JavaScript code.
 *
 *     Distance: Y:
 *     - Vertical distance to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To JS Coordinates
 * - Moves unit(s) to specified JS Coordinates.
 * - Sideview-only! Uses JavaScript!
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   JS: Coordinates:
 *   - Code used to determine the coordinates for the target(s) to move to.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Point
 * - Moves unit(s) to a designated point on the screen.
 * - Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Destination Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Target(s)
 * - Moves unit(s) to another unit(s) on the battle field.
 * - Sideview-only!
 *
 *   Targets (Moving):
 *   - Select which unit(s) to move.
 *
 *   Targets (Destination):
 *   - Select which unit(s) to move to.
 *
 *     Target Location:
 *     - Select which part target group to move to.
 *       - front head
 *       - front center
 *       - front base
 *       - middle head
 *       - middle center
 *       - middle base
 *       - back head
 *       - back center
 *       - back base
 *
 *     Melee Distance:
 *     - The melee distance away from the target location in addition to the
 *       battler's width.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Opacity
 * - Causes the unit(s) to change opacity.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change opacity.
 *
 *   Desired Opacity:
 *   - Change to this opacity value.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for opacity change.
 *
 *   Opacity Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Opacity?:
 *   - Wait for opacity changes to complete before performing next command?
 *
 * ---
 *
 * MOVE: Scale/Grow/Shrink
 * - Causes the unit(s) to scale, grow, or shrink?.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change the scale of.
 *
 *   Scale X:
 *   Scale Y:
 *   - What target scale value do you want?
 *   - 1.0 is normal size.
 *
 *   Duration:
 *   - Duration in frames to scale for.
 *
 *   Scale Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Scale?:
 *   - Wait for scaling to complete before performing next command?
 *
 * ---
 *
 * MOVE: Skew/Distort
 * - Causes the unit(s) to skew.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to skew.
 *
 *   Skew X:
 *   Skew Y:
 *   - What variance to skew?
 *   - Use small values for the best results.
 *
 *   Duration:
 *   - Duration in frames to skew for.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew to complete before performing next command?
 *
 * ---
 *
 * MOVE: Spin/Rotate
 * - Causes the unit(s) to spin.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to spin.
 *
 *   Angle:
 *   - How many degrees to spin?
 *
 *   Duration:
 *   - Duration in frames to spin for.
 *
 *   Spin Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 * 
 *   Revert Angle on Finish:
 *   - Upon finishing the spin, revert the angle back to 0.
 *
 *   Wait For Spin?:
 *   - Wait for spin to complete before performing next command?
 *
 * ---
 *
 * MOVE: Wait For Float
 * - Waits for floating to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Jump
 * - Waits for jumping to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Movement
 * - Waits for movement to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Opacity
 * - Waits for opacity changes to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Scale
 * - Waits for scaling to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Skew
 * - Waits for skewing to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Spin
 * - Waits for spinning to complete before performing next command.
 *
 * ---
 * 
 * === Action Sequences - Projectiles ===
 * 
 * Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * ---
 *
 * PROJECTILE: Animation
 * - Create an animation projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Animation ID:
 *     - Determine which animation to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 * 
 *     Wait For Animation?:
 *     - Wait for animation to finish before going to the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the projectile's trajectory arc in pixels.
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 * 
 *     Effect Emulation:
 * 
 *       Action Effect?:
 *       - Emulate current Action Effect when projectile reaches target?
 *       - Only works with start and goal targets.
 * 
 *       Item Effect ID?:
 *       - Emulate an Item Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Skill Effect ID?:
 *       - Emulate a Skill Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Common Event ID:
 *       - Plays a Once Parallel Common Event upon reaching target.
 *       - Use 0 to not use.
 *       - Works regardless of start/goal targets.
 *
 * ---
 *
 * PROJECTILE: Icon
 * - Create an icon projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Icon:
 *     - Determine which icon to use as a projectile.
 *       - You may use JavaScript code.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the projectile's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 * 
 *     Effect Emulation:
 * 
 *       Action Effect?:
 *       - Emulate current Action Effect when projectile reaches target?
 *       - Only works with start and goal targets.
 * 
 *       Item Effect ID?:
 *       - Emulate an Item Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Skill Effect ID?:
 *       - Emulate a Skill Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Common Event ID:
 *       - Plays a Once Parallel Common Event upon reaching target.
 *       - Use 0 to not use.
 *       - Works regardless of start/goal targets.
 *
 * ---
 *
 * PROJECTILE: Picture
 * - Create a picture projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Picture Filename:
 *     - Determine which picture to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the projectile's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 * 
 *     Effect Emulation:
 * 
 *       Action Effect?:
 *       - Emulate current Action Effect when projectile reaches target?
 *       - Only works with start and goal targets.
 * 
 *       Item Effect ID?:
 *       - Emulate an Item Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Skill Effect ID?:
 *       - Emulate a Skill Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Common Event ID:
 *       - Plays a Once Parallel Common Event upon reaching target.
 *       - Use 0 to not use.
 *       - Works regardless of start/goal targets.
 *
 * ---
 * 
 * === Action Sequences - Skew ===
 * 
 * These action sequences allow you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * ---
 *
 * SKEW: Change Skew
 * - Changes the camera skew.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Skew X:
 *   - Change the camera skew X to this value.
 *
 *   Skew Y:
 *   - Change the camera skew Y to this value.
 *
 *   Duration:
 *   - Duration in frames to change camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Reset Skew
 * - Reset any skew settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Wait For Skew
 * - Waits for skew changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Target ===
 *
 * If using a manual target by target Action Sequence, these commands will give
 * you full control over its usage.
 *
 * ---
 *
 * TARGET: Current Index
 * - Sets the current index to this value.
 * - Then decide to jump to a label (optional).
 *
 *   Set Index To:
 *   - Sets current targeting index to this value.
 *   - 0 is the starting index of a target group.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Next Target
 * - Moves index forward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Previous Target
 * - Moves index backward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Random Target
 * - Sets index randomly to determine new currernt target.
 * - Then decide to jump to a label (optional).
 *
 *   Force Random?:
 *   - Index cannot be its previous index amount after random.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 * 
 * === Action Sequences - Voice ==
 * 
 * ---
 *
 * VOICE: Common Line
 * - Plays a common voice line from target battler(s).
 * - Requires VisuMZ_3_BattleVoices!
 *
 *   Speaker Target(s):
 *   - Select unit(s) to play voice lines from.
 *
 *   Voice Line:
 *   - What voice line do you wish to play?
 *
 * ---
 *
 * VOICE: Play Special Line
 * - Plays a special voice line from target battler(s).
 * - Requires VisuMZ_3_BattleVoices!
 *
 *   Speaker Target(s):
 *   - Select unit(s) to play voice lines from.
 *
 *   Voice Line Type:
 *   - What voice line type do you wish to play?
 *     - Action Name
 *     - Chant Line
 *     - Item Name
 *     - Skill Name
 *     - Spell Name
 *     - Unique Lines
 *
 *   Name / Letter:
 *   - What voice letter/name do you want to play?
 *
 * ---
 *
 * === Action Sequences - Weapon ===
 *
 * Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * ---
 *
 * WEAPON: Clear Weapon Slot
 * - Clears the active weapon slot (making others valid again).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to clear the active weapon slot for.
 *
 * ---
 *
 * WEAPON: Next Weapon Slot
 * - Goes to next active weapon slot (making others invalid).
 * - If next slot is weaponless, don't label jump.
 *
 *   Targets:
 *   - Select unit(s) to change the next active weapon slot for.
 *
 * ---
 *
 * WEAPON: Set Weapon Slot
 * - Sets the active weapon slot (making others invalid).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to change the active weapon slot for.
 *
 *   Weapon Slot ID:
 *   - Select weapon slot to make active (making others invalid).
 *   - Use 0 to clear and normalize. You may use JavaScript code.
 *
 * ---
 *
 * === Action Sequences - Zoom ===
 *
 * These Action Sequences are zoom-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ZOOM: Change Scale
 * - Changes the zoom scale.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Scale:
 *   - The zoom scale to change to.
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Reset Zoom
 * - Reset any zoom settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Wait For Zoom
 * - Waits for zoom changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Auto Battle Settings
 * ============================================================================
 *
 * These Plugin Parameter settings allow you to change the aspects added by
 * this plugin that support Auto Battle and the Auto Battle commands.
 *
 * Auto Battle commands can be added to the Party Command Window and/or Actor
 * Command Window. The one used by the Party Command Window will cause the
 * whole party to enter an Auto Battle state until stopped by a button input.
 * The command used by the Actor Command Window, however, will cause the actor
 * to select an action based off the Auto Battle A.I. once for the current turn
 * instead.
 *
 * ---
 *
 * Battle Display
 * 
 *   Message:
 *   - Message that's displayed when Auto Battle is on.
 *     Text codes allowed. %1 - OK button, %2 - Cancel button
 * 
 *   OK Button:
 *   - Text used to represent the OK button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Cancel Button:
 *   - Text used to represent the Cancel button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Background Type:
 *   - Select background type for Auto Battle window.
 *     - 0 - Window
 *     - 1 - Dim
 *     - 2 - Transparent
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the Auto Battle options to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Startup Name:
 *   - Command name of the option.
 * 
 *   Style Name:
 *   - Command name of the option.
 * 
 *   OFF:
 *   - Text displayed when Auto Battle Style is OFF.
 * 
 *   ON:
 *   - Text displayed when Auto Battle Style is ON.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Damage Settings
 * ============================================================================
 *
 * These Plugin Parameters add a variety of things to how damage is handled in
 * battle. These range from hard damage caps to soft damage caps to how damage
 * popups appear, how the formulas for various aspects are handled and more.
 *
 * Damage Styles are also a feature added through this plugin. More information
 * can be found in the help section above labeled 'Damage Styles'.
 *
 * ---
 *
 * Damage Styles
 * 
 *   Default Style:
 *   - Which Damage Style do you want to set as default?
 *   - Use 'Manual' to not use any styles at all.
 *     - The 'Manual' style will not support <Armor Penetration> notetags.
 *     - The 'Manual' style will not support <Armor Reduction> notetags.
 * 
 *   Style List:
 *   - A list of the damage styles available.
 *   - These are used to calculate base damage.
 * 
 *     Name:
 *     - Name of this Damage Style.
 *     -Used for notetags and such.
 * 
 *     JS: Formula:
 *     - The base formula for this Damage Style.
 * 
 *     Items & Equips Core:
 * 
 *       HP Damage:
 *       MP Damage:
 *       HP Recovery:
 *       MP Recovery:
 *       HP Drain:
 *       MP Drain:
 *       - Vocabulary used for this data entry.
 * 
 *       JS: Damage Display:
 *       - Code used the data displayed for this category.
 *
 * ---
 *
 * Damage Cap
 * 
 *   Enable Damage Cap?:
 *   - Put a maximum hard damage cap on how far damage can go?
 *   - This can be broken through the usage of notetags.
 * 
 *   Default Hard Cap:
 *   - The default hard damage cap used before applying damage.
 * 
 *   Enable Soft Cap?:
 *   - Soft caps ease in the damage values leading up to the  hard damage cap.
 *   - Requires hard Damage Cap enabled.
 * 
 *     Base Soft Cap Rate:
 *     - The default soft damage cap used before applying damage.
 * 
 *     Soft Scale Constant:
 *     - The default soft damage cap used before applying damage.
 *
 * ---
 *
 * Popups
 * 
 *   Popup Duration:
 *   - Adjusts how many frames a popup stays visible.
 * 
 *   Newest Popups Bottom:
 *   - Puts the newest popups at the bottom.
 * 
 *   End Battle Show?:
 *   - Show or hide popups upon victory or escape?
 *   - Used to hide battle-state removal popups.
 * 
 *   Offset X:
 *   Offset Y:
 *   - Sets how much to offset the sprites by horizontally/vertically.
 * 
 *   Shift X:
 *   Shift Y:
 *   - Sets how much to shift the sprites by horizontally/vertically.
 * 
 *   Shift Y:
 * 
 *   Critical Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Critical Duration:
 *   - Adjusts how many frames a the flash lasts.
 *
 * ---
 *
 * Formulas
 * 
 *   JS: Overall Formula:
 *   - The overall formula used when calculating damage.
 * 
 *   JS: Variance Formula:
 *   - The formula used when damage variance.
 * 
 *   JS: Guard Formula:
 *   - The formula used when damage is guarded.
 *
 * ---
 *
 * Critical Hits
 * 
 *   JS: Rate Formula:
 *   - The formula used to calculate Critical Hit Rates.
 * 
 *   JS: Damage Formula:
 *   - The formula used to calculate Critical Hit Damage modification.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Mechanics Settings
 * ============================================================================
 *
 * Some of the base settings for the various mechanics found in the battle
 * system can be altered here in these Plugin Parameters. Most of these will
 * involve JavaScript code and require you to have to good understanding of
 * how the RPG Maker MZ code works before tampering with it.
 *
 * ---
 *
 * Action Speed
 * 
 *   Allow Random Speed?:
 *   - Allow speed to be randomized base off the user's AGI?
 * 
 *   Turn End Buffs Expire?:
 *   - Normally, buffs expire after all actions end.
 *   - But here, you can have buffs expire on turn end.
 * 
 *   JS: Calculate:
 *   - Code used to calculate action speed.
 *
 * ---
 *
 * Base Troop
 * 
 *   Base Troop ID's:
 *   - Select the Troop ID(s) to duplicate page events from for all
 *     other troops.
 *   - More information can be found in the dedicated Help section above.
 *
 * ---
 * 
 * Common Events (on Map)
 * 
 *   Pre-Battle Event:
 *   Post-Battle Event:
 *   Victory Event:
 *   Defeat Event:
 *   Escape Success Event:
 *   Escape Fail Event:
 *   - Queued Common Event to run upon meeting the condition.
 *   - Use to 0 to not run any Common Event at all.
 *   - "Post-Battle Event" will always run regardless.
 *   - If any events are running before the battle, they will continue running
 *     to the end first before the queued Common Events will run.
 *   - These common events only run on the map scene. They're not meant to run
 *     in the battle scene.
 *   - If the "Defeat Event" has a common event attached to it, then random
 *     encounters will be changed to allow defeat without being sent to the
 *     Game Over scene. Instead, the game will send the player to the map scene
 *     where the Defeat Event will run.
 *
 * ---
 *
 * Escape
 * 
 *   JS: Calc Escape Ratio:
 *   - Code used to calculate the escape success ratio.
 * 
 *   JS: Calc Escape Raise:
 *   - Code used to calculate how much the escape success ratio raises upon
 *     each failure.
 * 
 * ---
 * 
 * Switches
 * 
 *   Switch: Critical:
 *   - Turns switch ON if the action performs a critical hit.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit lands a critical
 *     hit, then the switch will remain ON for the rest of the action.
 * 
 *   Switch: Miss/Evade:
 *   - Turns switch ON if the action misses/is evaded.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit fails to land,
 *     then the switch will remain ON for the rest of the action.
 * 
 * ---
 * 
 * Variables
 * 
 *   Variable: Damage:
 *   - Variable records target damage during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of damage done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 * 
 *   Variable: Healing:
 *   - Variable records target healing during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of healing done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 * 
 * ---
 *
 * JS: Battle-Related
 * 
 *   JS: Pre-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Battle Victory:
 *   - Target function: BattleManager.processVictory()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Escape Success:
 *   - Target function: BattleManager.onEscapeSuccess()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Escape Failure:
 *   - Target function: BattleManager.onEscapeFailure()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Battle Defeat:
 *   - Target function: BattleManager.processDefeat()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Pre-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Turn-Related
 * 
 *   JS: Pre-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Action-Related
 * 
 *   JS: Pre-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Pre-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Post-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-End Action:
 *   - Target function: BattleManager.endAction()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Action:
 *   - DescriTarget function: BattleManager.endAction()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Layout Settings
 * ============================================================================
 *
 * The Battle Layout Settings Plugin Parameter gives you control over the look,
 * style, and appearance of certain UI elements. These range from the way the
 * Battle Status Window presents its information to the way certain windows
 * like the Party Command Window and Actor Command Window appear.
 *
 * ---
 *
 * Battle Layout Style
 * - The style used for the battle layout.
 * 
 *   Default:
 *   - Shows actor faces in Battle Status.
 * 
 *   List:
 *   - Lists actors in Battle Status.
 * 
 *   XP:
 *   - Shows actor battlers in a stretched Battle Status.
 * 
 *   Portrait:
 *   - Shows portraits in a stretched Battle Status.
 * 
 *   Border:
 *   - Displays windows around the screen border.
 *
 * ---
 *
 * List Style
 * 
 *   Show Faces:
 *   - Shows faces in List Style?
 * 
 *   Command Window Width:
 *   - Determine the window width for the Party and Actor Command Windows.
 *   - Affects Default and List Battle Layout styles.
 *
 * ---
 *
 * XP Style
 * 
 *   Command Lines:
 *   - Number of action lines in the Actor Command Window for the XP Style.
 * 
 *   Sprite Height:
 *   - Default sprite height used when if the sprite's height has not been
 *     determined yet.
 * 
 *   Sprite Base Location:
 *   - Determine where the sprite is located on the Battle Status Window.
 *     - Above Name - Sprite is located above the name.
 *     - Bottom - Sprite is located at the bottom of the window.
 *     - Centered - Sprite is centered in the window.
 *     - Top - Sprite is located at the top of the window.
 *
 * ---
 *
 * Portrait Style
 * 
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait instead of a face.
 * 
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Border Style
 * 
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 * 
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait at the edge of the screen.
 * 
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Skill & Item Windows
 * 
 *   Middle Layout:
 *   - Shows the Skill & Item Windows in mid-screen?
 * 
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 *
 * ---
 * 
 * Status Window Elements
 * 
 *   Battler Name:
 *   Gauge 1 (HP):
 *   Gauge 2 (MP):
 *   Gauge 3 (TP):
 *   State Icon:
 *   TPB/ATB Gauge:
 * 
 *     Offset: X/Y:
 *     - Offset this Battle Status Window element's X/Y.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Window Skin:
 * 
 *     Filename:
 *     - Filename used for the Battle Status Window skin.
 *     - Leave this empty to use the default window skin.
 * 
 *     Hide Window Skin?:
 *     - Hide the window skin for the Battle Status Window?
 * 
 *   Selectable Background:
 * 
 *     Hide Selectable BG?:
 *     - Show/Hide the selectable background box for the Battle Status Window?
 * 
 *   Attachments:
 * 
 *     Back Attachment:
 * 
 *       Filename:
 *       - Filename used for an image to attach to the back of the Battle
 *         Status Window. Leave empty for none.
 * 
 *       Offset: X/Y:
 *       - Offset this Battle Status Window element's X/Y.
 *       - For X: Negative goes left. Positive goes right.
 *       - For Y: Negative goes up. Positive goes down.
 * 
 *     Front Attachment:
 * 
 *       Filename:
 *       - Filename used for an image to attach to the front of the Battle
 *         Status Window. Leave empty for none.
 * 
 * ---
 * 
 * UI Elements
 * 
 *   Anti-Tint UI?
 *   - Prevent UI Elements from being tinted?
 *   - This prevents UI Elements such as HP Gauges, Enemy Names, Battle Cursor,
 *     and Weakness Display from being affected by screen tint.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Log Settings
 * ============================================================================
 *
 * These Plugin Parameters give you control over how the Battle Log Window, the
 * window shown at the top of the screen in the battle layout, appears, its
 * various properties, and which text will be displayed.
 *
 * The majority of the text has been disabled by default with this plugin to
 * make the flow of battle progress faster.
 *
 * ---
 *
 * General
 * 
 *   Back Color:
 *   - Use #rrggbb for a hex color.
 * 
 *   Max Lines:
 *   - Maximum number of lines to be displayed.
 * 
 *   Message Wait:
 *   - Number of frames for a usual message wait.
 * 
 *   Text Align:
 *   - Text alignment for the Window_BattleLog.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for the battle log.
 *
 * ---
 *
 * Start Turn
 * 
 *   Show Start Turn?:
 *   - Display turn changes at the start of the turn?
 * 
 *   Start Turn Message:
 *   - Message displayed at turn start.
 *   - %1 - Turn Count
 * 
 *   Start Turn Wait:
 *   - Number of frames to wait after a turn started.
 *
 * ---
 *
 * Display Action
 * 
 *   Show Centered Action?:
 *   - Display a centered text of the action name?
 * 
 *   Show Skill Message 1?:
 *   - Display the 1st skill message?
 * 
 *   Show Skill Message 2?:
 *   - Display the 2nd skill message?
 * 
 *   Show Item Message?:
 *   - Display the item use message?
 *
 * ---
 *
 * Action Changes
 * 
 *   Show Counter?:
 *   - Display counter text?
 * 
 *     Wait Frames:
 *     - How many frames should the battle log wait after text?
 *     - 60 frames = 1 second.
 * 
 *   Show Reflect?:
 *   - Display magic reflection text?
 * 
 *     Wait Frames:
 *     - How many frames should the battle log wait after text?
 *     - 60 frames = 1 second.
 * 
 *   Show Substitute?:
 *   - Display substitute text?
 * 
 *     Wait Frames:
 *     - How many frames should the battle log wait after text?
 *     - 60 frames = 1 second.
 *
 * ---
 *
 * Action Results
 * 
 *   Show No Effect?:
 *   - Display no effect text?
 * 
 *   Show Critical?:
 *   - Display critical text?
 * 
 *   Show Miss/Evasion?:
 *   - Display miss/evasion text?
 * 
 *   Show HP Damage?:
 *   - Display HP Damage text?
 * 
 *   Show MP Damage?:
 *   - Display MP Damage text?
 * 
 *   Show TP Damage?:
 *   - Display TP Damage text?
 *
 * ---
 *
 * Display States
 * 
 *   Show Added States?:
 *   - Display added states text?
 * 
 *   Show Removed States?:
 *   - Display removed states text?
 * 
 *   Show Current States?:
 *   - Display the currently affected state text?
 * 
 *   Show Added Buffs?:
 *   - Display added buffs text?
 * 
 *   Show Added Debuffs?:
 *   - Display added debuffs text?
 * 
 *   Show Removed Buffs?:
 *   - Display removed de/buffs text?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battleback Scaling Settings
 * ============================================================================
 *
 * By default, the battlebacks in RPG Maker MZ scale as if the screen size is
 * a static 816x624 resolution, which isn't always the case. These settings
 * here allow you to dictate how you want the battlebacks to scale for the
 * whole game. These settings CANNOT be changed midgame or per battle.
 *
 * ---
 *
 * Settings
 * 
 *   Default Style:
 *   - The default scaling style used for battlebacks.
 *   - MZ (MZ's default style)
 *   - 1:1 (No Scaling)
 *   - Scale To Fit (Scale to screen size)
 *   - Scale Down (Scale Downward if Larger than Screen)
 *   - Scale Up (Scale Upward if Smaller than Screen)
 * 
 *   JS: 1:1:
 *   JS: Scale To Fit:
 *   JS: Scale Down:
 *   JS: Scale Up:
 *   - This code gives you control over the scaling for this style.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Party Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you control over how the Party Command Window
 * operates in the battle scene. You can turn disable it from appearing or make
 * it so that it doesn't 
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Party Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Party Command Window.
 * 
 *   Fight Icon:
 *   - The icon used for the Fight command.
 * 
 *   Add Auto Battle?:
 *   - Add the "Auto Battle" command to the Command Window?
 * 
 *     Auto Battle Icon:
 *     - The icon used for the Auto Battle command.
 * 
 *     Auto Battle Text:
 *     - The text used for the Auto Battle command.
 * 
 *   Add Status?:
 *   - Add the "Status" command to the Command Window?
 * 
 *   Add Options?:
 *   - Add the "Options" command to the Command Window?
 * 
 *     Options Icon:
 *     - The icon used for the Options command.
 * 
 *     Active TPB Message:
 *     - Message that will be displayed when selecting options during the
 *       middle of an action.
 * 
 *   Escape Icon:
 *   - The icon used for the Escape command.
 *
 * ---
 *
 * Access
 * 
 *   Skip Party Command:
 *   - DTB: Skip Party Command selection on turn start.
 *   - TPB: Skip Party Command selection at battle start.
 * 
 *   Disable Party Command:
 *   - Disable the Party Command Window entirely?
 *
 * ---
 *
 * Help Window
 * 
 *   Fight:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 * 
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 * 
 *   Options:
 *   - Text displayed when selecting the Options command.
 * 
 *   Escape:
 *   - Text displayed when selecting the escape command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you to change various aspects regarding the
 * Actor Command Window and how it operates in the battle scene. This ranges
 * from how it appears to the default battle commands given to all players
 * without a custom <Battle Commands> notetag.
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Actor Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Actor Command Window.
 * 
 *   Item Icon:
 *   - The icon used for the Item command.
 * 
 *   Normal SType Icon:
 *   - Icon used for normal skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * 
 *   Magic SType Icon:
 *   - Icon used for magic skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 *
 * ---
 *
 * Battle Commands
 * 
 *   Command List:
 *   - List of battle commands that appear by default if the <Battle Commands>
 *     notetag isn't present.
 *
 *     - Attack 
 *       - Adds the basic attack command.
 * 
 *     - Skills
 *       - Displays all the skill types available to the actor.
 * 
 *     - SType: x
 *     - Stype: name
 *       - Adds in a specific skill type.
 *       - Replace 'x' with the ID of the skill type.
 *       - Replace 'name' with the name of the skill type (without text codes).
 *
 *     - All Skills
 *       - Adds all usable battle skills as individual actions.
 * 
 *     - Skill: x
 *     - Skill: name
 *       - Adds in a specific skill as a usable action.
 *       - Replace 'x' with the ID of the skill.
 *       - Replace 'name' with the name of the skill.
 * 
 *     - Guard
 *       - Adds the basic guard command.
 * 
 *     - Item
 *       - Adds the basic item command.
 * 
 *     - Status
 *       - Adds the status command.
 * 
 *     - Escape
 *       - Adds the escape command.
 * 
 *     - Auto Battle
 *       - Adds the auto battle command.
 * 
 *     - Party
 *       - Requires VisuMZ_2_PartySystem!
 *       - Switches out the current actor for another.
 * 
 *     - Combat Log
 *       - Requires VisuMZ_4_CombatLog!
 *       - Shows combat log.
 * 
 *     - Talk
 *       - Requires VisuMZ_3_BattleCmdTalk!
 *       - Shows talk command if applicable.
 * 
 *     - Weapon Swap
 *       - Requires VisuMZ_2_WeaponSwapSystem!
 *       - Swaps current weapon for next one.
 * 
 *   Show Command Costs:
 *   - If a battle command has a resource cost, show it?
 *
 * ---
 *
 * Help Window
 * 
 *   Skill Types:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 * 
 *   Items:
 *   - Text displayed when selecting the item command.
 * 
 *   Escape:
 *   - Text displayed when selecting the escape command.
 * 
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: In-Battle Status Window
 * ============================================================================
 *
 * Added with Battle Core version 1.84, this new window allows the player to
 * view the status of the current active party. If the actors have states and
 * buffs, the player can scroll through them and read about their effects
 * through the help window.
 * 
 * If you would like to manage which parameters can appear here, this can be
 * done through the VisuMZ_0_CoreEngine's "Parameter Settings" and adjust which
 * parameters are shown through "Extended Parameters". These settings will
 * reflect in the In-Battle Status window, too. Otherwise, the parameters that
 * will be shown will only be MaxHP, MaxMP, ATK, DEF, MAT, MDF, AGI, and LUK.
 * 
 * The In-Battle Status can also be used to view enemies (if the parameter is
 * enabled). To view enemies, players must scroll through all the actors before
 * viewing enemies. Enemies will have their battler graphic displayed. If the
 * enemy has a SV Battler graphic, that will be displayed instead. However, if
 * the enemy has a Dragonbones, then the database battler graphic is displayed
 * to match any of the turn order displays as those also use the same graphic.
 * 
 * Enemies will not display the current HP on their In-Battle Status gauges.
 * Instead, they will display what percentage their HP, MP, and/or TP is at.
 * This is primarily due to how gauges do not support large numbers well and
 * showing the percentage values are better for this scene.
 *
 * ---
 * 
 * General Settings
 * 
 *   Status Icon:
 *   - The icon used for the Status command.
 * 
 *   Status Graphic:
 *   - Choose how the actor graphic appears for In-Battle Status.
 * 
 *   Help Description:
 *   - Text displayed when selecting the Status command.
 * 
 * ---
 * 
 * Enemy Settings
 * 
 *   Allow View Enemies?:
 *   - Allows players to view enemy stats (even if limited)?
 * 
 *   Show Level?:
 *   - Shows the enemy's level in the In-Battle Status?
 * 
 *   Hidden Parameter:
 *   - The text that appears if a parameter value is hidden.
 * 
 *     Show Params Always:
 *     - Always show exact enemy parameter values.
 * 
 *     Show Battle Test:
 *     - Show exact enemy parameter values in battle test.
 * 
 *     Show If Defeated:
 *     - Show exact enemy parameter values if enemy has been defeated before.
 * 
 * ---
 * 
 * Page Buttons:
 * 
 *   Show Page Buttons?:
 *   - Shows page buttons to switch between actors?
 *   - Still requires Touch UI option to be on.
 * 
 *   Large UI Position?:
 *   - If using a large resolution, position the page buttons on which side?
 * 
 *  Offset X
 *  - Offsets the page buttons x position.
 *  - Negative: left. Positive: right.
 * 
 *  Offset Y
 *  - Offsets the page buttons y position.
 *  - Negative: up. Positive: down.
 * 
 * ---
 * 
 * Parameter Display
 * 
 *   Increased Value
 *   - How are increased parameter values displayed?
 *   - %1 - Parameter Value
 * 
 *   Decreased Value
 *   - How are increased parameter values displayed?
 *   - %1 - Parameter Value
 * 
 * ---
 * 
 * States Display
 * 
 *   Max Width
 *   - Maximum width of the states list display.
 * 
 *   List States?
 *   - Lists states in the states list display?
 * 
 *   List Buffs?
 *   - Lists buffs in the states list display?
 * 
 *   List Debuffs?
 *   - Lists debuffs in the states list display?
 * 
 *   Buffs/Debuffs Display:
 * 
 *     Buff Name Format
 *     - Text format used to represent buffs.
 *     - %1 - Parameter Name
 * 
 *     Debuff Name Format
 *     - Text format used to represent debuffs.
 *     - %1 - Parameter Name
 * 
 *   Normal State:
 * 
 *     Normal Icon
 *     - Icon used to represent normal state (unaffected by states, buffs, or
 *       debuffs).
 * 
 *     Normal Text
 *     - Text used to represent normal state (unaffected by states, buffs, or
 *       debuffs).
 * 
 * ---
 * 
 * Help Descriptions
 * 
 *   State Help Format:
 *   - Text format used for state help descriptions
 *   - %1 - Description; %2 - Turns/Actions Remaining
 * 
 *   Buff Help Format:
 *   - Text format used for Buff help descriptions
 *   - %1 - Param; %2 - Percent; %3 - Color; %4 - Turns
 * 
 *   Debuff Help Format:
 *   - Text format used for Debuff help descriptions
 *   - %1 - Param; %2 - Percent; %3 - Color; %4 - Turns
 * 
 *   Normal State:
 *   - Help description used to explain normal state (unaffected by states,
 *     buffs, or debuffs).
 * 
 *   Turns/Actions Left:
 * 
 *     Actions Format:
 *     - Text format used to represent actions remaining.
 *     - %1 - Actions; %2 - Color
 * 
 *     Turns Format:
 *     - Text format used to represent turns remaining.
 *     - %1 - Turns; %2 - Color
 * 
 *     Passive Text:
 *     - Text used to represent a passive.
 * 
 * ---
 * 
 * Window Settings
 * 
 *   Background Type:
 *   - Select background type for this window.
 * 
 *   JS: Draw Data:
 *   - Code used to draw battler data.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 * 
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Multi-Target Windows Settings
 * ============================================================================
 *
 * Action Sequence Plugin Parameters adjust how the Multi-Target Windows appear
 * in battle. These windows are visible when selecting an enemy or actor while
 * using a skill/item that has the <Single or Multiple Select> notetag.
 * 
 * Those wondering why this isn't regulated to a command left or right of the
 * enemies and actors is because mouse controls and touch controls would not be
 * able to select all enemies or all allies that way.
 *
 * ---
 * 
 * Properties
 * 
 *   Window Width:
 *   - What is the width used for the Multi-Target Window?
 * 
 *   Background Type:
 *   - Select background type for these windows.
 * 
 *   Show Button:
 *   - Shows the keyboard/controller button to press?
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 * ---
 * 
 * Vocab
 * 
 *   All Actors:
 *   - What is the text used for the "All Actors" button?
 * 
 *   All Enemies:
 *   - What is the text used for the "All Enemies" button?
 * 
 * ---
 * 
 * Offsets > Actor Offsets
 * Offsets > Enemy Offsets
 * 
 *   Offset X:
 *   - Offsets the button's x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the button's y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Damage Combo Window Settings
 * ============================================================================
 * 
 * If enabled, this window will display updated information about the total
 * amount of hits performed and total damage/healing value executed for HP.
 * 
 * This only applies when HP damage is directly dealt through action effects.
 * It does NOT apply for MP damage, TP damage, states, regeneration, or event
 * commands.
 * 
 * If you would like to adjust the Damage Combo Window mid-action, you can use
 * the following script calls to do so:
 * 
 *     $comboWindowReset()
 *     - Resets the all values found in the damage combo window.
 * 
 *     $comboWindowIncreaseHits(x)
 *     - Increases the current hit counter in the combo window by 'x'.
 *     - Insert a number for 'x'.
 *     - Example: $comboWindowIncreaseHits(2)
 * 
 *     $comboWindowIncreaseDamage(x)
 *     - Increases the current total damage counter in the combo window by 'x'.
 *     - Insert a number for 'x'.
 *     - This will offset any healing added in the damage counter window.
 *     - Example: $comboWindowIncreaseDamage(100)
 * 
 *     $comboWindowIncreaseHealing(x)
 *     - Increases the current total heal counter in the combo window by 'x'.
 *     - Insert a number for 'x'.
 *     - This will offset any damage added in the damage counter window.
 *     - Example: $comboWindowIncreaseHealing(200)
 * 
 * ---
 * 
 * General Settings:
 * 
 *   Enable?:
 *   - Add the Combo Window to show in battle?
 * 
 * ---
 * 
 * Appearance Settings:
 * 
 *   Custom Font:
 *   - Insert the custom font face name here.
 *   - Use VisuMZ_1_MessageCore to register new fonts.
 * 
 *   Text Align:
 *   - Text alignment for this window?
 * 
 *   JS: Draw Data:
 *   - Code used to draw the data in this window.
 * 
 * ---
 * 
 * Vocabulary:
 * 
 *   Damage Combo Format:
 *   - Text format used to display total hits for damage.
 *   - %1 - Total Hits
 * 
 *   Healing Combo Format:
 *   - Text format used to display total hits for healing.
 *   - %1 - Total Hits
 * 
 *   Damage Total Format:
 *   - Text format used to display total value for damage.
 *   - %1 - Total Damage
 * 
 *   Healing Total Format:
 *   - Text format used to display total value for healing.
 *   - %1 - Total Healing
 * 
 * ---
 * 
 * Position Settings:
 * 
 *   Fade Shift X:
 *   - Shifts the windows x position when fading.
 *   - Negative: left. Positive: right.
 * 
 *   Fade Shift Y:
 *   - Shifts the windows y position when fading.
 *   - Negative: up. Positive: down.
 * 
 *   Offset X:
 *   - Offsets the windows x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the windows y position.
 *   - Negative: up. Positive: down.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 * 
 * ---
 * 
 * Updating Settings:
 * 
 *   Number Roll Duration:
 *   - Frame duration to roll damage numbers.
 *   - 60 frames = 1 second.
 * 
 *   Minimum Stay Duration:
 *   - Frame duration to stay visible minimum. 
 *   - 60 frames = 1 second.
 * 
 *   Minimum Hit Visible:
 *   - Minimum hits before combo window becomes visible?
 * 
 *   Opacity Speed:
 *   - Opacity speed when fading in/out.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how the sideview battlers behave for
 * the actor sprites. Some of these settings are shared with enemies if they
 * use sideview battler graphics.
 *
 * ---
 *
 * Flinch
 * 
 *   Flinch Distance X:
 *   - The normal X distance when flinching.
 * 
 *   Flinch Distance Y:
 *   - The normal Y distance when flinching.
 * 
 *   Flinch Duration:
 *   - The number of frames for a flinch to complete.
 * 
 *   Shake Flinch:
 *   - Perform a shake flinch when taking damage?
 * 
 *     Max Duration:
 *     - Maximum duration a shake flinch can have.
 *     - This is reduced relative to the amount of damage taken.
 * 
 *     Max Power:
 *     - The power rating of a shake flinch at full damage.
 *     - This is reduced relative to the amount of damage taken.
 *
 * ---
 * 
 * Frontview Battlers
 * 
 *   Portrait Animations:
 * 
 *     Each Target:
 *     - Place animations on top for "Each Target" display types?
 *     - Does not apply to MV animations.
 * 
 *     Center of All:
 *     - Place animations on top for "Center of All" display types?
 *     - Does not apply to MV animations.
 * 
 *     Center of Screen:
 *     - Place animations on top for "Center of Screen" display types?
 *     - Does not apply to MV animations.
 * 
 * ---
 *
 * Sideview Battlers
 * 
 *   Anchor:
 * 
 *     Anchor: X:
 *     - Default X anchor for Sideview Battlers.
 * 
 *     Anchor: Y:
 *     - Default Y anchor for Sideview Battlers.
 * 
 *   Chant Style:
 *   - What determines the chant motion?
 *   - Hit type or skill type?
 * 
 *   Motion Speed:
 *   - The number of frames in between each motion.
 * 
 *   Position:
 * 
 *     Offset X:
 *     - Offsets X position where actor is positioned.
 *     - Negative values go left. Positive values go right.
 * 
 *     Offset Y:
 *     - Offsets Y position where actor is positioned.
 *     - Negative values go up. Positive values go down.
 * 
 *   Priority: Active:
 *   - Place the active actor on top of actor and enemy sprites.
 * 
 *   Priority: Actors:
 *   - Prioritize actors over enemies when placing sprites on top of each other
 * 
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 * 
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 * 
 *   State Overlay:
 * 
 *     Offset X:
 *     - Offsets X position for state overlay on actor.
 *     - Negative values go left. Positive values go right.
 * 
 *     Offset Y:
 *     - Offsets Y position for state overlay on actor.
 *     - Negative values go up. Positive values go down.
 * 
 *   JS: Home Position:
 *   - Code used to calculate the home position of actors.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Enemy Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how enemies appear visually in the
 * battle scene. Some of these settings will override the settings used for
 * actors if used as sideview battlers. Other settings include changing up the
 * default attack animation for enemies, how the enemy select window functions,
 * and more.
 *
 * ---
 *
 * Visual
 * 
 *   Attack Animation:
 *   - Default attack animation used for enemies.
 *   - Use <Attack Animation: x> for custom animations.
 * 
 *   Emerge Text:
 *   - Show or hide the 'Enemy emerges!' text at the start of battle.
 * 
 *   Offset X:
 *   - Offsets X position where enemy is positioned.
 *   - Negative values go left. Positive values go right.
 * 
 *   Offset Y:
 *   - Offsets Y position where enemy is positioned.
 *   - Negative values go up. Positive values go down.
 * 
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 *
 * ---
 *
 * Select Window
 * 
 *   Any: Last Selected:
 *   - Prioritize last selected enemy over front view or sideview settings?
 * 
 *   FV: Right Priority:
 *   - If using frontview, auto select the enemy furthest right.
 * 
 *   SV: Right Priority:
 *   - If using sideview, auto select the enemy furthest right.
 * 
 * ---
 * 
 * Name:
 * 
 *   Legacy Option:
 *   - Use the legacy version (window) or new version (sprite).
 *   - WARNING: Legacy version is no longer supported for bugs.
 *   - Not all settings available here in the Plugin Parameters will be
 *     available to the legacy version (ie Always Visible and Attach States).
 * 
 *   Font Size:
 *   - Font size used for enemy names.
 * 
 *   Name Position:
 * 
 *     Offset X:
 *     Offset Y:
 *     - Offset the enemy name's position by this much.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Name: Attach States:
 *   - Attach the enemy's state icon to the enemy name?
 * 
 *     Attach: Offset X:
 *     Attach: Offset Y:
 *     - How much to offset the attached icon's X/Y position by?
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Name Visibility:
 * 
 *     Always Hidden:
 *     - Determines if the enemy name will always be visible.
 *     - Highest priority.
 * 
 *     Always Visible:
 *     - Determines if the enemy name will always be visible.
 *     - Medium priority.
 * 
 *     As Target:
 *     - Shows enemy name when enemy is a target.
 *     - Medium priority.
 * 
 *     By Selection?:
 *     - Determines the conditions for enemy name visibility.
 *     - Lowest priority.
 * 
 *     Temporary Visibility:
 *     - Number of frames enemy's name temporarily visible after taking an
 *       action effect in battle.
 *     - 60 frames = 1 second.
 *
 * ---
 *
 * Sideview Battlers
 * 
 *   Allow Collapse:
 *   - Causes defeated enemies with SV Battler graphics to "fade away"
 *     when defeated?
 * 
 *   Anchor: X:
 *   - Default X anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 * 
 *   Anchor: Y:
 *   - Default Y anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 * 
 *   Motion: Idle:
 *   - Sets default idle animation used by Sideview Battlers.
 * 
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 * 
 *   Size: Width:
 *   - Default width for enemies that use Sideview Battlers.
 * 
 *   Size: Height:
 *   - Default height for enemies that use Sideview Battlers.
 * 
 *   Weapon Type:
 *   - Sets default weapon type used by Sideview Battlers.
 *   - Use 0 for Bare Hands.
 *
 * ---
 * 
 * Aspect Defaults
 * 
 *   Name Format:
 *   - Default name aspect format.
 *   - %1 - Original Enemy Name
 * 
 *   Name Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Icon:
 *   - Default icon used for aspect.
 *   - Use <Aspect Icon: x> to change icon.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: HP Gauge Settings
 * ============================================================================
 *
 * Settings that adjust the visual HP Gauge displayed in battle.
 *
 * ---
 *
 * Show Gauges For
 * 
 *   Actors:
 *   - Show HP Gauges over the actor sprites' heads?
 *   - Requires SV Actors to be visible.
 * 
 *   Enemies:
 *   - Show HP Gauges over the enemy sprites' heads?
 *   - Can be bypassed with <Hide HP Gauge> notetag.
 * 
 *     Requires Defeat?:
 *     - Requires defeating the enemy once to show HP Gauge?
 *     - Can be bypassed with <Show HP Gauge> notetag.
 * 
 *       Battle Test Bypass?:
 *       - Bypass the defeat requirement in battle test?
 *
 * ---
 *
 * Settings
 * 
 *   Animation Duration:
 *   - How many frames should gauges animate themselves?
 *   - Default: 20 frames.
 * 
 *   Anchor X:
 *   Anchor Y:
 *   - Where do you want the HP Gauge sprite's anchor X/Y to be?
 *     Use values between 0 and 1 to be safe.
 * 
 *   Scale:
 *   - How large/small do you want the HP Gauge to be scaled?
 * 
 *   Offset X:
 *   Offset Y:
 *   - How many pixels to offset the HP Gauge's X/Y by?
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the 'Show HP Gauge' option to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Option Name:
 *   - Command name of the option.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Action Sequence Settings
 * ============================================================================
 *
 * Action Sequence Plugin Parameters allow you to decide if you want automatic
 * Action Sequences to be used for physical attacks, the default casting
 * animations used, how counters and reflects appear visually, and what the
 * default stepping distances are.
 *
 * ---
 *
 * Automatic Sequences
 * 
 *   Melee Single Target:
 *   - Allow this auto sequence for physical, single target actions?
 * 
 *   Melee Multi Target:
 *   - Allow this auto sequence for physical, multi-target actions?
 *
 * ---
 * 
 * Quality of Life
 * 
 *   Auto Notetag:
 *   - Automatically apply the <Custom Action Sequence> notetag effect to any
 *     item or skill that has a Common Event?
 *   - Any item or skill without a Common Event attached to it will use the
 *     Automatic Action Sequences instead.
 *   - The <Auto Action Sequence> notetag will disable this effect for that
 *     particular skill or item.
 * 
 * ---
 *
 * Cast Animations
 * 
 *   Certain Hit:
 *   - Cast animation for Certain Hit skills.
 * 
 *   Physical:
 *   - Cast animation for Physical skills.
 * 
 *   Magical:
 *   - Cast animation for Magical skills.
 *
 * ---
 *
 * Counter/Reflect
 * 
 *   Counter Back:
 *   - Play back the attack animation used?
 * 
 *   Reflect Animation:
 *   - Animation played when an action is reflected.
 * 
 *   Reflect Back:
 *   - Play back the attack animation used?
 *
 * ---
 *
 * Stepping
 * 
 *   Melee Distance:
 *   - Minimum distance in pixels for Movement Action Sequences.
 * 
 *   Step Distance X:
 *   - The normal X distance when stepping forward.
 * 
 *   Step Distance Y:
 *   - The normal Y distance when stepping forward.
 * 
 *   Step Duration:
 *   - The number of frames for a stepping action to complete.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.85: November 14, 2024
 * * Bug Fixes!
 * ** Fixed a bug where the enemy name's visibility would remain after an
 *    action has taken place and before inputting is done. Fix made by Olivia.
 * ** Fixed a bug where the "Name Visibility As Target" plugin parameter did
 *    not work properly. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Updated <Help Description> notetag documentation:
 * *** This is used as a common notetag between Battle Core's state
 *     descriptions and State Tooltips' state descriptions.
 * * New Features!
 * ** New Notetag added by Olivia:
 * *** <In-Battle Status Description>
 * **** A prioritized help description used to separate from the common help
 *      description notetag shared with State Tooltips.
 * ** New Plugin Parameters added by Olivia:
 * *** Actor Battlers > Frontview > Portrait Animations > Each Target
 * *** Actor Battlers > Frontview > Portrait Animations > Center of All
 * *** Actor Battlers > Frontview > Portrait Animations > Center of Screen
 * **** Place animations on top or behind for these display types?
 * *** Battle Log > Action Changes > Show Counter? > Wait Frames
 * *** Battle Log > Action Changes > Show Reflect? > Wait Frames
 * *** Battle Log > Action Changes > Show Substitute? > Wait Frames
 * **** If devs allow the results of counters, reflects, and substitutes, there
 *      wasn't enough time before to allow the text to be visible on screen.
 *      You can now adjust how many frames are now visible if text is shown.
 * **** Default values are left at 0 as to not interrupt currently existing
 *      action sequences.
 * 
 * Version 1.84: September 19, 2024
 * * Bug Fixes!
 * ** Fixed a bug where Action Sequence "MOVE: Change Home By Distance" would
 *    also be affected by the actor and enemy position offsets. Fixed by Irina.
 * ** Fixed a bug where Action Sequence "MECH: STB Exploit Effect" caused a
 *    crash. Fix made by Arisu.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Command added by Arisu:
 * *** ANIM: Change Battle Portrait (JS)
 * **** Changes the battle portrait of the actor through JavaScript.
 * **** Can be used outside of battle/action sequences.
 * ** New Plugin Parameters added by Olivia:
 * *** Plugin Parameters > In-Battle Status Window
 * **** This new window allows the player to view the status of the current
 *      active party. If the actors have states and buffs, the player can
 *      scroll through them and read about their effects through the help
 *      window.
 * ** New Notetags added by Olivia:
 * *** <Help Description>
 * **** Assigns a help description for the state that's displayed under the
 *      new "Status" actor command.
 * *** <Exclude From Status Listing>
 * **** Excludes the state from being displayed in the status listing.
 * *** <Aspect Name: x>
 * *** <Aspect Icon: x>
 * *** <Aspect Color: x>
 * *** <Aspect Description>
 * **** Used to define enemy aspect that will show up in the In-Battle Status
 *      as well as other supported plugins.
 * *** <Popup Position: Head>
 * *** <Popup Position: Center>
 * *** <Popup Position: Base>
 * **** Changes the popup starting position for this enemy.
 * *** <Popup Offset X: +x>
 * *** <Popup Offset X: -x>
 * *** <Popup Offset Y: +y>
 * *** <Popup Offset Y: -y>
 * **** Changes the popup X/Y position offset for this enemy.
 * ** New Plugin Parameters added by Olivia:
 * *** Plugin Parameters > Party Command Window > Add Status?
 * **** Add the "Status" command to the Command Window? 
 * *** Plugin Parameters > Actor Command Window > Command List
 * **** Updated to have the "Status" command.
 * *** Plugin Parameters > In-Battle Status Window
 * **** Completely new! View the help file for more information.
 * *** Plugin Parameters > Enemy > Aspects
 * **** Used for the In-Battle Status as well as other supported plugins.
 * 
 * Version 1.83: May 16, 2024
 * * Bug Fixes!
 * ** Fixed a bug where sometimes, a battler in Active TPB would not refresh
 *    their motion after a state has been removed. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Fixed a typo with MP Life Steal notetag entry.
 * * Feature Updates!
 * ** Added fail safes for some plugin parameters in case users outright delete
 *    plugin parameter values without introducing something to replace them.
 *    Update made by Olivia.
 * * New Features!
 * ** New Action Sequence added by Olivia:
 * *** GRID: Add Trigger to Node JS
 * **** Adds JS Trigger to target node. Target node cannot have battler.
 * **** Requires VisuMZ_2_BattleGridSystem!
 * ** New notetags added by Olivia:
 * *** <JS Accuracy>
 * *** <JS Accuracy as User>
 * *** <JS Accuracy as Target>
 * **** Allows usage of JavaScript code to modify accuracy rates of actions in
 *      battle through skills, items, and trait objects.
 * *** <JS Critical Rate as User>
 * *** <JS Critical Rate as Target>
 * **** Allows usage of JavaScript code to modify critical rate of actions in
 *      battle through skills, items, and trait objects.
 * **** <JS Critical Rate> version already exists.
 * ** New Plugin Parameters added by Olivia
 * *** Plugin Parameters > Damage Combo Window
 * **** If enabled, this window will display updated information about the
 *      total amount of hits performed and total damage/healing value executed
 *      for HP.
 * *** Plugin Parameters > Actor Battler Settings > Sideview Battlers >
 *     State Overlay > Offset X/Y
 * **** Offsets X/Y position for state overlay on actor.
 * *** Plugin Parameters > Enemy Battler Settings > Name Visibility >
 *     As Target
 * **** Shows enemy name when enemy is a target.
 * *** Plugin Parameters > Enemy Battler Settings > Name Visibility >
 *     Temporary Visibility
 * **** Number of frames enemy's name temporarily visible after taking an
 *      action effect in battle.
 * 
 * Version 1.82: March 14, 2024
 * * Bug Fixes!
 * ** Home movement changes did not acknowledge actor and enemy offset X/Y
 *    positions. This should now be reflected properly. Fix made by Irina.
 * ** Fixed a bug where in active TPB/ATB, revived actors may not resume normal
 *    motions after collapsing. Fix made by Olivia.
 * 
 * Version 1.81: February 15, 2024
 * * Bug Fixes!
 * ** Fixed a bug that would cause active TPB inputting actors to not show
 *    their damage or evasion motions. Fix made by Olivia.
 * ** Fixed a bug that would cause a crash upon motion changes. Fix by Olivia.
 * ** Fixed an incorrect spelling of "Anger" for "ANIM: Balloon Animation" that
 *    prevented it from working properly.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Olivia:
 * *** ANIM: Show Animation JS
 * **** Plays the a specific animation on unit(s). Uses JavaScript to determine
 *      animation ID.
 * ** New Action Sequences added for future plugin: VisuMZ_2_BattleGridSystem
 * *** GRID: Action Animation at Node
 * *** GRID: Add Passive State(s) to Node
 * *** GRID: Add Trigger to Node
 * *** GRID: Animation ID at Node
 * *** GRID: Animation JS at Node
 * *** GRID: Animation Type at Node
 * *** GRID: Move Target(s) In Direction
 * *** GRID: Pull To Target Node
 * *** GRID: Push From Target Node
 * *** GRID: Remove All Passive States from Node
 * *** GRID: Remove Passive State(s) from Node
 * *** GRID: Remove Trigger from Node
 * *** GRID: Teleport To Node
 * *** GRID: Traverse To Node
 * **** Requires the future plugin VisuMZ_2_BattleGridSystem!
 * **** Read the help section for more information on these.
 * 
 * Version 1.80: January 18, 2024
 * * Bug Fixes!
 * ** Fixed a crash that would occur with <Disperse Damage> when used outside
 *    of battle. Fix made by Irina.
 * ** Fixed a crash that would occur with certain enemy graphics when images
 *    used for them would disappear. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Olivia:
 * *** ANIM: Guard Animation
 * *** ANIM: Item Animation
 * *** ANIM: Skill Animation
 * **** Plays the animation associated with the user's guard action (if any),
 *      or a specific item/skill.
 * *** MECH: Emulate Attack Effect
 * *** MECH: Emulate Guard Effect
 * *** MECH: Emulate Item Effect
 * *** MECH: Emulate Skill Effect
 * **** Emulate an "Action Effect" but using a the user's attack skill, guard
 *      skill, specific item, or specific skill instead of the current action.
 * **** Essentially lets you perform the mechanics of another action without
 *      having to use another action or needing to pay that action's costs.
 * *** MECH: Emulate Skill Cost
 * **** Pick a skill for target(s) to emulate paying the cost of.
 * **** Includes cooldowns and limited uses.
 * *** MECH: State Turns Change By
 * *** MECH: State Turns Change To
 * **** Changes target(s) state turns by an amount/to a certain value.
 * **** Requires VisuMZ_1_SkillsStatesCore!
 * *** Projectile action sequences have new Extra Features!
 * **** See v1.08 changes for VisuMZ_3_ActSeqProjectiles.
 * 
 * Version 1.79: December 14, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Arisu:
 * *** ANIM: Balloon Animation
 * **** Plays a balloon animation on target(s).
 * *** ANIM: Balloon Icon (Single)
 * *** ANIM: Balloon Icon (Range)
 * *** ANIM: Balloon Icon (Specific)
 * **** Plays a balloon animation using an icon on target(s).
 * **** Requires VisuMZ_4_IconBalloons!
 * 
 * Version 1.78: October 12, 2023
 * * Bug Fixes!
 * ** Fixed a bug that is caused by using the actor escape command not escaping
 *    properly in battle and causing a freeze. Fix made by Olivia.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Parameters > Mechanics > Turn End Buffs Expire?
 * **** Normally, buffs expire after all actions end.
 * **** But here, you can have buffs expire on turn end.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.77: August 17, 2023
 * * Bug Fixes!
 * ** Fixed a bug where for TPB, actions aimed at dead targets would not
 *    redirect to suitable targets. Fix made by Olivia.
 * ** Fixed a bug where dual wielding would not use a weapon if it was equipped
 *    in the second weapon slot if the first weapon slot was empty. Fix made
 *    by Olivia.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Added compatibility for VisuStella MZ Battle Voices Action Sequences.
 * * Documentation Update!
 * ** Help file updated for new features.
 * 
 * Version 1.76: July 13, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Olivia and sponsored by NSG:
 * *** MOVE: Change Home To JS Coordinates
 * **** Change home position(s) to specified JS Coordinates. Sideview-only!
 *      Uses JS!
 * *** MOVE: Face JS Coordinates
 * **** Causes the unit(s) to face specified JS Coordinates. Sideview-only!
 *      Uses JS!
 * *** MOVE: Move To JS Coordinates
 * **** Moves unit(s) to specified JS Coordinates. Sideview-only! Uses JS!
 * 
 * Version 1.75: March 16, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia and sponsored by Anon:
 * *** <HP Life Steal: x%>
 * *** <MP Life Steal: x%>
 * *** <HP Life Steal hitType: +/-x%>
 * *** <MP Life Steal hitType: +/-x%>
 * *** <Cancel Life Steal>
 * *** <Guard Life Steal>
 * *** <Disarm Life Steal>
 * *** <Negative Life Steal>
 * **** Life Steal properties involving HP/MP are now added. They will restore
 *      a portion of the dealt HP/MP damage to the target.
 * **** This is a different mechanic from Drain HP/Drain MP and cannot be used
 *      together to prevent clashing.
 * **** Read the help file for more information.
 * 
 * Version 1.74: February 16, 2023
 * * Bug Fixes!
 * ** Fixed a bug that would cause a crash if your basic attack skill somehow
 *    manages to target neither an enemy nor an actor. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Auto-action sequence for jumping forward and attacking is now reinstated
 *    so that it's only disabled when the target and user are on the same side.
 *    If there is no target, a jump still occurs for visual player feedback.
 *    Update made by Olivia.
 * * New Features!
 * ** New notetag effect added by Olivia and sponsored by AndyL:
 * *** <Cannot Target User>
 * **** This will cause the action to be unable to select the user as target.
 * **** This is not a targeting scope. Instead, it is used in addition to any
 *      other targeting scopes out there.
 * 
 * Version 1.73: January 20, 2023
 * * Bug Fixes!
 * ** Active TPB custom action sequences will no longer play differently due to
 *    queued inputting actors causing motion refreshes. Fix made by Arisu.
 * ** Corrected and updated Anti-Tint UI animation offsets for MV animations.
 *    Fix made by Irina.
 * ** Fixed a problem with Sideview Battlers not working properly. Fix made
 *    by Irina.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Help file updated for to add the following text to the <Target: x>
 *    notetag entries in order to avoid confusion.
 * *** This will overwrite the existing database scope and ignore the
 *     database's existing scope in favor of this.
 * * Feature Update!
 * ** <Extend: x> Troop Name Tag is now also usable as a Troop Comment Tag.
 * ** Action Sequence targeting has been updated with two new types "special"
 *    and "special x", to be used for future plugins.
 * * New Features!
 * ** New Notetags added by Irina and sponsored by AndyL:
 * *** <Target: Ally or Enemy>
 * *** <Target: Enemy or Ally>
 * **** Allows the player to target allies or enemies with the skill/item.
 * **** See help file for more information.
 * *** <Single or Multiple Select>
 * **** This will allow the skill/item to be able to select either single
 *      targets or multiple targets at once.
 * **** See help file for more information.
 * *** <Disperse Damage>
 * **** This will cause any damage dealt by this skill to be split equally
 *      amongst all targets of the skill including repeats.
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Multi-Target Windows
 * **** Settings that alter the Multi-Target Windows in battle.
 * 
 * Version 1.72: December 15, 2022
 * * Bug Fixes!
 * ** Fixed a transformation of a sideview enemy to a static enemy and back not
 *    working properly. Fix made by Irina.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Feature!
 * ** New Plugin Parameter added by Irina!
 * *** Plugin Parameters > HP Gauges > Settings > Animation Duration
 * **** How many frames should gauges animate themselves? Default: 20 frames.
 * ** New Plugin Parameters added by Yanfly!
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch > Max Power
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch > Max Duration
 * **** These new plugin parameters will cause targets that take HP damage to
 *      shake (in addition to a regular flinch) to provide better visual
 *      feedback to the player.
 * **** Shake Flinch will be kept disabled by default and only turned on when
 *      you want it to be.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.71: November 10, 2022
 * ** Fixed a problem with repeating animations from Visual State Effects
 *    causing softlocks. Fix made by Olivia.
 * 
 * Version 1.70: October 6, 2022
 * * Bug Fixes!
 * ** Fixed a problem with the "Border" style where if a battle portrait
 *    changed midway through the battle, the portrait shown didn't actually
 *    update properly. Fix made by Irina.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence added by Olivia:
 * *** MECH: Active Chain Input Disable
 * **** Disables input for Active Chain Skills at this time.
 * **** Requires VisuMZ_3_ActiveChainSkills!
 * ** New Plugin Parameter added by Olivia and sponsored by Anon:
 * *** Plugin Parameters > Damage Settings > Popups > End Battle Show?
 * **** Show or hide popups upon victory or escape?
 * **** Used to hide battle-state removal popups.
 * 
 * Version 1.69: September 7, 2022
 * * Compatibility Update!
 * ** Better compatibility with VisuMZ Active Chain Skills.
 * ** Compatibility will be seen with VisuMZ_3_ActiveChainSkills version 1.02.
 * * Documentation Update!
 * ** Added notes to the following Action Sequences:
 * *** MOTION: Clear Freeze Frame and MOTION: Freeze Motion Frame
 * **** Only applies to sprite sheets.
 * **** Does NOT work with Dragonbones.
 * **** Use "DB: Dragonbones Time Scale" instead.
 * * Feature Update!
 * ** Reduced MV Animation misalignment when Screen Resolution does not match
 *    the UI Area Resolution. Update by Arisu.
 * ** Command Remember will now remember the locations of single skills. Update
 *    made by Olivia.
 * 
 * Version 1.68: August 4, 2022
 * * Feature Update!
 * ** Damage popups are now automatically cleared upon starting battles. This
 *    is to ensure that, if for some reason, residual damage popup requests
 *    will not be retained. Update made by Olivia.
 * 
 * Version 1.67: July 28, 2022
 * * Feature Updates!
 * ** Rounding window coordinates have been added for for 'XP' and 'Portrait'
 *    styles when window sizes happen to land on non-divisible numbers. Update
 *    made by Irina.
 * ** Enemy name position rounding is now enforced. Update made by Irina.
 * 
 * Version 1.66: July 14, 2022
 * * Bug Fixes!
 * ** Fixed a bug that caused the various Battleback Scaling JS custom plugin
 *    parameters to not work properly. Fix made by Irina.
 * 
 * Version 1.65: July 7, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Automatic action motions for HP and MP Recovery (Certain Hit type) will
 *    now use the "skill" cast SV animation instead of attack animation to
 *    better match the default RPG Maker MZ cast animation. Update by Olivia.
 * * New Features!
 * ** New troop name tag added by Olivia:
 * *** <Extend: x> and <Extend: x, x, x>
 * **** Adds enemies from another troop to the current troop.
 * **** Enemies from another troop will retain their database positions.
 * **** Extended troop members will be added in the order they're listed.
 * **** Be cautious of how many enemies you add as too many will lag the battle
 *      system. We are not responsible for frame drops due to this.
 * 
 * Version 1.64: June 16, 2022
 * * Bug Fixes!
 * ** "All Skills" battle command should now work with the updated version of
 *    VisuMZ Skills & States Core. Fix madde by Olivia.
 * * Compatibility Update
 * ** Plugins should be more compatible with one another.
 * 
 * Version 1.63: May 26, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** HP Gauge sprite now properly synchs with battler location.
 * * New Features!
 * ** New Action Sequence Effects added by Irina and sponsored by MirageV:
 * *** INJECT action sequence series
 * **** See the Action Sequence Impact changelog for details.
 * 
 * Version 1.62: April 22, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Battle Forced End Action Crash
 * **** Depending on various circumstances, currently active battlers can be
 *      cleared from the battle system at will due to a number of reasons.
 *      However, if it just so happens that the targets are cleared, too, with
 *      actions remaining, then a crash will follow up. This plugin will
 *      prevent that change. Fix made by Olivia.
 * 
 * Version 1.61: April 14, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Impact Effects added by Irina and collaborating with Manu Gaming!
 * *** Impact: Bizarro Inversion
 * *** Impact: Desaturation
 * *** Impact: Negative Inversion
 * *** Impact: Oversaturation
 * *** Impact: Time Scale
 * *** Impact: Time Stop
 * 
 * Version 1.60: April 7, 2022
 * * Bug Fixes!
 * ** <Bypass Soft Damage Cap> notetag should no longer cause crashes. Fix made
 *    by Olivia.
 * * Feature Update!
 * ** Removed one of the forced log window clear events that have made log
 *    window messages impossible to utilize for certain settings. Update made
 *    by Olivia.
 * 
 * Version 1.59: March 31, 2022
 * * Bug Fixes!
 * ** Escape failure will no longer trigger Post-Battle Common Events. Fix
 *    made by Arisu.
 * 
 * Version 1.58: March 24, 2022
 * * Documentation Update:
 * ** Added extra clarity to <Sideview Size: width, height> notetag:
 * *** This does NOT change the image size. This only changes the HITBOX size.
 * * Feature Update!
 * ** Added failsafes to prevent battlers from moving to non-finite coordinates
 *    if calculations are made for non-existent targets. Updated by Olivia.
 * ** Regeneration timing for TPB-based battle systems will now occur based on
 *    individual turn counts instead of global turn counts for initial turn 0
 *    checks. Updated by Olivia.
 * 
 * Version 1.57: February 17, 2022
 * * Feature Update!
 * ** Adjusted the offset properties for the anti-tint UI container to properly
 *    match the UI offsets if the anti-tint were to be off. Update by Irina.
 * 
 * Version 1.56: February 10, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Once Parallels for battle now operate outside of the battle process.
 *    Update made by Olivia.
 * * New Features!
 * ** New Troop Page comment tag added by Olivia and sponsored by Puddor:
 * *** <Once Parallel When Start Battle>
 * **** Causes the troop page to immediately run the moment the battle scene
 *      begins to fade in (not after it fades in). This is faster than a turn 0
 *      condition troop page. Troop page conditions are ignored.
 * **** This can be used for things like the Action Sequence Camera plugin, the
 *      Visual Battle Environment plugin, and/or initial battle poses and such
 *      in order to provide a near seamless battle transition experience.
 * **** This does NOT trigger when coming out of the options menu or party
 *      menu screens.
 * **** This WILL trigger when going from battle to battle nonstop via plugins
 *      like VisuStella MZ's Chain Battles.
 * **** When actors are moving towards their home positions, it will take
 *      around 30 frames by default. Use this information however you like.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.55: January 27 2022
 * * Compatibility Update!
 * ** RPG Maker MV animations with front view should now play in the correct
 *    area against actor faces. Update made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Animations now play on top of all actor faces/portraits regardless of the
 *    battle layout style. Update made by Olivia.
 * * New Features!
 * ** New notetag added by Arisu.
 * *** <Bypass Auto Action Sequence>
 * **** This notetag is used for the game devs that have the Action Sequence
 *      Plugin Parameter "Auto Notetag" on for applying the notetag
 *      <Custom Action Sequence> to every skill and item with common events.
 * **** This will allow items and skills to be able to launch their common
 *      events from the menu scene regardless of the inherent restriction to
 *      prevent action sequence based skills/items with common events from
 *      launching.
 * **** Ignore this if you have "Auto Notetag" disabled or set to false. By
 *      default, this setting is set to false. Please be aware of the changes
 *      you've made to your game before using it.
 * 
 * Version 1.54: January 13, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Overly-Protective Substitute
 * *** When an ally with critical health is being targeted by a friendly non-
 *     Certain Hit skill (such as a heal or buff) and another ally has the
 *     substitute state, the other ally would "protect" the originally targeted
 *     ally and take the heal or buff.
 * *** The new changed behavior is that now, substitute will not trigger for
 *     any actions whose scope targets allies.
 * *** Fix made by Olivia.
 * 
 * Version 1.53: December 30, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Help file updated for updated features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > Battle Layout > UI Elements > Anti-Tint UI?
 * **** Prevent UI Elements from being tinted?
 * **** This prevents UI Elements such as HP Gauges, Enemy Names, Battle
 *      Cursor, and Weakness Display from being affected by screen tint.
 * * Updated Feature!
 * ** Updated Plugin Command "PROJECTILE: Animation" by Arisu!
 * *** New Parameter: Wait For Animation?
 * **** Wait for animation to finish before going to the next command?
 * 
 * Version 1.52: December 16, 2021
 * * Compatibility Update!
 * ** RPG Maker MZ 1.4.0 compatibility update!
 * *** MV Animations played on screen level will now show up properly in the
 *     center of the screen.
 * 
 * Version 1.51: December 9, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence Plugin Commands added by Arisu:
 * *** MOVE: Change Home By Distance
 * *** MOVE: Change Home To Point
 * *** MOVE: Change Home To Target(s)
 * **** These Plugin Commands allow you to adjust the home position of
 *      battlers in sideview battle.
 * **** This is sideview only!
 * **** This does NOT work with front view!
 * **** For those wondering, going to the options screen, party screen, etc.
 *      won't reset the home positions like regular movement changes do.
 * **** Merry Christmas, Harold-gang!
 * 
 * Version 1.50: November 4, 2021
 * * Bug Fixes!
 * ** <Seal Attack> and <Seal Guard> should no longer be bypassed by
 *    auto-battle status. Fix made by Yanfly.
 * 
 * Version 1.49: October 28, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Action Sequence: MOTION: Freeze Motion Frame will now only show weapons
 *    when using a motion that is named either "attack", "thrust", "swing", or
 *    "missile". Update made by Irina.
 * ** Fail safe added to prevent Scene_Battle going into unsupported scenes
 *    like Scene_Equip and Scene_Skill. Update made by Olivia.
 * * New Feature!
 * ** New Action Sequence Plugin Command added by Arisu and sponsored by Anon:
 * *** MECH: Once Parallel
 * **** Plays a Common Event parallel to the battle event once without
 *      repeating itself when done.
 * **** When exiting battle scene, all Once Parallels are cleared.
 * **** Once Parallels are not retained upon reentering the scene.
 * **** Once Parallels are not stored in memory and cannot be saved.
 * 
 * Version 1.48: October 21, 2021
 * * Feature Update!
 * ** Animations are now played on top of battlers in the Front View XP Battle
 *    Layout appearance. Update made by Irina.
 * ** Battle Log, if decided to be shown, now updates faster. Update by Irina.
 * ** Default Critical Damage Bonus increase is now updated to account for
 *    HP Healing and MP Recovery. To update this, create a new project, with
 *    the newest version of Battle Core installed. Copy over the Plugin
 *    Parameters for the Damage Settings > Critical Hits > JS: Damage Formula
 *    to your own project's version. Update made by Irina.
 * 
 * Version 1.47: October 14, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Feature Update!
 * ** Back attachment sprites are now automatically updated with sprite
 *    battlers to be shifted towards the very back.
 * 
 * Version 1.46: September 23, 2021
 * * Bug Fixes!
 * ** Fixed problem with skills and items without action sequences preventing
 *    actions from occurring. Fix made by Yanfly.
 * 
 * Version 1.45: September 17, 2021
 * * Bug Fixes!
 * ** <JS Pre-End Action> and <JS Post-End Action> effects now have multiple
 *    checks to make sure that they don't launch multiple times when a battler
 *    without actions has a turn after one that does. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence notetags added by Yanfly and Arisu:
 * *** <Common Event Key: name>
 * *** <Common Event Keys: name, name, name>
 * *** <Common Event Keys>
 *      key
 *      key
 *      key
 *     </Common Event Keys>
 * **** Will generate Common Events for the skill/item with a corresponding
 *      key.
 * **** More information will be explained inside of the help file.
 * **** This feature is made for make the process of sharing Action Sequences
 *      to become easier without needing to line up Common Event ID's.
 * 
 * Version 1.44: August 20, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence added by Irina and sponsored by Anon.
 * *** "ANIM: Play at Coordinate"
 * **** Plays an animation on the screen at a specific x, y coordinate even if
 *      there is no sprite attached.
 * **** Requires VisuMZ_0_CoreEngine!
 * 
 * Version 1.43: July 23, 2021
 * * Feature Update!
 * ** Immortality now works different with instant death mechanics. Skill
 *    effects that apply instant death or attack states that apply instant
 *    death will now trigger a flag instead of cancelling immortality. The
 *    flag will remain until immortality is manually cancelled via Action
 *    Sequence and then proc the death effect. This way, animations can remain
 *    to the end with instant death mechanics in mind. This does not affect
 *    script calls.
 * 
 * Version 1.42: July 16, 2021
 * * Bug Fixes!
 * ** Added another fail safe for empty common events used for pre-battle
 *    common events. Fix made by Olivia.
 * 
 * Version 1.41: July 2, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Added entries to <Battle Command> notetags and Plugin Parameters for
 *    "Party", "Combat Log", and "Weapon Swap" which weren't updated before.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * * New Features!
 * ** New Action Sequence added by Arisu:
 * *** MECH: Enemy Escape
 * **** Causes the enemy unit(s) to escape.
 * 
 * Version 1.40: June 25, 2021
 * * Bug Fixes!
 * ** Transformations from static enemies to and from animated SV enemies
 *    should no longer show both sprites. Fix made by Irina.
 * * Compatibility Update
 * ** Compatibility update with RPG Maker MZ 1.3.0+.
 * 
 * Version 1.39: June 18, 2021
 * * Bug Fixes!
 * ** MOVE: Home Reset should no longer trigger an end action function and
 *    cause plugins such as "Boost Action" to malfunction. Fix made by Olivia.
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <Battle Layout: x> Troop Name tags can now work with comment tags. Update
 *    made by Irina.
 * ** Random encounter lists are now better shuffled for more variety with how
 *    the RNG seed works. Update made by Arisu.
 * 
 * Version 1.38: June 11, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Location calculations will now be based off the a battler's base position
 *    in order for animations, popups, and other aspects to line up properly
 *    when scaled. Update made by Irina.
 * ** Plugin Parameters for Enemy Battler Settings > Name have been rearranged
 *    for better organization. Update by Olivia.
 * * New Features!
 * ** New Notetags added by Olivia and sponsored by NSG:
 * *** <Sideview Shadow Scale X: x%>
 * *** <Sideview Shadow Scale X: x.y>
 * *** <Sideview Shadow Scale Y: x%>
 * *** <Sideview Shadow Scale Y: x.y>
 * **** These new notetags allow you to adjust the X and Y scale of the SV
 *      shadow sprite separately.
 * ** New Plugin Parameters added by Olivia and sponsored by NSG:
 * *** Enemy Battler Settings > Name > Name Visibility > Always Hidden
 * *** Enemy Battler Settings > Name > Name Visibility > By Selection?
 * **** Choose to have the names always hidden or by selection.
 * **** These are adjusted on a priority list.
 * 
 * Version 1.37: May 21, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia.
 * *** <Command Require Learn>
 * *** <Command Require Access>
 * **** These two commands determine the visibility of a battle command by
 *      whether or not the skill has been learned or accessible.
 * * Feature Update!
 * ** For those using TPB, each battler's regeneration phase will no longer
 *    tick multiple times in a single frame to prevent irregularities. Update
 *    made by Olivia.
 * 
 * Version 1.36: May 14, 2021
 * * Bug Fixes!
 * ** Reversed an HP/MP regeneration bug that was incorrectly reported for TPB.
 *    Fix made by Olivia.
 * * Documentation Update
 * ** Added "TPB/ATB Active Battle Actor Shifting" to Major Changes section:
 * *** This change has been active since the start of this plugin. It was not
 *     documented until now.
 * *** Pressing cancel on the Actor Command Window no longer switches between
 *     actors with a full TPB/ATB gauge before reaching the Party Command
 *     Window. This is to accomplish a couple of things: 1) reduce the number
 *     of button presses to reach the Party Command Window and 2) to prevent
 *     motion resets and disrupting action sequences. If this feature is vital
 *     to your battle system, we recommend that you do not use this plugin or
 *     any of the Battle Core-required plugins.
 * ** Feature Updates
 * *** Distortion sprite Y calculations will now be rounded upward for better
 *     visuals and prevent odd pixelation effects. Update made by Irina.
 * 
 * Version 1.35: May 7, 2021
 * * Bug Fixes!
 * ** Pre-Battle Common Events without a wait command at the end should no
 *    longer lock up by coincidentally pressing the menu key at the same time.
 *    Fix made by Olivia.
 * * Feature Update!
 * ** Added an extra check for TPB-based battle systems to not run turn end
 *    functions when it's not actually the actual turn end timing. Update made
 *    by Olivia.
 * ** "Damage Styles" plugin parameters are now moved to the top of the
 *    Damage Settings category. This should make it easier to acknowledge the
 *    existence of and not have it be an unknown entity. Update made by Irina.
 * 
 * Version 1.34: April 23, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Uses a better algorithm for determining shadow positioning. Update made
 *    by Olivia.
 * * New Features!
 * ** New additions made for Projectile action sequences.
 * ** "Start Location" and "Goal Location" now have "Target Location" parameter
 *    to determine which part of the target's body to send the projectile from
 *    or towards. Added by Olivia.
 * ** Requires VisuMZ_1_BattleCore version 1.34 to have affect.
 * 
 * Version 1.33: April 9, 2021
 * * Bug Fixes!
 * ** Skill costs should now be displayed on battle commands again. Bug fix
 *    made by Olivia.
 * ** Pre-Battle Common Events should no longer cause stalling when used with
 *    specific event commands. Bug fix made by Olivia.
 * * Compatibility Update!
 * ** Added "Weapon Swap" to the list of battle commands that can be added.
 * * Documentation Update!
 * ** Added "Weapon Swap" and "Combat Log" to the list of <Battle Commands> in
 *    the notetags section.
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia:
 * *** <Sideview Shadow Scale: x%> and <Sideview Shadow Scale: x.y>
 * **** Used for: Actor, Enemy Notetags
 * **** Adjusts the scaling size of the sideview battler's shadow.
 * 
 * Version 1.32: April 2, 2021
 * * Feature Update!
 * ** Sideview battler sprites when using front view will now factor in the
 *    window padding and appear properly centered to their focus point. Update
 *    made by Olivia.
 * 
 * Version 1.31: March 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Added "VisuStella MZ Compatibility" section for detailed compatibility
 *    explanations with the VisuMZ_3_BoostAction plugin.
 * 
 * Version 1.30: March 19, 2021
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <JS Targets> is now updated to include the default set of targets
 *    selected by the skill/item's original scope. Update made by Yanfly.
 * *** If you wish to clear it out, simply do 'targets = []' first.
 * 
 * Version 1.29: March 12, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > Enemy Battler Settings > Name > Legacy Option
 * **** Use the legacy version (window) or new version (sprite).
 * **** WARNING: Legacy version is no longer supported for bugs.
 * **** Not all settings available here in the Plugin Parameters will be
 *      available to the legacy version (ie Always Visible and Attach States).
 * 
 * Version 1.28: March 5, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Arisu:
 * *** Plugin Parameters > Actor Command > Show Command Costs
 * **** If you don't want to show skill costs for your commands in the Actor
 *      Command Window, you can now hide them.
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battle Layout Settings > Status Window Elements
 * *** Battle Layout Settings > Status Window Elements > Battler Name
 * *** Battle Layout Settings > Status Window Elements > Gauge 1 (HP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 2 (MP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 3 (TP)
 * *** Battle Layout Settings > Status Window Elements > State Icon
 * *** Battle Layout Settings > Status Window Elements > TPB/ATB Gauge
 * **** These new Plugin Parameters allow you to offset the positions of the
 *      various Battle Status Window elements. Their base positions will be
 *      calculated by the Battle Layout used and then offset from there.
 * *** Battle Layout Settings > Status Window Elements > Window Skin
 * **** These settings allow you to set a specific window skin for the
 *      Battle Status Window or hide it from view completely.
 * *** Battle Layout Settings > Status Window Elements > Selectable Background
 * **** This option allows you to hide the black box that comes with the
 *      majority of selectable elements found in RPG Maker MZ in case it does
 *      not fit with how you want the Battle Status Window to look.
 * *** Battle Layout Settings > Status Window Elements > Back Attachment
 * *** Battle Layout Settings > Status Window Elements > Front Attachment
 * **** These settings allow you to attach images to the back/front of the
 *      Battle Status Window from the img/system/ folder.
 * **** You may offset X and Y positions for them as well.
 * ** New Plugin Parameters added by Olivia:
 * *** Plugin Parameters > Enemy Settings > Name: Always Visible
 * **** Determines if the enemy name will always be visible.
 * *** Plugin Parameters > Enemy Settings > Name: Attach States
 * **** Attach the enemy's state icon to the enemy name?
 * *** Plugin Parameters > Enemy Settings > Attach: Offset X/Y
 * **** Offset the attached state icon's position.
 * * Feature Update!
 * ** Switched drawing enemy names on the screen from window to sprite to
 *    reduce lag and for better screen positioning accuracy especially during
 *    screen zooming. Update by Olivia.
 * 
 * Version 1.27: February 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Critical
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Miss/Evade
 * **** Turns Switches ON if the action performs a critical hit, misses, or is
 *      evaded at any point.
 * **** Switch reverts to OFF whenever an action starts.
 * **** If multiple targets/hits are struck, as long as one hit respectively
 *      lands a critical hit, fails to land, then the switch will remain ON for
 *      the rest of the action.
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Damage
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Healing
 * **** Variable records target damage/healing during action.
 * **** Variable reverts to 0 whenever an action starts.
 * **** If multiple targets/hits are struck, the variable will record the total
 *      amount of damage/healing done for the remainder of the action (unless
 *      manually reseting to 0 during an Action Sequence).
 * 
 * Version 1.26: February 19, 2021
 * * Bug Fixes!
 * ** Battles with branching event paths found within a conditional branch or
 *    choice tree will no longer be skipped over. Fix made by Arisu.
 * * Compatibility Update
 * ** Returning to the battle scene from the options scene in a Tpb-base battle
 *    system now links the current actor. Update by Irina.
 * 
 * Version 1.25: February 5, 2021
 * * Compatibility Update
 * ** Added compatibility update with VisuStella MZ Skills and States Core's
 *    Plugin Parameter > State Settings > Action End Update
 * * Feature Update!
 * ** <Common Event: name> notetag no longer requires <Custom Action Sequence>
 *    notetag if the Plugin Parameter: Auto Notetag is enabled.
 * 
 * Version 1.24: January 29, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** MOVE: Move To Point and MOVE: Move To Target(s) Action Sequences'
 *    "Offset Adjustment" normal setting will now factor in Offset X and
 *    Offset Y positions unlike before where it cancels them. Update by Irina.
 * * New Features!
 * ** New notetag added by Arisu:
 * *** <Common Event: name>
 * **** Battle only: calls forth a Common Event of a matching name.
 * **** This is primarily used for users who are reorganizing around their
 *      Common Events and would still like to have their skills/items perform
 *      the correct Action Sequences in case the ID's are different.
 * 
 * Version 1.23: January 22, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** ACSET: All Targets Action Set and ACSET: Each Target Action Set updated
 * *** New parameter added: Dual/Multi Wield?
 * **** Add times struck based on weapon quantity equipped?
 * * New Features!
 * ** Dual Wielding now functions differently. Made by Olivia.
 * *** Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 *     animations at once, with the combined ATK of each weapon. It's confusing
 *     to look at and does not portray the nature of "Dual Wielding".
 * *** Dual Wielding, or in the case of users adding in third and fourth
 *     weapons, Multi Wielding is now changed. Each weapon is displayed
 *     individually, each producing its own attack animation, showing each
 *     weapon type, and applying only that weapon's ATK, Traits, and related
 *     effects. It is no longer a combined effect to display everything at once
 *     like RPG Maker MZ default.
 * *** If an actor has multiple weapon slots but some of them are unequipped,
 *     then the action will treat the attack as a single attack. There will be
 *     no barehanded attack to add on top of it. This is to match RPG Maker
 *     MZ's decision to omit a second animation if the same scenario is
 *     applied.
 * ** New Action Sequence Plugin Commands added by Yanfly
 * *** ANIM: Attack Animation 2+
 * **** Plays the animation associated with the user's 2nd weapon.
 *      Plays nothing if there is no 2nd weapon equipped.
 * ** New Action Sequence Plugin Commands added by Olivia
 * *** WEAPON: Clear Weapon Slot
 * *** WEAPON: Next Weapon Slot
 * *** WEAPON: Set Weapon Slot
 * **** These are Action Sequence Plugin Commands for devs who want finer
 *      control over Dual/Multi Wielding weapons.
 * 
 * Version 1.22: January 15, 2021
 * * Compatibility Update
 * ** Compatibility with "All Skills" Actor Command should now work with the
 *    Skills & States Core hide skill notetags.
 * 
 * Version 1.21: January 8, 2021
 * * Bug Fixes!
 * ** "MOVE: Home Reset" Plugin Command Action Sequence should work properly.
 *    Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Notetag snuck in by Arisu
 * *** <Auto Action Sequence>
 * **** Used for those who have the "Auto Notetag" Plugin Parameter enabled and
 *      just want to use an automatic Action Sequence instead.
 * ** New Plugin Parameter snuck in by Arisu!
 * *** Plugin Parameters > Action Sequences > Quality of Life > Auto Notetag
 * **** Automatically apply the <Custom Action Sequence> notetag effect to any
 *      item or skill that has a Common Event?
 * **** Any item or skill without a Common Event attached to it will use the
 *      Automatic Action Sequences instead.
 * **** The <Auto Action Sequence> notetag will disable this effect for that
 *      particular skill or item.
 * ** Arisu, you're going to be responsible for any bugs these may cause.
 * *** Bring it!!!!
 * **** And handling any bug report emails that are sent because this was
 *      turned on by accident.
 * ***** Please read the documentation, guys!
 * 
 * Version 1.20: January 1, 2021
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors that have received damage
 *    will return back to place after flinching. Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New notetags added by Yanfly:
 * *** <Battle Portrait Offset: +x, +y>
 * *** <Battle Portrait Offset X: +x>
 * *** <Battle Portrait Offset Y: +y>
 * **** This is used with the "Portrait" and "Border" Battle Layouts.
 * **** Offsets the X and Y coordinates for the battle portrait.
 * 
 * Version 1.19: December 25, 2020
 * * Bug Fixes!
 * ** Removing a state from a Sideview Enemy during the middle of their a non-
 *    looping motion will no longer reset their motion to neutral.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for updated feature(s)!
 * * Feature Update!
 * ** Action Sequence "PROJECTILE: Icon" now supports code for the "Icon"
 *    parameter. Update made by Yanfly.
 * 
 * Version 1.18: December 18, 2020
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors will no longer step back
 *    after an enemy's action is finished. Fix made by Yanfly and Shiro.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** Action Sequence "BTLOG: Add Text" is updated for the convenience of a new
 *    option to quickly copy the displayed text to the VisuStella MZ Combat Log
 *    if that plugin is installed. Added by Yanfly.
 * 
 * Version 1.17: December 11, 2020
 * * Bug Fixes!
 * ** Common Events in TPB Active that cause forced actions will no longer
 *    cause currently inputting actors that match the forced action battler to
 *    crash the game. Fix made by Yanfly and Shiro.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * Feature Update!
 * ** Action Sequence Impact Action Sequences "Shockwave from Each Target(s)",
 *    "Shockwave from Target(s) Center", and "Zoom Blur at Target(s) Center"
 *    now have "Offset X" and "Offset Y" plugin parameters. Added by Yanfly.
 * ** Action Sequence "MOVE: Move To Target(s)" is now changed so that if the
 *    "Melee Distance" value is set to 0, battlers will no longer stand a half
 *    body distance away. Added by Yanfly.
 * 
 * Version 1.16: December 4, 2020
 * * Bug Fixes!
 * ** Bug fixes made for the RPG Maker MZ base code. If a battler has no
 *    actions, then their action speed will not be Infinity. Fix by Olivia.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.15: November 29, 2020
 * * Bug Fixes!
 * ** Completely replacing the whole party at once will no longer cause the
 *    battle system to crash. Fix made by Olivia.
 * ** Pre-Battle Common Events will no longer cancel out any win/lose branches.
 *    Fix made by Arisu.
 * * Feature Update!
 * ** Custom Action Sequences will no longer close the Actor Command Input
 *    window unless absolutely necessary (like for Show Message events) during
 *    Active TPB/ATB. Change made by Arisu.
 * 
 * Version 1.14: November 22, 2020
 * * Feature Update!
 * ** Natural Miss and Evasion motions now have flinch distance.
 *    Added by Yanfly.
 * 
 * Version 1.13: November 15, 2020
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.12: November 8, 2020
 * * Bug Fixes!
 * ** Failsafes added to prevent common events from running if they're empty.
 *    Fix made by Irina.
 * ** Skip Party Command will now work properly with TPB-based battle systems.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** In preparation for upcoming VisuStella MZ plugins.
 * 
 * Version 1.11: November 1, 2020
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added clarity for the Plugin Parameters for the Common Events settings
 *    found in the mechanics section. The common events are only meant to run
 *    in the map scene and not for the battle scene. Update made by Irina.
 * * Feature Update!
 * ** The Plugin Parameter for Mechanics, Common Events (on Map), Defeat Event
 *    now has updated functionality. If this has a common event attached to it,
 *    then losing to random encounters will no longer send the player to the
 *    Game Over scene, but instead, send the player back to the map scene,
 *    where the Defeat Common Event will run. Update made by Irina.
 * 
 * Version 1.10: October 25, 2020
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Action Sequence Plugin Command added by Olivia:
 * *** MECH: Custom Damage Formula
 * **** Changes the current action's damage formula to custom.
 *      This will assume the MANUAL damage style.
 * ** New Notetag added by Irina:
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battleback Scaling Settings
 * **** These settings allow you to adjust how battlebacks scale to the screen
 *      in the game.
 * *** <Battler Sprite Grounded>
 * **** Prevents the enemy from being able to jumping and/or floating due to
 *      Action Sequences but still able to move. Useful for rooted enemies.
 * 
 * Version 1.09: October 18, 2020
 * * Bug Fixes!
 * ** Exiting out of the Options menu scene or Party menu scene will no longer
 *    cause party members to reset their starting position. Fix made by Arisu
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * ** There was a documentation error with <JS Pre-Regenerate> and
 *    <JS Post-Regenerate>. Fix made by Yanfly.
 * *** Before, these were written as <JS Pre-Regenerate Turn> and
 *     <JS Post-Regenerate Turn>. The "Turn" part of the notetag has been
 *     removed in the documentation.
 * * Feature Update!
 * ** Damage sprites on actors are now centered relative to the actor's anchor.
 *    Change made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Command added by Yanfly:
 * *** MECH: Variable Popup
 * **** Causes the unit(s) to display a popup using the data stored inside
 *      a variable.
 * 
 * Version 1.08: October 11, 2020
 * * Bug Fixes!
 * ** Dead party members at the start of battle no longer start offscreen.
 *    Fix made by Arisu.
 * ** Removed party members from battle no longer count as moving battlers.
 *    Fix made by Yanfly.
 * ** Using specific motions should now have the weapons showing and not
 *    showing properly. Fix made by Yanfly.
 * 
 * Version 1.07: October 4, 2020
 * * Bug Fixes!
 * ** Adding and removing actors will now refresh the battle status display.
 *    Fix made by Irina.
 * ** Adding new states that would change the affected battler's state motion
 *    will automatically refresh the battler's motion. Fix made by Irina.
 * ** Boss Collapse animation fixed and will sink into the ground.
 *    Fix made by Irina.
 * ** Failsafes added for certain animation types. Fix made by Yanfly.
 * ** Freeze Motion for thrust, swing, and missile animations will now show the
 *    weapons properly. Fix made by Yanfly.
 * ** The Guard command will no longer display the costs of the Attack command.
 *    Fix made by Irina.
 * * Documentation Update!
 * ** Updated help file for newly added plugin parameters.
 * * Feature Updates!
 * ** When using the Change Battleback event command in battle, the game client
 *    will wait until both battlebacks are loaded before changing the both of
 *    them so that the appearance is synched together. Change made by Yanfly.
 * * New Features!
 * ** New plugin parameters added by Irina!
 * *** Plugin Parameters > Actor Battler Settings > Chant Style
 * **** What determines the chant motion? Hit type or skill type?
 * 
 * Version 1.06: September 27, 2020
 * * Bug Fixes!
 * ** Enemy Battler Plugin Parameter "Shadow Visible" should now work again.
 *    Fix made by Irina.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins. Added by Yanfly.
 * * Documentation Update!
 * ** Updated the help file for all the new plugin parameters.
 * * Feature Update!
 * ** Action Sequence "MECH: HP, MP, TP" will now automatically collapse an
 *    enemy if it has been killed by the effect.
 * ** All battle systems for front view will now have damage popups appear
 *    in front of the status window instead of just the Portrait battle layout.
 *    Update made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Commands from Irina!
 * *** MOTION: Clear Freeze Frame
 * *** MOTION: Freeze Motion Frame
 * **** You can freeze a battler's sprite's motion with a specific frame.
 * ** New notetags for Maps and name tags for Troops added by Yanfly!
 * *** <Battle Layout: type> to change the battle layout style used for
 *     specific maps and/or troops.
 * ** New plugin parameters added by Yanfly!
 * *** Plugin Parameters > Battle Layout Settings > Command Window Width
 * **** This plugin parameter lets you adjust the window width for Party and
 *      Actor Command windows in the Default and List Battle Layout styles.
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset X
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset Y
 * **** These plugin parameters allow you to offset the position of the enemy
 *      name positions on the screen by a specific amount.
 * 
 * Version 1.05: September 20, 2020
 * * Bug Fixes!
 * ** Actors now use their casting or charging animations again during TPB/ATB.
 *    Fix made by Yanfly.
 * ** Defeat requirement for enemies will no longer crash the game if turned on
 *    after creating
 * ** Escaping animation no longer has actors stay in place. Fixed by Yanfly.
 * ** Failsafes added for newly added weapon types that have not been adjusted
 *    in the Database > System 2 tab. Fixed by Irina.
 * ** Shadows now appear under the actor sprites. Fix made by Yanfly.
 * ** Victory during TPB will no longer cancel the victory animations of
 *    actors that will have their turn after. Fixed by Yanfly.
 * * Documentation Update!
 * ** All Anchor Plugin Parameter descriptions now state to use values between
 *    0 and 1 to be safe. Update made by Yanfly.
 * * Feature Update!
 * ** During Active TPB / ATB, canceling out of the actor command window will
 *    go directly into the party window without having to sort through all of
 *    the available active actors.
 * ** Going from the Party Command Window's Fight command will immediately
 *    return back to the actor command window that was canceled from.
 * * New Features!
 * ** Action Sequence Plugin Command "MOVE: Spin/Rotate" has been updated.
 * *** A new parameter has been added: "Revert Angle on Finish"
 * *** Added by Yanfly.
 * ** New plugin parameters have been added to Damage Settings.
 * *** Appear Position: Selects where you want popups to appear relative to the
 *     battler. Head, Center, Base. Added by Yanfly.
 * *** Offset X: Sets how much to offset the sprites by vertically.
 *     Added by Yanfly.
 * *** Offset Y: Sets how much to offset the sprites by horizontally.
 *     Added by Yanfly.
 * ** New plugin parameters have been added to Actor Battler Settings.
 * *** Priority: Active - Place the active actor on top of actor and
 *     enemy sprites. Added by Yanfly.
 * *** Priority: Actors - Prioritize actors over enemies when placing 
 *     sprites on top of each other. Added by Yanfly.
 * 
 * Version 1.04: September 13, 2020
 * * Bug Fixes!
 * ** Active Battler Sprites now remain on top and won't be hidden behind
 *    other sprites for better visual clarity. Fix made by Arisu.
 * ** Collapsing battlers will now show the dead motion properly. Fix made by
 *    Olivia.
 * ** Dead battlers can no longer be given immortality. Fix made by Olivia.
 * ** Going into the Options menu with no battleback set will no longer set a
 *    battle snapshot.
 * ** HP Gauges for Sideview Enemies are no longer flipped! Fix made by Yanfly.
 * ** Moving a dead battler would no longer reset their animation. Fix made by
 *    Olivia.
 * ** Pre-Battle Common Events now work with events instead of just random
 *    encounters. Fix made by Yanfly.
 * ** Sideview Enemy shadows no longer twitch. Fix made by Irina.
 * * Documentation Updates!
 * ** Added further explanations for Anchor X and Anchor Y plugin parameters.
 *    This is because there's a lot of confusion for users who aren't familiar
 *    with how sprites work. Added by Irina.
 * ** <Magic Reduction: x> notetag updated to say magical damage instead of
 *    physical damage. Fix made by Yanfly.
 * * New Features!
 * ** Additional Action Sequence Plugin Commands have been added in preparation
 *    of upcoming plugins! Additions made by Irina.
 * *** Action Sequences - Angle (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Camera (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Skew (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Zoom (for VisuMZ_3_ActSeqCamera)
 * ** Additional Action Sequence Plugin Commands have been made available now
 *    and added to Battle Core! Additions made by Irina.
 * *** MOVE: Scale/Grow/Shrink
 * *** MOVE: Skew/Distort
 * *** MOVE: Spin/Rotate
 * *** MOVE: Wait For Scale
 * *** MOVE: Wait For Skew
 * *** MOVE: Wait For Spin
 * ** Plugin Parameters Additions. Additions made by Irina.
 * *** Plugin Params > Actor Battler Settings > Offset X
 * *** Plugin Params > Actor Battler Settings > Offset Y
 * *** Plugin Params > Actor Battler Settings > Smooth Image
 * *** Plugin Params > Enemy Battler Settings > Offset X
 * *** Plugin Params > Enemy Battler Settings > Offset Y
 * *** Plugin Params > Enemy Battler Settings > Smooth Image
 * 
 * Version 1.03: September 6, 2020
 * * Bug Fixes!
 * ** Animated Battlers will refresh their motions from the death motion once
 *    they're revived instead of waiting for their next input phase. Fix made
 *    by Yanfly.
 * ** Battle Log speed sometimes went by too fast for certain enabled messages.
 *    Wait timers are now added to them, like state results, buff results, and
 *    debuff results. Fix made by Yanfly.
 * ** Boss Collapse animation now works properly. Fix made by Yanfly.
 * ** Freeze fix for TPB (Wait) if multiple actors get a turn at the same time.
 *    Fix made by Olivia.
 * ** Pressing cancel on a target window after selecting a single skill no
 *    longer causes the status window to twitch.
 * ** Sideview Enemies had a split frame of being visible if they were to start
 *    off hidden in battle. Fix made by Shaz.
 * * Compatibility Update:
 * ** Battle Core's Sprite_Damage.setup() function is now separated fro the
 *    default to allow for better compatibility. Made by Yanfly.
 * * Documentation Update:
 * ** Inserted more information for "Damage Popups" under "Major Changes"
 * * New Features!
 * ** <Magic Penetration: x>, <Magic Penetration: x%> notetags added.
 * ** <Magic Reduction: x>, <Magic Reduction: x%> notetags added.
 * ** <Battle UI Offset: +x, +y>, <Battle UI Offset X: +x>, and
 *    <Battle UI Offset Y: +y> notetags added for adjusting the positions of
 *    HP Gauges and State Icons.
 * *** Notetags added by Yanfly.
 * 
 * Version 1.02: August 30, 2020
 * * Bug Fixes!
 * ** Failsafes added for parsing battle targets. Fix made by Yanfly.
 * ** Immortality is no longer ignored by skills/items with the Normal Attack
 *    state effect. Fix made by Yanfly.
 * ** Miss and Evasion sound effects work again! Fix made by Yanfly.
 * ** Selecting "Escape" from the Actor Command Window will now have the
 *    Inputting Battler show its escape motion. Fix made by Yanfly.
 * ** Wait for Movement now applies to SV Enemies. Fix made by Yanfly.
 * * New Features!
 * ** Plugin Command "ACSET: Finish Action" now has an option to turn off the
 *    Immortality of targets. Feature added by Yanfly.
 * * Optimization Update
 * ** Uses less resources when making checks for Pre-Battle Battle Start events
 * 
 * Version 1.01: August 23, 2020
 * * Bug Fixes!
 * ** Plugin Parameters > Damage Settings > Damage Formats are now fixed.
 *    Fix made by Olivia.
 * ** TPB Battle System with Disable Party Command fixed. Fix made by Olivia.
 * ** States now show in list format if faces are disabled. Fix made by Yanfly.
 * ** The default damage styles were missing the 'v' variable to allow for
 *    variable data input. These are back now. Fix made by Yanfly.
 * *** Users updating from version 1.00 will need to fix this problem by either
 *     removing the plugin from the Plugin Manager list and reinstalling it, or
 *     going to Plugin Parameters > Damage Settings > Style List > the style
 *     you want, and adding "const v = $gameVariables._data;" to JS: Formula
 * * New Notetags Added:
 * ** <Command Show Switch: x> added by Olivia
 * ** <Command Show All Switches: x,x,x> added by Olivia
 * ** <Command Show Any Switches: x,x,x> added by Olivia
 * ** <Command Hide Switch: x> added by Olivia
 * ** <Command Hide All Switches: x,x,x> added by Olivia
 * ** <Command Hide Any Switches: x,x,x> added by Olivia
 * ** <JS Command Visible> added by Olivia
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceStart
 * @text -
 * @desc The following are Action Sequences commands/sets.
 * These Plugin Commands only work in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSet
 * @text Action Sequence - Action Sets
 * @desc Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_SetupAction
 * @text ACSET: Setup Action Set
 * @desc The generic start to most actions.
 * 
 * @arg DisplayAction:eval
 * @text Display Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: On
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionStart:eval
 * @text Battle Step
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg CastAnimation:eval
 * @text Cast Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_WholeActionSet
 * @text ACSET: All Targets Action Set
 * @desc Affects all targets simultaneously performing the following.
 * 
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 * 
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 * 
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_TargetActionSet
 * @text ACSET: Each Target Action Set
 * @desc Goes through each target one by one to perform the following.
 * 
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 * 
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount1:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 * 
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount2:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed * 2
 * 
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_FinishAction
 * @text ACSET: Finish Action
 * @desc The generic ending to most actions.
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForNewLine:eval
 * @text Wait For New Line
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForEffect:eval
 * @text Wait For Effects
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ClearBattleLog:eval
 * @text Clear Battle Log
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionEnd:eval
 * @text Home Reset
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAngle
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAngle
 * @text Action Sequences - Angle
 * @desc Allows you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeAngle
 * @text ANGLE: Change Angle
 * @desc Changes the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Angle:eval
 * @text Angle
 * @desc Change the camera angle to this many degrees.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_Reset
 * @text ANGLE: Reset Angle
 * @desc Reset any angle settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_WaitForAngle
 * @text ANGLE: Wait For Angle
 * @desc Waits for angle changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAnimation
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAnimation
 * @text Action Sequences - Animations
 * @desc These Action Sequences are related to the 'Animations' that
 * can be found in the Animations tab of the Database.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ActionAnimation
 * @text ANIM: Action Animation
 * @desc Plays the animation associated with the action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation
 * @text ANIM: Attack Animation
 * @desc Plays the animation associated with the user's 1st weapon.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation2
 * @text ANIM: Attack Animation 2+
 * @desc Plays the animation associated with the user's other weapons.
 * Plays nothing if there is no other weapon equipped.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Slot:eval
 * @text Slot
 * @desc Which weapon slot to get this data from?
 * Main-hand weapon is weapon slot 1.
 * @default 2
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonAnimation
 * @text ANIM: Balloon Animation
 * @desc Plays a balloon animation on target(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg Balloon:str
 * @text Balloon Type
 * @type select
 * @option Exclamation
 * @option Question
 * @option Music Note
 * @option Heart
 * @option Anger
 * @option Sweat
 * @option Frustration
 * @option Silence
 * @option Light Bulb
 * @option Zzz
 * @option User-defined 1
 * @option User-defined 2
 * @option User-defined 3
 * @option User-defined 4
 * @option User-defined 5
 * @desc What kind of balloon should be played on target(s)?
 * @default Exclamation
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonIcon
 * @text ANIM: Balloon Icon (Single)
 * @desc Plays a balloon animation using an icon on target(s).
 * Requires VisuMZ_4_IconBalloons!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg IconIndex:num
 * @text Icon Index
 * @desc Insert the ID of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default 0
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonIconRange
 * @text ANIM: Balloon Icon (Range)
 * @desc Plays a balloon animation an icon range on target(s).
 * Requires VisuMZ_4_IconBalloons!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg startIcon:num
 * @text Starting Icon Index
 * @desc Insert the ID of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default 0
 *
 * @arg endIcon:num
 * @text Ending Icon Index
 * @desc Insert the ID of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default 0
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonIconSpecific
 * @text ANIM: Balloon Icon (Specific)
 * @desc Plays a balloon animation with specific icons on target(s).
 * Requires VisuMZ_4_IconBalloons!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg icons:arraynum
 * @text Icons
 * @type string[]
 * @desc Insert the ID(s) of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default []
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_CastAnimation
 * @text ANIM: Cast Animation
 * @desc Plays the cast animation associated with the action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ChangeBattlePortrait
 * @text ANIM: Change Battle Portrait
 * @desc Changes the battle portrait of the actor (if it's an actor).
 * Can be used outside of battle/action sequences.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to change the portraits for.
 * Valid units can only be actors.
 * @default ["user"]
 * 
 * @arg Filename:str
 * @text Filename
 * @type file
 * @dir img/pictures/
 * @desc Select the file to change the actor's portrait to.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ChangeBattlePortrait_JS
 * @text ANIM: Change Battle Portrait (JS)
 * @desc Changes the battle portrait of the actor through JavaScript.
 * Can be used outside of battle/action sequences.
 *
 * @arg ActorJS:func
 * @text JS: Actor ID
 * @type note
 * @desc Enter which Actor ID to affect.
 * Uses JavaScript code.
 * @default "// Get Actor ID here.\nlet actorID = 0;\nactorID = $gameParty.members()[0].actorId();\n\n// Return Actor ID\nreturn actorID;"
 *
 * @arg FilenameJS:func
 * @text JS: Filename
 * @type note
 * @desc Enter the filename you wish to use.
 * Uses JavaScript code.
 * @default "// Get Filename here.\nlet filename = 'Actor1_';\nfilename += String(Math.randomInt(8) + 1);\n\n// Return Filename\nreturn filename;"
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_GuardAnimation
 * @text ANIM: Guard Animation
 * @desc Plays the animation associated with the user's guard action (if any).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ItemAnimation
 * @text ANIM: Item Animation
 * @desc Plays the animation associated with a specific item.
 * 
 * @arg ItemID:eval
 * @text Item ID
 * @type item
 * @desc Which item ID will the animation come from?
 * @default 7
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_PlayAtCoordinate
 * @text ANIM: Play at Coordinate
 * @desc Plays an animation on the screen at a specific x, y coordinate.
 * Requires VisuMZ_0_CoreEngine!
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Animation
 * @type animation
 * @desc Plays this animation.
 * @default 1
 * 
 * @arg Coordinates
 *
 * @arg pointX:eval
 * @text X
 * @parent Coordinates
 * @desc X coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 *
 * @arg pointY:eval
 * @text Y
 * @parent Coordinates
 * @desc Y coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 *
 * @arg Mirror:eval
 * @text Mirror Animation?
 * @parent Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute Animation?
 * @parent Animation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the animation?
 * @default false
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion?
 * @parent Animation
 * @type boolean
 * @on Wait
 * @off Normal
 * @desc Wait the animation to finish before continuing?
 * @default false
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ShowAnimation
 * @text ANIM: Show Animation
 * @desc Plays the a specific animation on unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Select which animation to play on unit(s).
 * @default 1
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ShowAnimationJS
 * @text ANIM: Show Animation JS
 * @desc Plays the a specific animation on unit(s).
 * Uses JavaScript to determine animation ID.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg AnimationID:eval
 * @text JS: Animation ID
 * @desc Select which animation to play on unit(s).
 * Uses JavaScript to determine animation ID.
 * @default 1
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_SkillAnimation
 * @text ANIM: Skill Animation
 * @desc Plays the animation associated with a specific skill.
 * 
 * @arg SkillID:eval
 * @text Skill ID
 * @type skill
 * @desc Which skill ID will the animation come from?
 * @default 99
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_WaitForAnimation
 * @text ANIM: Wait For Animation
 * @desc Causes the interpreter to wait for any animation(s) to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceBattleLog
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakBattleLog
 * @text Action Sequences - Battle Log
 * @desc These Action Sequences are related to the Battle Log Window,
 * the window found at the top of the battle screen.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_AddText
 * @text BTLOG: Add Text
 * @desc Adds a new line of text into the Battle Log.
 * 
 * @arg Text:str
 * @text Text
 * @desc Add this text into the Battle Log.
 * Text codes allowed.
 * @default Insert text here.
 * 
 * @arg CopyCombatLog:eval
 * @text Copy to Combat Log?
 * @type boolean
 * @on Copy Text
 * @off Don't Copy
 * @desc Copies text to the Combat Log.
 * Requires VisuMZ_4_CombatLog
 * @default true
 *
 * @arg CombatLogIcon:num
 * @text Combat Log Icon
 * @parent CopyCombatLog:eval
 * @desc What icon would you like to bind to this entry?
 * Requires VisuMZ_4_CombatLog
 * @default 87
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Clear
 * @text BTLOG: Clear Battle Log
 * @desc Clears all the text in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_DisplayAction
 * @text BTLOG: Display Action
 * @desc Displays the current action in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PopBaseLine
 * @text BTLOG: Pop Base Line
 * @desc Removes the Battle Log's last added base line and 
 * all text up to its former location.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PushBaseLine
 * @text BTLOG: Push Base Line
 * @desc Adds a new base line to where the Battle Log currently is at.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Refresh
 * @text BTLOG: Refresh Battle Log
 * @desc Refreshes the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_UI
 * @text BTLOG: UI Show/Hide
 * @desc Shows or hides the Battle UI (including the Battle Log).
 * 
 * @arg ShowHide:eval
 * @text Show/Hide?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows/hides the Battle UI.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForBattleLog
 * @text BTLOG: Wait For Battle Log
 * @desc Causes the interpreter to wait for the Battle Log to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForNewLine
 * @text BTLOG: Wait For New Line
 * @desc Causes the interpreter to wait for a new line in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceCamera
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakCamera
 * @text Action Sequences - Camera
 * @desc Allows you to have control over the camera.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Clamp
 * @text CAMERA: Clamp ON/OFF
 * @desc Turns battle camera clamping on/off.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Setting:eval
 * @text ON/OFF
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Turns camera clamping on/off.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusPoint
 * @text CAMERA: Focus Point
 * @desc Focus the battle camera on a certain point in the screen.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg FocusX:eval
 * @text X Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg FocusY:eval
 * @text Y Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusTarget
 * @text CAMERA: Focus Target(s)
 * @desc Focus the battle camera on certain battler target(s).
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to focus the battle camera on.
 * @default ["user"]
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Offset
 * @text CAMERA: Offset
 * @desc Offset the battle camera from the focus target.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @desc How much to offset the camera X by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @desc How much to offset the camera Y by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for offset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Reset
 * @text CAMERA: Reset
 * @desc Reset the battle camera settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg ResetFocus:eval
 * @text Reset Focus?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the focus point?
 * @default true
 * 
 * @arg ResetOffset:eval
 * @text Reset Offset?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the camera offset?
 * @default true
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for reset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_WaitForCamera
 * @text CAMERA: Wait For Camera
 * @desc Waits for camera to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceCutin
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakCutin
 * @text Action Sequences - Cutins
 * @desc Allows you to have control over Visual Cutin Effects.
 * Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_AddVisualCutinEffect
 * @text CUTIN: Add Visual Cutin Effect
 * @desc Adds the Visual Cutin Effect using these desired settings.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * @arg Basic
 * @text Basic Settings
 * 
 * @arg type:str
 * @text Cutin Style Type
 * @parent Basic
 * @type select
 * @option -
 * @option Whole
 * @option -
 * @option Showcase
 * @option -
 * @option LeftHorzSpan
 * @option CenterHorzSpan
 * @option RightHorzSpan
 * @option -
 * @option LeftHorzSlash
 * @option RightHorzSlash
 * @option -
 * @option LeftVertSlash
 * @option RightVertSlash
 * @option -
 * @option LeftMajor
 * @option RightMajor
 * @option -
 * @option LeftMinor
 * @option CenterMinor
 * @option RightMinor
 * @option -
 * @option LeftDiamond
 * @option CenterDiamond
 * @option RightDiamond
 * @option -
 * @option LeftGemstone
 * @option CenterGemstone
 * @option RightGemstone
 * @option -
 * @option TopLeftQuad
 * @option TopRightQuad
 * @option BottomLeftQuad
 * @option BottomRightQuad
 * @option -
 * @option TopLeftCorner
 * @option TopRightCorner
 * @option BottomLeftCorner
 * @option BottomRightCorner
 * @option -
 * @option Row1stThird
 * @option Row2ndThird
 * @option Row3rdThird
 * @option -
 * @option Row1stFourth
 * @option Row2ndFourth
 * @option Row3rdFourth
 * @option Row4thFourth
 * @option -
 * @option Row1stFifth
 * @option Row2ndFifth
 * @option Row3rdFifth
 * @option Row4thFifth
 * @option Row5thFifth
 * @option -
 * @option Col1stThird
 * @option Col2ndThird
 * @option Col3rdThird
 * @option -
 * @option Col1stFourth
 * @option Col2ndFourth
 * @option Col3rdFourth
 * @option Col4thFourth
 * @option -
 * @option Col1stFifth
 * @option Col2ndFifth
 * @option Col3rdFifth
 * @option Col4thFifth
 * @option Col5thFifth
 * @option -
 * @option SixPack1
 * @option SixPack2
 * @option SixPack3
 * @option SixPack4
 * @option SixPack5
 * @option SixPack6
 * @option -
 * @option EightPack1
 * @option EightPack2
 * @option EightPack3
 * @option EightPack4
 * @option EightPack5
 * @option EightPack6
 * @option EightPack7
 * @option EightPack8
 * @option -
 * @option TwelvePack1
 * @option TwelvePack2
 * @option TwelvePack3
 * @option TwelvePack4
 * @option TwelvePack5
 * @option TwelvePack6
 * @option TwelvePack7
 * @option TwelvePack8
 * @option TwelvePack9
 * @option TwelvePack10
 * @option TwelvePack11
 * @option TwelvePack12
 * @option -
 * @desc What Visual Cutin Effect style type do you wish to use?
 * Only one of each cutin-style type can be present.
 * @default CenterHorzSpan
 * 
 * @arg Targets:arraystr
 * @text Portrait Target
 * @parent Basic
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to grab the Visual Cutin Effect portrait
 * data from. First unit will be used to make portrait.
 * @default ["user"]
 *
 * @arg parallaxFilename:str
 * @text Parallax Filename
 * @parent Basic
 * @type file
 * @dir img/parallaxes/
 * @require 1
 * @desc Pick a parallax to use for the Visual Cutin Effect.
 * Pick (None) to not use a parallax.
 * @default >>>ATTENTION<<<
 *
 * @arg bgColor:str
 * @text Background Color
 * @parent Basic
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #888888
 *
 * @arg ExtraSettings:struct
 * @text Extra Settings
 * @type struct<VisualCutinEffect>
 * @desc Extra Plugin Command settings pertaining to this Visual Cutin Effect.
 * @default {}
 * 
 * @arg WaitForEntrance:eval
 * @text Wait For Entrance
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin entrance is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_EndVisualCutinEffectAll
 * @text CUTIN: End Visual Cutin Effect (All)
 * @desc Ends all Visual Cutin Effects currently present.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * @arg WaitForExit:eval
 * @text Wait For Exit
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin exit is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_EndVisualCutinEffectType
 * @text CUTIN: End Visual Cutin Effect (Type)
 * @desc Ends the Visual Cutin Effect with the matching type.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * @arg type:str
 * @text Cutin Style Type
 * @type select
 * @option -
 * @option Whole
 * @option -
 * @option Showcase
 * @option -
 * @option LeftHorzSpan
 * @option CenterHorzSpan
 * @option RightHorzSpan
 * @option -
 * @option LeftHorzSlash
 * @option RightHorzSlash
 * @option -
 * @option LeftVertSlash
 * @option RightVertSlash
 * @option -
 * @option LeftMajor
 * @option RightMajor
 * @option -
 * @option LeftMinor
 * @option CenterMinor
 * @option RightMinor
 * @option -
 * @option LeftDiamond
 * @option CenterDiamond
 * @option RightDiamond
 * @option -
 * @option LeftGemstone
 * @option CenterGemstone
 * @option RightGemstone
 * @option -
 * @option TopLeftQuad
 * @option TopRightQuad
 * @option BottomLeftQuad
 * @option BottomRightQuad
 * @option -
 * @option TopLeftCorner
 * @option TopRightCorner
 * @option BottomLeftCorner
 * @option BottomRightCorner
 * @option -
 * @option Row1stThird
 * @option Row2ndThird
 * @option Row3rdThird
 * @option -
 * @option Row1stFourth
 * @option Row2ndFourth
 * @option Row3rdFourth
 * @option Row4thFourth
 * @option -
 * @option Row1stFifth
 * @option Row2ndFifth
 * @option Row3rdFifth
 * @option Row4thFifth
 * @option Row5thFifth
 * @option -
 * @option Col1stThird
 * @option Col2ndThird
 * @option Col3rdThird
 * @option -
 * @option Col1stFourth
 * @option Col2ndFourth
 * @option Col3rdFourth
 * @option Col4thFourth
 * @option -
 * @option Col1stFifth
 * @option Col2ndFifth
 * @option Col3rdFifth
 * @option Col4thFifth
 * @option Col5thFifth
 * @option -
 * @option SixPack1
 * @option SixPack2
 * @option SixPack3
 * @option SixPack4
 * @option SixPack5
 * @option SixPack6
 * @option -
 * @option EightPack1
 * @option EightPack2
 * @option EightPack3
 * @option EightPack4
 * @option EightPack5
 * @option EightPack6
 * @option EightPack7
 * @option EightPack8
 * @option -
 * @option TwelvePack1
 * @option TwelvePack2
 * @option TwelvePack3
 * @option TwelvePack4
 * @option TwelvePack5
 * @option TwelvePack6
 * @option TwelvePack7
 * @option TwelvePack8
 * @option TwelvePack9
 * @option TwelvePack10
 * @option TwelvePack11
 * @option TwelvePack12
 * @option -
 * @desc What Visual Cutin Effect style type do you wish to end?
 * @default CenterHorzSpan
 * 
 * @arg WaitForExit:eval
 * @text Wait For Exit
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin exit is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_WaitForEntrance
 * @text CUTIN: Wait for Cutin Entrance
 * @desc Wait until all cutin entrances are finished before performing the next event command. Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_WaitForExit
 * @text CUTIN: Wait for Cutin Exit
 * @desc Wait until all cutin exits are finished before performing the next event command. Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 *
 * @command ActionSequenceSpaceDragonbones
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreaDragonbones
 * @text Action Sequences - Dragonbones
 * @desc These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesMotionAni
 * @text DB: Dragonbones Animation
 * @desc Causes the unit(s) to play a Dragonbones motion animation.
 * Requires VisuMZ_2_DragonbonesUnion!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg MotionAni:str
 * @text Motion Animation
 * @desc What is the name of the Dragonbones motion animation you wish to play?
 * @default attack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesTimeScale
 * @text DB: Dragonbones Time Scale
 * @desc Causes the unit(s) to change their Dragonbones time scale.
 * Requires VisuMZ_2_DragonbonesUnion!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg TimeScale:num
 * @text Time Scale
 * @desc Change the value of the Dragonbones time scale to this.
 * @default 1.0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceElements
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakElements
 * @text Action Sequences - Elements
 * @desc These Action Sequences are related to elements.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_AddElements
 * @text ELE: Add Elements
 * @desc Adds element(s) to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to add onto the action.
 * Insert multiple element ID's to add multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_Clear
 * @text ELE: Clear Element Changes
 * @desc Clears all element changes made through Action Sequences.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_ForceElements
 * @text ELE: Force Elements
 * @desc Forces only specific element(s) when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to force in the action.
 * Insert multiple element ID's to force multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_NullElements
 * @text ELE: Null Element
 * @desc Forces no element to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceGrid
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakGrid
 * @text Action Sequences - Grid
 * @desc These Action Sequences are Battle Grid System-related.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_ActionAnimationAtNode
 * @text GRID: Action Animation at Node
 * @desc Plays action animation at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AddPassiveStatesToNode
 * @text GRID: Add Passive State(s) to Node
 * @desc Adds Passive State(s) at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg StateIDs:arraynum
 * @text State ID(s)
 * @type state[]
 * @desc Select which State ID(s) to add as a Passive State.
 * @default []
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to add the Passive State Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to add a Passive State(s) to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to add a Passive State(s) to.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AddTriggerToNode
 * @text GRID: Add Trigger to Node
 * @desc Adds Trigger to target node. Target node cannot have battler.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg SkillID:num
 * @text Skill ID
 * @type skill
 * @desc Select which Skill ID(s) to add as the trigger.
 * @default 1
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to add the Trigger Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to add a Trigger to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to add a Trigger to.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AddTriggerToNodeJS
 * @text GRID: Add Trigger to Node JS
 * @desc Adds Trigger to target node. Target node cannot have battler.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg SkillID:eval
 * @text JS: Skill ID
 * @desc Use JavaScript to determine what skill ID to add to this node.
 * @default 1
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to add the Trigger Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to add a Trigger to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to add a Trigger to.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AnimationIDAtNode
 * @text GRID: Animation ID at Node
 * @desc Plays specific animation ID at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Play this animation at target node.
 * @default 1
 *
 * @arg Mirror:eval
 * @text Mirror?
 * @parent AnimationID:num
 * @type boolean
 * @on Mirror Animation
 * @off Don't Mirror
 * @desc Mirror this animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute?
 * @parent AnimationID:num
 * @type boolean
 * @on Mute Animation
 * @off Don't Mute
 * @desc Mute this animation?
 * @default false
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AnimationJsAtNode
 * @text GRID: Animation JS at Node
 * @desc Uses JS to calculate which animation to play at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 * 
 * @arg AnimationID:eval
 * @text JS: Animation ID
 * @desc Calculate which animation to play on unit(s).
 * Uses JavaScript to determine animation ID.
 * @default 1
 *
 * @arg Mirror:eval
 * @text Mirror?
 * @parent AnimationID:eval
 * @type boolean
 * @on Mirror Animation
 * @off Don't Mirror
 * @desc Mirror this animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute?
 * @parent AnimationID:eval
 * @type boolean
 * @on Mute Animation
 * @off Don't Mute
 * @desc Mute this animation?
 * @default false
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AnimationTypeAtNode
 * @text GRID: Animation Type at Node
 * @desc Plays certain animation type at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg Type:str
 * @text Animation Type
 * @type select
 * @option Attack
 * @option Guard
 * @option Item
 * @option Skill
 * @desc What is the animation type you would like to play?
 * @default Attack
 * 
 * @arg Slot:eval
 * @text Slot (Attack Type)
 * @parent Type:str
 * @desc Which weapon slot to get this data from?
 * Main-hand weapon is weapon slot 1.
 * @default 1
 * 
 * @arg ItemID:num
 * @text Item ID (Item Type)
 * @parent Type:str
 * @type item
 * @desc Which item ID will the animation come from?
 * @default 7
 * 
 * @arg SkillID:num
 * @text Skill ID (Skill Type)
 * @parent Type:str
 * @type skill
 * @desc Which skill ID will the animation come from?
 * @default 99
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_MoveTargetsInDirection
 * @text GRID: Move Target(s) In Direction
 * @desc Moves target(s) in a specific direction to other Nodes.
 * Requires VisuMZ_2_BattleGridSystem!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to move.
 * @default ["all targets"]
 * 
 * @arg MoveType:str
 * @text Movement Type
 * @type select
 * @option -
 * @option Exact
 * @option -
 * @option Mid
 * @option -
 * @option Switch
 * @option Switch Mid
 * @option -
 * @option Crash
 * @option Crash Mid
 * @option -
 * @desc Select the Movement type rulings.
 * See VisuMZ_2_BattleGridSystem help file for details.
 * @default Mid
 * 
 * @arg Direction:str
 * @text Direction
 * @parent MoveType:str
 * @type select
 * @option -
 * @option Upward
 * @option Downward
 * @option -
 * @option Up-Forward
 * @option Forward
 * @option Down-Forward
 * @option -
 * @option Up-Backward
 * @option Backward
 * @option Down-Backward
 * @option -
 * @option Up-Leftward
 * @option Leftward
 * @option Down-Leftward
 * @option -
 * @option Up-Rightward
 * @option Rightward
 * @option Down-Rightward
 * @option -
 * @desc Select the movement direction.
 * @default Backward
 *
 * @arg Distance:eval
 * @text Distance
 * @parent MoveType:str
 * @desc The number of nodes to be moved.
 * You may use JavaScript code.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 *
 * @arg SilentMove:eval
 * @text Silent Change?
 * @type boolean
 * @on Silent
 * @off Visual
 * @desc Silent: Discreet changes shown. More apparent later.
 * Visual: Instant changes shown.
 * @default false
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_PullToTargetNode
 * @text GRID: Pull To Target Node
 * @desc Pulls battlers towards target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to pull on?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to pull to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to pull to.
 * @default 1
 *
 * @arg Strength:eval
 * @text Strength
 * @desc Input the strength level of the pull.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_PushFromTargetNode
 * @text GRID: Push From Target Node
 * @desc Pushes battlers away from target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to push from?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to push from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to push from.
 * @default 1
 *
 * @arg Strength:eval
 * @text Strength
 * @desc Input the strength level of the push.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_ClearPassiveStatesFromNode
 * @text GRID: Remove All Passive States from Node
 * @desc Removes all all Passive State effects at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to clear the Node for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to clear Passive States from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to clear Passive States from.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_RemovePassiveStatesFromNode
 * @text GRID: Remove Passive State(s) from Node
 * @desc Remove Passive State(s) at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg StateIDs:arraynum
 * @text State ID(s)
 * @type state[]
 * @desc Select which State ID(s) to remove as a Passive State.
 * @default []
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to remove the Passive State Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to remove a Passive State(s) from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to remove a Passive State(s) from.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_RemoveTriggerFromNode
 * @text GRID: Remove Trigger from Node
 * @desc Removes Trigger from target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to clear Triggers for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to clear Triggers from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to clear Triggers from.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_TeleportToNode
 * @text GRID: Teleport To Node
 * @desc Teleports user/random opponent to target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to teleport to?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to teleport to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to teleport.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_TraverseToNode
 * @text GRID: Traverse To Node
 * @desc Traverses user/random opponent to target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to traverse to?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to traverse to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to traverse.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceHorror
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakHorror
 * @text Action Sequences - Horror Effects
 * @desc These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_Clear
 * @text HORROR: Clear All Filters
 * @desc Clear all Horror Effects filters on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove Horror Effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchCreate
 * @text HORROR: Glitch Create
 * @desc Creates the glitch effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg slices:num
 * @text Glitch Slices
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Glitch slices to be used with the target.
 * @default 10
 *
 * @arg offset:num
 * @text Glitch Offset
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Default offset value.
 * @default 100
 *
 * @arg animated:eval
 * @text Glitch Animated?
 * @parent FilterGlitch
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the glitch effect?
 * @default true
 *
 * @arg aniFrequency:num
 * @text Glitch Frequency
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how frequent to make the glitch effect?
 * Lower = often     Higher = rarer
 * @default 300
 *
 * @arg aniStrength:num
 * @text Glitch Strength
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how strong is the glitch effect?
 * Lower = weaker     Higher = stronger
 * @default 30
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchRemove
 * @text HORROR: Glitch Remove
 * @desc Removes the glitch effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseCreate
 * @text HORROR: Noise Create
 * @desc Creates the noise effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg noise:num
 * @text Noise Rate
 * @parent FilterNoise
 * @desc Noise rate to be used with the target.
 * @default 0.3
 *
 * @arg animated:eval
 * @text Noise Animated
 * @parent FilterNoise
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the noise for the target?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseRemove
 * @text HORROR: Noise Remove
 * @desc Removes the noise effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVCreate
 * @text HORROR: TV Create
 * @desc Creates the TV effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg lineWidth:num
 * @text TV Line Thickness
 * @parent FilterTV
 * @type number
 * @min 1
 * @desc Default TV line thickness
 * Lower = thinner     Higher = thicker
 * @default 5
 *
 * @arg vignetting:num
 * @text TV Corner Size
 * @parent FilterTV
 * @desc Default TV line corner size
 * Lower = smaller     Higher = bigger
 * @default 0.3
 *
 * @arg animated:eval
 * @text TV Animated
 * @parent FilterTV
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the TV?
 * @default true
 *
 * @arg aniSpeed:num
 * @text TV Speed
 * @parent FilterTV
 * @desc Speed used to animate the TV if animated
 * Lower = slower     Higher = faster
 * @default 0.25
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVRemove
 * @text HORROR: TV Remove
 * @desc Removes the TV effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceImpact
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakImpact
 * @text Action Sequences - Impact
 * @desc These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_BlueRedInvert
 * @text IMPACT: Bizarro Inversion
 * @desc Swaps blue/red colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Enable:eval
 * @text Bizarro?
 * @type boolean
 * @on Enable / Bizarro
 * @off Disable / Normal
 * @desc Enable Bizarro Inversion effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ColorBreak
 * @text IMPACT: Color Break
 * @desc Breaks the colors on the screen before reassembling.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Intensity:eval
 * @text Intensity
 * @desc What is the intensity of the color break effect?
 * @default 60
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the color break effect?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutBack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Desaturate
 * @text IMPACT: Desaturation
 * @desc Desaturates all colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 *
 * @arg Enable:eval
 * @text Desaturate?
 * @type boolean
 * @on Enable / Desaturate
 * @off Disable / Normal
 * @desc Enable Desaturation effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurScreen
 * @text IMPACT: Motion Blur Screen
 * @desc Creates a motion blur on the whole screen.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.1
 *
 * @arg Duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurTarget
 * @text IMPACT: Motion Blur Target(s)
 * @desc Creates a motion blur on selected target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create motion blur effects for.
 * @default ["user"]
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.5
 *
 * @arg Duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailCreate
 * @text IMPACT: Motion Trail Create
 * @desc Creates a motion trail effect for the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create motion trail effects for.
 * @default ["user"]
 *
 * @arg delay:num
 * @text Delay
 * @type number
 * @min 1
 * @desc How many frames to delay by when creating a motion trail?
 * The higher the delay, the less after images there are.
 * @default 1
 *
 * @arg duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion trail last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg hue:num
 * @text Hue
 * @type number
 * @min 0
 * @max 360
 * @desc What do you want to be the hue for the motion trail?
 * @default 0
 *
 * @arg opacityStart:num
 * @text Starting Opacity
 * @type number
 * @min 0
 * @max 255
 * @desc What starting opacity value do you want for the motion
 * trail? Opacity values decrease over time.
 * @default 200
 *
 * @arg tone:eval
 * @text Tone
 * @desc What tone do you want for the motion trail?
 * Format: [Red, Green, Blue, Gray]
 * @default [0, 0, 0, 0]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailRemove
 * @text IMPACT: Motion Trail Remove
 * @desc Removes the motion trail effect from the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to clear motion trail effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Negative
 * @text IMPACT: Negative Inversion
 * @desc Inverts all the colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 *
 * @arg Enable:eval
 * @text Negative?
 * @type boolean
 * @on Enable / Negative
 * @off Disable / Normal
 * @desc Enable negative inversion effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Oversaturate
 * @text IMPACT: Oversaturation
 * @desc Oversaturates colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Enable:eval
 * @text Oversaturate?
 * @type boolean
 * @on Enable / Oversaturate
 * @off Disable / Normal
 * @desc Enable Oversaturation effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwavePoint
 * @text IMPACT: Shockwave at Point
 * @desc Creates a shockwave at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Coordinates
 * 
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveEachTargets
 * @text IMPACT: Shockwave from Each Target(s)
 * @desc Creates a shockwave at each of the target(s) location(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveCenterTargets
 * @text IMPACT: Shockwave from Target(s) Center
 * @desc Creates a shockwave from the center of the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_TimeScale
 * @text IMPACT: Time Scale
 * @desc Adjust time to go faster or slower!
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 * 
 * @arg Scale:eval
 * @text Scale
 * @desc Adjusts how fast/slow time goes.
 * 1.00 is normal. Lower is slower. Higher is faster.
 * @default 1.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_TimeStop
 * @text IMPACT: Time Stop
 * @desc Stops time for a set amount of milliseconds.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 * 
 * @arg ms:eval
 * @text Milliseconds
 * @desc How many milliseconds should time stop for?
 * 1000 milliseconds = 1 second.
 * @default 1000
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurPoint
 * @text IMPACT: Zoom Blur at Point
 * @desc Creates a zoom blur at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Coordinates
 * 
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 * 
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 * 
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurTargetCenter
 * @text IMPACT: Zoom Blur at Target(s) Center
 * @desc Creates a zoom blur at the center of targets.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a zoom blur from.
 * @default ["user"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a zoom blur from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 * 
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceInject
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakInject
 * @text Action Sequences - Inject
 * @desc These Action Sequences are related to injected animations.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationStart
 * @text INJECT: Animation Begin
 * @desc Injects and plays a whole spritesheet animation.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to inject the animation on.
 * @default ["user"]
 * 
 * @arg Filename:str
 * @text Filename
 * @type file
 * @dir img/sv_actors/
 * @desc Select the animation spritesheet file.
 * Located in the /img/sv_actors/ folder.
 * @default Untitled
 *
 * @arg horzCells:num
 * @text Horizontal Cells
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many horizontal cells (or columns) are there?
 * @default 1
 *
 * @arg vertCells:num
 * @text Vertical Cells
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many vertical cells (or rows) are there?
 * @default 1
 *
 * @arg frameDelay:num
 * @text Frame Delay
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many frames are played inbetween cells?
 * @default 1
 *
 * @arg smooth:eval
 * @text Smooth Bitmap?
 * @parent Filename:str
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth the spritesheet graphic?
 * @default false
 * 
 * @arg Offset
 *
 * @arg offsetX:eval
 * @text Offset X
 * @parent Offset
 * @desc Offsets the X position of the injected animation.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg offsetY:eval
 * @text Offset Y
 * @parent Offset
 * @desc Offsets the Y position of the injected animation.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationEnd
 * @text INJECT: Animation End
 * @desc Stops and ends any injected animations on target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to stop injected animation(s).
 * @default ["user"]
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationPauseResume
 * @text INJECT: Animation Pause/Resume
 * @desc Pauses/resumes any injected animations on target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to pause injected animation(s).
 * @default ["user"]
 *
 * @arg pause:eval
 * @text Pause?
 * @parent Filename:str
 * @type boolean
 * @on Pause
 * @off Resume
 * @desc Pause the injected animation?
 * @default true
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_WaitForInjectAni
 * @text INJECT: Wait For Injected Animation
 * @desc Waits for injected animations to complete before performing
 * next command. Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMechanics
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMechanics
 * @text Action Sequences - Mechanics
 * @desc These Action Sequences are related to various mechanics
 * related to the battle system.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ActionEffect
 * @text MECH: Action Effect
 * @desc Causes the unit(s) to take damage/healing from action and
 * incurs any changes made such as buffs and states.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ActiveChainInputDisable
 * @text MECH: Active Chain Input Disable
 * @desc Disables input for Active Chain Skills at this time.
 * Requires VisuMZ_3_ActiveChainSkills!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddBuffDebuff
 * @text MECH: Add Buff/Debuff
 * @desc Adds buff(s)/debuff(s) to unit(s). 
 * Determine which parameters are affected and their durations.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the buff(s) and/or debuff(s).
 * @default ["user"]
 * 
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to buff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["ATK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to debuff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["DEF"]
 * 
 * @arg Turns:eval
 * @text Turns
 * @desc Number of turns to set the parameter(s) buffs to.
 * You may use JavaScript code.
 * @default 5
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddState
 * @text MECH: Add State
 * @desc Adds state(s) to unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the buff(s).
 * @default ["user"]
 * 
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to add to unit(s).
 * Insert multiple state ID's to add multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AnalyzeWeakness
 * @text MECH: Analyze Weakness
 * @desc Reveal elemental weakness(es) from target(s).
 * Requires VisuMZ_3_WeaknessDisplay!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to reveal elemental weaknesses for.
 * @default ["all targets"]
 * 
 * @arg Reveal:eval
 * @text Reveal
 * @desc How many elemental weaknesses do you wish to reveal?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ArmorPenetration
 * @text MECH: Armor Penetration
 * @desc Adds an extra layer of defensive penetration/reduction.
 * You may use JavaScript code for any of these.
 *
 * @arg ArmorPenetration
 * @text Armor/Magic Penetration
 * 
 * @arg ArPenRate:eval
 * @text Rate
 * @parent ArmorPenetration
 * @desc Penetrates an extra multiplier of armor by this value.
 * @default 0.00
 * 
 * @arg ArPenFlat:eval
 * @text Flat
 * @parent ArmorPenetration
 * @desc Penetrates a flat amount of armor by this value.
 * @default 0
 *
 * @arg ArmorReduction
 * @text Armor/Magic Reduction
 * 
 * @arg ArRedRate:eval
 * @text Rate
 * @parent ArmorReduction
 * @desc Reduces an extra multiplier of armor by this value.
 * @default 0.00
 * 
 * @arg ArRedFlat:eval
 * @text Flat
 * @parent ArmorReduction
 * @desc Reduces a flat amount of armor by this value.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AtbGauge
 * @text MECH: ATB Gauge
 * @desc Alters the ATB/TPB Gauges.
 * Requires VisuMZ_2_BattleSystemATB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 *
 * @arg Charging
 * 
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the ATB Gauge if it is currently charging.
 * @default -0.00
 * 
 * @arg Casting
 * 
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the ATB Gauge if it is currently casting.
 * @default -0.00
 * 
 * @arg Interrupt:eval
 * @text Interrupt?
 * @parent Casting
 * @type boolean
 * @on Interrupt
 * @off Don't Interrupt
 * @desc Interrupt the ATB Gauge if it is currently casting?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsChange
 * @text MECH: Boost Points Change
 * @desc Changes Boost Points for target(s).
 * Requires VisuMZ_3_BoostAction!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the Boost Points for.
 * @default ["user"]
 * 
 * @arg BoostPoints:eval
 * @text Alter Boost Points By
 * @desc Alters the unit(s) Boost Points.
 * Positive for gaining points. Negative for losing points.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsStoreData
 * @text MECH: Boost Store Data
 * @desc Stores the number of Boosts used this action inside a variable.
 * Requires VisuMZ_3_BoostAction!
 * 
 * @arg VariableID:num
 * @text Variable ID
 * @type variable
 * @desc Which variable do you want to store the data inside?
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldChange
 * @text MECH: Break Shield Change
 * @desc Changes Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the Break Shields for.
 * @default ["all targets"]
 * 
 * @arg BreakShields:eval
 * @text Alter Break Shields By
 * @desc Alters the unit(s) Break Shields.
 * Positive for gaining shields. Negative for losing shields.
 * @default -1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldReset
 * @text MECH: Break Shield Reset
 * @desc Resets Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to reset the Break Shields for.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BtbGain
 * @text MECH: BTB Brave Points
 * @desc Alters the target(s) Brave Points to an exact value.
 * Requires VisuMZ_2_BattleSystemBTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 * 
 * @arg BravePoints:eval
 * @text Alter Brave Points By
 * @desc Alters the target(s) Brave Points.
 * Positive for gaining BP. Negative for losing BP.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Collapse
 * @text MECH: Collapse
 * @desc Causes the unit(s) to perform its collapse animation
 * if the unit(s) has died.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to process a death collapse.
 * @default ["all targets"]
 * 
 * @arg ForceDeath:eval
 * @text Force Death
 * @type boolean
 * @on On
 * @off Off
 * @desc Force death even if the unit has not reached 0 HP?
 * This will remove immortality.
 * @default false
 * 
 * @arg WaitForEffect:eval
 * @text Wait For Effect?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for the collapse effect to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbOrder
 * @text MECH: CTB Order
 * @desc Alters the CTB Turn Order.
 * Requires VisuMZ_2_BattleSystemCTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the CTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg ChangeOrderBy:eval
 * @text Change Order By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbSpeed
 * @text MECH: CTB Speed
 * @desc Alters the CTB Speed.
 * Requires VisuMZ_2_BattleSystemCTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the CTB Speed for.
 * @default ["all targets"]
 *
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the CTB Speed if it is currently charging.
 * @default -0.00
 * 
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the CTB Speed if it is currently casting.
 * @default -0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CustomDmgFormula
 * @text MECH: Custom Damage Formula
 * @desc Changes the current action's damage formula to custom.
 * This will assume the MANUAL damage style.
 * 
 * @arg Formula:str
 * @text Formula
 * @desc Changes the current action's damage formula to custom.
 * Use 'default' to revert the damage formula.
 * @default default
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DamagePopup
 * @text MECH: Damage Popup
 * @desc Causes the unit(s) to display the current state of
 * damage received or healed.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a damage popup.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DeathBreak
 * @text MECH: Dead Label Jump
 * @desc If the active battler is dead, jump to a specific label in the common event.
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If the active battler is dead, jump to this specific label in the common event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateAttackEffect
 * @text MECH: Emulate Attack Effect
 * @desc Emulate an "Action Effect" but using a the user's
 * attack skill instead of the current action.
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateGuardEffect
 * @text MECH: Emulate Guard Effect
 * @desc Emulate an "Action Effect" but using a the user's
 * guard skill instead of the current action.
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateItemEffect
 * @text MECH: Emulate Item Effect
 * @desc Emulate an "Action Effect" but using a specific item
 * instead of the current action.
 * 
 * @arg ItemID:eval
 * @text Item ID
 * @type item
 * @desc Which item ID will be emulated?
 * @default 7
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateSkillCost
 * @text MECH: Emulate Skill Cost
 * @desc Pick a skill for target(s) to emulate paying the cost of.
 * Includes cooldowns and limited uses.
 * 
 * @arg SkillID:eval
 * @text Skill ID
 * @type skill
 * @desc Which skill ID will have its cost paid for?
 * Use 0 for current action's skill.
 * @default 0
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateSkillEffect
 * @text MECH: Emulate Skill Effect
 * @desc Emulate an "Action Effect" but using a specific skill
 * instead of the current action.
 * 
 * @arg SkillID:eval
 * @text Skill ID
 * @type skill
 * @desc Which skill ID will be emulated?
 * @default 99
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EnemyEscape
 * @text MECH: Enemy Escape
 * @desc Causes the enemy unit(s) to escape.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to escape.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EtbAction
 * @text MECH: ETB Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Requires VisuMZ_2_BattleSystemETB!
 * 
 * @arg ActionCount:eval
 * @text Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Positive for gaining energy. Negative for losing energy.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_FtbAction
 * @text MECH: FTB Action Count
 * @desc Alters the subject team's available Action Count.
 * Requires VisuMZ_2_BattleSystemFTB!
 * 
 * @arg ActionCount:eval
 * @text Action Count
 * @desc Alters the subject team's available Action Count.
 * Positive for gaining actions. Negative for losing actions.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_HpMpTp
 * @text MECH: HP, MP, TP
 * @desc Alters the HP, MP, and TP values for unit(s).
 * Positive values for healing. Negative values for damage.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["user"]
 *
 * @arg HP
 * 
 * @arg HP_Rate:eval
 * @text HP Rate
 * @parent HP
 * @desc Changes made to HP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg HP_Flat:eval
 * @text HP Flat
 * @parent HP
 * @desc Flat changes made to HP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 * 
 * @arg MP
 * 
 * @arg MP_Rate:eval
 * @text MP Rate
 * @parent MP
 * @desc Changes made to MP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg MP_Flat:eval
 * @text MP Flat
 * @parent MP
 * @desc Flat changes made to MP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 *
 * @arg TP
 * 
 * @arg TP_Rate:eval
 * @text TP Rate
 * @parent TP
 * @desc Changes made to TP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg TP_Flat:eval
 * @text TP Flat
 * @parent TP
 * @desc Flat changes made to TP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 * 
 * @arg ShowPopup:eval
 * @text Damage Popup?
 * @type boolean
 * @on On
 * @off Off
 * @desc Display a damage popup after?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Immortal
 * @text MECH: Immortal
 * @desc Changes the immortal flag of targets. If immortal flag is
 * removed and a unit would die, collapse that unit.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Alter the immortal flag of these groups. If immortal flag
 * is removed and a unit would die, collapse that unit.
 * @default ["user","all targets"]
 * 
 * @arg Immortal:eval
 * @text Immortal
 * @type boolean
 * @on On
 * @off Off
 * @desc Turn immortal flag for unit(s) on/off?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Multipliers
 * @text MECH: Multipliers
 * @desc Changes the multipliers for the current action.
 * You may use JavaScript code for any of these.
 *
 * @arg CriticalHit
 * @text Critical Hit%
 * 
 * @arg CriticalHitRate:eval
 * @text Rate
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this multiplier.
 * @default 1.00
 * 
 * @arg CriticalHitFlat:eval
 * @text Flat
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this flat bonus.
 * @default +0.00
 *
 * @arg CriticalDmg
 * @text Critical Damage
 * 
 * @arg CriticalDmgRate:eval
 * @text Rate
 * @parent CriticalDmg
 * @desc Affects critical damage by this multiplier.
 * @default 1.00
 * 
 * @arg CriticalDmgFlat:eval
 * @text Flat
 * @parent CriticalDmg
 * @desc Affects critical damage by this flat bonus.
 * @default +0.00
 *
 * @arg Damage
 * @text Damage/Healing
 * 
 * @arg DamageRate:eval
 * @text Rate
 * @parent Damage
 * @desc Sets the damage/healing multiplier for current action.
 * @default 1.00
 * 
 * @arg DamageFlat:eval
 * @text Flat
 * @parent Damage
 * @desc Sets the damage/healing bonus for current action.
 * @default +0.00
 *
 * @arg HitRate
 * @text Hit Rate
 * 
 * @arg HitRate:eval
 * @text Rate
 * @parent HitRate
 * @desc Affects chance to connect attack by this multiplier.
 * @default 1.00
 * 
 * @arg HitFlat:eval
 * @text Flat
 * @parent HitRate
 * @desc Affects chance to connect attack by this flat bonus.
 * @default +0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_OnceParallel
 * @text MECH: Once Parallel
 * @desc Plays a Common Event parallel to the battle event once
 * without repeating itself when done.
 *
 * @arg CommonEventID:num
 * @text Common Event ID
 * @type common_event
 * @desc The ID of the parallel Common Event to play.
 * Does NOT repeat itself when finished.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_OtbOrder
 * @text MECH: OTB Order
 * @desc Alters the OTB Turn Order. Best used with single targets.
 * Requires VisuMZ_2_BattleSystemOTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the OTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg CurrentTurn:eval
 * @text Current Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @arg NextTurn:eval
 * @text Next Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @arg FollowTurn:eval
 * @text Follow Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbAlterCost
 * @text MECH: PTB Alter Cost
 * @desc Alters the action's cost settings.
 * Requires VisuMZ_2_BattleSystemPTB!
 *
 * @arg Override:eval
 * @text Override?
 * @type boolean
 * @on Override Permanent
 * @off Require Temporary
 * @desc Overrides any 'permanent' settings for Changeability?
 * @default false
 *
 * @arg alterChange:str
 * @text Alter Changeability
 * @type select
 * @option Unchanged - Cost type is unchanged after this effect
 * @value unchanged
 * @option Permanent - Cost type can no longer be changed after
 * @value permanent
 * @option Temporary - Cost type can still be changed after
 * @value temporary
 * @desc Allow the cost type and value to be changeable?
 * @default unchanged
 *
 * @arg alterType:str
 * @text Alter Cost Type
 * @type select
 * @option Unchanged - No changes are made
 * @value unchanged
 * @option Consume - Removes half, otherwise consumes full
 * @value consume
 * @option Convert - Converts full => half, otherwise consumes half
 * @value convert
 * @option Compress - Consumes half, otherwise converts full => half
 * @value compress
 * @desc Change the cost type to this scenario.
 * Use 'Unchanged' for no changes.
 * @default convert
 *
 * @arg alterCost:eval
 * @text Alter Cost Value
 * @desc What is the default action cost for this scenario?
 * @default +0
 *
 * @arg alterPriority:eval
 * @text Priority
 * @desc What is this scenario's priority? Scenario outcomes with
 * equal or lower priorities cannot override types and costs.
 * @default 50
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbConvert
 * @text MECH: PTB Conversion
 * @desc Converts full actions into half actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 * 
 * @arg ConvertCount:eval
 * @text Conversion Count
 * @desc Converts full actions into half actions.
 * If not enough, consume half actions.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbFullHalfAction
 * @text MECH: PTB Full/Half Action(s)
 * @desc Alters the subject team's available Full/Half Actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 * 
 * @arg FullActions:eval
 * @text Full Actions
 * @desc Alters the subject team's available Full Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 * 
 * @arg HalfActions:eval
 * @text Half Actions
 * @desc Alters the subject team's available Half Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveBuffDebuff
 * @text MECH: Remove Buff/Debuff
 * @desc Removes buff(s)/debuff(s) from unit(s). 
 * Determine which parameters are removed.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to have the buff(s) and/or debuff(s) removed.
 * @default ["user"]
 * 
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which buffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which debuffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveState
 * @text MECH: Remove State
 * @desc Remove state(s) from unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to have states removed from.
 * @default ["user"]
 * 
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to remove from unit(s).
 * Insert multiple state ID's to remove multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StateTurnsChangeBy
 * @text MECH: State Turns Change By
 * @desc Changes target(s) state turns by an amount.
 * Requires VisuMZ_1_SkillsStatesCore!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to affect state turns for.
 * @default ["all targets"]
 *
 * @arg StateID:num
 * @text State ID
 * @type state
 * @desc What is the ID of the state you wish to change turns for?
 * Only works on states that can have turns.
 * @default 5
 *
 * @arg Turns:eval
 * @text Change Turns By
 * @desc How many turns should the state be changed to?
 * You may use JavaScript code.
 * @default +1
 *
 * @arg AutoAddState:eval
 * @text Auto-Add State?
 * @type boolean
 * @on Auto-Add
 * @off Don't Add
 * @desc Automatically adds state if actor(s) does not have it applied?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StateTurnsChangeTo
 * @text MECH: State Turns Change To
 * @desc Changes target(s) state turns to a specific value.
 * Requires VisuMZ_1_SkillsStatesCore!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to affect state turns for.
 * @default ["all targets"]
 *
 * @arg StateID:num
 * @text State ID
 * @type state
 * @desc What is the ID of the state you wish to change turns for?
 * Only works on states that can have turns.
 * @default 5
 *
 * @arg Turns:eval
 * @text Change Turns To
 * @desc How many turns should the state be changed to?
 * You may use JavaScript code.
 * @default 10
 *
 * @arg AutoAddState:eval
 * @text Auto-Add State?
 * @type boolean
 * @on Auto-Add
 * @off Don't Add
 * @desc Automatically adds state if target(s) does not have it applied?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExploit
 * @text MECH: STB Exploit Effect
 * @desc Utilize the STB Exploitation mechanics!
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Exploited:eval
 * @text Target(s) Exploited?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Exploit the below targets?
 * @default true
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to become exploited.
 * @default ["all targets"]
 * 
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploited status?
 * @default false
 * 
 * @arg Exploiter:eval
 * @text User Exploiter?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Allow the user to become the exploiter?
 * @default true
 * 
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploiter status?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExtraAction
 * @text MECH: STB Extra Action
 * @desc Adds an extra action for the currently active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Actions:eval
 * @text Extra Actions
 * @parent Charging
 * @desc How many extra actions should the active battler gain?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbRemoveExcessActions
 * @text MECH: STB Remove Excess Actions
 * @desc Removes excess actions from the active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Actions:eval
 * @text Remove Actions
 * @parent Charging
 * @desc How many actions to remove from the active battler?
 * You may use JavaScript code.
 * @default 99
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_SwapWeapon
 * @text MECH: Swap Weapon
 * @desc Causes the unit(s) to swap their weapon for another.
 * Requires VisuMZ_2_WeaponSwapSystem!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to swap weapons for.
 * @default ["user"]
 * 
 * @arg WeaponTypeID:eval
 * @text Weapon Type ID
 * @desc Which weapon type to swap to?
 * This is NOT the weapon's ID. It's the weapon TYPE.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_TextPopup
 * @text MECH: Text Popup
 * @desc Causes the unit(s) to display a text popup.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 * 
 * @arg Text:str
 * @text Text
 * @desc What text do you wish to display?
 * @default Text
 * 
 * @arg TextColor:str
 * @text Text Color
 * @parent Text:str
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 * 
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_VariablePopup
 * @text MECH: Variable Popup
 * @desc Causes the unit(s) to display a popup using the data
 * stored inside a variable.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 * 
 * @arg Variable:num
 * @text Variable ID
 * @type variable
 * @desc Get data from which variable to display as a popup?
 * @default 1
 * 
 * @arg DigitGrouping:eval
 * @text Digit Grouping
 * @parent Variable:num
 * @type boolean
 * @on Group Digits
 * @off Don't Group
 * @desc Use digit grouping to separate numbers?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 * 
 * @arg TextColor:str
 * @text Text Color
 * @parent Variable:num
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [0, 0, 0, 0]
 * 
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_WaitForEffect
 * @text MECH: Wait For Effect
 * @desc Waits for the effects to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMotion
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMotion
 * @text Action Sequences - Motion
 * @desc These Action Sequences allow you the ability to control
 * the motions of sideview sprites.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_ClearFreezeFrame
 * @text MOTION: Clear Freeze Frame
 * @desc Clears any freeze frames from the unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to clear freeze frames for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_FreezeMotionFrame
 * @text MOTION: Freeze Motion Frame
 * @desc Forces a freeze frame instantly at the selected motion.
 * Automatically clears with a new motion.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to freeze motions for.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Freeze this motion for the unit(s).
 * @default attack
 * 
 * @arg Frame:num
 * @text Frame Index
 * @desc Which frame do you want to freeze the motion on?
 * Frame index values start at 0.
 * @default 2
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_MotionType
 * @text MOTION: Motion Type
 * @desc Causes the unit(s) to play the selected motion.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default attack
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_PerformAction
 * @text MOTION: Perform Action
 * @desc Causes the unit(s) to play the proper motion based
 * on the current action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_RefreshMotion
 * @text MOTION: Refresh Motion
 * @desc Cancels any set motions unit(s) has to do and use
 * their most natural motion at the moment.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to refresh their motion state.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_WaitMotionFrame
 * @text MOTION: Wait By Motion Frame
 * @desc Creates a wait equal to the number of motion frames passing.
 * Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 * @arg MotionFrameWait:num
 * @text Motion Frames to Wait?
 * @type number
 * @min 1
 * @desc Each "frame" is equal to the value found in
 * Plugin Parameters => Actors => Motion Speed
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMovement
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMovement
 * @text Action Sequences - Movement
 * @desc These Action Sequences allow you the ability to control
 * the sprites of actors and enemies in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_BattleStep
 * @text MOVE: Battle Step
 * @desc Causes the unit(s) to move forward past their home position
 * to prepare for action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveBy
 * @text MOVE: Change Home By Distance
 * @desc Change unit(s)'s home position by a distance from their
 * current home position(s). Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 *
 * @arg DistanceAdjust:str
 * @text Distance Adjustment
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to distance values to determine
 * which direction to change by.
 * @default horz
 * 
 * @arg DistanceX:eval
 * @text Distance: X
 * @parent DistanceAdjust:str
 * @desc Horizontal distance to change home by.
 * You may use JavaScript code.
 * @default 48
 * 
 * @arg DistanceY:eval
 * @text Distance: Y
 * @parent DistanceAdjust:str
 * @desc Vertical distance to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToJsPoint
 * @text MOVE: Change Home To JS Coordinates
 * @desc Change home position(s) to specified JS Coordinates.
 * Sideview-only! Uses JavaScript!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 *
 * @arg DestinationJS:func
 * @text JS: Coordinates
 * @type note
 * @desc Code used to determine the coordinates for the
 * target(s)'s new home position.
 * @default "// Declare Variables\nconst target = arguments[0];\nlet goalX = 0;\nlet goalY = 0;\n\n// Calculations\ngoalX = Graphics.width / 2;\ngoalY = Graphics.height / 2;\n\n// Return Data\nreturn new Point(goalX, goalY);"
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToPoint
 * @text MOVE: Change Home To Point
 * @desc Change home position(s) to a target point on the screen.
 * Sideview-only! Points based off Graphics.boxWidth/Height.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 * 
 * @arg Destination:str
 * @text Destination Point
 * @type combo
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default center
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToTarget
 * @text MOVE: Change Home To Target(s)
 * @desc Moves unit(s) to another unit(s) on the battle field.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (Moving)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (Destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position to.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to change home position to.
 * @default front base
 * 
 * @arg MeleeDistance:eval
 * @text Melee Distance
 * @parent TargetLocation:str
 * @desc The melee distance away from the target location
 * in addition to the battler's width.
 * @default 24
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Targets2:arraystr
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceDirection
 * @text MOVE: Face Direction
 * @desc Causes the unit(s) to face forward or backward.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Direction:str
 * @text Direction
 * @type combo
 * @option forward
 * @option backward
 * @option random
 * @desc Select which direction to face.
 * @default forward
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceJsPoint
 * @text MOVE: Face JS Coordinates
 * @desc Causes the unit(s) to face specified JS Coordinates.
 * Sideview-only! Uses JavaScript!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 *
 * @arg PointJS:func
 * @text JS: Coordinates
 * @type note
 * @desc Code used to determine the coordinates for the
 * target(s) to face towards.
 * @default "// Declare Variables\nconst target = arguments[0];\nlet goalX = 0;\nlet goalY = 0;\n\n// Calculations\ngoalX = Graphics.width / 2;\ngoalY = Graphics.height / 2;\n\n// Return Data\nreturn new Point(goalX, goalY);"
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the point instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FacePoint
 * @text MOVE: Face Point
 * @desc Causes the unit(s) to face a point on the screen.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Point:str
 * @text Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the point instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceTarget
 * @text MOVE: Face Target(s)
 * @desc Causes the unit(s) to face other targets on the screen.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (facing)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for the turning unit(s) to face.
 * @default ["current target"]
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the unit(s) instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Float
 * @text MOVE: Float
 * @desc Causes the unit(s) to float above the ground.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to make float.
 * @default ["user"]
 * 
 * @arg Height:eval
 * @text Desired Height
 * @desc Vertical distance to float upward.
 * You may use JavaScript code.
 * @default 100
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total float amount.
 * @default 12
 *
 * @arg EasingType:str
 * @text Float Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForFloat:eval
 * @text Wait For Float?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for floating to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeReset
 * @text MOVE: Home Reset
 * @desc Causes the unit(s) to move back to their home position(s)
 * and face back to their original direction(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["alive battlers"]
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Jump
 * @text MOVE: Jump
 * @desc Causes the unit(s) to jump into the air.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to make jump.
 * @default ["user"]
 * 
 * @arg Height:eval
 * @text Desired Height
 * @desc Max jump height to go above the ground
 * You may use JavaScript code.
 * @default 100
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total jump amount.
 * @default 12
 * 
 * @arg WaitForJump:eval
 * @text Wait For Jump?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for jumping to complete before performing next command?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveBy
 * @text MOVE: Move Distance
 * @desc Moves unit(s) by a distance from their current position(s).
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg DistanceAdjust:str
 * @text Distance Adjustment
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to distance values to determine
 * which direction to move unit(s).
 * @default horz
 * 
 * @arg DistanceX:eval
 * @text Distance: X
 * @parent DistanceAdjust:str
 * @desc Horizontal distance to move.
 * You may use JavaScript code.
 * @default 48
 * 
 * @arg DistanceY:eval
 * @text Distance: Y
 * @parent DistanceAdjust:str
 * @desc Vertical distance to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToJsPoint
 * @text MOVE: Move To JS Coordinates
 * @desc Moves unit(s) to specified JS Coordinates.
 * Sideview-only! Uses JavaScript!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg DestinationJS:func
 * @text JS: Coordinates
 * @type note
 * @desc Code used to determine the coordinates for the
 * target(s) to move to.
 * @default "// Declare Variables\nconst target = arguments[0];\nlet goalX = 0;\nlet goalY = 0;\n\n// Calculations\ngoalX = Graphics.width / 2;\ngoalY = Graphics.height / 2;\n\n// Return Data\nreturn new Point(goalX, goalY);"
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToPoint
 * @text MOVE: Move To Point
 * @desc Moves unit(s) to a designated point on the screen.
 * Sideview-only! Points based off Graphics.boxWidth/Height.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg Destination:str
 * @text Destination Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToTarget
 * @text MOVE: Move To Target(s)
 * @desc Moves unit(s) to another unit(s) on the battle field.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (Moving)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (Destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move to.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to move to.
 * @default front base
 * 
 * @arg MeleeDistance:eval
 * @text Melee Distance
 * @parent TargetLocation:str
 * @desc The melee distance away from the target location
 * in addition to the battler's width.
 * @default 24
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Targets2:arraystr
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Opacity
 * @text MOVE: Opacity
 * @desc Causes the unit(s) to change opacity.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change opacity.
 * @default ["user"]
 * 
 * @arg Opacity:eval
 * @text Desired Opacity
 * @desc Change to this opacity value.
 * You may use JavaScript code.
 * @default 255
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for opacity change.
 * @default 12
 *
 * @arg EasingType:str
 * @text Opacity Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForOpacity:eval
 * @text Wait For Opacity?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for opacity changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Scale
 * @text MOVE: Scale/Grow/Shrink
 * @desc Causes the unit(s) to scale, grow, or shrink?.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change the scale of.
 * @default ["user"]
 * 
 * @arg ScaleX:eval
 * @text Scale X
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 * 
 * @arg ScaleY:eval
 * @text Scale Y
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to scale for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Scale Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForScale:eval
 * @text Wait For Scale?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for scaling to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Skew
 * @text MOVE: Skew/Distort
 * @desc Causes the unit(s) to skew.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to skew.
 * @default ["user"]
 * 
 * @arg SkewX:eval
 * @text Skew X
 * @desc X variance to skew?
 * Use small values for the best results.
 * @default 0.00
 * 
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Y variance to skew?
 * Use small values for the best results.
 * @default 0.00
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to skew for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Spin
 * @text MOVE: Spin/Rotate
 * @desc Causes the unit(s) to spin.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to spin.
 * @default ["user"]
 * 
 * @arg Angle:eval
 * @text Angle
 * @desc How many degrees to spin?
 * @default 360
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to spin for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Spin Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg RevertAngle:eval
 * @text Revert Angle on Finish
 * @type boolean
 * @on Revert
 * @off Don't
 * @desc Revert angle after spinning?
 * @default true
 * 
 * @arg WaitForSpin:eval
 * @text Wait For Spin?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for spin to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForFloat
 * @text MOVE: Wait For Float
 * @desc Waits for floating to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForJump
 * @text MOVE: Wait For Jump
 * @desc Waits for jumping to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForMovement
 * @text MOVE: Wait For Movement
 * @desc Waits for movement to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForOpacity
 * @text MOVE: Wait For Opacity
 * @desc Waits for opacity changes to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForScale
 * @text MOVE: Wait For Scale
 * @desc Waits for scaling to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSkew
 * @text MOVE: Wait For Skew
 * @desc Waits for skewing to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSpin
 * @text MOVE: Wait For Spin
 * @desc Waits for spinning to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceProjectile
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakProjectile
 * @text Action Sequences - Projectiles
 * @desc Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Animation
 * @text PROJECTILE: Animation
 * @desc Create an animation projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Settings
 * @type animation
 * @desc Determine which animation to use as a projectile.
 * @default 77
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to finish before going to the next command?
 * @default false
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExAni>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","EasingType:str":"Linear","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Icon
 * @text PROJECTILE: Icon
 * @desc Create an icon projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg Icon:eval
 * @text Icon Index
 * @parent Settings
 * @desc Determine which icon to use as a projectile.
 * You may use JavaScript code.
 * @default 118
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Picture
 * @text PROJECTILE: Picture
 * @desc Create a picture projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg Picture:str
 * @text Picture Filename
 * @parent Settings
 * @type file
 * @dir img/pictures/
 * @desc Determine which picture to use as a projectile.
 * @default Untitled
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceSkew
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSkew
 * @text Action Sequences - Skew
 * @desc Allows you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeSkew
 * @text SKEW: Change Skew
 * @desc Changes the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg SkewX:eval
 * @text Skew X
 * @desc Change the camera skew X to this value.
 * @default 0
 * 
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Change the camera skew Y to this value.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_Reset
 * @text SKEW: Reset Skew
 * @desc Reset any skew settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_WaitForSkew
 * @text SKEW: Wait For Skew
 * @desc Waits for skew changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceTarget
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakTarget
 * @text Action Sequences - Target
 * @desc If using a manual target by target Action Sequence,
 * these commands will give you full control over its usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_CurrentIndex
 * @text TARGET: Current Index
 * @desc Sets the current index to this value.
 * Then decide to jump to a label (optional).
 * 
 * @arg Index:eval
 * @text Set Index To
 * @desc Sets current targeting index to this value.
 * 0 is the starting index of a target group.
 * @default 0
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_NextTarget
 * @text TARGET: Next Target
 * @desc Moves index forward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_PrevTarget
 * @text TARGET: Previous Target
 * @desc Moves index backward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_RandTarget
 * @text TARGET: Random Target
 * @desc Sets index randomly to determine new currernt target.
 * Then decide to jump to a label (optional).
 * 
 * @arg ForceRandom:eval
 * @text Force Random?
 * @type boolean
 * @on On
 * @off Off
 * @desc Index cannot be its previous index amount after random.
 * @default false
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceVoice
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakVoice
 * @text Action Sequences - Voice
 * @desc Allows you to play battle voices.
 * Requires VisuMZ_3_BattleVoices!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleVoice_PlayCommonLine
 * @text VOICE: Play Common Line
 * @desc Plays a common voice line from target battler(s).
 * Requires VisuMZ_3_BattleVoices!
 * 
 * @arg Targets:arraystr
 * @text Speaker Target(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play voice lines from.
 * @default ["user"]
 *
 * @arg VoiceLine:str
 * @text Voice Line
 * @type select
 * @option -
 * @value -
 * @option ---Battle Phase---
 * @value -
 * @option On Battle Start
 * @value BattleStart
 * @option On Battle Input
 * @value BattleInput
 * @option On Battle Victory
 * @value BattleVictory
 * @option Victory => Level Up
 * @value BattleVictoryLevelUp
 * @option Escape => Success
 * @value BattleEscapeSuccess
 * @option Escape => Failure
 * @value BattleEscapeFailure
 * @option -
 * @value -
 * @option ---On Action Start---
 * @value -
 * @option Basic Action => Regular Attack
 * @value ActionStartBasicAttack
 * @option Basic Action => Regular Guard
 * @value ActionStartBasicGuard
 * @option Skill Usage For Allies => Certain Hit
 * @value ActionStartSkillAllyCertainHit
 * @option Skill Usage For Allies => Physical
 * @value ActionStartSkillAllyPhysical
 * @option Skill Usage For Allies => Magical
 * @value ActionStartSkillAllyMagical
 * @option Skill Usage For Enemies => Certain Hit
 * @value ActionStartSkillEnemyCertainHit
 * @option Skill Usage For Enemies => Physical
 * @value ActionStartSkillEnemyPhysical
 * @option Skill Usage For Enemies => Magical
 * @value ActionStartSkillEnemyMagical
 * @option Item Usage For Allies
 * @value ActionStartItemAlly
 * @option Item Usage For Enemies
 * @value ActionStartItemEnemy
 * @option -
 * @value -
 * @option ---Perform Action---
 * @value -
 * @option Basic Action => Attack Motion
 * @value PerformActionBasicAttack
 * @option Basic Action => Critical Action
 * @value PerformActionCritical
 * @option Basic Action => Defeat Opponent
 * @value PerformActionDefeatFoe
 * @option Basic Action => Missed Action
 * @value PerformActionMiss
 * @option Skill Usage => Certain Hit
 * @value PerformActionSkillCertainHit
 * @option Skill Usage => Physical
 * @value PerformActionSkillPhysical
 * @option Skill Usage => Magical
 * @value PerformActionSkillMagical
 * @option -
 * @value -
 * @option ---On HP Change---
 * @value -
 * @option Life State => On Death
 * @value HpChangeDeath
 * @option Life State => On Revive
 * @value HpChangeRevive
 * @option On Damage => Damage <= 0%
 * @value HpChangeDamageNone
 * @option On Damage => Damage < 25%
 * @value HpChangeDamageLight
 * @option On Damage => Damage < 50%
 * @value HpChangeDamageMedium
 * @option On Damage => Damage >= 50%
 * @value HpChangeDamageHeavy
 * @option On Damage => Guarding Damage
 * @value HpChangeDamageGuard
 * @option On Recovery => Recovery < 25%
 * @value HpChangeRecoverLight
 * @option On Recovery => Recovery < 50%
 * @value HpChangeRecoverMedium
 * @option On Recovery => Recovery >= 50%
 * @value HpChangeRecoverHeavy
 * @option -
 * @value -
 * @option ---On Action Result---
 * @value -
 * @option On Miss/Evasion
 * @value ActionResultEvasion
 * @option On Magic Evasion
 * @value ActionResultMagicEvasion
 * @option On Counter
 * @value ActionResultCounter
 * @option On Reflection
 * @value ActionResultReflection
 * @option On Substitute
 * @value ActionResultSubstitute
 * @option -
 * @value -
 * @option ---Buff/Debuff Related---
 * @value -
 * @option On Buff Apply
 * @value BuffAdd
 * @option On Buff Remove
 * @value BuffRemove
 * @option On Debuff Apply
 * @value DebuffAdd
 * @option On Debuff Remove
 * @value DebuffRemove
 * @option -
 * @value -
 * @option ---State Related---
 * @value -
 * @option Positive States => On State Apply
 * @value StatePositiveAdd
 * @option Positive States => text On State Remove
 * @value StatePositiveRemove
 * @option Negative States => On State Apply
 * @value StateNegativeAdd
 * @option Negative States => On State Remove
 * @value StateNegativeRemove
 * @option Neutral States => On State Apply
 * @value StateNeutralAdd
 * @option Neutral States => On State Remove
 * @value StateNeutralRemove
 * @option -
 * @value -
 * @option ---Miscellaneous---
 * @value -
 * @option Voice Preview
 * @value CharaCreatePreview
 * @option -
 * @value -
 * @desc What voice line do you wish to play?
 * @default ActionStartBasicAttack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleVoice_PlaySpecialLine
 * @text VOICE: Play Special Line
 * @desc Plays a special voice line from target battler(s).
 * Requires VisuMZ_3_BattleVoices!
 * 
 * @arg Targets:arraystr
 * @text Speaker Target(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play voice lines from.
 * @default ["user"]
 *
 * @arg VoiceLineType:str
 * @text Voice Line Type
 * @type select
 * @option Action Name
 * @value ActionName
 * @option Chant Line
 * @value ChantLine
 * @option Item Name
 * @value ItemName
 * @option Skill Name
 * @value SkillName
 * @option Spell Name
 * @value SpellName
 * @option Unique Lines
 * @value UniqueLine
 * @desc What voice line type do you wish to play?
 * @default ActionName
 *
 * @arg Letter:str
 * @text Name / Letter
 * @type select
 * @option A
 * @option B
 * @option C
 * @option D
 * @option E
 * @option F
 * @option G
 * @option H
 * @option I
 * @option J
 * @option K
 * @option L
 * @option M
 * @option N
 * @option O
 * @option P
 * @option Q
 * @option R
 * @option S
 * @option T
 * @option U
 * @option V
 * @option W
 * @option X
 * @option Y
 * @option Z
 * @desc What voice letter/name do you want to play?
 * @default A
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceWeapon
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakWeapon
 * @text Action Sequences - Weapon
 * @desc Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_ClearActiveWeapon
 * @text WEAPON: Clear Weapon Slot
 * @desc Clears the active weapon slot (making others valid again).
 * Only works for Actors.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to clear the active weapon slot for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_NextActiveWeapon
 * @text WEAPON: Next Weapon Slot
 * @desc Goes to next active weapon slot (making others invalid).
 * If next slot is weaponless, don't label jump.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to change the next active weapon slot for.
 * @default ["user"]
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a weapon is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_SetActiveWeapon
 * @text WEAPON: Set Weapon Slot
 * @desc Sets the active weapon slot (making others invalid).
 * Only works for Actors.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to change the active weapon slot for.
 * @default ["user"]
 * 
 * @arg SlotID:eval
 * @text Weapon Slot ID
 * @desc Select weapon slot to make active (making others invalid).
 * Use 0 to clear and normalize. You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceZoom
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakZoom
 * @text Action Sequences - Zoom
 * @desc Allows you to have control over the screen zoom.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Scale
 * @text ZOOM: Change Scale
 * @desc Changes the zoom scale.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Scale:eval
 * @text Scale
 * @desc The zoom scale to change to.
 * @default 1.0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Reset
 * @text ZOOM: Reset Zoom
 * @desc Reset any zoom settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_WaitForZoom
 * @text ZOOM: Wait For Zoom
 * @desc Waits for zoom to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceEnd
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleCore
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param AutoBattle:struct
 * @text Auto Battle Settings
 * @type struct<AutoBattle>
 * @desc Settings pertaining to Auto Battle.
 * @default {"BattleDisplay":"","AutoBattleMsg:str":"Press %1 or %2 to stop Auto Battle","AutoBattleOK:str":"OK","AutoBattleCancel:str":"Cancel","AutoBattleBgType:num":"1","AutoBattleRect:func":"\"const width = Graphics.width;\\nconst height = this.calcWindowHeight(1, false);\\nconst x = 0;\\nconst y = (Graphics.height - height) / 2;\\nreturn new Rectangle(x, y, width, height);\"","Options":"","AddOption:eval":"true","AdjustRect:eval":"true","StartName:str":"Auto Battle Start","StyleName:str":"Auto Battle Style","StyleOFF:str":"Attack","StyleON:str":"Skills"}
 *
 * @param Damage:struct
 * @text Damage Settings
 * @type struct<Damage>
 * @desc Settings pertaining to damage calculations.
 * @default {"DamageStyles":"","DefaultDamageStyle:str":"Standard","DamageStyleList:arraystruct":"[\"{\\\"Name:str\\\":\\\"Standard\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"Armor Scaling\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"CT\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\\\\\nvalue = attackStat * 4;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"D4\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nlet stat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n    armor = 0;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n    armor = 0;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"DQ\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Get Primary Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Check for Recovery\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    let value = stat * multiplier * sign;\\\\\\\\n    return isNaN(value) ? 0 : value;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = 0;\\\\\\\\nif (stat < ((2 + armor) / 2)) {\\\\\\\\n    // Plink Damage\\\\\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\\\\\n    value = baseline / 3;\\\\\\\\n} else {\\\\\\\\n    // Normal Damage\\\\\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\\\\\n    value = baseline / 2;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF7\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare base Damage\\\\\\\\nlet baseDamage = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = 6 * (a.mat + level);\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.def + level);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.mdf + level);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Final Damage\\\\\\\\nlet value = baseDamage;\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    value += 22 * power;\\\\\\\\n} else {\\\\\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF8\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Damage\\\\\\\\nlet Value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\\\\\n    value *= power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.mat + power;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\\\\\n    value *= power / 256;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = (power + a.def) * power / 2;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = (power + a.mdf) * power / 2;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF9\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Main Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Base Damage\\\\\\\\nlet baseDamage = power;\\\\\\\\nif (this.isPhysical()) {\\\\\\\\n    baseDamage += stat;\\\\\\\\n}\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    baseDamage -= armor;\\\\\\\\n    baseDamage = Math.max(1, baseDamage);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Bonus Damage\\\\\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\\\\\n\\\\\\\\n// Declare Final Damage\\\\\\\\nlet value = baseDamage * bonusDamage * sign;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF10\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Create Damage Offense Value\\\\\\\\nlet value = power;\\\\\\\\n\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.def + power) / 2);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.mdf + power) / 2);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Damage Defense Value\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\\\\\n    armor = Math.max(armor, 1);\\\\\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\\\\\n} else if (this.isRecover()) {\\\\\\\\n    value *= -1;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MK\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nconst denominator = Math.max(200 + armor, 1);\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.atk / denominator;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.mat / denominator;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.def / 200;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.mdf / 200;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MOBA\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Value\\\\\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\\\\\n\\\\\\\\n// Apply Attacker's Offense Parameter\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value *= a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value *= a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"PKMN\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\"]","Cap":"","EnableDamageCap:eval":"false","DefaultHardCap:num":"9999","EnableSoftCap:eval":"false","DefaultSoftCap:num":"0.80","DefaultSoftScaler:num":"0.1275","Popups":"","PopupDuration:num":"128","NewPopupBottom:eval":"true","PopupPosition:str":"base","PopupOffsetX:num":"0","PopupOffsetY:num":"0","PopupShiftX:num":"8","PopupShiftY:num":"-28","hpDamageFmt:str":"-%1","hpHealingFmt:str":"+%1","mpDamageFmt:str":"-%1 %2","mpHealingFmt:str":"+%1 %2","CriticalColor:eval":"[255, 0, 0, 160]","CriticalDuration:num":"128","Formulas":"","OverallFormulaJS:func":"\"// Declare Constants\\nconst target = arguments[0];\\nconst critical = arguments[1];\\nconst item = this.item();\\n\\n// Get Base Damage\\nconst baseValue = this.evalDamageFormula(target);\\n\\n// Calculate Element Modifiers\\nlet value = baseValue * this.calcElementRate(target);\\n\\n// Calculate Physical and Magical Modifiers\\nif (this.isPhysical()) {\\n    value *= target.pdr;\\n}\\nif (this.isMagical()) {\\n    value *= target.mdr;\\n}\\n\\n// Apply Healing Modifiers\\nif (baseValue < 0) {\\n    value *= target.rec;\\n}\\n\\n// Apply Critical Modifiers\\nif (critical) {\\n    value = this.applyCritical(value);\\n}\\n\\n// Apply Variance and Guard Modifiers\\nvalue = this.applyVariance(value, item.damage.variance);\\nvalue = this.applyGuard(value, target);\\n\\n// Finalize Damage\\nvalue = Math.round(value);\\nreturn value;\"","VarianceFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst variance = arguments[1];\\n\\n// Calculate Variance\\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\\n\\n// Return Damage\\nreturn damage >= 0 ? damage + v : damage - v;\"","GuardFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst target = arguments[1];\\n\\n// Return Damage Early\\nconst note = this.item().note;\\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\\nif (!target.isGuard()) return damage;\\nif (damage < 0) return damage;\\n\\n// Declare Guard Rate\\nlet guardRate = 0.5;\\nguardRate /= target.grd;\\n\\n// Return Damage\\nreturn damage * guardRate;\"","Critical":"","CriticalHitRateJS:func":"\"// Declare Constants\\nconst user = this.subject();\\nconst target = arguments[0];\\n\\n// Create Base Critical Rate\\nlet rate = this.subject().cri * (1 - target.cev);\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<ALWAYS CRITICAL>/i)) {\\n    return 1;\\n}\\nif (note.match(/<SET CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    return Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    rate *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    rate += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL RATE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL RATE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Apply LUK Buffs/Debuffs\\nconst lukStack = this.subject().buff(7);\\nrate *= 2 ** lukStack;\\n\\n// Return Rate\\nreturn rate;\"","CriticalHitMultiplier:func":"\"// Declare Constants\\nconst user = this.subject();\\nlet damage = arguments[0];\\nlet multiplier = 2.0;\\nlet bonusDamage = this.subject().luk * this.subject().cri;\\nif (this.isHpRecover() || this.isMpRecover()) {\\n    bonusDamage *= -1;\\n}\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\\\d+)([%％])>/i)) {\\n    multiplier = Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    multiplier += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\\\d+)([%％])>/i)) {\\n    bonusDamage *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL DAMAGE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL DAMAGE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Return Damage\\nreturn damage * multiplier + bonusDamage;\""}
 *
 * @param Mechanics:struct
 * @text Mechanics Settings
 * @type struct<Mechanics>
 * @desc Settings pertaining to various game mechanics.
 * @default {"ActionSpeed":"","AllowRandomSpeed:eval":"false","CalcActionSpeedJS:func":"\"// Declare Constants\\nconst agi = this.subject().agi;\\n\\n// Create Speed\\nlet speed = agi;\\nif (this.allowRandomSpeed()) {\\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\\n}\\nif (this.item()) {\\n    speed += this.item().speed;\\n}\\nif (this.isAttack()) {\\n    speed += this.subject().attackSpeed();\\n}\\n\\n// Return Speed\\nreturn speed;\"","BaseTroop":"","BaseTroopIDs:arraynum":"[\"1\"]","CommonEvents":"","BattleStartEvent:num":"0","BattleEndEvent:num":"0","VictoryEvent:num":"0","DefeatEvent:num":"0","EscapeSuccessEvent:num":"0","EscapeFailEvent:num":"0","Escape":"","CalcEscapeRatioJS:func":"\"// Calculate Escape Ratio\\nlet ratio = 0.5;\\nratio *= $gameParty.agility();\\nratio /= $gameTroop.agility();\\n\\n// Return Ratio\\nreturn ratio;\"","CalcEscapeRaiseJS:func":"\"// Calculate Escape Ratio\\nlet value = 0.1;\\nvalue += $gameParty.aliveMembers().length;\\n\\n// Return Value\\nreturn value;\"","BattleJS":"","PreStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleVictoryJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeSuccessJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeFailureJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleDefeatJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","TurnJS":"","PreStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","ActionJS":"","PreStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PreApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\""}
 *
 * @param CmdWindows
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleLayout:struct
 * @text Battle Layout Settings
 * @type struct<BattleLayout>
 * @desc Settings that adjust how the battle layout appears.
 * @default {"Style:str":"default","ListStyle":"","ShowFacesListStyle:eval":"true","CommandWidth:num":"192","XPStyle":"","XPActorCommandLines:num":"4","XPActorDefaultHeight:num":"64","XPSpriteYLocation:str":"name","PotraitStyle":"","ShowPortraits:eval":"true","PortraitScale:num":"0.5","BorderStyle":"","SkillItemBorderCols:num":"1","ShowPortraitsBorderStyle:eval":"true","PortraitScaleBorderStyle:num":"1.25","SkillItemWindows":"","SkillItemMiddleLayout:eval":"false","SkillItemStandardCols:num":"2"}
 *
 * @param BattleLog:struct
 * @text Battle Log Settings
 * @type struct<BattleLog>
 * @desc Settings that adjust how Window_BattleLog behaves.
 * @default {"General":"","BackColor:str":"#000000","MaxLines:num":"10","MessageWait:num":"16","TextAlign:str":"center","BattleLogRectJS:func":"\"const wx = 0;\\nconst wy = 0;\\nconst ww = Graphics.boxWidth;\\nconst wh = this.calcWindowHeight(10, false);\\nreturn new Rectangle(wx, wy, ww, wh);\"","StartTurn":"","StartTurnShow:eval":"true","StartTurnMsg:str":"Turn %1","StartTurnWait:num":"40","DisplayAction":"","ActionCenteredName:eval":"true","ActionSkillMsg1:eval":"false","ActionSkillMsg2:eval":"true","ActionItemMsg:eval":"false","ActionChanges":"","ShowCounter:eval":"true","ShowReflect:eval":"true","ShowSubstitute:eval":"true","ActionResults":"","ShowFailure:eval":"false","ShowCritical:eval":"false","ShowMissEvasion:eval":"false","ShowHpDmg:eval":"false","ShowMpDmg:eval":"false","ShowTpDmg:eval":"false","DisplayStates":"","ShowAddedState:eval":"false","ShowRemovedState:eval":"false","ShowCurrentState:eval":"false","ShowAddedBuff:eval":"false","ShowAddedDebuff:eval":"false","ShowRemovedBuff:eval":"false"}
 *
 * @param BattlebackScale:struct
 * @text Battleback Scaling
 * @type struct<Battleback>
 * @desc Settings that adjust how battlebacks scale.
 * @default {"DefaultStyle:str":"MZ","jsOneForOne:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst scale = 1.0;\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = 0;\\nthis.y = 0;\"","jsScaleToFit:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = this.width / this.bitmap.width;\\nconst ratioY = this.height / this.bitmap.height;\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScaleDown:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScale Up:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\""}
 *
 * @param PartyCmd:struct
 * @text Party Command Window
 * @type struct<PartyCmd>
 * @desc Settings that alter the Party Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconFight:num":"76","CommandAddAutoBattle:eval":"true","CmdIconAutoBattle:num":"78","CmdTextAutoBattle:str":"Auto","CommandAddOptions:eval":"true","CmdIconOptions:num":"83","ActiveTpbOptionsMessage:str":"Options Menu queued after action is complete.","CmdIconEscape:num":"82","Access":"","SkipPartyCmd:eval":"true","DisablePartyCmd:eval":"false","HelpWindow":"","HelpFight:str":"Select actions to fight.","HelpAutoBattle:str":"Sets party to Auto Battle mode.","HelpOptions:str":"Opens up the Options Menu.","HelpEscape:str":"Attempt to escape the battle."}
 *
 * @param ActorCmd:struct
 * @text Actor Command Window
 * @type struct<ActorCmd>
 * @desc Settings that alter the Actor Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconItem:num":"176","IconStypeNorm:num":"78","IconStypeMagic:num":"79","BattleCmd":"","BattleCmdList:arraystr":"[\"attack\",\"skills\",\"guard\",\"item\",\"escape\"]","ShowCosts:eval":"true","HelpWindow":"","HelpSkillType:str":"Opens up a list of skills under the \\C[16]%1\\C[0] category.","HelpItem:str":"Opens up a list of items that you can use.","HelpEscape:str":"Attempt to escape the battle.","HelpAutoBattle:str":"Automatically choose an action suitable for combat.","HelpParty:str":"Automatically choose an action suitable for combat."}
 *
 * @param InBattleStatus:struct
 * @text In-Battle Status Window
 * @type struct<InBattleStatus>
 * @desc Settings that alter the In-Battle Status window accessed
 * through the "Status" command.
 * @default {"General":"","CmdIconStatus:num":"87","StatusGraphic:str":"face","HelpStatus:str":"View battle member status.","Enemy":"","enemyStatus:eval":"true","enemyShowLevel:eval":"true","enemyHiddenParameter:str":"???","enemyShowParametersAlways:eval":"false","enemyShowParametersIfBattleTest:eval":"true","enemyShowParametersIfDefeated:eval":"true","PageButtons":"","pageOffsetX:num":"+0","pageOffsetY:num":"+0","pageButtons:eval":"true","Parameters":"","buffValueFmt:str":"▲%1","debuffValueFmt:str":"▼%1","States":"","statesMaxWidth:num":"384","drawStates:eval":"true","drawBuffs:eval":"true","drawDebuffs:eval":"true","BuffsDebuffs":"","buffNameFmt:str":"%1▲","debuffNameFmt:str":"%1▼","NormalState":"","normalIcon:num":"84","normalText:str":"Normal","HelpDesc":"","stateHelpFmt:json":"\"%1 %2\"","buffHelpFmt:json":"\"Increases %1 to %3%2\\\\C[0]. %4\"","debuffHelpFmt:json":"\"Decreases %1 to %3%2\\\\C[0]. %4\"","normalHelp:json":"\"Status is currently normal.\"","TurnHelpDesc":"","actionsFmt:str":"\\C[6](Actions %2%1\\C[6])\\C[0]","TurnsFmt:str":"\\C[5](Turns %2%1\\C[5])\\C[0]","passiveText:str":"\\C[4](Passive)\\C[0]","Window":"","StatusWindow_BgType:num":"0","StatusWindow_DrawJS:func":"\"{ // Draw Face and Simple Status\\n    const x = this.colSpacing() / 2;\\n    const h = ImageManager.faceHeight;\\n    const y = h / 2 - this.lineHeight() * 1.5;\\n    this.drawActorGraphic(this._battler, x + 1, 0, ImageManager.faceWidth, h);\\n    this.drawActorSimpleStatus(this._battler, x + 180, y);\\n}\\n{ // Draw Actor Parameters\\n    let maxWidth = this.drawingAreaWidth();\\n    let x1 = 0;\\n    let x2 = Math.ceil(this.drawingAreaWidth() / 2);\\n\\n    let counter = 0;\\n    const params = this.displayedParams();\\n\\n    let px = x1;\\n    const availableHeight = this.innerHeight - ImageManager.faceHeight;\\n    const paramHeight = Math.ceil(params.length / 2) * this.lineHeight();\\n    let py = Math.ceil((availableHeight - paramHeight) / 2) + ImageManager.faceHeight;\\n    let pw = Math.floor(maxWidth / 2);\\n\\n    if (this._statesWindow.y !== 0) {\\n        this._statesWindow.y = py;\\n    }\\n\\n    for (const param of params) {\\n        this.drawDarkRect(px, py, pw, this.lineHeight());\\n        this.drawParamData(param, px, py, pw);\\n        counter++;\\n        if (counter % 2 === 0) {\\n            px = x1;\\n            py += this.lineHeight();\\n        } else {\\n            px = x2;\\n        }\\n    }\\n}\"","StatusWindow_RectJS:func":"\"const wx = Graphics.boxWidth > 1000 ? 120 : 0;\\nconst wy = this._helpWindow.y + this._helpWindow.height;\\nconst ww = Graphics.boxWidth - (wx * 2);\\nconst wh = Graphics.boxHeight - wy - this.windowAreaHeight();\\nreturn new Rectangle(wx, wy, ww, wh);\""}
 * 
 * @param MultiTarget:struct
 * @text Multi-Target Windows
 * @type struct<MultiTarget>
 * @desc Settings that alter the Multi-Target Windows in battle.
 * @default {"Properties":"","WindowWidth:num":"280","BgType:num":"2","ShowButton:eval":"true","Vocab":"","AllActorsText:str":"All Allies","AllEnemiesText:str":"All Enemies","Offsets":"","ActorOffsets":"","ActorOffsetX:num":"+0","ActorOffsetY:num":"+0","EnemyOffsets":"","EnemyOffsetX:num":"+0","EnemyOffsetY:num":"+0"}
 * 
 * @param ComboWindow:struct
 * @text Damage Combo Window
 * @type struct<ComboWindow>
 * @desc Settings that alter the damage/healing combo window displayed in battle.
 * @default {"General":"","Enable:eval":"true","Appearance":"","CustomFontFace:str":"Arial","TextAlign:str":"left","ComboWindow_DrawJS:func":"\"// Declare Coordinates\\nlet x = 0;\\nlet y = 0;\\n\\n// Hit Text\\nconst hitText = this.hitText();\\nconst hitTextSize = this.textSizeEx(hitText);\\nif (this.textAlignment() === 'right') {\\n    x = this.innerWidth - this.itemPadding() - hitTextSize.width;\\n} else if (this.textAlignment() === 'center') {\\n    x = Math.floor((this.innerWidth - hitTextSize.width) / 2);\\n} else {\\n    x = this.itemPadding();\\n}\\nthis.drawTextEx(hitText, x, y);\\n\\n// New Line\\ny += Math.ceil(this.lineHeight() * 2/3);\\n\\n// Damage Text\\nconst dmgText = this.damageText();\\nconst dmgTextSize = this.textSizeEx(dmgText);\\nif (this.textAlignment() === 'right') {\\n    x = this.innerWidth - this.itemPadding() - dmgTextSize.width;\\n} else if (this.textAlignment() === 'center') {\\n    x = Math.floor((this.innerWidth - dmgTextSize.width) / 2);\\n} else {\\n    x = this.itemPadding();\\n}\\nthis.drawTextEx(dmgText, x, y);\"","Vocab":"","hitsDmgFmt:str":"\\C[6]%1\\} \\C[4]Hit Combo\\C[0]\\{","hitsHealFmt:str":"\\C[6]%1\\} \\C[4]Heal Combo\\C[0]\\{","totalDmgFmt:str":"\\}\\C[21]Total Damage: \\{\\C[0]%1","totalHealFmt:str":"\\}\\C[21]Total Healing: \\{\\C[24]+%1\\C[0]","Position":"","fadeShiftX:num":"-2","fadeShiftY:num":"+0","PosOffsetX:num":"+0","PosOffsetY:num":"+0","ComboWindow_RectJS:func":"\"const ww = Math.ceil(Graphics.width / 4);\\nconst wh = this.calcWindowHeight(2, true);\\nconst wx = 0 + this.comboWindowOffsetX();\\nconst wy = Math.round(Graphics.boxHeight * 1 / 3) + this.comboWindowOffsetY();\\nreturn new Rectangle(wx, wy, ww, wh);\"","Update":"","updateDuration:num":"20","minimumStayDuration:num":"40","minimumHits:num":"1","opacitySpeed:num":"16"}
 *
 * @param VisualBreak
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Actor:struct
 * @text Actor Battler Settings
 * @type struct<Actor>
 * @desc Settings that alter various properties for actors.
 * @default {"Flinch":"","FlinchDistanceX:num":"12","FlinchDistanceY:num":"0","FlinchDuration:num":"6","SvBattlers":"","AnchorX:num":"0.5","AnchorY:num":"1.0","ChantStyle:eval":"true","OffsetX:num":"0","OffsetY:num":"0","MotionSpeed:num":"12","PrioritySortActive:eval":"true","PrioritySortActors:eval":"false","Shadow:eval":"true","SmoothImage:eval":"true","HomePosJS:func":"\"// Declare Constants\\nconst sprite = this;\\nconst actor = this._actor;\\nconst index = arguments[0];\\n\\n// Make Calculations\\nlet x = Math.round((Graphics.width / 2) + 192)\\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\\nx += index * 32;\\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\\ny += index * 48;\\n\\n// Home Position Offsets\\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\\\+\\\\-]\\\\d+),[ ]([\\\\+\\\\-]\\\\d+)>/i;\\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\\nx = xOffsets.reduce((r, offset) => r + offset, x);\\ny = yOffsets.reduce((r, offset) => r + offset, y);\\n\\n// Set Home Position\\nthis.setHome(x, y);\""}
 *
 * @param Enemy:struct
 * @text Enemy Battler Settings
 * @type struct<Enemy>
 * @desc Settings that alter various properties for enemies.
 * @default {"Visual":"","AttackAnimation:num":"1","EmergeText:eval":"false","OffsetX:num":"0","OffsetY:num":"0","SmoothImage:eval":"true","SelectWindow":"","FrontViewSelect:eval":"false","SideviewSelect:eval":"true","NameFontSize:num":"22","SvBattlers":"","AllowCollapse:eval":"false","AnchorX:num":"0.5","AnchorY:num":"1.0","MotionIdle:str":"walk","Shadow:eval":"true","Width:num":"64","Height:num":"64","WtypeId:num":"0"}
 *
 * @param HpGauge:struct
 * @text HP Gauge Settings
 * @type struct<HpGauge>
 * @desc Settings that adjust the visual HP Gauge displayed in battle.
 * @default {"Display":"","ShowActorGauge:eval":"false","ShowEnemyGauge:eval":"true","RequiresDefeat:eval":"false","BTestBypass:eval":"true","Settings":"","AnchorX:num":"0.5","AnchorY:num":"1.0","Scale:num":"0.5","OffsetX:num":"0","OffsetY:num":"-3","Options":"","AddHpGaugeOption:eval":"true","AdjustRect:eval":"true","Name:str":"Show HP Gauge"}
 *
 * @param ActionSequence:struct
 * @text Action Sequence Settings
 * @type struct<ActionSequence>
 * @desc Settings that adjust how certain Action Sequences work.
 * @default {"AutoSequences":"","AutoMeleeSolo:eval":"true","AutoMeleeAoE:eval":"true","CastAnimations":"","CastCertain:num":"120","CastPhysical:num":"52","CastMagical:num":"51","CounterReflection":"","CounterPlayback:eval":"true","ReflectAnimation:num":"53","ReflectPlayback:eval":"true","Stepping":"","MeleeDistance:num":"24","StepDistanceX:num":"48","StepDistanceY:num":"0","StepDuration:num":"12"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Auto Battle Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~AutoBattle:
 *
 * @param BattleDisplay
 * @text Battle Display
 *
 * @param AutoBattleMsg:str
 * @text Message
 * @parent BattleDisplay
 * @desc Message that's displayed when Auto Battle is on.
 * Text codes allowed. %1 - OK button, %2 - Cancel button
 * @default Press %1 or %2 to stop Auto Battle
 *
 * @param AutoBattleOK:str
 * @text OK Button
 * @parent BattleDisplay
 * @desc Text used to represent the OK button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default OK
 *
 * @param AutoBattleCancel:str
 * @text Cancel Button
 * @parent BattleDisplay
 * @desc Text used to represent the Cancel button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default Cancel
 *
 * @param AutoBattleBgType:num
 * @text Background Type
 * @parent BattleDisplay
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for Auto Battle window.
 * @default 1
 *
 * @param AutoBattleRect:func
 * @text JS: X, Y, W, H
 * @parent BattleDisplay
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = Graphics.width;\nconst height = this.calcWindowHeight(1, false);\nconst x = 0;\nconst y = (Graphics.height - height) / 2;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param Options
 *
 * @param AddOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the Auto Battle options to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param StartName:str
 * @text Startup Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Start
 *
 * @param StyleName:str
 * @text Style Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Style
 *
 * @param StyleOFF:str
 * @text OFF
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is OFF.
 * @default Attack
 *
 * @param StyleON:str
 * @text ON
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is ON.
 * @default Skills
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Damage:
 *
 * @param DamageStyles
 * @text Damage Styles
 *
 * @param DefaultDamageStyle:str
 * @text Default Style
 * @parent DamageStyles
 * @desc Which Damage Style do you want to set as default?
 * Use 'Manual' to not use any styles at all.
 * @default Standard
 *
 * @param DamageStyleList:arraystruct
 * @text Style List
 * @parent DamageStyles
 * @type struct<DamageStyle>[]
 * @desc A list of the damage styles available.
 * These are used to calculate base damage.
 * @default ["{\"Name:str\":\"Standard\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"Armor Scaling\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"CT\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\nvalue = attackStat * 4;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"D4\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nlet stat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n    armor = 0;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n    armor = 0;\\\\n}\\\\n\\\\n// Calculate Damage \\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"DQ\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\n}\\\\n\\\\n// Get Primary Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Check for Recovery\\\\nif (this.isRecover()) {\\\\n    let value = stat * multiplier * sign;\\\\n    return isNaN(value) ? 0 : value;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = 0;\\\\nif (stat < ((2 + armor) / 2)) {\\\\n    // Plink Damage\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\n    value = baseline / 3;\\\\n} else {\\\\n    // Normal Damage\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\n    value = baseline / 2;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF7\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare base Damage\\\\nlet baseDamage = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = 6 * (a.mat + level);\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.def + level);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.mdf + level);\\\\n}\\\\n\\\\n// Calculate Final Damage\\\\nlet value = baseDamage;\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isRecover()) {\\\\n    value += 22 * power;\\\\n} else {\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF8\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Damage\\\\nlet Value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\n    value *= power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.mat + power;\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\n    value *= power / 256;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = (power + a.def) * power / 2;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = (power + a.mdf) * power / 2;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF9\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Declare Main Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Declare Base Damage\\\\nlet baseDamage = power;\\\\nif (this.isPhysical()) {\\\\n    baseDamage += stat;\\\\n}\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    baseDamage -= armor;\\\\n    baseDamage = Math.max(1, baseDamage);\\\\n}\\\\n\\\\n// Declare Bonus Damage\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\n\\\\n// Declare Final Damage\\\\nlet value = baseDamage * bonusDamage * sign;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF10\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Create Damage Offense Value\\\\nlet value = power;\\\\n\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = power * ((a.def + power) / 2);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = power * ((a.mdf + power) / 2);\\\\n}\\\\n\\\\n// Apply Damage Defense Value\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\n    armor = Math.max(armor, 1);\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\n} else if (this.isRecover()) {\\\\n    value *= -1;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MK\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nconst denominator = Math.max(200 + armor, 1);\\\\n\\\\n// Calculate Damage \\\\nlet value = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.atk / denominator;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.mat / denominator;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = 200 * a.def / 200;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = 200 * a.mdf / 200;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MOBA\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Value\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\n\\\\n// Apply Attacker's Offense Parameter\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value *= a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value *= a.mdf;\\\\n}\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"PKMN\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}"]
 *
 * @param Cap
 * @text Damage Cap
 *
 * @param EnableDamageCap:eval
 * @text Enable Damage Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Put a maximum hard damage cap on how far damage can go?
 * This can be broken through the usage of notetags.
 * @default false
 *
 * @param DefaultHardCap:num
 * @text Default Hard Cap
 * @parent EnableDamageCap:eval
 * @type number
 * @min 1
 * @desc The default hard damage cap used before applying damage.
 * @default 9999
 *
 * @param EnableSoftCap:eval
 * @text Enable Soft Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Soft caps ease in the damage values leading up to the 
 * hard damage cap. Requires hard Damage Cap enabled.
 * @default false
 *
 * @param DefaultSoftCap:num
 * @text Base Soft Cap Rate
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.80
 *
 * @param DefaultSoftScaler:num
 * @text Soft Scale Constant
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.1275
 *
 * @param Popups
 *
 * @param PopupDuration:num
 * @text Popup Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a popup stays visible.
 * @default 128
 *
 * @param NewPopupBottom:eval
 * @text Newest Popups Bottom
 * @parent Popups
 * @type boolean
 * @on Bottom
 * @off Top
 * @desc Puts the newest popups at the bottom.
 * @default true
 *
 * @param PopupPosition:str
 * @text Appear Position
 * @parent Popups
 * @type select
 * @option Head - At the top of the battler.
 * @value head
 * @option Center - At the center of the battler.
 * @value center
 * @option Base - At the foot of the battler.
 * @value base
 * @desc Selects where you want popups to appear relative to the battler.
 * @default base
 *
 * @param EndBattlePopups:eval
 * @text End Battle Show?
 * @parent Popups
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide popups upon victory or escape?
 * Used to hide battle-state removal popups.
 * @default true
 *
 * @param PopupOffsetX:num
 * @text Offset X
 * @parent Popups
 * @desc Sets how much to offset the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param PopupOffsetY:num
 * @text Offset Y
 * @parent Popups
 * @desc Sets how much to offset the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param PopupShiftX:num
 * @text Shift X
 * @parent Popups
 * @desc Sets how much to shift the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 8
 *
 * @param PopupShiftY:num
 * @text Shift Y
 * @parent Popups
 * @desc Sets how much to shift the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default -28
 *
 * @param hpDamageFmt:str
 * @text HP Damage Format
 * @parent Popups
 * @desc Determines HP damage format for popup.
 * %1 - Value, %2 - HP Text
 * @default -%1
 *
 * @param hpHealingFmt:str
 * @text HP Healing Format
 * @parent Popups
 * @desc Determines HP healing format for popup.
 * %1 - Value, %2 - HP Text
 * @default +%1
 *
 * @param mpDamageFmt:str
 * @text MP Damage Format
 * @parent Popups
 * @desc Determines MP damage format for popup.
 * %1 - Value, %2 - MP Text
 * @default -%1 %2
 *
 * @param mpHealingFmt:str
 * @text MP Healing Format
 * @parent Popups
 * @desc Determines MP healing format for popup.
 * %1 - Value, %2 - MP Text
 * @default +%1 %2
 *
 * @param CriticalColor:eval
 * @text Critical Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 *
 * @param CriticalDuration:num
 * @text Critical Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a the flash lasts.
 * @default 128
 *
 * @param Formulas
 *
 * @param OverallFormulaJS:func
 * @text JS: Overall Formula
 * @parent Formulas
 * @type note
 * @desc The overall formula used when calculating damage.
 * @default "// Declare Constants\nconst target = arguments[0];\nconst critical = arguments[1];\nconst item = this.item();\n\n// Get Base Damage\nconst baseValue = this.evalDamageFormula(target);\n\n// Calculate Element Modifiers\nlet value = baseValue * this.calcElementRate(target);\n\n// Calculate Physical and Magical Modifiers\nif (this.isPhysical()) {\n    value *= target.pdr;\n}\nif (this.isMagical()) {\n    value *= target.mdr;\n}\n\n// Apply Healing Modifiers\nif (baseValue < 0) {\n    value *= target.rec;\n}\n\n// Apply Critical Modifiers\nif (critical) {\n    value = this.applyCritical(value);\n}\n\n// Apply Variance and Guard Modifiers\nvalue = this.applyVariance(value, item.damage.variance);\nvalue = this.applyGuard(value, target);\n\n// Finalize Damage\nvalue = Math.round(value);\nreturn value;"
 *
 * @param VarianceFormulaJS:func
 * @text JS: Variance Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage variance.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst variance = arguments[1];\n\n// Calculate Variance\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\n\n// Return Damage\nreturn damage >= 0 ? damage + v : damage - v;"
 *
 * @param GuardFormulaJS:func
 * @text JS: Guard Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage is guarded.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst target = arguments[1];\n\n// Return Damage Early\nconst note = this.item().note;\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\nif (!target.isGuard()) return damage;\nif (damage < 0) return damage;\n\n// Declare Guard Rate\nlet guardRate = 0.5;\nguardRate /= target.grd;\n\n// Return Damage\nreturn damage * guardRate;"
 *
 * @param Critical
 * @text Critical Hits
 *
 * @param CriticalHitRateJS:func
 * @text JS: Rate Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Rates.
 * @default "// Declare Constants\nconst user = this.subject();\nconst target = arguments[0];\n\n// Create Base Critical Rate\nlet rate = this.subject().cri * (1 - target.cev);\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<ALWAYS CRITICAL>/i)) {\n    return 1;\n}\nif (note.match(/<SET CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    return Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    rate *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    rate += Number(RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL RATE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL RATE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Apply LUK Buffs/Debuffs\nconst lukStack = this.subject().buff(7);\nrate *= 2 ** lukStack;\n\n// Return Rate\nreturn rate;"
 *
 * @param CriticalHitMultiplier:func
 * @text JS: Damage Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Damage modification.
 * @default "// Declare Constants\nconst user = this.subject();\nlet damage = arguments[0];\nlet multiplier = 2.0;\nlet bonusDamage = this.subject().luk * this.subject().cri;\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\d+)([%％])>/i)) {\n    multiplier = Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    multiplier += Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\d+)([%％])>/i)) {\n    bonusDamage *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL DAMAGE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL DAMAGE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Return Damage\nreturn damage * multiplier + bonusDamage;"
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Formula Style
 * ----------------------------------------------------------------------------
 */
/*~struct~DamageStyle:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Damage Style.
 * Used for notetags and such.
 * @default Untitled
 *
 * @param Formula:func
 * @text JS: Formula
 * @parent Name:str
 * @type note
 * @desc The base formula for this Damage Style.
 * @default "// Define Constants\nconst item = this.item();\nconst a = this.subject();\nconst b = target;\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\n\n// Create Damage Value\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\n\n// Return Value\nreturn isNaN(value) ? 0 : value;"
 *
 * @param ItemsEquipsCore
 * @text Items & Equips Core
 *
 * @param DamageType
 * @text Damage Label
 * @parent ItemsEquipsCore
 *
 * @param DamageType1:str
 * @text HP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType2:str
 * @text MP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType3:str
 * @text HP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType4:str
 * @text MP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType5:str
 * @text HP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageType6:str
 * @text MP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageDisplay:func
 * @text JS: Damage Display
 * @parent ItemsEquipsCore
 * @type note
 * @desc Code used the data displayed for this category.
 * @default "// Define Constants\nconst item = this._item;\nconst formula = item.damage.formula;\nconst a = this._tempActorA;\nconst b = this._tempActorB;\nconst user = a;\nconst target = b;\n\n// Return Value\ntry {\n    const value = Math.max(eval(formula), 0);\n    return '%1%'.format(Math.round(value * 100));\n} catch (e) {\n    if ($gameTemp.isPlaytest()) {\n        console.log('Damage Formula Error for %1'.format(this._item.name));\n    }\n    return '?????';\n}"
 *
 */
/* ----------------------------------------------------------------------------
 * Mechanics Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Mechanics:
 *
 * @param ActionSpeed
 * @text Action Speed
 *
 * @param AllowRandomSpeed:eval
 * @text Allow Random Speed?
 * @parent ActionSpeed
 * @type boolean
 * @on Allow
 * @off Disable
 * @desc Allow speed to be randomized base off the user's AGI?
 * @default false
 *
 * @param SyncBuffExpire:eval
 * @text Turn End Buffs Expire
 * @parent ActionSpeed
 * @type boolean
 * @on Expire
 * @off Don't Expire
 * @desc Normally, buffs expire after all actions end.
 * But here, you can have buffs expire on turn end.
 * @default false
 *
 * @param CalcActionSpeedJS:func
 * @text JS: Calculate
 * @parent ActionSpeed
 * @type note
 * @desc Code used to calculate action speed.
 * @default "// Declare Constants\nconst agi = this.subject().agi;\n\n// Create Speed\nlet speed = agi;\nif (this.allowRandomSpeed()) {\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\n}\nif (this.item()) {\n    speed += this.item().speed;\n}\nif (this.isAttack()) {\n    speed += this.subject().attackSpeed();\n}\n\n// Return Speed\nreturn speed;"
 *
 * @param BaseTroop
 * @text Base Troop
 *
 * @param BaseTroopIDs:arraynum
 * @text Base Troop ID's
 * @parent BaseTroop
 * @type troop[]
 * @desc Select the Troop ID(s) to duplicate page events from for all other troops.
 * @default ["1"]
 *
 * @param CommonEvents
 * @text Common Events (on Map)
 *
 * @param BattleStartEvent:num
 * @text Pre-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Common Event to run before each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param BattleEndEvent:num
 * @text Post-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run after each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param VictoryEvent:num
 * @text Victory Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon victory on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param DefeatEvent:num
 * @text Defeat Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon defeat on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeSuccessEvent:num
 * @text Escape Success Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape success on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeFailEvent:num
 * @text Escape Fail Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape failure on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param Escape
 *
 * @param CalcEscapeRatioJS:func
 * @text JS: Calc Escape Ratio
 * @parent Escape
 * @type note
 * @desc Code used to calculate the escape success ratio.
 * @default "// Calculate Escape Ratio\nlet ratio = 0.5;\nratio *= $gameParty.agility();\nratio /= $gameTroop.agility();\n\n// Return Ratio\nreturn ratio;"
 *
 * @param CalcEscapeRaiseJS:func
 * @text JS: Calc Escape Raise
 * @parent Escape
 * @type note
 * @desc Code used to calculate how much the escape success ratio raises upon each failure.
 * @default "// Calculate Escape Ratio\nlet value = 0.1;\nvalue += $gameParty.aliveMembers().length;\n\n// Return Value\nreturn value;"
 *
 * @param Switches
 *
 * @param SwitchCritical:num
 * @text Switch: Critical
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action performs a critical hit.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param SwitchMissEvade:num
 * @text Switch: Miss/Evade
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action misses/is evaded.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param Variables
 *
 * @param VariableDmg:num
 * @text Variable: Damage
 * @parent Variables
 * @type variable
 * @desc Variable records target damage during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param VariableHeal:num
 * @text Variable: Healing
 * @parent Variables
 * @type variable
 * @desc Variable records target healing during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param BattleJS
 * @text JS: Battle-Related
 * 
 * @param PreStartBattleJS:func
 * @text JS: Pre-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartBattleJS:func
 * @text JS: Post-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleVictoryJS:func
 * @text JS: Battle Victory
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processVictory()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeSuccessJS:func
 * @text JS: Escape Success
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeSuccess()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeFailureJS:func
 * @text JS: Escape Failure
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeFailure()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleDefeatJS:func
 * @text JS: Battle Defeat
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processDefeat()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param PreEndBattleJS:func
 * @text JS: Pre-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndBattleJS:func
 * @text JS: Post-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param TurnJS
 * @text JS: Turn-Related
 *
 * @param PreStartTurnJS:func
 * @text JS: Pre-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartTurnJS:func
 * @text JS: Post-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreEndTurnJS:func
 * @text JS: Pre-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndTurnJS:func
 * @text JS: Post-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreRegenerateJS:func
 * @text JS: Pre-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostRegenerateJS:func
 * @text JS: Post-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param ActionJS
 * @text JS: Action-Related
 *
 * @param PreStartActionJS:func
 * @text JS: Pre-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostStartActionJS:func
 * @text JS: Post-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PreApplyJS:func
 * @text JS: Pre-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreDamageJS:func
 * @text JS: Pre-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostDamageJS:func
 * @text JS: Post-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostApplyJS:func
 * @text JS: Post-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreEndActionJS:func
 * @text JS: Pre-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostEndActionJS:func
 * @text JS: Post-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Layout Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLayout:
 *
 * @param Style:str
 * @text Battle Layout Style
 * @type select
 * @option Default - Shows actor faces in Battle Status.
 * @value default
 * @option List - Lists actors in Battle Status.
 * @value list
 * @option XP - Shows actor battlers in a stretched Battle Status.
 * @value xp
 * @option Portrait - Shows portraits in a stretched Battle Status.
 * @value portrait
 * @option Border - Displays windows around the screen border.
 * @value border
 * @option Frontview Battle UI - Requires VisuMZ_3_FrontviewBattleUI
 * @value frontview_ui
 * @option Sideview Battle UI - Requires VisuMZ_3_SideviewBattleUI
 * @value sideview_ui
 * @desc The style used for the battle layout.
 * @default default
 *
 * @param ListStyle
 * @text List Style
 * @parent Style:str
 *
 * @param ShowFacesListStyle:eval
 * @text Show Faces
 * @parent ListStyle
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows faces in List Style?
 * @default true
 *
 * @param CommandWidth:num
 * @text Command Window Width
 * @parent ListStyle
 * @type number
 * @min 1
 * @desc Determine the window width for the Party and Actor Command
 * Windows. Affects Default and List Battle Layout styles.
 * @default 192
 *
 * @param XPStyle
 * @text XP Style
 * @parent Style:str
 *
 * @param XPActorCommandLines:num
 * @text Command Lines
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Number of action lines in the Actor Command Window for the XP Style.
 * @default 4
 *
 * @param XPActorDefaultHeight:num
 * @text Sprite Height
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Default sprite height used when if the sprite's height has not been determined yet.
 * @default 64
 *
 * @param XPSpriteYLocation:str
 * @text Sprite Base Location
 * @parent XPStyle
 * @type select
 * @option Above Name - Sprite is located above the name.
 * @value name
 * @option Bottom - Sprite is located at the bottom of the window.
 * @value bottom
 * @option Centered - Sprite is centered in the window.
 * @value center
 * @option Top - Sprite is located at the top of the window.
 * @value top
 * @desc Determine where the sprite is located on the Battle Status Window.
 * @default name
 *
 * @param PotraitStyle
 * @text Portrait Style
 * @parent Style:str
 *
 * @param ShowPortraits:eval
 * @text Show Portraits?
 * @parent PotraitStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait instead of a face.
 * @default true
 *
 * @param PortraitScale:num
 * @text Portrait Scaling
 * @parent PotraitStyle
 * @desc If portraits are used, scale them by this much.
 * @default 0.5
 *
 * @param BorderStyle
 * @text Border Style
 * @parent Style:str
 *
 * @param SkillItemBorderCols:num
 * @text Columns
 * @parent BorderStyle
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 1
 *
 * @param ShowPortraitsBorderStyle:eval
 * @text Show Portraits?
 * @parent BorderStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait at the edge of the screen.
 * @default true
 *
 * @param PortraitScaleBorderStyle:num
 * @text Portrait Scaling
 * @parent BorderStyle
 * @desc If portraits are used, scale them by this much.
 * @default 1.0
 *
 * @param SkillItemWindows
 * @text Skill & Item Windows
 *
 * @param SkillItemMiddleLayout:eval
 * @text Middle Layout
 * @parent SkillItemWindows
 * @type boolean
 * @on Middle
 * @off Bottom
 * @desc Shows the Skill & Item Windows in mid-screen?
 * @default false
 *
 * @param SkillItemStandardCols:num
 * @text Columns
 * @parent SkillItemWindows
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 2
 *
 * @param StatusWindow
 * @text Status Window Elements
 *
 * @param StatusWindowName
 * @text Battler Name
 * @parent StatusWindow
 *
 * @param NameOffsetX:num
 * @text Offset: X
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param NameOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowHpGauge
 * @text Gauge 1 (HP)
 * @parent StatusWindow
 *
 * @param HpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param HpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowMpGauge
 * @text Gauge 2 (MP)
 * @parent StatusWindow
 *
 * @param MpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param MpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpGauge
 * @text Gauge 3 (TP)
 * @parent StatusWindow
 *
 * @param TpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowStateIcon
 * @text State Icon
 * @parent StatusWindow
 *
 * @param StateIconOffsetX:num
 * @text Offset: X
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StateIconOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpbGauge
 * @text TPB/ATB Gauge
 * @parent StatusWindow
 *
 * @param TpbGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpbGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowSkin
 * @text Window Skin
 * @parent StatusWindow
 *
 * @param StatusWindowSkinFilename:str
 * @text Filename
 * @parent StatusWindowSkin
 * @type file
 * @dir img/system/
 * @desc Filename used for the Battle Status Window skin.
 * Leave this empty to use the default window skin.
 * @default 
 *
 * @param StatusWindowSkinHide:eval
 * @text Hide Window Skin?
 * @parent StatusWindowSkin
 * @type boolean
 * @on No Window Skin
 * @off Default Skin
 * @desc Show/Hide the window skin for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowSelectBack
 * @text Selectable Background
 * @parent StatusWindow
 *
 * @param StatusWindowSelectableBackHide:eval
 * @text Hide Selectable BG?
 * @parent StatusWindowSelectBack
 * @type boolean
 * @on No Selectable BG
 * @off Default Selectable BG
 * @desc Show/Hide the selectable background box for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowAttachments
 * @text Attachments
 * @parent StatusWindow
 *
 * @param StatusWindowBackAttachment
 * @text Back Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentBack:str
 * @text Filename
 * @parent StatusWindowBackAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the back of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentBackOffsetX:num
 * @text Offset: X
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentBackOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowFrontAttachment
 * @text Front Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentFront:str
 * @text Filename
 * @parent StatusWindowFrontAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the front of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentFrontOffsetX:num
 * @text Offset: X
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentFrontOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param UiElements
 * @text UI Elements
 *
 * @param AntiTintUiElements:eval
 * @text Anti-Tint UI?
 * @parent UiElements
 * @type boolean
 * @on Prevent Tint
 * @off Allow Tint
 * @desc Prevent UI Elements from being tinted?
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Log Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLog:
 *
 * @param General
 *
 * @param BackColor:str
 * @text Back Color
 * @parent General
 * @desc Use #rrggbb for a hex color.
 * @default #000000
 *
 * @param MaxLines:num
 * @text Max Lines
 * @parent General
 * @type number
 * @min 1
 * @desc Maximum number of lines to be displayed.
 * @default 10
 *
 * @param MessageWait:num
 * @text Message Wait
 * @parent General
 * @type number
 * @min 1
 * @desc Number of frames for a usual message wait.
 * @default 16
 *
 * @param TextAlign:str
 * @text Text Align
 * @parent General
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Window_BattleLog.
 * @default center
 *
 * @param BattleLogRectJS:func
 * @text JS: X, Y, W, H
 * @parent General
 * @type note
 * @desc Code used to determine the dimensions for the battle log.
 * @default "const wx = 0;\nconst wy = 0;\nconst ww = Graphics.boxWidth;\nconst wh = this.calcWindowHeight(10, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param StartTurn
 * @text Start Turn
 *
 * @param StartTurnShow:eval
 * @text Show Start Turn?
 * @parent StartTurn
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display turn changes at the start of the turn?
 * @default false
 *
 * @param StartTurnMsg:str
 * @text Start Turn Message
 * @parent StartTurn
 * @desc Message displayed at turn start.
 * %1 - Turn Count
 * @default Turn %1
 *
 * @param StartTurnWait:num
 * @text Start Turn Wait
 * @parent StartTurn
 * @type number
 * @min 1
 * @desc Number of frames to wait after a turn started.
 * @default 40
 *
 * @param DisplayAction
 * @text Display Action
 *
 * @param ActionCenteredName:eval
 * @text Show Centered Action?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display a centered text of the action name?
 * @default true
 *
 * @param ActionSkillMsg1:eval
 * @text Show Skill Message 1?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 1st skill message?
 * @default false
 *
 * @param ActionSkillMsg2:eval
 * @text Show Skill Message 2?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 2nd skill message?
 * @default true
 *
 * @param ActionItemMsg:eval
 * @text Show Item Message?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the item use message?
 * @default false
 *
 * @param ActionChanges
 * @text Action Changes
 *
 * @param ShowCounter:eval
 * @text Show Counter?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display counter text?
 * @default true
 *
 * @param ShowCounterWait:eval
 * @text Wait Frames
 * @parent ShowCounter:eval
 * @type number
 * @desc How many frames should the battle log wait after text?
 * 60 frames = 1 second.
 * @default 0
 *
 * @param ShowReflect:eval
 * @text Show Reflect?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display magic reflection text?
 * @default true
 *
 * @param ShowReflectWait:eval
 * @text Wait Frames
 * @parent ShowReflect:eval
 * @type number
 * @desc How many frames should the battle log wait after text?
 * 60 frames = 1 second.
 * @default 0
 *
 * @param ShowSubstitute:eval
 * @text Show Substitute?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display substitute text?
 * @default true
 *
 * @param ShowSubstituteWait:eval
 * @text Wait Frames
 * @parent ShowSubstitute:eval
 * @type number
 * @desc How many frames should the battle log wait after text?
 * 60 frames = 1 second.
 * @default 0
 *
 * @param ActionResults
 * @text Action Results
 *
 * @param ShowFailure:eval
 * @text Show No Effect?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display no effect text?
 * @default false
 *
 * @param ShowCritical:eval
 * @text Show Critical?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display critical text?
 * @default false
 *
 * @param ShowMissEvasion:eval
 * @text Show Miss/Evasion?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display miss/evasion text?
 * @default false
 *
 * @param ShowHpDmg:eval
 * @text Show HP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display HP Damage text?
 * @default false
 *
 * @param ShowMpDmg:eval
 * @text Show MP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display MP Damage text?
 * @default false
 *
 * @param ShowTpDmg:eval
 * @text Show TP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display TP Damage text?
 * @default false
 *
 * @param DisplayStates
 * @text Display States
 *
 * @param ShowAddedState:eval
 * @text Show Added States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added states text?
 * @default false
 *
 * @param ShowRemovedState:eval
 * @text Show Removed States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed states text?
 * @default false
 *
 * @param ShowCurrentState:eval
 * @text Show Current States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the currently affected state text?
 * @default false
 *
 * @param ShowAddedBuff:eval
 * @text Show Added Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added buffs text?
 * @default false
 *
 * @param ShowAddedDebuff:eval
 * @text Show Added Debuffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added debuffs text?
 * @default false
 *
 * @param ShowRemovedBuff:eval
 * @text Show Removed Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed de/buffs text?
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * Battleback Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Battleback:
 *
 * @param DefaultStyle:str
 * @text Default Style
 * @type select
 * @option MZ (MZ's default style)
 * @value MZ
 * @option 1:1 (No Scaling)
 * @value 1:1
 * @option Scale To Fit (Scale to screen size)
 * @value ScaleToFit
 * @option Scale Down (Scale Downward if Larger than Screen)
 * @value ScaleDown
 * @option Scale Up (Scale Upward if Smaller than Screen)
 * @value ScaleUp
 * @desc The default scaling style used for battlebacks.
 * @default MZ
 *
 * @param jsOneForOne:func
 * @text JS: 1:1
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst scale = 1.0;\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = 0;\nthis.y = 0;"
 *
 * @param jsScaleToFit:func
 * @text JS: Scale To Fit
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = this.width / this.bitmap.width;\nconst ratioY = this.height / this.bitmap.height;\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleDown:func
 * @text JS: Scale Down
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleUp:func
 * @text JS: Scale Up
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 */
/* ----------------------------------------------------------------------------
 * Party Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~PartyCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Party Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Party Command Window.
 * @default left
 *
 * @param CmdIconFight:num
 * @text Fight Icon
 * @parent Cmd
 * @desc The icon used for the Fight command.
 * @default 76
 *
 * @param CommandAddAutoBattle:eval
 * @text Add Auto Battle?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Auto Battle" command to the Command Window?
 * @default true
 *
 * @param CmdIconAutoBattle:num
 * @text Auto Battle Icon
 * @parent CommandAddAutoBattle:eval
 * @desc The icon used for the Auto Battle command.
 * @default 78
 *
 * @param CmdTextAutoBattle:str
 * @text Auto Battle Text
 * @parent CommandAddAutoBattle:eval
 * @desc The text used for the Auto Battle command.
 * @default Auto
 *
 * @param CommandAddStatus:eval
 * @text Add Status?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Status" command to the Command Window?
 * @default true
 *
 * @param CmdIconStatus:num
 * @text Status Icon
 * @parent CommandAddStatus:eval
 * @desc The icon used for the Status command.
 * @default 87
 *
 * @param CommandAddOptions:eval
 * @text Add Options?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Options" command to the Command Window?
 * @default true
 *
 * @param CmdIconOptions:num
 * @text Options Icon
 * @parent CommandAddOptions:eval
 * @desc The icon used for the Options command.
 * @default 83
 *
 * @param ActiveTpbOptionsMessage:str
 * @text Active TPB Message
 * @parent CommandAddOptions:eval
 * @desc Message that will be displayed when selecting options during the middle of an action.
 * @default Options Menu queued after action is complete.
 *
 * @param CmdIconEscape:num
 * @text Escape Icon
 * @parent Cmd
 * @desc The icon used for the Escape command.
 * @default 82
 *
 * @param Access
 *
 * @param SkipPartyCmd:eval
 * @text Skip Party Command
 * @parent Access
 * @type boolean
 * @on Skip
 * @off Don't
 * @desc DTB: Skip Party Command selection on turn start.
 * TPB: Skip Party Command selection at battle start.
 * @default true
 *
 * @param DisablePartyCmd:eval
 * @text Disable Party Command
 * @parent Access
 * @type boolean
 * @on Disable
 * @off Don't
 * @desc Disable the Party Command Window entirely?
 * @default false
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpFight:str
 * @text Fight
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Select actions to fight.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Sets party to Auto Battle mode.
 *
 * @param HelpOptions:str
 * @text Options
 * @parent HelpWindow
 * @desc Text displayed when selecting the Options command.
 * @default Opens up the Options Menu.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActorCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Actor Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Actor Command Window.
 * @default left
 *
 * @param CmdIconItem:num
 * @text Item Icon
 * @parent Cmd
 * @desc The icon used for the Item command.
 * @default 176
 *
 * @param IconStypeNorm:num
 * @text Normal SType Icon
 * @parent Cmd
 * @desc Icon used for normal skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 78
 *
 * @param IconStypeMagic:num
 * @text Magic SType Icon
 * @parent Cmd
 * @desc Icon used for magic skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 79
 *
 * @param BattleCmd
 * @text Battle Commands
 *
 * @param BattleCmdList:arraystr
 * @text Command List
 * @parent BattleCmd
 * @type combo[]
 * @option attack
 * @option skills
 * @option guard
 * @option item
 * @option status
 * @option party
 * @option escape
 * @option auto battle
 * @option stypes
 * @option stype: x
 * @option stype: name
 * @option all skills
 * @option skill: x
 * @option skill: name
 * @option combat log
 * @option talk
 * @option weapon swap
 * @desc List of battle commands that appear by default
 * if the <Battle Commands> notetag isn't present.
 * @default ["attack","skills","guard","party","item"]
 *
 * @param ShowCosts:eval
 * @text Show Command Costs
 * @parent BattleCmd
 * @type boolean
 * @on Show Costs
 * @off Hide Costs
 * @desc If a battle command has a resource cost, show it?
 * @default true
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpSkillType:str
 * @text Skill Types
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Opens up a list of skills under the \C[16]%1\C[0] category.
 *
 * @param HelpItem:str
 * @text Items
 * @parent HelpWindow
 * @desc Text displayed when selecting the item command.
 * @default Opens up a list of items that you can use.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Automatically choose an action suitable for combat.
 *
 * @param HelpParty:str
 * @text Party
 * @parent HelpWindow
 * @desc Text displayed when selecting the Party command.
 * Requires 
 * @default Automatically choose an action suitable for combat.
 *
 */
/* ----------------------------------------------------------------------------
 * In_Battle Status Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~InBattleStatus:
 *
 * @param General
 * @text General Settings
 *
 * @param CmdIconStatus:num
 * @text Status Icon
 * @parent General
 * @desc The icon used for the Status command.
 * @default 87
 *
 * @param StatusGraphic:str
 * @text Status Graphic
 * @parent General
 * @type select
 * @option None
 * @value none
 * @option Face
 * @value face
 * @option Map Sprite
 * @value sprite
 * @option Sideview Battler
 * @value svbattler
 * @desc Choose how the actor graphic appears for In-Battle Status.
 * @default face
 *
 * @param HelpStatus:str
 * @text Help Description
 * @parent General
 * @desc Text displayed when selecting the Status command.
 * @default View battle member status.
 *
 * @param Enemy
 * @text Enemy Settings
 *
 * @param enemyStatus:eval
 * @text Allow View Enemies?
 * @parent Enemy
 * @type boolean
 * @on Allow
 * @off Forbid
 * @desc Allows players to view enemy stats (even if limited)?
 * @default true
 *
 * @param enemyShowLevel:eval
 * @text Show Level?
 * @parent Enemy
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows the enemy's level in the In-Battle Status?
 * @default true
 *
 * @param enemyHiddenParameter:str
 * @text Hidden Parameter
 * @parent Enemy
 * @desc The text that appears if a parameter value is hidden.
 * @default ???
 *
 * @param enemyShowParametersAlways:eval
 * @text Show Params Always
 * @parent enemyHiddenParameter:str
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Always show exact enemy parameter values.
 * @default false
 *
 * @param enemyShowParametersIfBattleTest:eval
 * @text Show Battle Test
 * @parent enemyHiddenParameter:str
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show exact enemy parameter values in battle test.
 * @default true
 *
 * @param enemyShowParametersIfDefeated:eval
 * @text Show If Defeated
 * @parent enemyHiddenParameter:str
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show exact enemy parameter values if enemy has been defeated before.
 * @default true
 *
 * @param PageButtons
 * @text Page Buttons
 *
 * @param pageButtons:eval
 * @text Show Page Buttons?
 * @parent PageButtons
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows page buttons to switch between actors?
 * Still requires Touch UI option to be on.
 * @default true
 *
 * @param pageButtonPosition:str
 * @text Large UI Position?
 * @parent pageButtons:eval
 * @type select
 * @option left
 * @option right
 * @desc If using a large resolution, position the page buttons on which side?
 * @default left
 *
 * @param pageOffsetX:num
 * @text Offset X
 * @parent PageButtons
 * @desc Offsets the page buttons x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param pageOffsetY:num
 * @text Offset Y
 * @parent PageButtons
 * @desc Offsets the page buttons y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param Parameters
 * @text Parameter Display
 *
 * @param buffValueFmt:str
 * @text Increased Value
 * @parent Parameters
 * @desc How are increased parameter values displayed?
 * %1 - Parameter Value
 * @default ▲%1
 *
 * @param debuffValueFmt:str
 * @text Decreased Value
 * @parent Parameters
 * @desc How are increased parameter values displayed?
 * %1 - Parameter Value
 * @default ▼%1
 *
 * @param States
 * @text States Display
 *
 * @param statesMaxWidth:num
 * @text Max Width
 * @parent States
 * @desc Maximum width of the states list display.
 * @default 384
 *
 * @param drawStates:eval
 * @text List States?
 * @parent States
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Lists states in the states list display?
 * @default true
 *
 * @param drawBuffs:eval
 * @text List Buffs?
 * @parent States
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Lists buffs in the states list display?
 * @default true
 *
 * @param drawDebuffs:eval
 * @text List Debuffs?
 * @parent States
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Lists debuffs in the states list display?
 * @default true
 *
 * @param BuffsDebuffs
 * @text Buffs/Debuffs Display
 * @parent States
 *
 * @param buffNameFmt:str
 * @text Buff Name Format
 * @parent BuffsDebuffs
 * @desc Text format used to represent buffs.
 * %1 - Parameter Name
 * @default %1▲
 *
 * @param debuffNameFmt:str
 * @text Debuff Name Format
 * @parent BuffsDebuffs
 * @desc Text format used to represent debuffs.
 * %1 - Parameter Name
 * @default %1▼
 *
 * @param NormalState
 * @text Normal State
 * @parent States
 *
 * @param normalIcon:num
 * @text Normal Icon
 * @parent NormalState
 * @desc Icon used to represent normal state (unaffected by states, buffs, or debuffs).
 * @default 84
 *
 * @param normalText:str
 * @text Normal Text
 * @parent NormalState
 * @desc Text used to represent normal state (unaffected by states, buffs, or debuffs).
 * @default Normal
 *
 * @param HelpDesc
 * @text Help Descriptions
 *
 * @param stateHelpFmt:json
 * @text State Help Format
 * @parent HelpDesc
 * @type note
 * @desc Text format used for state help descriptions
 * %1 - Description; %2 - Turns/Actions Remaining
 * @default "%1 %2"
 *
 * @param buffHelpFmt:json
 * @text Buff Help Format
 * @parent HelpDesc
 * @type note
 * @desc Text format used for Buff help descriptions
 * %1 - Param; %2 - Percent; %3 - Color; %4 - Turns
 * @default "Increases %1 to %3%2\\C[0]. %4"
 *
 * @param debuffHelpFmt:json
 * @text Debuff Help Format
 * @parent HelpDesc
 * @type note
 * @desc Text format used for Debuff help descriptions
 * %1 - Param; %2 - Percent; %3 - Color; %4 - Turns
 * @default "Decreases %1 to %3%2\\C[0]. %4"
 *
 * @param normalHelp:json
 * @text Normal State
 * @parent HelpDesc
 * @type note
 * @desc Help description used to explain normal state (unaffected by states, buffs, or debuffs).
 * @default "Status is currently normal."
 *
 * @param TurnHelpDesc
 * @text Turns/Actions Left
 * @parent HelpDesc
 *
 * @param actionsFmt:str
 * @text Actions Format
 * @parent TurnHelpDesc
 * @desc Text format used to represent actions remaining.
 * %1 - Actions; %2 - Color
 * @default \C[6](Actions %2%1\C[6])\C[0]
 *
 * @param TurnsFmt:str
 * @text Turns Format
 * @parent TurnHelpDesc
 * @desc Text format used to represent turns remaining.
 * %1 - Turns; %2 - Color
 * @default \C[5](Turns %2%1\C[5])\C[0]
 *
 * @param passiveText:str
 * @text Passive Text
 * @parent TurnHelpDesc
 * @desc Text used to represent a passive.
 * @default \C[4](Passive)\C[0]
 *
 * @param Window
 * @text Window Settings
 *
 * @param StatusWindow_BgType:num
 * @text Background Type
 * @parent Window
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param StatusWindow_DrawJS:func
 * @text JS: Draw Data
 * @parent Window
 * @type note
 * @desc Code used to draw battler data.
 * @default "{ // Draw Face and Simple Status\n    const x = this.colSpacing() / 2;\n    const h = ImageManager.faceHeight;\n    const y = h / 2 - this.lineHeight() * 1.5;\n    this.drawActorGraphic(this._battler, x + 1, 0, ImageManager.faceWidth, h);\n    this.drawActorSimpleStatus(this._battler, x + 180, y);\n}\n{ // Draw Actor Parameters\n    let maxWidth = this.drawingAreaWidth();\n    let x1 = 0;\n    let x2 = Math.ceil(this.drawingAreaWidth() / 2);\n\n    let counter = 0;\n    const params = this.displayedParams();\n\n    let px = x1;\n    const availableHeight = this.innerHeight - ImageManager.faceHeight;\n    const paramHeight = Math.ceil(params.length / 2) * this.lineHeight();\n    let py = Math.ceil((availableHeight - paramHeight) / 2) + ImageManager.faceHeight;\n    let pw = Math.floor(maxWidth / 2);\n\n    if (this._statesWindow.y !== 0) {\n        this._statesWindow.y = py;\n    }\n\n    for (const param of params) {\n        this.drawDarkRect(px, py, pw, this.lineHeight());\n        this.drawParamData(param, px, py, pw);\n        counter++;\n        if (counter % 2 === 0) {\n            px = x1;\n            py += this.lineHeight();\n        } else {\n            px = x2;\n        }\n    }\n}"
 *
 * @param StatusWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Window
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const wx = Graphics.boxWidth > 1000 ? 120 : 0;\nconst wy = this._helpWindow.y + this._helpWindow.height;\nconst ww = Graphics.boxWidth - (wx * 2);\nconst wh = Graphics.boxHeight - wy - this.windowAreaHeight();\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 */
/* ----------------------------------------------------------------------------
 * Multi-Target Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MultiTarget:
 *
 * @param Properties
 * 
 * @param WindowWidth:num
 * @text Window Width
 * @parent Properties
 * @type number
 * @min 1
 * @desc What is the width used for the Multi-Target Window?
 * @default 280
 *
 * @param BgType:num
 * @text Background Type
 * @parent Properties
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for these windows.
 * @default 2
 *
 * @param ShowButton:eval
 * @text Show Button
 * @parent Properties
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows the keyboard/controller button to press?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 * 
 * @param Vocab
 *
 * @param AllActorsText:str
 * @text All Actors
 * @parent Vocab
 * @desc What is the text used for the "All Actors" button?
 * @default All Allies
 *
 * @param AllEnemiesText:str
 * @text All Enemies
 * @parent Vocab
 * @desc What is the text used for the "All Enemies" button?
 * @default All Enemies
 * 
 * @param Offsets
 * 
 * @param ActorOffsets
 * @text Actor Offsets
 * @parent Offsets
 *
 * @param ActorOffsetX:num
 * @text Offset X
 * @parent ActorOffsets
 * @desc Offsets the button's x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param ActorOffsetY:num
 * @text Offset Y
 * @parent ActorOffsets
 * @desc Offsets the button's y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @param EnemyOffsets
 * @text Enemy Offsets
 * @parent Offsets
 *
 * @param EnemyOffsetX:num
 * @text Offset X
 * @parent EnemyOffsets
 * @desc Offsets the button's x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param EnemyOffsetY:num
 * @text Offset Y
 * @parent EnemyOffsets
 * @desc Offsets the button's y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Combo Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ComboWindow:
 *
 * @param General
 * @text General Settings
 *
 * @param Enable:eval
 * @text Enable?
 * @parent General
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Add the Combo Window to show in battle?
 * @default true
 *
 * @param Appearance
 * @text Appearance Settings
 *
 * @param CustomFontFace:str
 * @text Custom Font
 * @parent Appearance
 * @desc Insert the custom font face name here.
 * Use VisuMZ_1_MessageCore to register new fonts.
 * @default Arial
 *
 * @param TextAlign:str
 * @text Text Align
 * @parent Appearance
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for this window?
 * @default left
 *
 * @param ComboWindow_DrawJS:func
 * @text JS: Draw Data
 * @parent Appearance
 * @type note
 * @desc Code used to draw the data in this window.
 * @default ""
 * 
 * @param Vocab
 * @text Vocabulary
 *
 * @param hitsDmgFmt:str
 * @text Damage Combo Format
 * @parent Vocab
 * @desc Text format used to display total hits for damage.
 * %1 - Total Hits
 * @default \C[6]%1\} \C[4]Hit Combo\C[0]\{
 *
 * @param hitsHealFmt:str
 * @text Healing Combo Format
 * @parent Vocab
 * @desc Text format used to display total hits for healing.
 * %1 - Total Hits
 * @default \C[6]%1\} \C[4]Heal Combo\C[0]\{
 *
 * @param totalDmgFmt:str
 * @text Damage Total Format
 * @parent Vocab
 * @desc Text format used to display total value for damage.
 * %1 - Total Damage
 * @default \}\C[21]Total Damage: \{\C[0]%1
 *
 * @param totalHealFmt:str
 * @text Healing Total Format
 * @parent Vocab
 * @desc Text format used to display total value for healing.
 * %1 - Total Healing
 * @default \}\C[21]Total Healing: \{\C[24]+%1\C[0]
 *
 * @param Position
 * @text Position Settings
 *
 * @param fadeShiftX:num
 * @text Fade Shift X
 * @parent Position
 * @desc Shifts the windows x position when fading.
 * Negative: left. Positive: right.
 * @default -2
 *
 * @param fadeShiftY:num
 * @text Fade Shift Y
 * @parent Position
 * @desc Shifts the windows y position when fading.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param PosOffsetX:num
 * @text Offset X
 * @parent Position
 * @desc Offsets the windows x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param PosOffsetY:num
 * @text Offset Y
 * @parent Position
 * @desc Offsets the windows y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param ComboWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Position
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.ceil(Graphics.width / 4);\nconst wh = this.calcWindowHeight(2, true);\nconst wx = 0 + this.comboWindowOffsetX();\nconst wy = Math.round(Graphics.boxHeight * 1 / 3) + this.comboWindowOffsetY();\nreturn new Rectangle(wx, wy, ww, wh);"
 * 
 * @param Update
 * @text Updating Settings
 *
 * @param updateDuration:num
 * @text Number Roll Duration
 * @parent Update
 * @type number
 * @min 1
 * @desc Frame duration to roll damage numbers.
 * 60 frames = 1 second.
 * @default 20
 *
 * @param minimumStayDuration:num
 * @text Minimum Stay Duration
 * @parent Update
 * @type number
 * @desc Frame duration to stay visible minimum.
 * 60 frames = 1 second.
 * @default 40
 *
 * @param minimumHits:num
 * @text Minimum Hit Visible
 * @parent Update
 * @type number
 * @min 1
 * @desc Minimum hits before combo window becomes visible?
 * @default 1
 *
 * @param opacitySpeed:num
 * @text Opacity Speed
 * @parent Update
 * @type number
 * @min 1
 * @desc Opacity speed when fading in/out.
 * @default 16
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Actor:
 *
 * @param Flinch
 *
 * @param FlinchDistanceX:num
 * @text Flinch Distance X
 * @parent Flinch
 * @desc The normal X distance when flinching.
 * @default 12
 *
 * @param FlinchDistanceY:num
 * @text Flinch Distance Y
 * @parent Flinch
 * @desc The normal Y distance when flinching.
 * @default 0
 *
 * @param FlinchDuration:num
 * @text Flinch Duration
 * @parent Flinch
 * @desc The number of frames for a flinch to complete.
 * @default 6
 *
 * @param ShakeFlinch:eval
 * @text Shake Flinch
 * @parent Flinch
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Perform a shake flinch when taking damage?
 * @default false
 *
 * @param ShakeFlinchDuration:num
 * @text Max Duration
 * @parent ShakeFlinch:eval
 * @type number
 * @min 1
 * @desc Maximum duration a shake flinch can have.
 * This is reduced relative to the amount of damage taken.
 * @default 24
 *
 * @param ShakeFlinchPower:num
 * @text Max Power
 * @parent ShakeFlinch:eval
 * @type number
 * @min 1
 * @desc The power rating of a shake flinch at full damage.
 * This is reduced relative to the amount of damage taken.
 * @default 48
 *
 * @param FvBattlers
 * @text Frontview Battlers
 * 
 * @param FvPortraitAni
 * @text Portrait Animations
 * @parent FvBattlers
 *
 * @param FvAniEachTarget:eval
 * @text Each Target
 * @parent FvPortraitAni
 * @type boolean
 * @on On Top
 * @off Behind
 * @desc Place animations on top for "Each Target" display types?
 * Does not apply to MV animations.
 * @default true
 *
 * @param FvAniCenterAll:eval
 * @text Center of All
 * @parent FvPortraitAni
 * @type boolean
 * @on On Top
 * @off Behind
 * @desc Place animations on top for "Center of All" display types?
 * Does not apply to MV animations.
 * @default true
 *
 * @param FvAniCenterScreen:eval
 * @text Center of Screen
 * @parent FvPortraitAni
 * @type boolean
 * @on On Top
 * @off Behind
 * @desc Place animations on top for "Center of Screen" display types?
 * Does not apply to MV animations.
 * @default false
 *
 * @param SvBattlers
 * @text Sideview Battlers
 * 
 * @param SvAnchor
 * @text Anchor
 * @parent SvBattlers
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvAnchor
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvAnchor
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param ChantStyle:eval
 * @text Chant Style
 * @parent SvBattlers
 * @type boolean
 * @on Magical Hit Type
 * @off Magical Skill Type
 * @desc What determines the chant motion?
 * Hit type or skill type?
 * @default true
 *
 * @param MotionSpeed:num
 * @text Motion Speed
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc The number of frames in between each motion.
 * @default 12
 * 
 * @param SvPosition
 * @text Position
 * @parent SvBattlers
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent SvPosition
 * @desc Offsets X position where actor is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent SvPosition
 * @desc Offsets Y position where actor is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param PrioritySortActive:eval
 * @text Priority: Active
 * @parent SvBattlers
 * @type boolean
 * @on Active Actor over All Else
 * @off Active Actor is Sorted Normally
 * @desc Place the active actor on top of actor and enemy sprites.
 * @default false
 *
 * @param PrioritySortActors:eval
 * @text Priority: Actors
 * @parent SvBattlers
 * @type boolean
 * @on Actors over Enemies
 * @off Sort by Y Position
 * @desc Prioritize actors over enemies when placing sprites on top
 * of each other.
 * @default true
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 * 
 * @param SvStateOverlay
 * @text State Overlay
 * @parent SvBattlers
 *
 * @param StateOverlayOffsetX:num
 * @text Offset: X
 * @parent SvStateOverlay
 * @desc Offsets X position for state overlay on actor.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param StateOverlayOffsetY:num
 * @text Offset: Y
 * @parent SvStateOverlay
 * @desc Offsets Y position for state overlay on actor.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent SvBattlers
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default false
 *
 * @param HomePosJS:func
 * @text JS: Home Position
 * @parent SvBattlers
 * @type note
 * @desc Code used to calculate the home position of actors.
 * @default "// Declare Constants\nconst sprite = this;\nconst actor = this._actor;\nconst index = arguments[0];\n\n// Make Calculations\nlet x = Math.round((Graphics.width / 2) + 192)\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\nx += index * 32;\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\ny += index * 48;\n\n// Home Position Offsets\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\+\\-]\\d+),[ ]([\\+\\-]\\d+)>/i;\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\nx = xOffsets.reduce((r, offset) => r + offset, x);\ny = yOffsets.reduce((r, offset) => r + offset, y);\n\n// Set Home Position\nthis.setHome(x, y);"
 *
 */
/* ----------------------------------------------------------------------------
 * Enemy Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Enemy:
 *
 * @param Visual
 *
 * @param AttackAnimation:num
 * @text Attack Animation
 * @parent Visual
 * @type animation
 * @desc Default attack animation used for enemies.
 * Use <Attack Animation: x> for custom animations.
 * @default 1
 *
 * @param EmergeText:eval
 * @text Emerge Text
 * @parent Visual
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide the 'Enemy emerges!' text at the start of battle.
 * @default false
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent Visual
 * @desc Offsets X position where enemy is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent Visual
 * @desc Offsets Y position where enemy is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent Visual
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default true
 *
 * @param SelectWindow
 * @text Select Window
 *
 * @param LastSelected:eval
 * @text Any: Last Selected
 * @parent SelectWindow
 * @type boolean
 * @on Last Selected
 * @off FV/SV Priority
 * @desc Prioritize last selected enemy over front view or sideview settings?
 * @default true
 *
 * @param FrontViewSelect:eval
 * @text FV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using frontview, auto select the enemy furthest right.
 * @default false
 *
 * @param SideviewSelect:eval
 * @text SV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using sideview, auto select the enemy furthest right.
 * @default true
 * 
 * @param Name
 *
 * @param NameLegacy:eval
 * @text Legacy Option
 * @parent Name
 * @type boolean
 * @on Legacy Version
 * @off New Version (Sprite)
 * @desc Use the legacy version (window) or new version (sprite).
 * WARNING: Legacy version is no longer supported for bugs.
 * @default false
 *
 * @param NameFontSize:num
 * @text Font Size
 * @parent Name
 * @desc Font size used for enemy names.
 * @default 22
 * 
 * @param NamePosition
 * @text Name Position
 * @parent Name
 *
 * @param NameOffsetX:num
 * @text Offset X
 * @parent NamePosition
 * @desc Offset the enemy name's X position by this much.
 * Negative goes left. Positive goes right.
 * @default 0
 *
 * @param NameOffsetY:num
 * @text Offset Y
 * @parent NamePosition
 * @desc Offset the enemy name's Y position by this much.
 * Negative goes up. Positive goes down.
 * @default 0
 *
 * @param NameAttachStateIcon:eval
 * @text Attach States
 * @parent Name
 * @type boolean
 * @on Attach
 * @off Normal Position
 * @desc Attach the enemy's state icon to the enemy name?
 * @default false
 *
 * @param AttachStateOffsetX:num
 * @text Attach: Offset X
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's X position by?
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param AttachStateOffsetY:num
 * @text Attach: Offset Y
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's Y position by?
 * Negative goes up. Positive goes down.
 * @default +0
 * 
 * @param NameVisibility
 * @text Name Visibility
 * @parent Name
 *
 * @param NameAlwaysHidden:eval
 * @text Always Hidden
 * @parent NameVisibility
 * @type boolean
 * @on Always Hidden
 * @off No Priority
 * @desc Determines if the enemy name will always be visible.
 * Highest priority.
 * @default false
 *
 * @param NameAlwaysVisible:eval
 * @text Always Visible
 * @parent NameVisibility
 * @type boolean
 * @on Always Visible
 * @off Hide when Unselected
 * @desc Determines if the enemy name will always be visible.
 * Medium priority.
 * @default false
 *
 * @param NameAsTarget:eval
 * @text As Target
 * @parent NameVisibility
 * @type boolean
 * @on Visible As Target
 * @off No Priority
 * @desc Shows enemy name when enemy is a target.
 * Medium priority.
 * @default true
 *
 * @param NameAlwaysSelectOnly:eval
 * @text By Selection?
 * @parent NameVisibility
 * @type boolean
 * @on Visible when Selected
 * @off Visible when Targeting
 * @desc Determines the conditions for enemy name visibility.
 * Lowest priority.
 * @default false
 *
 * @param NameDamageVisibility:num
 * @text Temporary Visibility
 * @parent NameVisibility
 * @type number
 * @desc Number of frames enemy's name temporarily visible after
 * taking an action effect in battle. 60 frames = 1 second.
 * @default 0
 *
 * @param SvBattlers
 * @text Sideview Battlers
 *
 * @param AllowCollapse:eval
 * @text Allow Collapse
 * @parent SvBattlers
 * @type boolean
 * @on Allow
 * @off Don't
 * @desc Causes defeated enemies with SV Battler graphics
 * to "fade away" when defeated?
 * @default false
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvBattlers
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvBattlers
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param MotionIdle:str
 * @text Motion: Idle
 * @parent SvBattlers
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Sets default idle animation used by Sideview Battlers.
 * @default walk
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 *
 * @param Width:num
 * @text Size: Width
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default width for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param Height:num
 * @text Size: Height
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default height for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param WtypeId:num
 * @text Weapon Type
 * @parent SvBattlers
 * @type number
 * @min 0
 * @desc Sets default weapon type used by Sideview Battlers.
 * Use 0 for Bare Hands.
 * @default 0
 *
 * @param Aspect
 * @text Aspect Defaults
 *
 * @param AspectNameFmt:str
 * @text Name Format
 * @parent Aspect
 * @desc Default name aspect format.
 * %1 - Original Enemy Name
 * @default %1 Aspect
 *
 * @param AspectColor:str
 * @text Name Color
 * @parent Aspect
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 2
 *
 * @param AspectIcon:num
 * @text Icon
 * @parent Aspect
 * @desc Default icon used for aspect.
 * Use <Aspect Icon: x> to change icon.
 * @default 26
 *
 */
/* ----------------------------------------------------------------------------
 * HP Gauge Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~HpGauge:
 *
 * @param Display
 * @text Show Gauges For
 *
 * @param ShowActorGauge:eval
 * @text Actors
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the actor sprites' heads?
 * Requires SV Actors to be visible.
 * @default true
 *
 * @param ShowEnemyGauge:eval
 * @text Enemies
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the enemy sprites' heads?
 * Can be bypassed with <Hide HP Gauge> notetag.
 * @default true
 *
 * @param RequiresDefeat:eval
 * @text Requires Defeat?
 * @parent ShowEnemyGauge:eval
 * @type boolean
 * @on Require Defeat First
 * @off No Requirement
 * @desc Requires defeating the enemy once to show HP Gauge?
 * Can be bypassed with <Show HP Gauge> notetag.
 * @default true
 *
 * @param BTestBypass:eval
 * @text Battle Test Bypass?
 * @parent RequiresDefeat:eval
 * @type boolean
 * @on Bypass
 * @off Don't Bypass
 * @desc Bypass the defeat requirement in battle test?
 * @default true
 *
 * @param Settings
 *
 * @param AniDuration:num
 * @text Animation Duration
 * @parent Settings
 * @type number
 * @min 1
 * @desc How many frames should gauges animate themselves?
 * Default: 20 frames.
 * @default 20
 *
 * @param AnchorX:num
 * @text Anchor X
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor X to be?
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor Y
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor Y to be?
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param Scale:num
 * @text Scale
 * @parent Settings
 * @desc How large/small do you want the HP Gauge to be scaled?
 * @default 0.5
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's X by?
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's Y by?
 * @default -3
 *
 * @param Options
 * @text Options
 *
 * @param AddHpGaugeOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the 'Show HP Gauge' option to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param Name:str
 * @text Option Name
 * @parent Options
 * @desc Command name of the option.
 * @default Show HP Gauge
 *
 */
/* ----------------------------------------------------------------------------
 * Action Sequence Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActionSequence:
 *
 * @param AutoSequences
 * @text Automatic Sequences
 *
 * @param AutoMeleeSolo:eval
 * @text Melee Single Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, single target actions?
 * @default true
 *
 * @param AutoMeleeAoE:eval
 * @text Melee Multi Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, multi-target actions?
 * @default true
 *
 * @param QoL
 * @text Quality of Life
 *
 * @param AutoNotetag:eval
 * @text Auto Notetag
 * @parent QoL
 * @type boolean
 * @on Automatic
 * @off Manual
 * @desc Automatically apply the <Custom Action Sequence> notetag
 * effect to any item or skill that has a Common Event?
 * @default false
 *
 * @param CastAnimations
 * @text Cast Animations
 *
 * @param CastCertain:num
 * @text Certain Hit
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Certain Hit skills.
 * @default 120
 *
 * @param CastPhysical:num
 * @text Physical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Physical skills.
 * @default 52
 *
 * @param CastMagical:num
 * @text Magical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Magical skills.
 * @default 51
 *
 * @param CounterReflection
 * @text Counter/Reflect
 *
 * @param CounterPlayback:eval
 * @text Counter Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param ReflectAnimation:num
 * @text Reflect Animation
 * @parent CounterReflection
 * @type animation
 * @desc Animation played when an action is reflected.
 * @default 53
 *
 * @param ReflectPlayback:eval
 * @text Reflect Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param Stepping
 *
 * @param MeleeDistance:num
 * @text Melee Distance
 * @parent Stepping
 * @desc Minimum distance in pixels for Movement Action Sequences.
 * @default 24
 *
 * @param StepDistanceX:num
 * @text Step Distance X
 * @parent Stepping
 * @desc The normal X distance when stepping forward.
 * @default 48
 *
 * @param StepDistanceY:num
 * @text Step Distance Y
 * @parent Stepping
 * @desc The normal Y distance when stepping forward.
 * @default 0
 *
 * @param StepDuration:num
 * @text Step Duration
 * @parent Stepping
 * @desc The number of frames for a stepping action to complete.
 * @default 12
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Start Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileStart:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Start from battler target(s)
 * @value target
 * @option Point - Start from a point on the screen
 * @value point
 * @desc Select where the projectile should start from.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to start the projectile from.
 * @default ["user"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Create one projectile at the center of the targets?
 * Or create a projectile for each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile from.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Goal Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileGoal:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Goal is battler target(s)
 * @value target
 * @option Point - Goal is a point on the screen
 * @value point
 * @desc Select where the projectile should go to.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for projectile to go to.
 * @default ["all targets"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Set goal in the center of targets?
 * Or create a projectile to go to each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile at.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Animation Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExAni:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the projectile's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 * 
 * @param Emulate
 * @text Effect Emulation
 * 
 * @param EmulateActionEffect:eval
 * @text Action Effect?
 * @parent Emulate
 * @type boolean
 * @on Emulate
 * @off Don't Emulate
 * @desc Emulate current Action Effect when projectile reaches
 * target? Only works with start/goal targets.
 * @default false
 * 
 * @param EmulateItemEffect:eval
 * @text Item Effect ID
 * @parent Emulate
 * @type item
 * @desc Emulate an Item Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 * 
 * @param EmulateSkillEffect:eval
 * @text Skill Effect ID
 * @parent Emulate
 * @type skill
 * @desc Emulate a Skill Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 *
 * @param OnceParallel:num
 * @text Common Event ID
 * @parent Emulate
 * @type common_event
 * @desc Plays a Once Parallel Common Event upon reaching target.
 * Use 0 to not use. Works regardless of start/goal targets.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExtra:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the projectile's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param BlendMode:num
 * @text Blend Mode
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the projectile?
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Hue:eval
 * @text Hue
 * @parent Settings
 * @desc Adjust the hue of the projectile.
 * Insert a number between 0 and 360.
 * @default 0
 * 
 * @param Scale:eval
 * @text Scale
 * @parent Settings
 * @desc Adjust the size scaling of the projectile.
 * Use decimals for exact control.
 * @default 1.0
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 * 
 * @param Emulate
 * @text Effect Emulation
 * 
 * @param EmulateActionEffect:eval
 * @text Action Effect?
 * @parent Emulate
 * @type boolean
 * @on Emulate
 * @off Don't Emulate
 * @desc Emulate current Action Effect when projectile reaches
 * target? Only works with start/goal targets.
 * @default false
 * 
 * @param EmulateItemEffect:eval
 * @text Item Effect ID
 * @parent Emulate
 * @type item
 * @desc Emulate an Item Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 * 
 * @param EmulateSkillEffect:eval
 * @text Skill Effect ID
 * @parent Emulate
 * @type skill
 * @desc Emulate a Skill Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 *
 * @param OnceParallel:num
 * @text Common Event ID
 * @parent Emulate
 * @type common_event
 * @desc Plays a Once Parallel Common Event upon reaching target.
 * Use 0 to not use. Works regardless of start/goal targets.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Visual Cutin Effect Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~VisualCutinEffect:
 *
 * @param Transition
 * 
 * @param enterDuration:num
 * @text Entrance Duration
 * @parent Transition
 * @type number
 * @desc How many frames does it take to fully enter?
 * Used when a Visual Cutin Effect starts.
 * @default 12
 * 
 * @param exitDuration:num
 * @text Exit Duration
 * @parent Transition
 * @type number
 * @desc How many frames does it take to fully exit?
 * Used when a Visual Cutin Effect ends.
 * @default 12
 *
 * @param Cutin
 * @text Cutin Settings
 *
 * @param bgShow:eval
 * @text Show BG Color?
 * @parent Cutin
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Add a background color for this cutin?
 * Background colors appear behind the parallax.
 * @default true
 *
 * @param outlineShow:eval
 * @text Show Outline?
 * @parent Cutin
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the cutin outline?
 * @default true
 *
 * @param Portrait
 * @text Portrait Settings
 *
 * @param PortraitBase
 * @text Base Properties
 * @parent Portrait
 * 
 * @param portraitAnchorX:num
 * @text Anchor X
 * @parent PortraitBase
 * @desc Determines the sprite anchor X alignment.
 * 0.0: Left, 0.5: Center, 1.0: Right.
 * @default 0.5
 * 
 * @param portraitAnchorY:num
 * @text Anchor Y
 * @parent PortraitBase
 * @desc Determines the sprite anchor Y alignment.
 * 0.0: Top, 0.5: Middle, 1.0: Bottom.
 * @default 0.5
 *
 * @param portraitHue:num
 * @text Hue
 * @parent PortraitBase
 * @type number
 * @min 0
 * @max 360
 * @desc Do you wish to adjust this cutin's portrait hue?
 * @default 0
 * 
 * @param portraitOpacity:num
 * @text Opacity
 * @parent PortraitBase
 * @type number
 * @max 255
 * @desc What is the opacity level of this cutin's portrait?
 * @default 255
 * 
 * @param portraitOffsetX:num
 * @text Offset X
 * @parent PortraitBase
 * @desc Offsets the cutin portrait's X location.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @param portraitOffsetY:num
 * @text Offset Y
 * @parent PortraitBase
 * @desc Offsets the cutin portrait's Y location.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param PortraitEnter
 * @text Entrance Properties
 * @parent Portrait
 * 
 * @param portraitEnterX:num
 * @text Entrance X
 * @parent PortraitEnter
 * @desc Sets the cutin portrait's X entrance.
 * Negative: from left. Positive: from right.
 * @default +0
 * 
 * @param portraitEnterY:num
 * @text Entrance Y
 * @parent PortraitEnter
 * @desc Sets the cutin portrait's Y entrance.
 * Negative: from up. Positive: from down.
 * @default +0
 *
 * @param portraitEnterEasingType:str
 * @text Entrance Easing
 * @parent PortraitEnter
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @param PortraitExit
 * @text Exit Properties
 * @parent Portrait
 * 
 * @param portraitExitX:num
 * @text Exit X
 * @parent PortraitExit
 * @desc Sets the cutin portrait's X exit.
 * Negative: to left. Positive: to right.
 * @default +0
 * 
 * @param portraitExitY:num
 * @text Exit Y
 * @parent PortraitExit
 * @desc Sets the cutin portrait's Y exit.
 * Negative: to up. Positive: to down.
 * @default +0
 *
 * @param portraitExitEasingType:str
 * @text Exit Easing
 * @parent PortraitExit
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @param PortraitFlip
 * @text Flip Properties
 * @parent Portrait
 *
 * @param portraitFlipHorz:eval
 * @text Flip Horizontally?
 * @parent PortraitFlip
 * @type boolean
 * @on Flip
 * @off Don't Flip
 * @desc Flip the cutin portrait horizontally?
 * @default false
 *
 * @param portraitFlipVert:eval
 * @text Flip Vertically?
 * @parent PortraitFlip
 * @type boolean
 * @on Flip
 * @off Don't Flip
 * @desc Flip the cutin portrait vertically?
 * @default false
 *
 * @param PortraitScale
 * @text Scaling Properties
 * @parent Portrait
 * 
 * @param portraitForcedScale:num
 * @text Forced Scaling
 * @parent PortraitScale
 * @desc Do you want to force a scaling ratio?
 * Leave as 0 for none. Disables "Fit to Scale?".
 * @default 0.0
 *
 * @param portraitScaleToFit:eval
 * @text Fit to Scale?
 * @parent PortraitScale
 * @type boolean
 * @on Fit to Scale
 * @off Don't Scale
 * @desc Scale the cutin portrait to fit the cutin style?
 * Cannot be used with "Forced Scaling".
 * @default true
 *
 * @param portraitScaleMax:eval
 * @text Scale Max?
 * @parent portraitScaleToFit:eval
 * @type boolean
 * @on Scale Maximum
 * @off Scale Minimum
 * @desc Scale the cutin portrait to the maximum fit or
 * scale the cutin portrait to the minimum fit.
 * @default false
 *
 * @param PortraitAni
 * @text Animated Portraits
 * @parent Portrait
 *
 * @param animatedPortraitLooping:eval
 * @text Loop?
 * @parent PortraitAni
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Will loop back to beginning once ended.
 * Requires VisuMZ_4_AnimatedPictures!
 * @default true
 *
 * @param animatedPortraitWaitFrames:num
 * @text Wait Frames
 * @parent PortraitAni
 * @type number
 * @min 1
 * @desc Frames to wait before moving to next cell.
 * Requires VisuMZ_4_AnimatedPictures!
 * @default 4
 *
 * @param Parallax
 * @text Parallax Settings
 *
 * @param ParallaxBase
 * @text Base Settings
 * @parent Parallax
 *
 * @param parallaxBlendMode:num
 * @text Blend Mode
 * @parent ParallaxBase
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the cutin?
 * @default 0
 *
 * @param parallaxHue:num
 * @text Hue
 * @parent ParallaxBase
 * @type number
 * @min 0
 * @max 360
 * @desc Do you wish to adjust this cutin's parallax hue?
 * @default 0
 *
 * @param parallaxHueEnemyModifier:num
 * @text Enemy Modifier
 * @parent parallaxHue:num
 * @desc Adjust the hue value by this if the cutin target is an enemy.
 * @default +0
 * 
 * @param parallaxOpacity:num
 * @text Opacity
 * @parent ParallaxBase
 * @type number
 * @max 255
 * @desc What is the opacity level of this cutin's parallax?
 * @default 255
 *
 * @param ParallaxScroll
 * @text Scrolling Settings
 * @parent Parallax
 * 
 * @param parallaxOffsetX:num
 * @text Offset X
 * @parent ParallaxScroll
 * @desc Offsets the cutin parallax's X location.
 * Negative: left. Positive: right.
 * @default +0.0
 * 
 * @param parallaxOffsetY:num
 * @text Offset Y
 * @parent ParallaxScroll
 * @desc Offsets the cutin parallax's Y location.
 * Negative: up. Positive: down.
 * @default +0.0
 * 
 * @param parallaxScrollX:num
 * @text Scroll X
 * @parent ParallaxScroll
 * @desc How many pixels does the parallax scroll horizontally?
 * Negative: Scroll to right. Positive: Scroll to left.
 * @default +0.0
 *
 * @param parallaxScrollXinvertEnemy:eval
 * @text Invert for Enemy?
 * @parent parallaxScrollX:num
 * @type boolean
 * @on Invert
 * @off Don't Invert
 * @desc Invert the X scroll direction if the cutin target is an enemy?
 * @default false
 * 
 * @param parallaxScrollY:num
 * @text Scroll Y
 * @parent ParallaxScroll
 * @desc How many pixels does the parallax scroll vertically?
 * Negative: Scroll to down. Positive: Scroll to up.
 * @default +0.0
 *
 * @param parallaxScrollYinvertEnemy:eval
 * @text Invert for Enemy?
 * @parent parallaxScrollY:num
 * @type boolean
 * @on Invert
 * @off Don't Invert
 * @desc Invert the Y scroll direction if the cutin target is an enemy?
 * @default false
 *
 */
//=============================================================================

const _0x4bcec6=_0x2f5c;(function(_0x4a6bc8,_0x35f170){const _0x476122=_0x2f5c,_0x34a0f3=_0x4a6bc8();while(!![]){try{const _0x184d93=parseInt(_0x476122(0x134))/0x1*(-parseInt(_0x476122(0x1a0))/0x2)+parseInt(_0x476122(0x908))/0x3+parseInt(_0x476122(0x57a))/0x4*(-parseInt(_0x476122(0x83d))/0x5)+parseInt(_0x476122(0x396))/0x6+-parseInt(_0x476122(0x972))/0x7+parseInt(_0x476122(0x42e))/0x8+parseInt(_0x476122(0x954))/0x9;if(_0x184d93===_0x35f170)break;else _0x34a0f3['push'](_0x34a0f3['shift']());}catch(_0x58ba5a){_0x34a0f3['push'](_0x34a0f3['shift']());}}}(_0x345c,0x40f3f));function _0x2f5c(_0x29f128,_0x1146c6){const _0x345c20=_0x345c();return _0x2f5c=function(_0x2f5ce1,_0xc9d49f){_0x2f5ce1=_0x2f5ce1-0xf4;let _0x97bcb6=_0x345c20[_0x2f5ce1];return _0x97bcb6;},_0x2f5c(_0x29f128,_0x1146c6);}var label='BattleCore',tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x4bcec6(0x9f4)](function(_0x50179b){const _0x39c574=_0x4bcec6;return _0x50179b['status']&&_0x50179b[_0x39c574(0x726)]['includes']('['+label+']');})[0x0];VisuMZ[label][_0x4bcec6(0x187)]=VisuMZ[label][_0x4bcec6(0x187)]||{},VisuMZ[_0x4bcec6(0x9b1)]=function(_0x26d150,_0x128cef){const _0x5252a5=_0x4bcec6;for(const _0x28216b in _0x128cef){if(_0x28216b['match'](/(.*):(.*)/i)){const _0x1ad635=String(RegExp['$1']),_0x585530=String(RegExp['$2'])[_0x5252a5(0x1fd)]()[_0x5252a5(0x7d5)]();let _0x187c84,_0x1239ad,_0x18d3d2;switch(_0x585530){case _0x5252a5(0x11b):_0x187c84=_0x128cef[_0x28216b]!==''?Number(_0x128cef[_0x28216b]):0x0;break;case _0x5252a5(0x860):_0x1239ad=_0x128cef[_0x28216b]!==''?JSON[_0x5252a5(0x719)](_0x128cef[_0x28216b]):[],_0x187c84=_0x1239ad[_0x5252a5(0x228)](_0x13edfd=>Number(_0x13edfd));break;case'EVAL':_0x187c84=_0x128cef[_0x28216b]!==''?eval(_0x128cef[_0x28216b]):null;break;case _0x5252a5(0x712):_0x1239ad=_0x128cef[_0x28216b]!==''?JSON[_0x5252a5(0x719)](_0x128cef[_0x28216b]):[],_0x187c84=_0x1239ad['map'](_0x27a212=>eval(_0x27a212));break;case _0x5252a5(0xb81):_0x187c84=_0x128cef[_0x28216b]!==''?JSON[_0x5252a5(0x719)](_0x128cef[_0x28216b]):'';break;case _0x5252a5(0x201):_0x1239ad=_0x128cef[_0x28216b]!==''?JSON[_0x5252a5(0x719)](_0x128cef[_0x28216b]):[],_0x187c84=_0x1239ad[_0x5252a5(0x228)](_0x14149e=>JSON['parse'](_0x14149e));break;case _0x5252a5(0x736):_0x187c84=_0x128cef[_0x28216b]!==''?new Function(JSON[_0x5252a5(0x719)](_0x128cef[_0x28216b])):new Function(_0x5252a5(0x5ef));break;case _0x5252a5(0x5ba):_0x1239ad=_0x128cef[_0x28216b]!==''?JSON['parse'](_0x128cef[_0x28216b]):[],_0x187c84=_0x1239ad[_0x5252a5(0x228)](_0x595f08=>new Function(JSON[_0x5252a5(0x719)](_0x595f08)));break;case _0x5252a5(0x56b):_0x187c84=_0x128cef[_0x28216b]!==''?String(_0x128cef[_0x28216b]):'';break;case _0x5252a5(0x81f):_0x1239ad=_0x128cef[_0x28216b]!==''?JSON['parse'](_0x128cef[_0x28216b]):[],_0x187c84=_0x1239ad['map'](_0x5655b7=>String(_0x5655b7));break;case'STRUCT':_0x18d3d2=_0x128cef[_0x28216b]!==''?JSON[_0x5252a5(0x719)](_0x128cef[_0x28216b]):{},_0x26d150[_0x1ad635]={},VisuMZ[_0x5252a5(0x9b1)](_0x26d150[_0x1ad635],_0x18d3d2);continue;case _0x5252a5(0x421):_0x1239ad=_0x128cef[_0x28216b]!==''?JSON['parse'](_0x128cef[_0x28216b]):[],_0x187c84=_0x1239ad[_0x5252a5(0x228)](_0x4a0a81=>VisuMZ['ConvertParams']({},JSON[_0x5252a5(0x719)](_0x4a0a81)));break;default:continue;}_0x26d150[_0x1ad635]=_0x187c84;}}return _0x26d150;},(_0x2b141b=>{const _0x37341b=_0x4bcec6,_0x332e5a=_0x2b141b[_0x37341b(0x4fc)];for(const _0x154b4b of dependencies){if(!Imported[_0x154b4b]){alert(_0x37341b(0x6b4)[_0x37341b(0xb12)](_0x332e5a,_0x154b4b)),SceneManager[_0x37341b(0x410)]();break;}}const _0x394878=_0x2b141b[_0x37341b(0x726)];if(_0x394878[_0x37341b(0x820)](/\[Version[ ](.*?)\]/i)){const _0x456e4f=Number(RegExp['$1']);_0x456e4f!==VisuMZ[label][_0x37341b(0x6e5)]&&(alert(_0x37341b(0x89b)['format'](_0x332e5a,_0x456e4f)),SceneManager[_0x37341b(0x410)]());}if(_0x394878[_0x37341b(0x820)](/\[Tier[ ](\d+)\]/i)){const _0x413dd4=Number(RegExp['$1']);_0x413dd4<tier?(alert(_0x37341b(0x51e)['format'](_0x332e5a,_0x413dd4,tier)),SceneManager[_0x37341b(0x410)]()):tier=Math[_0x37341b(0x4d5)](_0x413dd4,tier);}VisuMZ[_0x37341b(0x9b1)](VisuMZ[label]['Settings'],_0x2b141b[_0x37341b(0x6e7)]);})(pluginData),VisuMZ[_0x4bcec6(0x8bd)]=function(_0x1913b3){const _0x4513d5=_0x4bcec6;let _0x36e466=[];for(const _0x31c418 of _0x1913b3){_0x36e466=_0x36e466[_0x4513d5(0x5cb)](VisuMZ[_0x4513d5(0x1ac)](_0x31c418));}return _0x36e466['filter'](_0x280593=>_0x280593);},VisuMZ['ConvertActionSequenceTarget']=function(_0x4cfb9a){const _0x125ff3=_0x4bcec6,_0x611d5=BattleManager['allBattleMembers']()[_0x125ff3(0x9f4)](_0x38ebdb=>_0x38ebdb&&_0x38ebdb['isAppeared']()),_0x3593a5=BattleManager[_0x125ff3(0xba3)],_0x133067=BattleManager[_0x125ff3(0x78f)],_0x21c565=BattleManager[_0x125ff3(0x361)]?BattleManager[_0x125ff3(0x361)]['slice'](0x0):_0x611d5;_0x4cfb9a=_0x4cfb9a['toLowerCase']()[_0x125ff3(0x7d5)]();if(_0x4cfb9a===_0x125ff3(0x147))return[_0x3593a5];else{if(_0x4cfb9a===_0x125ff3(0x6d1))return[_0x133067];else{if(_0x4cfb9a==='prev\x20target'){if(_0x133067){const _0x1b6c95=_0x21c565['indexOf'](_0x133067);return _0x1b6c95>=0x0?[_0x21c565[_0x1b6c95-0x1]||_0x133067]:[_0x133067];}}else{if(_0x4cfb9a===_0x125ff3(0x114)){if(_0x133067){const _0x4dbc32=_0x21c565['indexOf'](_0x133067);return _0x4dbc32>=0x0?[_0x21c565[_0x4dbc32+0x1]||_0x133067]:[_0x133067];}}else{if(_0x4cfb9a==='all\x20targets')return _0x21c565;else{if(_0x4cfb9a===_0x125ff3(0x194))return[_0x3593a5][_0x125ff3(0x5cb)](_0x21c565);else{if(_0x4cfb9a==='not\x20focus')return _0x611d5[_0x125ff3(0x9f4)](_0x3d55b4=>_0x3d55b4!==_0x3593a5&&!_0x21c565[_0x125ff3(0x5e4)](_0x3d55b4)&&_0x3d55b4['notFocusValid']());else{if(_0x4cfb9a===_0x125ff3(0x412))return[VisuMZ[_0x125ff3(0x332)]()];else{if(_0x4cfb9a[_0x125ff3(0x820)](/SPECIAL (.*)>/i)){const _0x5c808d=String(RegExp['$1'])['split'](',')[_0x125ff3(0x228)](_0x311e79=>_0x311e79[_0x125ff3(0x7d5)]());return[VisuMZ[_0x125ff3(0x174)](_0x5c808d)];}}}}}}}}}if(_0x3593a5){if(_0x4cfb9a===_0x125ff3(0x615))return _0x3593a5['friendsUnit']()['aliveMembers']();else{if(_0x4cfb9a===_0x125ff3(0x583))return _0x3593a5[_0x125ff3(0xbdc)]()[_0x125ff3(0x14b)]()[_0x125ff3(0x9f4)](_0xfd3a67=>_0xfd3a67!==_0x3593a5);else{if(_0x4cfb9a===_0x125ff3(0xaf6))return _0x3593a5[_0x125ff3(0xbdc)]()[_0x125ff3(0x14b)]()[_0x125ff3(0x9f4)](_0x258e1e=>_0x258e1e!==_0x133067);else{if(_0x4cfb9a===_0x125ff3(0x267))return _0x3593a5[_0x125ff3(0xbdc)]()['deadMembers']();else{if(_0x4cfb9a[_0x125ff3(0x820)](/FRIEND INDEX (\d+)/i)){const _0x1b3997=Number(RegExp['$1']);return[_0x3593a5['friendsUnit']()[_0x125ff3(0x6bd)]()[_0x1b3997]];}}}}}if(_0x4cfb9a===_0x125ff3(0x2c8))return _0x3593a5[_0x125ff3(0x43f)]()[_0x125ff3(0x14b)]();else{if(_0x4cfb9a===_0x125ff3(0x751))return _0x3593a5[_0x125ff3(0x43f)]()['aliveMembers']()[_0x125ff3(0x9f4)](_0x3e46ba=>_0x3e46ba!==_0x133067);else{if(_0x4cfb9a===_0x125ff3(0x472))return _0x3593a5['opponentsUnit']()['deadMembers']();else{if(_0x4cfb9a['match'](/OPPONENT INDEX (\d+)/i)){const _0x546019=Number(RegExp['$1']);return[_0x3593a5[_0x125ff3(0x43f)]()[_0x125ff3(0x6bd)]()[_0x546019]];}}}}}if(_0x4cfb9a===_0x125ff3(0x2af))return $gameParty[_0x125ff3(0x14b)]();else{if(_0x4cfb9a===_0x125ff3(0x7db))return $gameParty[_0x125ff3(0x14b)]()['filter'](_0x6b7f50=>_0x6b7f50!==_0x3593a5);else{if(_0x4cfb9a===_0x125ff3(0xa39))return $gameParty[_0x125ff3(0x14b)]()[_0x125ff3(0x9f4)](_0x28eec5=>_0x28eec5!==_0x133067);else{if(_0x4cfb9a==='dead\x20actors')return $gameParty['deadMembers']();else{if(_0x4cfb9a[_0x125ff3(0x820)](/ACTOR INDEX (\d+)/i)){const _0x9b15a2=Number(RegExp['$1']);return[$gameParty[_0x125ff3(0x6bd)]()[_0x9b15a2]];}else{if(_0x4cfb9a['match'](/ACTOR ID (\d+)/i)){const _0x3497fe=Number(RegExp['$1']);return[$gameActors[_0x125ff3(0x37d)](_0x3497fe)];}}}}}}if(_0x4cfb9a===_0x125ff3(0x5f8))return $gameTroop[_0x125ff3(0x14b)]();else{if(_0x4cfb9a==='alive\x20enemies\x20not\x20user')return $gameTroop[_0x125ff3(0x14b)]()[_0x125ff3(0x9f4)](_0x1b8e1e=>_0x1b8e1e!==_0x3593a5);else{if(_0x4cfb9a==='alive\x20enemies\x20not\x20target')return $gameTroop[_0x125ff3(0x14b)]()[_0x125ff3(0x9f4)](_0x17b404=>_0x17b404!==_0x133067);else{if(_0x4cfb9a===_0x125ff3(0x8bf))return $gameTroop[_0x125ff3(0xb58)]();else{if(_0x4cfb9a[_0x125ff3(0x820)](/ENEMY INDEX (\d+)/i)){const _0x41936c=Number(RegExp['$1']);return[$gameTroop[_0x125ff3(0x6bd)]()[_0x41936c]];}else{if(_0x4cfb9a['match'](/ENEMY ID (\d+)/i)){const _0x24b7bc=Number(RegExp['$1']);return $gameTroop[_0x125ff3(0x14b)]()[_0x125ff3(0x9f4)](_0x2ee869=>_0x2ee869[_0x125ff3(0x888)]()===_0x24b7bc);}}}}}}if(_0x4cfb9a==='alive\x20battlers')return _0x611d5[_0x125ff3(0x9f4)](_0x28b0ab=>_0x28b0ab[_0x125ff3(0x694)]());else{if(_0x4cfb9a===_0x125ff3(0x2e3))return _0x611d5[_0x125ff3(0x9f4)](_0x4bde24=>_0x4bde24[_0x125ff3(0x694)]()&&_0x4bde24!==_0x3593a5);else{if(_0x4cfb9a===_0x125ff3(0x8a4))return _0x611d5[_0x125ff3(0x9f4)](_0x4bfd43=>_0x4bfd43[_0x125ff3(0x694)]()&&_0x4bfd43!==_0x133067);else{if(_0x4cfb9a===_0x125ff3(0x87a))return _0x611d5['filter'](_0x550940=>_0x550940[_0x125ff3(0x4a5)]());}}}return[];},VisuMZ[_0x4bcec6(0x332)]=function(){const _0x4f181a=_0x4bcec6;return BattleManager[_0x4f181a(0x78f)];},VisuMZ[_0x4bcec6(0x174)]=function(_0x243539){const _0x5114dc=_0x4bcec6;return BattleManager[_0x5114dc(0x78f)];},PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x8e5),_0xa0f878=>{const _0x291824=_0x4bcec6;if(!SceneManager[_0x291824(0x772)]())return;VisuMZ[_0x291824(0x9b1)](_0xa0f878,_0xa0f878);const _0xb11595=$gameTemp[_0x291824(0x475)](),_0x10d156=BattleManager['_action'],_0x511506=BattleManager[_0x291824(0xba3)],_0x241c32=BattleManager[_0x291824(0x361)]?BattleManager[_0x291824(0x361)]['slice'](0x0):[],_0x4fab3a=BattleManager[_0x291824(0x7ed)];if(!_0xb11595||!_0x10d156||!_0x511506)return;if(!_0x10d156[_0x291824(0x93c)]())return;if(_0xa0f878[_0x291824(0x5bf)])_0x4fab3a[_0x291824(0x273)](_0x511506,_0x10d156[_0x291824(0x93c)]());_0xa0f878[_0x291824(0x9ed)]&&_0x4fab3a[_0x291824(0x27a)](_0x291824(0x6f6),_0x511506,_0x241c32,!![]);if(_0xa0f878[_0x291824(0x901)])_0x4fab3a['push'](_0x291824(0x9c3),_0x511506,_0x10d156);if(_0xa0f878[_0x291824(0x303)])_0x4fab3a[_0x291824(0x27a)](_0x291824(0x9c6));if(_0xa0f878[_0x291824(0x2a1)])_0x4fab3a[_0x291824(0x27a)](_0x291824(0x7d2),_0x511506,_0x10d156);if(_0xa0f878[_0x291824(0x3bc)])_0x4fab3a[_0x291824(0x27a)](_0x291824(0xb8e));_0xb11595[_0x291824(0x23d)](_0x291824(0x3a2));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Set_WholeActionSet',_0x3ac4d9=>{const _0x5818fd=_0x4bcec6;if(!SceneManager[_0x5818fd(0x772)]())return;VisuMZ[_0x5818fd(0x9b1)](_0x3ac4d9,_0x3ac4d9);const _0x4a7728=$gameTemp[_0x5818fd(0x475)](),_0x15bfd7=BattleManager['_action'],_0x53011a=BattleManager[_0x5818fd(0xba3)],_0x2eba36=BattleManager['_allTargets']?BattleManager[_0x5818fd(0x361)][_0x5818fd(0x9dd)](0x0):[],_0x2458e7=BattleManager['_logWindow'],_0x11e6c9=_0x3ac4d9['DualWield']??![];if(!_0x4a7728||!_0x15bfd7||!_0x53011a)return;if(!_0x15bfd7[_0x5818fd(0x93c)]())return;let _0x37b2c1=_0x11e6c9?_0x2458e7[_0x5818fd(0x339)](_0x53011a):0x1;for(let _0x151ab2=0x0;_0x151ab2<_0x37b2c1;_0x151ab2++){_0x11e6c9&&_0x53011a['isActor']()&&_0x2458e7['push'](_0x5818fd(0x243),_0x53011a,_0x151ab2);if(_0x3ac4d9['PerformAction'])_0x2458e7[_0x5818fd(0x27a)](_0x5818fd(0x2ba),_0x53011a,_0x15bfd7);if(_0x3ac4d9[_0x5818fd(0x342)]>0x0)_0x2458e7[_0x5818fd(0x27a)]('waitCount',_0x3ac4d9['WaitCount']);if(_0x3ac4d9[_0x5818fd(0x447)])_0x2458e7['push'](_0x5818fd(0x275),_0x53011a,_0x2eba36,_0x15bfd7['item']()[_0x5818fd(0x1b4)]);if(_0x3ac4d9['WaitForAnimation'])_0x2458e7[_0x5818fd(0x27a)]('waitForAnimation');for(const _0x22c24e of _0x2eba36){if(!_0x22c24e)continue;if(_0x3ac4d9[_0x5818fd(0xab5)])_0x2458e7[_0x5818fd(0x27a)](_0x5818fd(0x78e),_0x53011a,_0x22c24e);}}_0x11e6c9&&_0x53011a['isActor']()&&_0x2458e7[_0x5818fd(0x27a)](_0x5818fd(0x6ab),_0x53011a);if(_0x3ac4d9[_0x5818fd(0x9ed)])_0x2458e7[_0x5818fd(0x27a)](_0x5818fd(0x6f6),_0x53011a,_0x2eba36,![]);_0x4a7728[_0x5818fd(0x23d)](_0x5818fd(0x3a2));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xb48),_0x5eefdb=>{const _0x5f0ed3=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x5f0ed3(0x9b1)](_0x5eefdb,_0x5eefdb);const _0x596686=$gameTemp[_0x5f0ed3(0x475)](),_0x137205=BattleManager['_action'],_0x325763=BattleManager[_0x5f0ed3(0xba3)],_0x59b745=BattleManager[_0x5f0ed3(0x361)]?BattleManager[_0x5f0ed3(0x361)][_0x5f0ed3(0x9dd)](0x0):[],_0x4593e2=BattleManager[_0x5f0ed3(0x7ed)],_0x1c8427=_0x5eefdb[_0x5f0ed3(0x407)]??![];if(!_0x596686||!_0x137205||!_0x325763)return;if(!_0x137205[_0x5f0ed3(0x93c)]())return;let _0x124948=_0x1c8427?_0x4593e2[_0x5f0ed3(0x339)](_0x325763):0x1;for(let _0x2ce43d=0x0;_0x2ce43d<_0x124948;_0x2ce43d++){for(const _0x537a36 of _0x59b745){if(!_0x537a36)continue;_0x1c8427&&_0x325763['isActor']()&&_0x4593e2[_0x5f0ed3(0x27a)]('setActiveWeaponSet',_0x325763,_0x2ce43d);if(_0x5eefdb[_0x5f0ed3(0xfd)])_0x4593e2[_0x5f0ed3(0x27a)](_0x5f0ed3(0x2ba),_0x325763,_0x137205);if(_0x5eefdb[_0x5f0ed3(0x6eb)]>0x0)_0x4593e2[_0x5f0ed3(0x27a)](_0x5f0ed3(0x10e),_0x5eefdb['WaitCount1']);if(_0x5eefdb[_0x5f0ed3(0x447)])_0x4593e2[_0x5f0ed3(0x27a)](_0x5f0ed3(0x275),_0x325763,[_0x537a36],_0x137205['item']()[_0x5f0ed3(0x1b4)]);if(_0x5eefdb[_0x5f0ed3(0xbed)]>0x0)_0x4593e2[_0x5f0ed3(0x27a)]('waitCount',_0x5eefdb[_0x5f0ed3(0xbed)]);if(_0x5eefdb[_0x5f0ed3(0xab5)])_0x4593e2[_0x5f0ed3(0x27a)]('actionEffect',_0x325763,_0x537a36);}}_0x1c8427&&_0x325763['isActor']()&&_0x4593e2[_0x5f0ed3(0x27a)](_0x5f0ed3(0x6ab),_0x325763);if(_0x5eefdb[_0x5f0ed3(0x9ed)])_0x4593e2['push'](_0x5f0ed3(0x6f6),_0x325763,_0x59b745,![]);_0x596686[_0x5f0ed3(0x23d)](_0x5f0ed3(0x3a2));}),PluginManager['registerCommand'](pluginData['name'],_0x4bcec6(0x6e8),_0x14c7d3=>{const _0x48af06=_0x4bcec6;if(!SceneManager[_0x48af06(0x772)]())return;VisuMZ['ConvertParams'](_0x14c7d3,_0x14c7d3);const _0x55d242=$gameTemp[_0x48af06(0x475)](),_0x98723f=BattleManager[_0x48af06(0x3fd)],_0x26c386=BattleManager[_0x48af06(0xba3)],_0x5c536a=BattleManager[_0x48af06(0x361)]?BattleManager[_0x48af06(0x361)]['slice'](0x0):[],_0x154b4c=BattleManager['_logWindow'];if(!_0x55d242||!_0x98723f||!_0x26c386)return;if(!_0x98723f['item']())return;if(_0x14c7d3[_0x48af06(0x9ed)])_0x154b4c['push'](_0x48af06(0x6f6),_0x26c386,_0x5c536a,![]);if(_0x14c7d3['WaitForNewLine'])_0x154b4c['push'](_0x48af06(0x838));if(_0x14c7d3[_0x48af06(0xaa6)])_0x154b4c['push'](_0x48af06(0xb04));if(_0x14c7d3[_0x48af06(0xa82)])_0x154b4c['push'](_0x48af06(0x885));if(_0x14c7d3['ActionEnd'])_0x154b4c[_0x48af06(0x27a)](_0x48af06(0x815),_0x26c386);if(_0x14c7d3[_0x48af06(0x303)])_0x154b4c[_0x48af06(0x27a)](_0x48af06(0x9c6));_0x55d242[_0x48af06(0x23d)](_0x48af06(0x3a2));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x6f9),_0xaea7b4=>{const _0x9a2f91=_0x4bcec6;if(!SceneManager[_0x9a2f91(0x772)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ[_0x9a2f91(0x9b1)](_0xaea7b4,_0xaea7b4);const _0x269b02=$gameTemp[_0x9a2f91(0x475)](),_0x499363=_0xaea7b4[_0x9a2f91(0x198)];if(!_0x269b02)return;$gameScreen[_0x9a2f91(0x4a4)](_0xaea7b4[_0x9a2f91(0xaa1)],_0xaea7b4[_0x9a2f91(0x161)],_0xaea7b4['EasingType']);if(_0x499363)_0x269b02[_0x9a2f91(0x23d)]('battleAngle');}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x222),_0x41174f=>{const _0x370334=_0x4bcec6;if(!SceneManager[_0x370334(0x772)]())return;if(!Imported[_0x370334(0x3f5)])return;VisuMZ['ConvertParams'](_0x41174f,_0x41174f);const _0x577fa3=$gameTemp[_0x370334(0x475)](),_0x2d4f56=_0x41174f['WaitForAngle'];if(!_0x577fa3)return;$gameScreen['setBattleAngle'](0x0,_0x41174f[_0x370334(0x161)],_0x41174f[_0x370334(0x1c0)]);if(_0x2d4f56)_0x577fa3[_0x370334(0x23d)](_0x370334(0x7c4));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x4d1),_0x6282ae=>{const _0x4163ca=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x4163ca(0x3f5)])return;const _0x2009aa=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x2009aa)return;_0x2009aa[_0x4163ca(0x23d)](_0x4163ca(0x7c4));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x491),_0x1df1d5=>{const _0x2c8244=_0x4bcec6;if(!SceneManager[_0x2c8244(0x772)]())return;VisuMZ['ConvertParams'](_0x1df1d5,_0x1df1d5);const _0x2102a9=$gameTemp['getLastPluginCommandInterpreter'](),_0x8669ac=BattleManager[_0x2c8244(0x3fd)],_0x524f3e=BattleManager[_0x2c8244(0xba3)],_0x4445fe=VisuMZ[_0x2c8244(0x8bd)](_0x1df1d5[_0x2c8244(0x5bc)]),_0x770891=_0x1df1d5['Mirror'],_0x3b8166=BattleManager[_0x2c8244(0x7ed)];if(!_0x2102a9||!_0x8669ac||!_0x524f3e)return;if(!_0x8669ac[_0x2c8244(0x93c)]())return;let _0x38b241=_0x8669ac[_0x2c8244(0x93c)]()['animationId'];if(_0x38b241<0x0)_0x38b241=_0x524f3e[_0x2c8244(0x85b)]();$gameTemp['requestAnimation'](_0x4445fe,_0x38b241,_0x770891),_0x1df1d5[_0x2c8244(0x3bc)]&&_0x2102a9[_0x2c8244(0x23d)](_0x2c8244(0x446));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x8b9),_0x3eaf39=>{const _0x6190f9=_0x4bcec6;if(!SceneManager[_0x6190f9(0x772)]())return;VisuMZ[_0x6190f9(0x9b1)](_0x3eaf39,_0x3eaf39);const _0x544512=$gameTemp[_0x6190f9(0x475)](),_0x293907=BattleManager[_0x6190f9(0xba3)],_0x18e5d6=VisuMZ[_0x6190f9(0x8bd)](_0x3eaf39[_0x6190f9(0x5bc)]),_0x36b722=_0x3eaf39['Mirror'],_0x398ecc=BattleManager[_0x6190f9(0x7ed)];if(!_0x544512||!_0x293907)return;const _0x4304fb=_0x293907[_0x6190f9(0x85b)]();$gameTemp['requestAnimation'](_0x18e5d6,_0x4304fb,_0x36b722),_0x3eaf39[_0x6190f9(0x3bc)]&&_0x544512[_0x6190f9(0x23d)](_0x6190f9(0x446));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Animation_AttackAnimation2',_0x4e579f=>{const _0x269d69=_0x4bcec6;if(!SceneManager[_0x269d69(0x772)]())return;VisuMZ[_0x269d69(0x9b1)](_0x4e579f,_0x4e579f);const _0x30bbd1=_0x59568b[_0x269d69(0x3fa)](_0x4e579f[_0x269d69(0x3bd)]);if(_0x30bbd1<=0x0)return;const _0x165f3f=$gameTemp[_0x269d69(0x475)](),_0x59568b=BattleManager['_subject'],_0x1b7200=VisuMZ[_0x269d69(0x8bd)](_0x4e579f['Targets']),_0x2c43c0=_0x4e579f[_0x269d69(0x9c2)],_0x545518=BattleManager[_0x269d69(0x7ed)];if(!_0x165f3f||!_0x59568b)return;$gameTemp[_0x269d69(0x6f8)](_0x1b7200,_0x30bbd1,_0x2c43c0),_0x4e579f[_0x269d69(0x3bc)]&&_0x165f3f[_0x269d69(0x23d)](_0x269d69(0x446));}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],'ActSeq_Animation_BalloonAnimation',_0x57cbd3=>{const _0x49f849=_0x4bcec6;if(!SceneManager[_0x49f849(0x772)]())return;VisuMZ[_0x49f849(0x9b1)](_0x57cbd3,_0x57cbd3);const _0xcbbb8d=$gameTemp[_0x49f849(0x475)](),_0x348b7d=VisuMZ[_0x49f849(0x8bd)](_0x57cbd3[_0x49f849(0x5bc)]),_0x985141=_0x57cbd3['Balloon'];let _0x83a17b=0x0;switch(_0x985141[_0x49f849(0x1fd)]()[_0x49f849(0x7d5)]()){case'!':case _0x49f849(0x7aa):_0x83a17b=0x1;break;case'?':case'QUESTION':_0x83a17b=0x2;break;case _0x49f849(0x4a1):case'NOTE':case _0x49f849(0x9ab):case'MUSIC-NOTE':case _0x49f849(0x655):_0x83a17b=0x3;break;case _0x49f849(0x44f):case _0x49f849(0x638):_0x83a17b=0x4;break;case _0x49f849(0x19b):case _0x49f849(0xc09):_0x83a17b=0x5;break;case _0x49f849(0x86f):_0x83a17b=0x6;break;case _0x49f849(0x3f0):case _0x49f849(0xb72):case'FRUSTRATION':_0x83a17b=0x7;break;case _0x49f849(0x214):case _0x49f849(0x113):_0x83a17b=0x8;break;case _0x49f849(0xa01):case _0x49f849(0x4e2):case _0x49f849(0xb43):case _0x49f849(0x538):case _0x49f849(0xbd6):_0x83a17b=0x9;break;case'Z':case'ZZ':case'ZZZ':case _0x49f849(0xbe3):_0x83a17b=0xa;break;case _0x49f849(0x486):_0x83a17b=0xb;break;case _0x49f849(0x7a9):_0x83a17b=0xc;break;case'USER-DEFINED\x203':_0x83a17b=0xd;break;case'USER-DEFINED\x204':_0x83a17b=0xe;break;case'USER-DEFINED\x205':_0x83a17b=0xf;break;}for(const _0x3473e5 of _0x348b7d){if(!_0x3473e5)continue;$gameTemp[_0x49f849(0x659)](_0x3473e5,_0x83a17b);}_0x57cbd3['WaitComplete']&&_0xcbbb8d&&(_0xcbbb8d[_0x49f849(0x4b6)](0x1),_0xcbbb8d['setWaitMode'](_0x49f849(0xb5e)));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x6dd),_0x55114d=>{const _0x3d0cd9=_0x4bcec6;if(!SceneManager[_0x3d0cd9(0x772)]())return;if(!Imported[_0x3d0cd9(0x2fd)])return;VisuMZ[_0x3d0cd9(0x9b1)](_0x55114d,_0x55114d);const _0xdef9af=$gameTemp[_0x3d0cd9(0x475)](),_0x1f13b6=VisuMZ['CreateActionSequenceTargets'](_0x55114d[_0x3d0cd9(0x5bc)]),_0x198f18=_0x55114d['IconIndex'];for(const _0x551717 of _0x1f13b6){if(!_0x551717)continue;$gameTemp['requestBattleBalloon'](_0x551717,[_0x198f18]);}_0x55114d[_0x3d0cd9(0x2e7)]&&_0xdef9af&&(_0xdef9af[_0x3d0cd9(0x4b6)](0x1),_0xdef9af[_0x3d0cd9(0x23d)](_0x3d0cd9(0xb5e)));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x79e),_0x53dbe1=>{const _0x2b3ea3=_0x4bcec6;if(!SceneManager[_0x2b3ea3(0x772)]())return;if(!Imported[_0x2b3ea3(0x2fd)])return;VisuMZ[_0x2b3ea3(0x9b1)](_0x53dbe1,_0x53dbe1);const _0x1de494=$gameTemp['getLastPluginCommandInterpreter'](),_0x34a7b1=VisuMZ[_0x2b3ea3(0x8bd)](_0x53dbe1['Targets']),_0x3b5ce1=Math[_0x2b3ea3(0x540)](Number(_0x53dbe1[_0x2b3ea3(0x63d)]||0x0),Number(_0x53dbe1['endIcon']||0x0)),_0x322c23=Math['max'](Number(_0x53dbe1['startIcon']||0x0),Number(_0x53dbe1[_0x2b3ea3(0x732)]||0x0)),_0x30a139=[];for(let _0x4f83a8=_0x3b5ce1;_0x4f83a8<=_0x322c23;_0x4f83a8++){_0x30a139[_0x2b3ea3(0x27a)](_0x4f83a8);}for(const _0x4c49b2 of _0x34a7b1){if(!_0x4c49b2)continue;$gameTemp['requestBattleBalloon'](_0x4c49b2,_0x30a139);}_0x53dbe1['WaitComplete']&&_0x1de494&&(_0x1de494[_0x2b3ea3(0x4b6)](0x1),_0x1de494[_0x2b3ea3(0x23d)](_0x2b3ea3(0xb5e)));}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Animation_BalloonIconSpecific',_0xf03d81=>{const _0xec5287=_0x4bcec6;if(!SceneManager[_0xec5287(0x772)]())return;if(!Imported[_0xec5287(0x2fd)])return;VisuMZ['ConvertParams'](_0xf03d81,_0xf03d81);const _0x13bfe0=$gameTemp[_0xec5287(0x475)](),_0x4a7aa6=VisuMZ[_0xec5287(0x8bd)](_0xf03d81[_0xec5287(0x5bc)]),_0x1db37d=_0xf03d81[_0xec5287(0x32f)];for(const _0x22901a of _0x4a7aa6){if(!_0x22901a)continue;$gameTemp['requestBattleBalloon'](_0x22901a,_0x1db37d);}_0xf03d81[_0xec5287(0x2e7)]&&_0x13bfe0&&(_0x13bfe0[_0xec5287(0x4b6)](0x1),_0x13bfe0[_0xec5287(0x23d)](_0xec5287(0xb5e)));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x8b8),_0xf08a33=>{const _0x5823a8=_0x4bcec6;if(!SceneManager[_0x5823a8(0x772)]())return;VisuMZ[_0x5823a8(0x9b1)](_0xf08a33,_0xf08a33);const _0x5dd3ea=$gameTemp[_0x5823a8(0x475)](),_0x2520a6=BattleManager[_0x5823a8(0x3fd)],_0xaa3bc5=_0xf08a33[_0x5823a8(0x9c2)],_0x59cb6b=VisuMZ[_0x5823a8(0x8bd)](_0xf08a33[_0x5823a8(0x5bc)]);if(!_0x5dd3ea||!_0x2520a6)return;if(!_0x2520a6['item']())return;for(const _0x2b86a1 of _0x59cb6b){if(!_0x2b86a1)continue;_0x2b86a1[_0x5823a8(0x7d2)](_0x2520a6,_0xaa3bc5);}if(_0xf08a33['WaitForAnimation'])_0x5dd3ea[_0x5823a8(0x23d)](_0x5823a8(0x446));}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0xa15),_0x860b90=>{const _0x14fe4a=_0x4bcec6;VisuMZ[_0x14fe4a(0x9b1)](_0x860b90,_0x860b90);const _0x42e03c=$gameTemp[_0x14fe4a(0x475)](),_0x3b8e59=VisuMZ[_0x14fe4a(0x8bd)](_0x860b90[_0x14fe4a(0x5bc)]),_0x5a8ea5=_0x860b90[_0x14fe4a(0x4f7)];if(!_0x5a8ea5)return;for(const _0x4f24be of _0x3b8e59){if(!_0x4f24be)continue;if(!_0x4f24be[_0x14fe4a(0xbf8)]())continue;_0x4f24be[_0x14fe4a(0x62b)](_0x5a8ea5);}}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x91e),_0x29cc34=>{const _0x84ac9c=_0x4bcec6;VisuMZ[_0x84ac9c(0x9b1)](_0x29cc34,_0x29cc34);const _0x4b3c92=_0x29cc34['ActorJS'](),_0x4b77c1=$gameActors[_0x84ac9c(0x37d)](_0x4b3c92)||null;if(!_0x4b77c1){console['log'](_0x84ac9c(0x8a6));return;}const _0x29aefd=_0x29cc34[_0x84ac9c(0x8a5)]();_0x4b77c1[_0x84ac9c(0x62b)](_0x29aefd);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x952),_0xe32ea6=>{const _0x209504=_0x4bcec6;if(!SceneManager[_0x209504(0x772)]())return;VisuMZ[_0x209504(0x9b1)](_0xe32ea6,_0xe32ea6);const _0x594971=$gameTemp[_0x209504(0x475)](),_0x40f7a8=BattleManager[_0x209504(0xba3)],_0x4b10c3=VisuMZ['CreateActionSequenceTargets'](_0xe32ea6[_0x209504(0x5bc)]),_0x87b300=_0xe32ea6['Mirror'];if(!_0x594971||!_0x40f7a8)return;const _0x42dae5=$dataSkilles[_0x40f7a8['guardSkillId']()],_0x12bc9f=_0x42dae5['animationId'];$gameTemp[_0x209504(0x6f8)](_0x4b10c3,_0x12bc9f,_0x87b300),_0xe32ea6['WaitForAnimation']&&_0x594971[_0x209504(0x23d)](_0x209504(0x446));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x2d9),_0x593073=>{const _0x2ff55b=_0x4bcec6;if(!SceneManager[_0x2ff55b(0x772)]())return;VisuMZ[_0x2ff55b(0x9b1)](_0x593073,_0x593073);const _0x54092a=$gameTemp[_0x2ff55b(0x475)](),_0x19a566=VisuMZ[_0x2ff55b(0x8bd)](_0x593073[_0x2ff55b(0x5bc)]),_0x11d52f=Number(_0x593073[_0x2ff55b(0x22b)]||0x1),_0x3fa6e4=$dataItems[_0x11d52f],_0x467ac1=_0x593073[_0x2ff55b(0x9c2)];if(!_0x54092a)return;if(!_0x3fa6e4)return;let _0xc7c3e3=_0x3fa6e4[_0x2ff55b(0x1b4)];$gameTemp['requestAnimation'](_0x19a566,_0xc7c3e3,_0x467ac1),_0x593073[_0x2ff55b(0x3bc)]&&_0x54092a[_0x2ff55b(0x23d)]('battleAnimation');}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x5ea),_0x24f774=>{const _0x479769=_0x4bcec6;if(!SceneManager[_0x479769(0xb7c)])return;if(!SceneManager['_scene'][_0x479769(0x8c8)])return;if(!Imported['VisuMZ_0_CoreEngine'])return;VisuMZ[_0x479769(0x9b1)](_0x24f774,_0x24f774);const _0x3cd71e=$gameTemp[_0x479769(0x475)](),_0x42e24d=Math['round'](_0x24f774[_0x479769(0x8b5)]),_0x212d64=Math[_0x479769(0x7f7)](_0x24f774[_0x479769(0x2f8)]);$gameTemp[_0x479769(0x8d3)](_0x42e24d,_0x212d64,_0x24f774[_0x479769(0x682)],_0x24f774[_0x479769(0x9c2)],_0x24f774[_0x479769(0x9e3)]),_0x24f774[_0x479769(0x2e7)]&&_0x3cd71e&&(SceneManager[_0x479769(0xb7c)][_0x479769(0x8c8)]['updatePointAnimations'](),_0x3cd71e[_0x479769(0x23d)](_0x479769(0x446)));}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],'ActSeq_Animation_ShowAnimation',_0x480241=>{const _0x16c778=_0x4bcec6;if(!SceneManager[_0x16c778(0x772)]())return;VisuMZ[_0x16c778(0x9b1)](_0x480241,_0x480241);const _0x5af326=$gameTemp[_0x16c778(0x475)](),_0x1f7fec=VisuMZ['CreateActionSequenceTargets'](_0x480241[_0x16c778(0x5bc)]),_0x518068=_0x480241['AnimationID'],_0x548f46=_0x480241[_0x16c778(0x9c2)];if(!_0x5af326)return;$gameTemp[_0x16c778(0x6f8)](_0x1f7fec,_0x518068,_0x548f46);if(_0x480241['WaitForAnimation'])_0x5af326[_0x16c778(0x23d)]('battleAnimation');}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x109),_0x2a73f1=>{const _0x107c98=_0x4bcec6;if(!SceneManager[_0x107c98(0x772)]())return;VisuMZ[_0x107c98(0x9b1)](_0x2a73f1,_0x2a73f1);const _0x7a2388=$gameTemp[_0x107c98(0x475)](),_0x1c6a7e=VisuMZ[_0x107c98(0x8bd)](_0x2a73f1[_0x107c98(0x5bc)]),_0x99c324=Number(_0x2a73f1[_0x107c98(0x682)])||0x1,_0x25bdb0=_0x2a73f1[_0x107c98(0x9c2)];if(!_0x7a2388)return;$gameTemp['requestAnimation'](_0x1c6a7e,_0x99c324,_0x25bdb0);if(_0x2a73f1['WaitForAnimation'])_0x7a2388[_0x107c98(0x23d)]('battleAnimation');}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x847),_0x1dc6dc=>{const _0x37c5ed=_0x4bcec6;if(!SceneManager[_0x37c5ed(0x772)]())return;VisuMZ[_0x37c5ed(0x9b1)](_0x1dc6dc,_0x1dc6dc);const _0x1ae009=$gameTemp[_0x37c5ed(0x475)](),_0x4f665e=VisuMZ['CreateActionSequenceTargets'](_0x1dc6dc[_0x37c5ed(0x5bc)]),_0x4e629d=Number(_0x1dc6dc['SkillID']||0x1),_0x5a05c6=$dataSkills[_0x4e629d],_0x897c2c=_0x1dc6dc['Mirror'];if(!_0x1ae009)return;if(!_0x5a05c6)return;let _0x3e6f3e=_0x5a05c6[_0x37c5ed(0x1b4)];$gameTemp[_0x37c5ed(0x6f8)](_0x4f665e,_0x3e6f3e,_0x897c2c),_0x1dc6dc['WaitForAnimation']&&_0x1ae009[_0x37c5ed(0x23d)](_0x37c5ed(0x446));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xa97),_0x529c06=>{const _0x139472=_0x4bcec6;if(!SceneManager[_0x139472(0x772)]())return;const _0x202357=$gameTemp[_0x139472(0x475)]();if(!_0x202357)return;_0x202357[_0x139472(0x23d)](_0x139472(0x446));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x80e),_0x482157=>{const _0x173e31=_0x4bcec6;if(!SceneManager[_0x173e31(0x772)]())return;VisuMZ[_0x173e31(0x9b1)](_0x482157,_0x482157);const _0x360311=BattleManager[_0x173e31(0x7ed)],_0x3f6e60=_0x482157[_0x173e31(0x360)]&&Imported[_0x173e31(0x7eb)];_0x360311[_0x173e31(0xc01)](_0x482157[_0x173e31(0x35a)]),_0x3f6e60&&Imported['VisuMZ_4_CombatLog']&&$gameSystem['addTextToCombatLog'](_0x482157[_0x173e31(0x35a)]||'',_0x482157[_0x173e31(0x3c2)]||0x0);}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],'ActSeq_BattleLog_Clear',_0x3a62b2=>{if(!SceneManager['isSceneBattle']())return;const _0x4c4d7d=BattleManager['_logWindow'];_0x4c4d7d['clear']();}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x137),_0x9ba3d9=>{const _0x4d7a87=_0x4bcec6;if(!SceneManager[_0x4d7a87(0x772)]())return;const _0x12afc6=$gameTemp[_0x4d7a87(0x475)](),_0x17aa4f=BattleManager[_0x4d7a87(0x3fd)],_0x5961a1=BattleManager['_subject'],_0x48c0cb=BattleManager[_0x4d7a87(0x7ed)];if(!_0x12afc6||!_0x17aa4f||!_0x5961a1)return;if(!_0x17aa4f['item']())return;_0x48c0cb[_0x4d7a87(0x273)](_0x5961a1,_0x17aa4f[_0x4d7a87(0x93c)]()),_0x12afc6[_0x4d7a87(0x23d)]('battlelog');}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xb29),_0x369054=>{const _0x989091=_0x4bcec6;if(!SceneManager[_0x989091(0x772)]())return;const _0x5a6431=BattleManager[_0x989091(0x7ed)];_0x5a6431['popBaseLine']();}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x9e9),_0x4c0c79=>{const _0xf088c=_0x4bcec6;if(!SceneManager[_0xf088c(0x772)]())return;const _0x5f4c3e=BattleManager[_0xf088c(0x7ed)];_0x5f4c3e[_0xf088c(0x656)]();}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x9f7),_0x447d27=>{const _0x22ebe8=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;const _0xc806c3=BattleManager[_0x22ebe8(0x7ed)];_0xc806c3[_0x22ebe8(0x4da)]();}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x9c8),_0x54266a=>{const _0x3eca25=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x3eca25(0x9b1)](_0x54266a,_0x54266a),SceneManager[_0x3eca25(0xb7c)][_0x3eca25(0x599)](_0x54266a['ShowHide']);}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x74f),_0x16b419=>{const _0x2f1e89=_0x4bcec6;if(!SceneManager[_0x2f1e89(0x772)]())return;const _0x5f1aa9=$gameTemp[_0x2f1e89(0x475)]();_0x5f1aa9[_0x2f1e89(0x23d)](_0x2f1e89(0x3a2));}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x2ab),_0x24db24=>{const _0x161bf7=_0x4bcec6;if(!SceneManager[_0x161bf7(0x772)]())return;const _0x560f12=$gameTemp['getLastPluginCommandInterpreter'](),_0x2c2337=BattleManager['_logWindow'];_0x2c2337[_0x161bf7(0x838)](),_0x560f12['setWaitMode'](_0x161bf7(0x3a2));}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],'ActSeq_Camera_Clamp',_0x59e196=>{const _0x3722c9=_0x4bcec6;if(!SceneManager[_0x3722c9(0x772)]())return;if(!Imported[_0x3722c9(0x3f5)])return;VisuMZ[_0x3722c9(0x9b1)](_0x59e196,_0x59e196);const _0xf6ab20=$gameScreen[_0x3722c9(0x8c4)]();_0xf6ab20['cameraClamp']=_0x59e196[_0x3722c9(0x212)];}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x663),_0x2a8e08=>{const _0x4dbf36=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x4dbf36(0x3f5)])return;VisuMZ[_0x4dbf36(0x9b1)](_0x2a8e08,_0x2a8e08);const _0x4de066=$gameTemp[_0x4dbf36(0x475)](),_0x5a627a=_0x2a8e08[_0x4dbf36(0x4b7)];$gameScreen['setBattleCameraPoint'](_0x2a8e08[_0x4dbf36(0x295)],_0x2a8e08['FocusY'],_0x2a8e08[_0x4dbf36(0x161)],_0x2a8e08[_0x4dbf36(0x1c0)]);if(_0x5a627a)_0x4de066[_0x4dbf36(0x23d)](_0x4dbf36(0x367));}),PluginManager['registerCommand'](pluginData['name'],'ActSeq_Camera_FocusTarget',_0x1018f5=>{const _0x3a68e1=_0x4bcec6;if(!SceneManager[_0x3a68e1(0x772)]())return;if(!Imported[_0x3a68e1(0x3f5)])return;VisuMZ[_0x3a68e1(0x9b1)](_0x1018f5,_0x1018f5);const _0x19d7be=$gameTemp[_0x3a68e1(0x475)](),_0x266135=VisuMZ[_0x3a68e1(0x8bd)](_0x1018f5['Targets']),_0x57a740=_0x1018f5[_0x3a68e1(0x4b7)];$gameScreen[_0x3a68e1(0x81c)](_0x266135,_0x1018f5['Duration'],_0x1018f5[_0x3a68e1(0x1c0)]);if(_0x57a740)_0x19d7be['setWaitMode'](_0x3a68e1(0x367));}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x6a6),_0x251de8=>{const _0xac7740=_0x4bcec6;if(!SceneManager[_0xac7740(0x772)]())return;if(!Imported[_0xac7740(0x3f5)])return;VisuMZ[_0xac7740(0x9b1)](_0x251de8,_0x251de8);const _0x3ce4bd=$gameTemp[_0xac7740(0x475)](),_0x393932=_0x251de8[_0xac7740(0x4b7)];$gameScreen[_0xac7740(0xa30)](_0x251de8[_0xac7740(0x2ca)],_0x251de8[_0xac7740(0x651)],_0x251de8['Duration'],_0x251de8['EasingType']);if(_0x393932)_0x3ce4bd['setWaitMode'](_0xac7740(0x367));}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x3e3),_0xec955c=>{const _0xf9f42=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0xf9f42(0x3f5)])return;VisuMZ[_0xf9f42(0x9b1)](_0xec955c,_0xec955c);const _0x389c12=$gameTemp[_0xf9f42(0x475)](),_0x53a716=_0xec955c['ResetFocus'],_0x510715=_0xec955c[_0xf9f42(0x735)],_0x4bf805=_0xec955c[_0xf9f42(0x4b7)];if(_0x53a716){const _0x2a37d1=Math[_0xf9f42(0x7f7)](Graphics[_0xf9f42(0xc08)]/0x2),_0x3f50ff=Math['round'](Graphics['height']/0x2);$gameScreen[_0xf9f42(0x388)](_0x2a37d1,_0x3f50ff,_0xec955c['Duration'],_0xec955c[_0xf9f42(0x1c0)]);}_0x510715&&$gameScreen[_0xf9f42(0xa30)](0x0,0x0,_0xec955c[_0xf9f42(0x161)],_0xec955c['EasingType']);if(_0x4bf805)_0x389c12['setWaitMode'](_0xf9f42(0x367));}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x8f3),_0x1c0866=>{const _0x108795=_0x4bcec6;if(!SceneManager[_0x108795(0x772)]())return;if(!Imported[_0x108795(0x3f5)])return;const _0xfa0f36=$gameTemp[_0x108795(0x475)]();if(!_0xfa0f36)return;_0xfa0f36[_0x108795(0x23d)](_0x108795(0x367));}),VisuMZ[_0x4bcec6(0x377)]['CreateCutinSettings']=function(_0x21ee1c){const _0x5a8997=_0x4bcec6;_0x21ee1c[_0x5a8997(0x780)]='';const _0x296e3e=VisuMZ[_0x5a8997(0x92b)][_0x5a8997(0x49f)](_0x21ee1c),_0x5a90f4=VisuMZ[_0x5a8997(0x8bd)](_0x21ee1c[_0x5a8997(0x5bc)])[0x0]||null;return _0x5a90f4&&(_0x296e3e['portraitFilename']=_0x5a90f4[_0x5a8997(0xa58)](),_0x296e3e[_0x5a8997(0x119)]=_0x5a90f4[_0x5a8997(0x79a)](),_0x296e3e['portraitHue']=_0x5a90f4[_0x5a8997(0xb21)](),_0x296e3e['portraitType']=_0x5a90f4[_0x5a8997(0x315)](),_0x5a90f4[_0x5a8997(0x52e)]()&&(_0x5a90f4['flipVisualCutinHorz']()&&(_0x296e3e[_0x5a8997(0xb66)]=!_0x296e3e[_0x5a8997(0xb66)]),_0x5a90f4[_0x5a8997(0x846)]()&&(_0x296e3e[_0x5a8997(0x331)]=!_0x296e3e['portraitFlipVert']),_0x296e3e[_0x5a8997(0x2b2)]===_0x5a8997(0x9bd)&&(_0x296e3e[_0x5a8997(0xb66)]=!_0x296e3e[_0x5a8997(0xb66)]),_0x21ee1c[_0x5a8997(0x6da)][_0x5a8997(0x197)]&&(_0x296e3e['parallaxScrollX']*=-0x1),_0x21ee1c[_0x5a8997(0x6da)][_0x5a8997(0x4a3)]&&(_0x296e3e['parallaxScrollY']*=-0x1),_0x296e3e['parallaxHue']+=_0x21ee1c[_0x5a8997(0x6da)][_0x5a8997(0xad7)]??0x0)),_0x296e3e;},PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x549),_0x3439d5=>{const _0x33703b=_0x4bcec6;if(!SceneManager[_0x33703b(0x772)]())return;if(!Imported[_0x33703b(0x87f)])return;VisuMZ[_0x33703b(0x9b1)](_0x3439d5,_0x3439d5);const _0x2d73b0=VisuMZ[_0x33703b(0x377)][_0x33703b(0x49f)](_0x3439d5);SceneManager[_0x33703b(0xb7c)][_0x33703b(0xa4e)](_0x2d73b0);const _0x59d89f=$gameTemp[_0x33703b(0x475)]();_0x59d89f&&_0x3439d5[_0x33703b(0x41a)]&&_0x59d89f[_0x33703b(0x23d)](_0x33703b(0x531));}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0xbee),_0x195e0d=>{const _0x1d7cd5=_0x4bcec6;if(!SceneManager[_0x1d7cd5(0x772)]())return;if(!Imported[_0x1d7cd5(0x87f)])return;VisuMZ[_0x1d7cd5(0x9b1)](_0x195e0d,_0x195e0d),SceneManager['_scene'][_0x1d7cd5(0x34d)]();const _0x5144ae=$gameTemp[_0x1d7cd5(0x475)]();_0x5144ae&&_0x195e0d['WaitForExit']&&_0x5144ae[_0x1d7cd5(0x23d)](_0x1d7cd5(0x7e3));}),PluginManager['registerCommand'](pluginData['name'],_0x4bcec6(0x9f3),_0x4a8d4c=>{const _0x36891b=_0x4bcec6;if(!SceneManager[_0x36891b(0x772)]())return;if(!Imported[_0x36891b(0x87f)])return;VisuMZ[_0x36891b(0x9b1)](_0x4a8d4c,_0x4a8d4c);const _0x3a14f5=_0x4a8d4c[_0x36891b(0xb4a)][_0x36891b(0xb8f)]()[_0x36891b(0x7d5)]();SceneManager[_0x36891b(0xb7c)]['endVisualCutin'](_0x3a14f5);const _0x44c3c6=$gameTemp[_0x36891b(0x475)]();_0x44c3c6&&_0x4a8d4c[_0x36891b(0x14d)]&&_0x44c3c6[_0x36891b(0x23d)](_0x36891b(0x7e3));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x637),_0x1055fa=>{const _0x297b39=_0x4bcec6;if(!SceneManager[_0x297b39(0x772)]())return;if(!Imported[_0x297b39(0x87f)])return;const _0x583d9e=$gameTemp[_0x297b39(0x475)]();_0x583d9e[_0x297b39(0x23d)]('cutinEnter');}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x934),_0x437f94=>{const _0x1a6f3c=_0x4bcec6;if(!SceneManager[_0x1a6f3c(0x772)]())return;if(!Imported[_0x1a6f3c(0x87f)])return;const _0x21b984=$gameTemp['getLastPluginCommandInterpreter']();_0x21b984[_0x1a6f3c(0x23d)](_0x1a6f3c(0x7e3));}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],'ActSeq_DB_DragonbonesMotionAni',_0x19a4ba=>{const _0x50364d=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x50364d(0x32e)])return;VisuMZ[_0x50364d(0x9b1)](_0x19a4ba,_0x19a4ba);const _0x26ad35=VisuMZ[_0x50364d(0x8bd)](_0x19a4ba[_0x50364d(0x5bc)]),_0x584b64=_0x19a4ba[_0x50364d(0x1c4)]['toLowerCase']()[_0x50364d(0x7d5)]();for(const _0x4c8e28 of _0x26ad35){if(!_0x4c8e28)continue;_0x4c8e28[_0x50364d(0xa43)](_0x584b64);}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x595),_0x21cfef=>{const _0x163a0e=_0x4bcec6;if(!SceneManager[_0x163a0e(0x772)]())return;if(!Imported['VisuMZ_2_DragonbonesUnion'])return;VisuMZ[_0x163a0e(0x9b1)](_0x21cfef,_0x21cfef);const _0x497b7b=VisuMZ[_0x163a0e(0x8bd)](_0x21cfef[_0x163a0e(0x5bc)]),_0x5a88c7=_0x21cfef[_0x163a0e(0x96e)];for(const _0xc1e141 of _0x497b7b){if(!_0xc1e141)continue;_0xc1e141[_0x163a0e(0x499)]()[_0x163a0e(0x6a8)]=_0x5a88c7;}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x65e),_0x386dae=>{const _0x5d23df=_0x4bcec6;if(!SceneManager[_0x5d23df(0x772)]())return;if(!Imported[_0x5d23df(0x73c)])return;VisuMZ[_0x5d23df(0x9b1)](_0x386dae,_0x386dae);const _0x10e9ac=BattleManager[_0x5d23df(0x3fd)],_0x1c34e2=_0x386dae['Elements'];if(!_0x10e9ac)return;_0x10e9ac[_0x5d23df(0x858)]=_0x1c34e2;}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x370),_0x122bbb=>{const _0x43bc11=_0x4bcec6;if(!SceneManager[_0x43bc11(0x772)]())return;if(!Imported[_0x43bc11(0x73c)])return;const _0x5d52ff=BattleManager[_0x43bc11(0x3fd)];if(!_0x5d52ff)return;_0x5d52ff[_0x43bc11(0x6aa)]();}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xa7f),_0x344f67=>{const _0xbdfd0d=_0x4bcec6;if(!SceneManager[_0xbdfd0d(0x772)]())return;if(!Imported[_0xbdfd0d(0x73c)])return;VisuMZ[_0xbdfd0d(0x9b1)](_0x344f67,_0x344f67);const _0x16a158=BattleManager[_0xbdfd0d(0x3fd)],_0x429d50=_0x344f67[_0xbdfd0d(0x7df)];if(!_0x16a158)return;_0x16a158[_0xbdfd0d(0xb60)]=_0x429d50;}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x821),_0x2bc934=>{const _0x52bbc6=_0x4bcec6;if(!SceneManager[_0x52bbc6(0x772)]())return;if(!Imported[_0x52bbc6(0x73c)])return;const _0x28808c=BattleManager[_0x52bbc6(0x3fd)];if(!_0x28808c)return;_0x28808c['_battleCoreNoElement']=!![];}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x7c6),_0x3df337=>{const _0x33e3da=_0x4bcec6;VisuMZ[_0x33e3da(0x94b)][_0x33e3da(0x7c6)](_0x3df337);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x683),_0x17c779=>{const _0x3f292d=_0x4bcec6;VisuMZ[_0x3f292d(0x94b)]['ActSeq_Grid_AddPassiveStatesToNode'](_0x17c779);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xa8e),_0x3c264b=>{const _0x380e4b=_0x4bcec6;VisuMZ[_0x380e4b(0x94b)][_0x380e4b(0xa8e)](_0x3c264b);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xa8d),_0x1c3b90=>{const _0x5605b6=_0x4bcec6;VisuMZ[_0x5605b6(0x94b)][_0x5605b6(0xa8e)](_0x1c3b90);}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Grid_AnimationIDAtNode',_0x127d3c=>{const _0xa7b350=_0x4bcec6;VisuMZ[_0xa7b350(0x94b)][_0xa7b350(0x556)](_0x127d3c);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x2a6),_0x4cf06d=>{const _0xc23276=_0x4bcec6;VisuMZ[_0xc23276(0x94b)]['ActSeq_Grid_AnimationJsAtNode'](_0x4cf06d);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x5f0),_0x32dfa5=>{VisuMZ['BattleGridSystem']['ActSeq_Grid_AnimationTypeAtNode'](_0x32dfa5);}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0xb4b),_0x1d5adc=>{const _0xbab605=_0x4bcec6;VisuMZ[_0xbab605(0x94b)][_0xbab605(0xb4b)](_0x1d5adc);}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0xb89),_0x2d27fd=>{const _0x5b2afe=_0x4bcec6;VisuMZ[_0x5b2afe(0x94b)]['ActSeq_Grid_MoveTargetsInDirection'](_0x2d27fd);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x1ad),_0x49bdb5=>{const _0x96f697=_0x4bcec6;VisuMZ[_0x96f697(0x94b)]['ActSeq_Grid_PullToTargetNode'](_0x49bdb5);}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x148),_0x27c465=>{const _0x3b814e=_0x4bcec6;VisuMZ[_0x3b814e(0x94b)][_0x3b814e(0x148)](_0x27c465);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xba2),_0x1c423b=>{const _0x3d6ee4=_0x4bcec6;VisuMZ['BattleGridSystem'][_0x3d6ee4(0xba2)](_0x1c423b);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x28b),_0x37bf44=>{const _0x427d1d=_0x4bcec6;VisuMZ[_0x427d1d(0x94b)][_0x427d1d(0x28b)](_0x37bf44);}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x3cf),_0x39f18b=>{VisuMZ['BattleGridSystem']['ActSeq_Grid_TeleportToNode'](_0x39f18b);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xbf6),_0x2f9e4c=>{VisuMZ['BattleGridSystem']['ActSeq_Grid_TraverseToNode'](_0x2f9e4c);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xac5),_0xdec125=>{const _0x4348f8=_0x4bcec6;if(!Imported['VisuMZ_2_HorrorEffects'])return;if(!SceneManager[_0x4348f8(0x772)]())return;VisuMZ['ConvertParams'](_0xdec125,_0xdec125);const _0xc11524=VisuMZ[_0x4348f8(0x8bd)](_0xdec125['Targets']);for(const _0x18da94 of _0xc11524){if(!_0x18da94)continue;_0x18da94['removeHorrorEffect'](_0x4348f8(0x1d2)),_0x18da94[_0x4348f8(0x97b)](_0x4348f8(0xbc6)),_0x18da94[_0x4348f8(0x97b)]('tv'),_0x18da94['clearHorrorEffects']();}$gamePlayer['refresh']();}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x84f),_0xc6f2cd=>{const _0x279698=_0x4bcec6;if(!Imported[_0x279698(0x678)])return;if(!SceneManager[_0x279698(0x772)]())return;VisuMZ[_0x279698(0x9b1)](_0xc6f2cd,_0xc6f2cd);const _0x55a90d=VisuMZ['CreateActionSequenceTargets'](_0xc6f2cd['Targets']),_0x52d817=_0x279698(0xbc6);_0xc6f2cd[_0x279698(0xb5b)]=Math['ceil'](_0xc6f2cd[_0x279698(0x2cc)]/0x2),_0xc6f2cd[_0x279698(0x85a)]=_0xc6f2cd[_0x279698(0x2cc)],_0xc6f2cd['refreshRequest']=!![];for(const _0x25230e of _0x55a90d){if(!_0x25230e)continue;_0x25230e['setHorrorEffectSettings'](_0x52d817,_0xc6f2cd);}$gamePlayer['refresh']();}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Horror_GlitchRemove',_0x2f761d=>{const _0x93fc81=_0x4bcec6;if(!Imported[_0x93fc81(0x678)])return;if(!SceneManager[_0x93fc81(0x772)]())return;VisuMZ[_0x93fc81(0x9b1)](_0x2f761d,_0x2f761d);const _0x163d35=VisuMZ[_0x93fc81(0x8bd)](_0x2f761d[_0x93fc81(0x5bc)]);for(const _0x1def9c of _0x163d35){if(!_0x1def9c)continue;_0x1def9c[_0x93fc81(0x97b)](_0x93fc81(0xbc6));}$gamePlayer['refresh']();}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x73d),_0x1d1fe2=>{const _0x4c8e75=_0x4bcec6;if(!Imported['VisuMZ_2_HorrorEffects'])return;if(!SceneManager[_0x4c8e75(0x772)]())return;VisuMZ[_0x4c8e75(0x9b1)](_0x1d1fe2,_0x1d1fe2);const _0x3cbd7f=VisuMZ['CreateActionSequenceTargets'](_0x1d1fe2[_0x4c8e75(0x5bc)]),_0x45fd06='noise';for(const _0xb5c6c of _0x3cbd7f){if(!_0xb5c6c)continue;_0xb5c6c[_0x4c8e75(0xb15)](_0x45fd06,_0x1d1fe2);}$gamePlayer[_0x4c8e75(0x4da)]();}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Horror_NoiseRemove',_0x4d5cb6=>{const _0x3dc133=_0x4bcec6;if(!Imported[_0x3dc133(0x678)])return;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x3dc133(0x9b1)](_0x4d5cb6,_0x4d5cb6);const _0x38e673=VisuMZ[_0x3dc133(0x8bd)](_0x4d5cb6[_0x3dc133(0x5bc)]);for(const _0xbc88a9 of _0x38e673){if(!_0xbc88a9)continue;_0xbc88a9['removeHorrorEffect'](_0x3dc133(0x1d2));}$gamePlayer[_0x3dc133(0x4da)]();}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xff),_0x4a1cf6=>{const _0x5d9396=_0x4bcec6;if(!Imported[_0x5d9396(0x678)])return;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x5d9396(0x9b1)](_0x4a1cf6,_0x4a1cf6);const _0x29be72=VisuMZ[_0x5d9396(0x8bd)](_0x4a1cf6['Targets']),_0x3b39ab='tv';for(const _0x22f2af of _0x29be72){if(!_0x22f2af)continue;_0x22f2af['setHorrorEffectSettings'](_0x3b39ab,_0x4a1cf6);}$gamePlayer['refresh']();}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x48f),_0x2de887=>{const _0x113d77=_0x4bcec6;if(!Imported[_0x113d77(0x678)])return;if(!SceneManager[_0x113d77(0x772)]())return;VisuMZ[_0x113d77(0x9b1)](_0x2de887,_0x2de887);const _0x1c9773=VisuMZ[_0x113d77(0x8bd)](_0x2de887[_0x113d77(0x5bc)]);for(const _0x5847f8 of _0x1c9773){if(!_0x5847f8)continue;_0x5847f8[_0x113d77(0x97b)]('tv');}$gamePlayer[_0x113d77(0x4da)]();}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x8e1),_0x177053=>{const _0x4ec23f=_0x4bcec6;if(!Imported[_0x4ec23f(0x39e)])return;const _0x3a5df1=SceneManager['_scene'][_0x4ec23f(0x8c8)];if(!_0x3a5df1)return;if(VisuMZ[_0x4ec23f(0x2b3)][_0x4ec23f(0x6e5)]<=1.04){alert(_0x4ec23f(0xa83)),SceneManager[_0x4ec23f(0x410)]();return;}VisuMZ[_0x4ec23f(0x9b1)](_0x177053,_0x177053);const _0x41e274=_0x177053['Enable'];_0x3a5df1[_0x4ec23f(0xa10)](_0x41e274);}),PluginManager['registerCommand'](pluginData['name'],_0x4bcec6(0x9da),_0x5541e5=>{const _0x49c681=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x49c681(0x39e)])return;const _0xa85b87=SceneManager[_0x49c681(0xb7c)]['_spriteset'];if(!_0xa85b87)return;VisuMZ['ConvertParams'](_0x5541e5,_0x5541e5);const _0x202c1c=_0x5541e5[_0x49c681(0x54b)]||0x1,_0x5869bd=_0x5541e5['Duration']||0x1,_0x2cd703=_0x5541e5['EasingType']||'Linear';_0xa85b87[_0x49c681(0x953)](_0x202c1c,_0x5869bd,_0x2cd703);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x520),_0x27d91e=>{const _0x5ddcea=_0x4bcec6;if(!Imported[_0x5ddcea(0x39e)])return;const _0x4f4709=SceneManager[_0x5ddcea(0xb7c)]['_spriteset'];if(!_0x4f4709)return;if(VisuMZ[_0x5ddcea(0x2b3)]['version']<=1.04){alert(_0x5ddcea(0xa83)),SceneManager[_0x5ddcea(0x410)]();return;}VisuMZ[_0x5ddcea(0x9b1)](_0x27d91e,_0x27d91e);const _0x1e5998=_0x27d91e[_0x5ddcea(0x558)];_0x4f4709['setupDesaturateImpactFilter'](_0x1e5998);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Impact_MotionBlurScreen',_0x17f04a=>{const _0x268510=_0x4bcec6;if(!SceneManager[_0x268510(0x772)]())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x2f9689=SceneManager[_0x268510(0xb7c)][_0x268510(0x8c8)];if(!_0x2f9689)return;VisuMZ[_0x268510(0x9b1)](_0x17f04a,_0x17f04a);const _0xab98ba=Number(_0x17f04a[_0x268510(0xaa1)])||0x0,_0x1e9d64=Number(_0x17f04a[_0x268510(0xae0)]),_0x36d51c=_0x17f04a[_0x268510(0x161)]||0x1,_0x437570=_0x17f04a['EasingType']||_0x268510(0x6db);_0x2f9689[_0x268510(0x57b)](_0xab98ba,_0x1e9d64,_0x36d51c,_0x437570);}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x1fe),_0x2ef1c2=>{const _0x3efc52=_0x4bcec6;if(!SceneManager[_0x3efc52(0x772)]())return;if(!Imported[_0x3efc52(0x39e)])return;const _0x490138=SceneManager[_0x3efc52(0xb7c)]['_spriteset'];if(!_0x490138)return;VisuMZ[_0x3efc52(0x9b1)](_0x2ef1c2,_0x2ef1c2);const _0x5a41ff=Number(_0x2ef1c2[_0x3efc52(0xaa1)])||0x0,_0x35567b=Number(_0x2ef1c2[_0x3efc52(0xae0)]),_0x4ee5c1=_0x2ef1c2[_0x3efc52(0x161)]||0x1,_0x1ea5b8=_0x2ef1c2[_0x3efc52(0x1c0)]||_0x3efc52(0x6db),_0x223a9e=VisuMZ[_0x3efc52(0x8bd)](_0x2ef1c2['Targets']);for(const _0x23f43b of _0x223a9e){if(!_0x23f43b)continue;if(!_0x23f43b[_0x3efc52(0x171)]())continue;_0x23f43b['battler']()['setupMotionBlurImpactFilter'](_0x5a41ff,_0x35567b,_0x4ee5c1,_0x1ea5b8);}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Impact_MotionTrailCreate',_0x2a35f4=>{const _0x4bd6be=_0x4bcec6;if(!SceneManager[_0x4bd6be(0x772)]())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;VisuMZ[_0x4bd6be(0x9b1)](_0x2a35f4,_0x2a35f4);const _0x514adb={'delay':_0x2a35f4['delay'],'duration':_0x2a35f4[_0x4bd6be(0xa1a)],'hue':_0x2a35f4[_0x4bd6be(0x74d)],'opacityStart':_0x2a35f4[_0x4bd6be(0x9a2)],'tone':_0x2a35f4['tone'],'visible':!![]},_0x1fe427=VisuMZ[_0x4bd6be(0x8bd)](_0x2a35f4[_0x4bd6be(0x5bc)]);for(const _0x178508 of _0x1fe427){if(!_0x178508)continue;_0x178508[_0x4bd6be(0x2c2)](_0x514adb);}}),PluginManager['registerCommand'](pluginData['name'],_0x4bcec6(0x688),_0x13f3a4=>{const _0x40d1a1=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;VisuMZ[_0x40d1a1(0x9b1)](_0x13f3a4,_0x13f3a4);const _0x3d20fe=VisuMZ[_0x40d1a1(0x8bd)](_0x13f3a4[_0x40d1a1(0x5bc)]);for(const _0xe32509 of _0x3d20fe){if(!_0xe32509)continue;_0xe32509[_0x40d1a1(0x49e)]();}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Impact_Negative',_0xffd56b=>{const _0x4ae8f9=_0x4bcec6;if(!Imported[_0x4ae8f9(0x39e)])return;const _0x314d37=SceneManager[_0x4ae8f9(0xb7c)][_0x4ae8f9(0x8c8)];if(!_0x314d37)return;if(VisuMZ[_0x4ae8f9(0x2b3)][_0x4ae8f9(0x6e5)]<=1.04){alert(_0x4ae8f9(0xa83)),SceneManager[_0x4ae8f9(0x410)]();return;}VisuMZ[_0x4ae8f9(0x9b1)](_0xffd56b,_0xffd56b);const _0x1ef87e=_0xffd56b['Enable'];_0x314d37[_0x4ae8f9(0x3da)](_0x1ef87e);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Impact_Oversaturate',_0x917774=>{const _0x3e4fa0=_0x4bcec6;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x437202=SceneManager[_0x3e4fa0(0xb7c)][_0x3e4fa0(0x8c8)];if(!_0x437202)return;if(VisuMZ['ActSeqImpact'][_0x3e4fa0(0x6e5)]<=1.04){alert(_0x3e4fa0(0xa83)),SceneManager[_0x3e4fa0(0x410)]();return;}VisuMZ[_0x3e4fa0(0x9b1)](_0x917774,_0x917774);const _0x123cc9=_0x917774[_0x3e4fa0(0x558)];_0x437202[_0x3e4fa0(0xbbc)](_0x123cc9);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Impact_ShockwavePoint',_0x400c3f=>{const _0x8b2a27=_0x4bcec6;if(!Imported[_0x8b2a27(0x39e)])return;const _0x2ef7dd=SceneManager['_scene'][_0x8b2a27(0x8c8)];if(!_0x2ef7dd)return;VisuMZ[_0x8b2a27(0x9b1)](_0x400c3f,_0x400c3f);const _0x19f087=_0x400c3f['X']||0x0,_0x1450a3=_0x400c3f['Y']||0x0,_0x5ce91d=_0x400c3f['Amp']||0x0,_0x122290=_0x400c3f['Wave']||0x0,_0x4b44a6=_0x400c3f[_0x8b2a27(0x161)]||0x1;_0x2ef7dd[_0x8b2a27(0x704)](_0x19f087,_0x1450a3,_0x5ce91d,_0x122290,_0x4b44a6);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xac1),_0x364526=>{const _0x5dd77e=_0x4bcec6;if(!SceneManager[_0x5dd77e(0x772)]())return;if(!Imported[_0x5dd77e(0x39e)])return;const _0x497ed8=SceneManager[_0x5dd77e(0xb7c)][_0x5dd77e(0x8c8)];if(!_0x497ed8)return;VisuMZ[_0x5dd77e(0x9b1)](_0x364526,_0x364526);const _0x571613=VisuMZ[_0x5dd77e(0x8bd)](_0x364526[_0x5dd77e(0x5bc)]),_0x3e0728=_0x364526['TargetLocation'],_0x52b804=_0x364526[_0x5dd77e(0x2ca)]||0x0,_0x2d1286=_0x364526[_0x5dd77e(0x651)]||0x0,_0x3177df=_0x364526['Amp']||0x0,_0xba42af=_0x364526['Wave']||0x0,_0x38c4cf=_0x364526[_0x5dd77e(0x161)]||0x1;for(const _0x1b5c72 of _0x571613){if(!_0x1b5c72)continue;if(!_0x1b5c72['battler']())continue;const _0x3e1763=_0x1b5c72[_0x5dd77e(0x171)]();let _0x42aacd=_0x3e1763[_0x5dd77e(0x7e7)],_0x1b8095=_0x3e1763[_0x5dd77e(0xbb1)];_0x42aacd+=(Graphics['width']-Graphics[_0x5dd77e(0x825)])/0x2,_0x1b8095+=(Graphics[_0x5dd77e(0xf4)]-Graphics[_0x5dd77e(0x61b)])/0x2;if(_0x3e0728[_0x5dd77e(0x820)](/front/i))_0x42aacd+=(_0x1b5c72[_0x5dd77e(0x52e)]()?0x1:-0x1)*_0x3e1763[_0x5dd77e(0x758)]()/0x2;else _0x3e0728[_0x5dd77e(0x820)](/back/i)&&(_0x42aacd+=(_0x1b5c72['isEnemy']()?-0x1:0x1)*_0x3e1763[_0x5dd77e(0x758)]()/0x2);if(_0x3e0728[_0x5dd77e(0x820)](/head/i))_0x1b8095-=_0x3e1763[_0x5dd77e(0x11a)]();else _0x3e0728['match'](/center/i)&&(_0x1b8095-=_0x3e1763[_0x5dd77e(0x11a)]()/0x2);_0x42aacd+=_0x52b804,_0x1b8095+=_0x2d1286,_0x497ed8[_0x5dd77e(0x704)](_0x42aacd,_0x1b8095,_0x3177df,_0xba42af,_0x38c4cf);}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x21c),_0x13cb0f=>{const _0x48955a=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x48955a(0x39e)])return;const _0x4999c3=SceneManager[_0x48955a(0xb7c)][_0x48955a(0x8c8)];if(!_0x4999c3)return;VisuMZ[_0x48955a(0x9b1)](_0x13cb0f,_0x13cb0f);const _0xe31ee2=VisuMZ[_0x48955a(0x8bd)](_0x13cb0f['Targets']),_0x339e61=_0x13cb0f[_0x48955a(0x169)],_0x5897d2=_0x13cb0f['OffsetX']||0x0,_0x8a13b7=_0x13cb0f[_0x48955a(0x651)]||0x0,_0x2284cb=_0x13cb0f[_0x48955a(0x20d)]||0x0,_0x17278b=_0x13cb0f[_0x48955a(0xa48)]||0x0,_0x227a81=_0x13cb0f[_0x48955a(0x161)]||0x1,_0x2da1ea=Math[_0x48955a(0x540)](..._0xe31ee2[_0x48955a(0x228)](_0x1b4c60=>_0x1b4c60['battler']()[_0x48955a(0x7e7)]-_0x1b4c60['battler']()[_0x48955a(0x758)]()/0x2)),_0x772f93=Math[_0x48955a(0x4d5)](..._0xe31ee2[_0x48955a(0x228)](_0x11a364=>_0x11a364['battler']()['_baseX']+_0x11a364[_0x48955a(0x171)]()[_0x48955a(0x758)]()/0x2)),_0x21ca9b=Math[_0x48955a(0x540)](..._0xe31ee2[_0x48955a(0x228)](_0x5f33a0=>_0x5f33a0[_0x48955a(0x171)]()[_0x48955a(0xbb1)]-_0x5f33a0[_0x48955a(0x171)]()[_0x48955a(0x11a)]())),_0x2564e1=Math['max'](..._0xe31ee2['map'](_0x35bdab=>_0x35bdab[_0x48955a(0x171)]()['_baseY'])),_0x18cbd8=_0xe31ee2[_0x48955a(0x9f4)](_0xf5bad7=>_0xf5bad7[_0x48955a(0xbf8)]())['length'],_0x2d4e22=_0xe31ee2[_0x48955a(0x9f4)](_0x43f1d3=>_0x43f1d3['isEnemy']())[_0x48955a(0x64b)];let _0xab0fd9=0x0,_0x3a8de3=0x0;if(_0x339e61[_0x48955a(0x820)](/front/i))_0xab0fd9=_0x18cbd8>=_0x2d4e22?_0x2da1ea:_0x772f93;else{if(_0x339e61[_0x48955a(0x820)](/middle/i))_0xab0fd9=(_0x2da1ea+_0x772f93)/0x2,melee=-0x1;else _0x339e61[_0x48955a(0x820)](/back/i)&&(_0xab0fd9=_0x18cbd8>=_0x2d4e22?_0x772f93:_0x2da1ea);}if(_0x339e61[_0x48955a(0x820)](/head/i))_0x3a8de3=_0x21ca9b;else{if(_0x339e61[_0x48955a(0x820)](/center/i))_0x3a8de3=(_0x21ca9b+_0x2564e1)/0x2;else _0x339e61[_0x48955a(0x820)](/base/i)&&(_0x3a8de3=_0x2564e1);}_0xab0fd9+=(Graphics['width']-Graphics[_0x48955a(0x825)])/0x2,_0x3a8de3+=(Graphics[_0x48955a(0xf4)]-Graphics[_0x48955a(0x61b)])/0x2,_0xab0fd9+=_0x5897d2,_0x3a8de3+=_0x8a13b7,_0x4999c3[_0x48955a(0x704)](_0xab0fd9,_0x3a8de3,_0x2284cb,_0x17278b,_0x227a81);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xa85),_0x14186f=>{const _0x5994be=_0x4bcec6;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x2e4345=SceneManager['_scene']['_spriteset'];if(!_0x2e4345)return;if(VisuMZ[_0x5994be(0x2b3)][_0x5994be(0x6e5)]<=1.04){alert(_0x5994be(0xa83)),SceneManager[_0x5994be(0x410)]();return;}VisuMZ['ConvertParams'](_0x14186f,_0x14186f);const _0x44e66d=$gameTemp[_0x5994be(0x475)](),_0x5bef77=Math[_0x5994be(0x4d5)](0.01,_0x14186f[_0x5994be(0x962)]);$gameTemp[_0x5994be(0x9ff)](_0x5bef77,_0x44e66d);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xab8),_0x3c81bc=>{const _0x1a1d4a=_0x4bcec6;if(!Imported[_0x1a1d4a(0x39e)])return;const _0x2f3714=SceneManager[_0x1a1d4a(0xb7c)]['_spriteset'];if(!_0x2f3714)return;if(VisuMZ['ActSeqImpact']['version']<=1.04){alert(_0x1a1d4a(0xa83)),SceneManager[_0x1a1d4a(0x410)]();return;}VisuMZ[_0x1a1d4a(0x9b1)](_0x3c81bc,_0x3c81bc);const _0x37e534=$gameTemp[_0x1a1d4a(0x475)](),_0x82964b=_0x3c81bc['ms']||0x1;VisuMZ[_0x1a1d4a(0x2b3)][_0x1a1d4a(0x6a4)](_0x82964b,_0x37e534);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Impact_ZoomBlurPoint',_0x406dc7=>{const _0x48d1ab=_0x4bcec6;if(!Imported[_0x48d1ab(0x39e)])return;const _0x212a12=SceneManager['_scene']['_spriteset'];if(!_0x212a12)return;VisuMZ['ConvertParams'](_0x406dc7,_0x406dc7);const _0x593fca=_0x406dc7['X']||0x0,_0x27f21b=_0x406dc7['Y']||0x0,_0x38ec97=_0x406dc7[_0x48d1ab(0x96a)]||0x0,_0x2f7116=_0x406dc7[_0x48d1ab(0xbba)]||0x0,_0x406954=_0x406dc7[_0x48d1ab(0x161)]||0x1,_0x248f80=_0x406dc7['EasingType']||_0x48d1ab(0x6db);_0x212a12['setupZoomBlurImpactFilter'](_0x38ec97,_0x593fca,_0x27f21b,_0x2f7116,_0x406954,_0x248f80);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x3ae),_0x5bc698=>{const _0x3b0e74=_0x4bcec6;if(!Imported[_0x3b0e74(0x39e)])return;const _0x50943d=SceneManager[_0x3b0e74(0xb7c)][_0x3b0e74(0x8c8)];if(!_0x50943d)return;VisuMZ[_0x3b0e74(0x9b1)](_0x5bc698,_0x5bc698);const _0x33a419=VisuMZ['CreateActionSequenceTargets'](_0x5bc698['Targets']),_0x397653=_0x5bc698[_0x3b0e74(0x169)],_0x12eab0=_0x5bc698[_0x3b0e74(0x2ca)]||0x0,_0x2e3aa9=_0x5bc698['OffsetY']||0x0,_0x112ad8=_0x5bc698[_0x3b0e74(0x96a)]||0x0,_0x238335=_0x5bc698[_0x3b0e74(0xbba)]||0x0,_0x3bc860=_0x5bc698['Duration']||0x1,_0x4a1eac=_0x5bc698[_0x3b0e74(0x1c0)]||'Linear',_0xeb5527=Math['min'](..._0x33a419['map'](_0x52068c=>_0x52068c['battler']()['_baseX']-_0x52068c[_0x3b0e74(0x171)]()[_0x3b0e74(0x758)]()/0x2)),_0x5c7397=Math[_0x3b0e74(0x4d5)](..._0x33a419[_0x3b0e74(0x228)](_0x2e2f1a=>_0x2e2f1a[_0x3b0e74(0x171)]()[_0x3b0e74(0x7e7)]+_0x2e2f1a[_0x3b0e74(0x171)]()[_0x3b0e74(0x758)]()/0x2)),_0x308f9d=Math[_0x3b0e74(0x540)](..._0x33a419[_0x3b0e74(0x228)](_0x1ed5c6=>_0x1ed5c6[_0x3b0e74(0x171)]()['_baseY']-_0x1ed5c6['battler']()['mainSpriteHeight']())),_0x5d9bf1=Math[_0x3b0e74(0x4d5)](..._0x33a419[_0x3b0e74(0x228)](_0x52f043=>_0x52f043[_0x3b0e74(0x171)]()['_baseY'])),_0x48cd49=_0x33a419[_0x3b0e74(0x9f4)](_0x255244=>_0x255244[_0x3b0e74(0xbf8)]())[_0x3b0e74(0x64b)],_0x7a5ec4=_0x33a419['filter'](_0xa4439=>_0xa4439[_0x3b0e74(0x52e)]())['length'];let _0x286bf4=0x0,_0x1df79c=0x0;if(_0x397653[_0x3b0e74(0x820)](/front/i))_0x286bf4=_0x48cd49>=_0x7a5ec4?_0xeb5527:_0x5c7397;else{if(_0x397653[_0x3b0e74(0x820)](/middle/i))_0x286bf4=(_0xeb5527+_0x5c7397)/0x2,melee=-0x1;else _0x397653[_0x3b0e74(0x820)](/back/i)&&(_0x286bf4=_0x48cd49>=_0x7a5ec4?_0x5c7397:_0xeb5527);}if(_0x397653[_0x3b0e74(0x820)](/head/i))_0x1df79c=_0x308f9d;else{if(_0x397653[_0x3b0e74(0x820)](/center/i))_0x1df79c=(_0x308f9d+_0x5d9bf1)/0x2;else _0x397653[_0x3b0e74(0x820)](/base/i)&&(_0x1df79c=_0x5d9bf1);}_0x286bf4+=(Graphics[_0x3b0e74(0xc08)]-Graphics[_0x3b0e74(0x825)])/0x2,_0x1df79c+=(Graphics['height']-Graphics['boxHeight'])/0x2,_0x286bf4+=_0x12eab0,_0x1df79c+=_0x2e3aa9,_0x50943d[_0x3b0e74(0x4bb)](_0x112ad8,_0x286bf4,_0x1df79c,_0x238335,_0x3bc860,_0x4a1eac);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x5c1),_0x5180b5=>{const _0x51ee20=_0x4bcec6;if(!Imported[_0x51ee20(0x39e)])return;const _0x5372f6=SceneManager[_0x51ee20(0xb7c)][_0x51ee20(0x8c8)];if(!_0x5372f6)return;if(VisuMZ[_0x51ee20(0x2b3)][_0x51ee20(0x6e5)]<=1.05){alert(_0x51ee20(0xa83)),SceneManager[_0x51ee20(0x410)]();return;}VisuMZ[_0x51ee20(0x9b1)](_0x5180b5,_0x5180b5);const _0x193f78=VisuMZ['CreateActionSequenceTargets'](_0x5180b5[_0x51ee20(0x5bc)]),_0x16ccb4={'filename':_0x5180b5[_0x51ee20(0x4f7)],'horzCells':_0x5180b5[_0x51ee20(0x1f6)]||0x1,'vertCells':_0x5180b5['vertCells']||0x1,'frameDelay':_0x5180b5['frameDelay']||0x1,'smooth':_0x5180b5['smooth']||![],'anchorX':_0x5180b5[_0x51ee20(0x27f)]||0x0,'anchorY':_0x5180b5['anchorY']||0x0,'offsetX':_0x5180b5[_0x51ee20(0x666)]||0x0,'offsetY':_0x5180b5[_0x51ee20(0x358)]||0x0};for(const _0x2385ab of _0x193f78){if(!_0x2385ab)continue;if(!_0x2385ab[_0x51ee20(0x171)]())continue;_0x2385ab[_0x51ee20(0x171)]()[_0x51ee20(0x641)](_0x16ccb4);}const _0xdd6a2e=$gameTemp['getLastPluginCommandInterpreter']();_0xdd6a2e&&_0xdd6a2e[_0x51ee20(0x23d)](_0x51ee20(0x40d));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x3a5),_0xce8134=>{const _0x4c2a74=_0x4bcec6;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x124d9b=SceneManager[_0x4c2a74(0xb7c)][_0x4c2a74(0x8c8)];if(!_0x124d9b)return;if(VisuMZ[_0x4c2a74(0x2b3)][_0x4c2a74(0x6e5)]<=1.05){alert(_0x4c2a74(0xa83)),SceneManager['exit']();return;}VisuMZ[_0x4c2a74(0x9b1)](_0xce8134,_0xce8134);const _0x3386d6=VisuMZ[_0x4c2a74(0x8bd)](_0xce8134[_0x4c2a74(0x5bc)]);for(const _0x1ba75a of _0x3386d6){if(!_0x1ba75a)continue;if(!_0x1ba75a[_0x4c2a74(0x171)]())continue;_0x1ba75a[_0x4c2a74(0x171)]()[_0x4c2a74(0x5d5)]();}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x75f),_0x3ac14b=>{const _0x3b0ec4=_0x4bcec6;if(!Imported[_0x3b0ec4(0x39e)])return;const _0x3a1389=SceneManager[_0x3b0ec4(0xb7c)][_0x3b0ec4(0x8c8)];if(!_0x3a1389)return;if(VisuMZ[_0x3b0ec4(0x2b3)]['version']<=1.05){alert(_0x3b0ec4(0xa83)),SceneManager['exit']();return;}VisuMZ[_0x3b0ec4(0x9b1)](_0x3ac14b,_0x3ac14b);const _0x22e013=VisuMZ['CreateActionSequenceTargets'](_0x3ac14b[_0x3b0ec4(0x5bc)]),_0x14125b=_0x3ac14b['pause'];for(const _0x3b8cee of _0x22e013){if(!_0x3b8cee)continue;if(!_0x3b8cee[_0x3b0ec4(0x171)]())continue;_0x3b8cee[_0x3b0ec4(0x171)]()['pauseInjectAnimation'](_0x14125b);}}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x25c),_0x173700=>{const _0x10e56a=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;const _0x147bd3=$gameTemp[_0x10e56a(0x475)]();if(!_0x147bd3)return;_0x147bd3[_0x10e56a(0x23d)]('battleInjectAni');}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Mechanics_ActionEffect',_0xba1942=>{const _0x26f03f=_0x4bcec6;if(!SceneManager[_0x26f03f(0x772)]())return;VisuMZ[_0x26f03f(0x9b1)](_0xba1942,_0xba1942);const _0x3017c4=$gameTemp[_0x26f03f(0x475)](),_0x5b9c3a=BattleManager['_action'],_0x1579ca=BattleManager['_subject'],_0x21d007=BattleManager[_0x26f03f(0x7ed)];if(!_0x3017c4||!_0x5b9c3a||!_0x1579ca)return;if(!_0x5b9c3a[_0x26f03f(0x93c)]())return;const _0x37cf66=VisuMZ[_0x26f03f(0x8bd)](_0xba1942[_0x26f03f(0x5bc)]);for(const _0x1bae5e of _0x37cf66){if(!_0x1bae5e)continue;_0x21d007[_0x26f03f(0x27a)](_0x26f03f(0x78e),_0x1579ca,_0x1bae5e);}_0x3017c4[_0x26f03f(0x23d)](_0x26f03f(0x3a2));}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x193),_0x431c34=>{const _0x21de0a=_0x4bcec6;if(!SceneManager[_0x21de0a(0x772)]())return;if(!Imported[_0x21de0a(0x8b1)])return;$gameTemp['_performActionEnd']=!![];}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],'ActSeq_Mechanics_AddBuffDebuff',_0x38aabd=>{const _0x4d3aca=_0x4bcec6;if(!SceneManager[_0x4d3aca(0x772)]())return;VisuMZ[_0x4d3aca(0x9b1)](_0x38aabd,_0x38aabd);const _0x574e97=[_0x4d3aca(0x67e),_0x4d3aca(0xb17),_0x4d3aca(0x401),_0x4d3aca(0x5c6),_0x4d3aca(0xbdb),_0x4d3aca(0x46c),_0x4d3aca(0x629),_0x4d3aca(0x960)],_0x2cfdcf=_0x38aabd[_0x4d3aca(0x216)],_0x960d4f=_0x38aabd[_0x4d3aca(0xb97)],_0x175c0c=_0x38aabd['Turns'],_0x368f4c=VisuMZ[_0x4d3aca(0x8bd)](_0x38aabd[_0x4d3aca(0x5bc)]);for(const _0x530e57 of _0x368f4c){if(!_0x530e57)continue;for(const _0x170063 of _0x2cfdcf){const _0x4edff5=_0x574e97[_0x4d3aca(0x4fd)](_0x170063[_0x4d3aca(0x1fd)]()[_0x4d3aca(0x7d5)]());_0x4edff5>=0x0&&_0x4edff5<=0x7&&_0x530e57[_0x4d3aca(0x590)](_0x4edff5,_0x175c0c);}for(const _0x5ef74d of _0x960d4f){const _0x57c173=_0x574e97[_0x4d3aca(0x4fd)](_0x5ef74d[_0x4d3aca(0x1fd)]()[_0x4d3aca(0x7d5)]());_0x57c173>=0x0&&_0x57c173<=0x7&&_0x530e57[_0x4d3aca(0x890)](_0x57c173,_0x175c0c);}}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xb31),_0x47c6d9=>{const _0x539853=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x539853(0x9b1)](_0x47c6d9,_0x47c6d9);const _0x255581=_0x47c6d9[_0x539853(0xba5)],_0x221a99=VisuMZ['CreateActionSequenceTargets'](_0x47c6d9[_0x539853(0x5bc)]);for(const _0x52f0a5 of _0x221a99){if(!_0x52f0a5)continue;for(const _0x12f4fd of _0x255581){_0x52f0a5[_0x539853(0x4b9)](_0x12f4fd);}}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Mechanics_ArmorPenetration',_0x4c64d7=>{const _0x72d8f5=_0x4bcec6;if(!SceneManager[_0x72d8f5(0x772)]())return;VisuMZ[_0x72d8f5(0x9b1)](_0x4c64d7,_0x4c64d7);const _0x37ab42=BattleManager[_0x72d8f5(0x3fd)],_0x37caa9={'arPenRate':_0x4c64d7[_0x72d8f5(0x591)],'arPenFlat':_0x4c64d7[_0x72d8f5(0xbd3)],'arRedRate':_0x4c64d7[_0x72d8f5(0x328)],'arRedFlat':_0x4c64d7[_0x72d8f5(0x7a2)]};_0x37ab42[_0x72d8f5(0xad1)]=_0x37caa9;}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xa13),_0x2df47e=>{const _0x59ad68=_0x4bcec6;if(!SceneManager[_0x59ad68(0x772)]())return;if(!Imported[_0x59ad68(0xa80)])return;VisuMZ[_0x59ad68(0x9b1)](_0x2df47e,_0x2df47e);const _0x298cfe=VisuMZ[_0x59ad68(0x8bd)](_0x2df47e['Targets']),_0x3d8b0c=_0x2df47e[_0x59ad68(0x6c3)]||0x1;for(const _0x20ba04 of _0x298cfe){if(!_0x20ba04)continue;if(!_0x20ba04[_0x59ad68(0x52e)]())continue;_0x20ba04[_0x59ad68(0x933)](_0x3d8b0c);}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x448),_0x1d9aff=>{const _0x2cccc8=_0x4bcec6;if(!SceneManager[_0x2cccc8(0x772)]())return;if(!Imported[_0x2cccc8(0x544)])return;if(!BattleManager['isATB']())return;VisuMZ[_0x2cccc8(0x9b1)](_0x1d9aff,_0x1d9aff);const _0x7115ed=VisuMZ[_0x2cccc8(0x8bd)](_0x1d9aff[_0x2cccc8(0x5bc)]),_0x3fafce=_0x1d9aff['ChargeRate'],_0xb96ed9=_0x1d9aff[_0x2cccc8(0xa53)],_0x536efa=_0x1d9aff[_0x2cccc8(0xb87)];for(const _0x5babe5 of _0x7115ed){if(!_0x5babe5)continue;if(_0x5babe5[_0x2cccc8(0x15b)]())_0x5babe5[_0x2cccc8(0xaa7)](_0x3fafce);else{if(_0x5babe5[_0x2cccc8(0x3dc)]()){_0x5babe5[_0x2cccc8(0x1c6)](_0xb96ed9);if(_0x536efa)_0x5babe5['atbInterrupt']();}}}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x21f),_0x5509f6=>{const _0x5a818e=_0x4bcec6;if(!SceneManager[_0x5a818e(0x772)]())return;if(!Imported[_0x5a818e(0x2b0)])return;VisuMZ[_0x5a818e(0x9b1)](_0x5509f6,_0x5509f6);const _0x2a23ef=VisuMZ['CreateActionSequenceTargets'](_0x5509f6['Targets']),_0x35a510=_0x5509f6['BoostPoints'];for(const _0x65ce6d of _0x2a23ef){if(!_0x65ce6d)continue;_0x65ce6d[_0x5a818e(0x59a)](_0x35a510);}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x38f),_0x142034=>{const _0x351466=_0x4bcec6;if(!SceneManager[_0x351466(0x772)]())return;if(!Imported[_0x351466(0x2b0)])return;if(!BattleManager[_0x351466(0xba3)])return;VisuMZ['ConvertParams'](_0x142034,_0x142034);const _0x8cd0c1=_0x142034['VariableID'];$gameVariables['setValue'](_0x8cd0c1,BattleManager[_0x351466(0xba3)][_0x351466(0x97d)]());}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x286),_0x187d55=>{const _0xe89523=_0x4bcec6;if(!SceneManager[_0xe89523(0x772)]())return;if(!Imported[_0xe89523(0x6ea)])return;VisuMZ[_0xe89523(0x9b1)](_0x187d55,_0x187d55);const _0x5f0b06=VisuMZ[_0xe89523(0x8bd)](_0x187d55[_0xe89523(0x5bc)]),_0x4fa060=_0x187d55['BreakShields'];for(const _0x39d9a2 of _0x5f0b06){if(!_0x39d9a2)continue;if(_0x39d9a2[_0xe89523(0xaa9)]())continue;if(!_0x39d9a2[_0xe89523(0xba8)]())continue;_0x39d9a2[_0xe89523(0xa57)](_0x4fa060);}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Mechanics_BreakShieldReset',_0x551430=>{const _0x1f380c=_0x4bcec6;if(!SceneManager[_0x1f380c(0x772)]())return;if(!Imported['VisuMZ_4_BreakShields'])return;VisuMZ[_0x1f380c(0x9b1)](_0x551430,_0x551430);const _0x21f87d=VisuMZ['CreateActionSequenceTargets'](_0x551430[_0x1f380c(0x5bc)]);for(const _0x468608 of _0x21f87d){if(!_0x468608)continue;if(_0x468608[_0x1f380c(0xaa9)]())continue;if(!_0x468608[_0x1f380c(0xba8)]())continue;_0x468608[_0x1f380c(0x9af)]();}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x3a9),_0xa61204=>{const _0x24ddc7=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_2_BattleSystemBTB'])return;if(!BattleManager[_0x24ddc7(0x426)]())return;VisuMZ[_0x24ddc7(0x9b1)](_0xa61204,_0xa61204);const _0x484d22=VisuMZ[_0x24ddc7(0x8bd)](_0xa61204['Targets']),_0x5c4af0=_0xa61204[_0x24ddc7(0xa40)];for(const _0x3c3431 of _0x484d22){if(!_0x3c3431)continue;_0x3c3431[_0x24ddc7(0x60d)](_0x5c4af0);}}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],'ActSeq_Mechanics_Collapse',_0xbc2073=>{const _0x1fff77=_0x4bcec6;if(!SceneManager[_0x1fff77(0x772)]())return;VisuMZ['ConvertParams'](_0xbc2073,_0xbc2073);const _0x34e2cc=$gameTemp['getLastPluginCommandInterpreter'](),_0x18c40c=BattleManager[_0x1fff77(0x3fd)],_0x163ec2=BattleManager[_0x1fff77(0xba3)];if(!_0x34e2cc||!_0x18c40c||!_0x163ec2)return;if(!_0x18c40c['item']())return;const _0x100ecf=VisuMZ[_0x1fff77(0x8bd)](_0xbc2073['Targets']);for(const _0x3a4e19 of _0x100ecf){if(!_0x3a4e19)continue;_0xbc2073['ForceDeath']&&(_0x3a4e19[_0x1fff77(0xa21)](),_0x3a4e19[_0x1fff77(0x4b9)](_0x3a4e19[_0x1fff77(0x9ee)]())),_0x3a4e19[_0x1fff77(0x18c)]()&&_0x3a4e19['performCollapse']();}_0x34e2cc[_0x1fff77(0x23d)]('battleEffect');}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0xaa5),_0x214473=>{const _0x170887=_0x4bcec6;if(!SceneManager[_0x170887(0x772)]())return;if(!Imported[_0x170887(0x54c)])return;if(!BattleManager[_0x170887(0x452)]())return;VisuMZ[_0x170887(0x9b1)](_0x214473,_0x214473);const _0xf6110f=VisuMZ[_0x170887(0x8bd)](_0x214473[_0x170887(0x5bc)]),_0x4e309e=_0x214473[_0x170887(0x437)];for(const _0x1aca0e of _0xf6110f){if(!_0x1aca0e)continue;_0x1aca0e['changeTurnOrderByCTB'](_0x4e309e);}}),PluginManager['registerCommand'](pluginData['name'],_0x4bcec6(0x580),_0x51ccdc=>{const _0x2b2338=_0x4bcec6;if(!SceneManager[_0x2b2338(0x772)]())return;if(!Imported['VisuMZ_2_BattleSystemCTB'])return;if(!BattleManager[_0x2b2338(0x452)]())return;VisuMZ[_0x2b2338(0x9b1)](_0x51ccdc,_0x51ccdc);const _0x2f758d=VisuMZ['CreateActionSequenceTargets'](_0x51ccdc['Targets']),_0x29b606=_0x51ccdc[_0x2b2338(0xa53)],_0x18071c=_0x51ccdc['ChargeRate'];for(const _0x448361 of _0x2f758d){if(!_0x448361)continue;if(_0x448361[_0x2b2338(0xb7d)]==='charging')_0x448361[_0x2b2338(0xa71)](_0x29b606);else _0x448361[_0x2b2338(0xb7d)]===_0x2b2338(0x828)&&_0x448361[_0x2b2338(0x498)](_0x18071c);}}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],'ActSeq_Mechanics_CustomDmgFormula',_0x432c53=>{const _0x25ca74=_0x4bcec6;if(!SceneManager[_0x25ca74(0x772)]())return;VisuMZ[_0x25ca74(0x9b1)](_0x432c53,_0x432c53);const _0x5a6b00=BattleManager[_0x25ca74(0x3fd)];if(!_0x5a6b00)return;let _0x13bd8d=_0x432c53[_0x25ca74(0x7bb)];_0x5a6b00['setCustomDamageFormula'](_0x13bd8d);}),PluginManager['registerCommand'](pluginData['name'],_0x4bcec6(0x4a2),_0x25e5b2=>{const _0x5d37e8=_0x4bcec6;if(!SceneManager[_0x5d37e8(0x772)]())return;VisuMZ[_0x5d37e8(0x9b1)](_0x25e5b2,_0x25e5b2);const _0x2c081c=VisuMZ[_0x5d37e8(0x8bd)](_0x25e5b2[_0x5d37e8(0x5bc)]);for(const _0x2662ef of _0x2c081c){if(!_0x2662ef)continue;if(_0x2662ef['shouldPopupDamage']())_0x2662ef[_0x5d37e8(0x434)]();}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Mechanics_DeathBreak',_0x41d018=>{const _0x39908e=_0x4bcec6;if(!SceneManager[_0x39908e(0x772)]())return;VisuMZ[_0x39908e(0x9b1)](_0x41d018,_0x41d018);const _0x1676bf=$gameTemp[_0x39908e(0x475)](),_0x1bb57a=BattleManager[_0x39908e(0xba3)],_0x516d8a=_0x41d018[_0x39908e(0x81d)];if(!_0x1676bf)return;if(!_0x1bb57a)return;_0x1bb57a&&_0x1bb57a[_0x39908e(0x4a5)]()&&_0x516d8a[_0x39908e(0x1fd)]()['trim']()!==_0x39908e(0x2bf)&&_0x1676bf[_0x39908e(0x52c)]([_0x516d8a]);}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x2fe),_0x1f9792=>{const _0x120709=_0x4bcec6;if(!SceneManager[_0x120709(0x772)]())return;VisuMZ[_0x120709(0x9b1)](_0x1f9792,_0x1f9792);const _0x425ede=$gameTemp[_0x120709(0x475)](),_0x59fb88=BattleManager['_logWindow'];if(!_0x425ede)return;const _0x21f7d7=VisuMZ[_0x120709(0x8bd)](_0x1f9792[_0x120709(0x47f)]),_0x343cc5=VisuMZ[_0x120709(0x8bd)](_0x1f9792['Targets']);for(const _0x40be5a of _0x21f7d7){for(const _0x5e7326 of _0x343cc5){if(!_0x5e7326)continue;const _0x310ee3=$dataSkills[_0x40be5a[_0x120709(0x73e)]()];_0x59fb88[_0x120709(0x27a)]('emulateActionEffect',_0x40be5a,_0x5e7326,_0x310ee3);}}_0x425ede[_0x120709(0x23d)](_0x120709(0x3a2));}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0xa86),_0x466877=>{const _0x2ac076=_0x4bcec6;if(!SceneManager[_0x2ac076(0x772)]())return;VisuMZ['ConvertParams'](_0x466877,_0x466877);const _0xfef309=$gameTemp[_0x2ac076(0x475)](),_0x241d27=BattleManager[_0x2ac076(0x7ed)];if(!_0xfef309)return;const _0x3607c6=VisuMZ[_0x2ac076(0x8bd)](_0x466877[_0x2ac076(0x47f)]),_0x3853c4=VisuMZ[_0x2ac076(0x8bd)](_0x466877['Targets']);for(const _0x2ce426 of _0x3607c6){for(const _0x25c300 of _0x3853c4){if(!_0x25c300)continue;const _0x4b73d6=$dataSkills[_0x2ce426['guardSkillId']()];_0x241d27[_0x2ac076(0x27a)]('emulateActionEffect',_0x2ce426,_0x25c300,_0x4b73d6);}}_0xfef309['setWaitMode'](_0x2ac076(0x3a2));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x13e),_0x108943=>{const _0x3569d6=_0x4bcec6;if(!SceneManager[_0x3569d6(0x772)]())return;VisuMZ[_0x3569d6(0x9b1)](_0x108943,_0x108943);const _0x17ecc7=$gameTemp['getLastPluginCommandInterpreter'](),_0x4390d0=BattleManager[_0x3569d6(0x7ed)],_0x4f79b5=Number(_0x108943[_0x3569d6(0x22b)]||0x1),_0x4b82a9=$dataItems[_0x4f79b5];if(!_0x17ecc7)return;if(!_0x4b82a9)return;const _0x3265bc=VisuMZ[_0x3569d6(0x8bd)](_0x108943[_0x3569d6(0x47f)]),_0x4eaacc=VisuMZ[_0x3569d6(0x8bd)](_0x108943[_0x3569d6(0x5bc)]);for(const _0x23794e of _0x3265bc){for(const _0x499ae1 of _0x4eaacc){if(!_0x499ae1)continue;_0x4390d0[_0x3569d6(0x27a)](_0x3569d6(0x319),_0x23794e,_0x499ae1,_0x4b82a9);}}_0x17ecc7['setWaitMode'](_0x3569d6(0x3a2));}),PluginManager['registerCommand'](pluginData['name'],_0x4bcec6(0x1a3),_0x5d5cf1=>{const _0x5eef73=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x5eef73(0x9b1)](_0x5d5cf1,_0x5d5cf1);let _0x2d10cf=Number(_0x5d5cf1['SkillID']||0x0);if(_0x2d10cf<=0x0){const _0x5d3e32=BattleManager[_0x5eef73(0x3fd)];if(_0x5d3e32&&_0x5d3e32[_0x5eef73(0x117)]())_0x2d10cf=_0x5d3e32[_0x5eef73(0x93c)]()['id'];else return;}const _0x45dd53=$dataSkills[_0x2d10cf];if(!_0x45dd53)return;const _0x562800=VisuMZ['CreateActionSequenceTargets'](_0x5d5cf1[_0x5eef73(0x47f)]);for(const _0x26958f of _0x562800){_0x26958f[_0x5eef73(0x9c0)](_0x45dd53);}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x6f1),_0xa15ea7=>{const _0x136fe2=_0x4bcec6;if(!SceneManager[_0x136fe2(0x772)]())return;VisuMZ[_0x136fe2(0x9b1)](_0xa15ea7,_0xa15ea7);const _0x46e4fe=$gameTemp[_0x136fe2(0x475)](),_0x4a9928=BattleManager['_logWindow'],_0x23d3cd=Number(_0xa15ea7[_0x136fe2(0x87b)]||0x1),_0x2cd701=$dataSkills[_0x23d3cd];if(!_0x46e4fe)return;if(!_0x2cd701)return;const _0x37baa4=VisuMZ['CreateActionSequenceTargets'](_0xa15ea7[_0x136fe2(0x47f)]),_0x5f1e1b=VisuMZ[_0x136fe2(0x8bd)](_0xa15ea7[_0x136fe2(0x5bc)]);for(const _0x12e896 of _0x37baa4){for(const _0x59610a of _0x5f1e1b){if(!_0x59610a)continue;_0x4a9928[_0x136fe2(0x27a)](_0x136fe2(0x319),_0x12e896,_0x59610a,_0x2cd701);}}_0x46e4fe[_0x136fe2(0x23d)](_0x136fe2(0x3a2));}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x832),_0x172095=>{const _0x184f8e=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x184f8e(0x9b1)](_0x172095,_0x172095);const _0x14dd5a=VisuMZ['CreateActionSequenceTargets'](_0x172095[_0x184f8e(0x5bc)]);for(const _0x463bc1 of _0x14dd5a){if(!_0x463bc1)continue;if(!_0x463bc1[_0x184f8e(0x52e)]())continue;_0x463bc1['escape']();}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x2ce),_0xe43e0a=>{const _0x1e7540=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_2_BattleSystemETB'])return;if(!BattleManager[_0x1e7540(0x8b6)]())return;VisuMZ[_0x1e7540(0x9b1)](_0xe43e0a,_0xe43e0a);const _0x543629=_0xe43e0a[_0x1e7540(0x36f)];BattleManager[_0x1e7540(0xba3)]&&BattleManager[_0x1e7540(0xba3)][_0x1e7540(0xbdc)]()['gainCurrentActionsETB'](_0x543629);}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x8c3),_0x6fd3eb=>{const _0x22b370=_0x4bcec6;if(!SceneManager[_0x22b370(0x772)]())return;if(!Imported[_0x22b370(0x8ec)])return;if(!BattleManager[_0x22b370(0x49a)]())return;VisuMZ['ConvertParams'](_0x6fd3eb,_0x6fd3eb);const _0x5ca092=_0x6fd3eb['ActionCount'];BattleManager[_0x22b370(0xba3)]&&BattleManager[_0x22b370(0xba3)][_0x22b370(0xbdc)]()['gainCurrentActionsFTB'](_0x5ca092);}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x51c),_0x714cde=>{const _0x1fcdc6=_0x4bcec6;if(!SceneManager[_0x1fcdc6(0x772)]())return;VisuMZ['ConvertParams'](_0x714cde,_0x714cde);const _0x42a052=VisuMZ[_0x1fcdc6(0x8bd)](_0x714cde[_0x1fcdc6(0x5bc)]),_0x121f74=_0x714cde[_0x1fcdc6(0x99b)],_0x387b7f=_0x714cde[_0x1fcdc6(0x234)],_0x2d0184=_0x714cde[_0x1fcdc6(0x6e6)],_0x528933=_0x714cde[_0x1fcdc6(0x7ea)],_0x4e365f=_0x714cde[_0x1fcdc6(0x62a)],_0x192399=_0x714cde[_0x1fcdc6(0x7cd)],_0x4963c5=_0x714cde[_0x1fcdc6(0x226)];for(const _0x550101 of _0x42a052){if(!_0x550101)continue;const _0x12dc18=_0x550101[_0x1fcdc6(0x694)](),_0x57b413=Math[_0x1fcdc6(0x7f7)](_0x121f74*_0x550101[_0x1fcdc6(0xae6)]+_0x387b7f),_0x212c6b=Math[_0x1fcdc6(0x7f7)](_0x2d0184*_0x550101[_0x1fcdc6(0x6a3)]+_0x528933),_0x385051=Math[_0x1fcdc6(0x7f7)](_0x4e365f*_0x550101['maxTp']()+_0x192399);if(_0x57b413!==0x0)_0x550101[_0x1fcdc6(0x740)](_0x57b413);if(_0x212c6b!==0x0)_0x550101[_0x1fcdc6(0x4ac)](_0x212c6b);if(_0x385051!==0x0)_0x550101[_0x1fcdc6(0x707)](_0x385051);if(_0x4963c5)_0x550101[_0x1fcdc6(0x434)]();_0x12dc18&&_0x550101[_0x1fcdc6(0x4a5)]()&&_0x550101[_0x1fcdc6(0x121)]();}}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x5c3),_0x2b55df=>{const _0x3a0402=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x3a0402(0x9b1)](_0x2b55df,_0x2b55df);const _0x5aa80b=VisuMZ[_0x3a0402(0x8bd)](_0x2b55df['Targets']);for(const _0x43205c of _0x5aa80b){if(!_0x43205c)continue;_0x43205c[_0x3a0402(0x3bb)](_0x2b55df[_0x3a0402(0x5fc)]);}}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0xb78),_0x4ef113=>{const _0x27322d=_0x4bcec6;if(!SceneManager[_0x27322d(0x772)]())return;VisuMZ[_0x27322d(0x9b1)](_0x4ef113,_0x4ef113);const _0x187277=BattleManager['_action'],_0x3b9eed={'criticalHitRate':_0x4ef113[_0x27322d(0x4ef)],'criticalHitFlat':_0x4ef113[_0x27322d(0x5b5)],'criticalDmgRate':_0x4ef113['CriticalDmgRate'],'criticalDmgFlat':_0x4ef113[_0x27322d(0x103)],'damageRate':_0x4ef113[_0x27322d(0x160)],'damageFlat':_0x4ef113[_0x27322d(0xa70)],'hitRate':_0x4ef113[_0x27322d(0x299)],'hitFlat':_0x4ef113[_0x27322d(0x8aa)]};_0x187277[_0x27322d(0x4a6)]=_0x3b9eed;}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],'ActSeq_Mechanics_OnceParallel',_0x578f44=>{const _0xdc677c=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0xdc677c(0x9b1)](_0x578f44,_0x578f44);const _0x452368=_0x578f44['CommonEventID'];SceneManager[_0xdc677c(0xb7c)][_0xdc677c(0x7ef)](_0x452368);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x7c3),_0x22f328=>{const _0x4bc6ba=_0x4bcec6;if(!SceneManager[_0x4bc6ba(0x772)]())return;if(!Imported[_0x4bc6ba(0xb9b)])return;if(!BattleManager['isOTB']())return;VisuMZ[_0x4bc6ba(0x9b1)](_0x22f328,_0x22f328);const _0xbcf950=VisuMZ['CreateActionSequenceTargets'](_0x22f328[_0x4bc6ba(0x5bc)]);for(const _0xa1aae3 of _0xbcf950){if(!_0xa1aae3)continue;let _0x31f3c2=_0x22f328[_0x4bc6ba(0x443)],_0x1d774c=_0x22f328['NextTurn'],_0x5ca223=_0x22f328['FollowTurn'];BattleManager[_0x4bc6ba(0x59f)]['includes'](_0xa1aae3)?_0x31f3c2+=_0x5ca223:_0x1d774c+=_0x5ca223,BattleManager['turnOrderChangeOTB'](_0xa1aae3,-_0x31f3c2,![]),BattleManager[_0x4bc6ba(0xa4a)](_0xa1aae3,-_0x1d774c,!![]);}}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0xb24),_0x27c184=>{const _0x2ace19=_0x4bcec6;if(!SceneManager[_0x2ace19(0x772)]())return;if(!Imported[_0x2ace19(0x809)])return;if(!BattleManager[_0x2ace19(0x812)]())return;VisuMZ['ConvertParams'](_0x27c184,_0x27c184);const _0x2cf8ce=BattleManager['_subject'][_0x2ace19(0xbdc)](),_0x1555be=_0x27c184[_0x2ace19(0x23a)],_0x264a22=_0x27c184[_0x2ace19(0x685)]||'unchanged',_0x17ce6c=_0x27c184[_0x2ace19(0x500)]||'unchanged',_0x203e0f=_0x27c184[_0x2ace19(0xbe0)]||0x0,_0x108e53=_0x27c184['alterPriority']||0x0;(_0x2cf8ce['canAlterActionCostPTB']()||_0x1555be)&&(_0x1555be&&(_0x2cf8ce[_0x2ace19(0x515)]=_0x2cf8ce['_ptbActionCost']||{},_0x2cf8ce['_ptbActionCost'][_0x2ace19(0xa1c)]=0x0),_0x2cf8ce[_0x2ace19(0x757)](_0x264a22,_0x17ce6c,_0x203e0f,_0x108e53));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x8db),_0x2463c2=>{const _0x48829c=_0x4bcec6;if(!SceneManager[_0x48829c(0x772)]())return;if(!Imported[_0x48829c(0x809)])return;if(!BattleManager['isPTB']())return;VisuMZ[_0x48829c(0x9b1)](_0x2463c2,_0x2463c2);const _0x425d2c=BattleManager['_subject'][_0x48829c(0xbdc)]();let _0x374084=Math[_0x48829c(0x4d5)](_0x2463c2[_0x48829c(0x584)],0x0),_0x203ec4=_0x425d2c[_0x48829c(0xaeb)](),_0x49de1e=_0x425d2c['getHalfActionsPTB']();while(_0x374084--){if(_0x203ec4<=0x0&&_0x49de1e<=0x0)break;else _0x203ec4>0x0?(_0x203ec4--,_0x49de1e++):_0x49de1e--;}_0x425d2c[_0x48829c(0x23c)](_0x203ec4),_0x425d2c[_0x48829c(0x764)](_0x49de1e);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Mechanics_PtbFullHalfAction',_0x3c26fc=>{const _0x1e6221=_0x4bcec6;if(!SceneManager[_0x1e6221(0x772)]())return;if(!Imported[_0x1e6221(0x809)])return;if(!BattleManager[_0x1e6221(0x812)]())return;VisuMZ[_0x1e6221(0x9b1)](_0x3c26fc,_0x3c26fc);const _0x113bc3=BattleManager[_0x1e6221(0xba3)][_0x1e6221(0xbdc)]();let _0x7d0e64=_0x3c26fc[_0x1e6221(0x6e0)],_0x219640=_0x3c26fc[_0x1e6221(0x458)];_0x113bc3[_0x1e6221(0x485)](_0x7d0e64),_0x113bc3[_0x1e6221(0x541)](_0x219640);}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0xa91),_0x384a91=>{const _0x5e614f=_0x4bcec6;if(!SceneManager[_0x5e614f(0x772)]())return;VisuMZ['ConvertParams'](_0x384a91,_0x384a91);const _0x1bddfb=[_0x5e614f(0x67e),_0x5e614f(0xb17),_0x5e614f(0x401),_0x5e614f(0x5c6),_0x5e614f(0xbdb),'MDF',_0x5e614f(0x629),_0x5e614f(0x960)],_0x32b978=_0x384a91[_0x5e614f(0x216)],_0x5b7a56=_0x384a91[_0x5e614f(0xb97)],_0x4a4228=VisuMZ['CreateActionSequenceTargets'](_0x384a91[_0x5e614f(0x5bc)]);for(const _0x5065f2 of _0x4a4228){if(!_0x5065f2)continue;for(const _0xf8f0ee of _0x32b978){const _0x4b53a3=_0x1bddfb[_0x5e614f(0x4fd)](_0xf8f0ee[_0x5e614f(0x1fd)]()[_0x5e614f(0x7d5)]());_0x4b53a3>=0x0&&_0x4b53a3<=0x7&&_0x5065f2['isBuffAffected'](_0x4b53a3)&&_0x5065f2[_0x5e614f(0x9c5)](_0x4b53a3);}for(const _0x561ab4 of _0x5b7a56){const _0x17210a=_0x1bddfb[_0x5e614f(0x4fd)](_0x561ab4['toUpperCase']()[_0x5e614f(0x7d5)]());_0x17210a>=0x0&&_0x17210a<=0x7&&_0x5065f2[_0x5e614f(0x725)](_0x17210a)&&_0x5065f2[_0x5e614f(0x9c5)](_0x17210a);}}}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x1be),_0x3e45bc=>{const _0x39ba15=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x39ba15(0x9b1)](_0x3e45bc,_0x3e45bc);const _0x34ccb4=_0x3e45bc['States'],_0x56957=VisuMZ[_0x39ba15(0x8bd)](_0x3e45bc[_0x39ba15(0x5bc)]);for(const _0x231041 of _0x56957){if(!_0x231041)continue;for(const _0x47796c of _0x34ccb4){_0x231041[_0x39ba15(0x6ce)](_0x47796c);}}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x6bb),_0x33e81c=>{const _0x323b1e=_0x4bcec6;if(!SceneManager[_0x323b1e(0x772)]())return;if(!Imported['VisuMZ_1_SkillsStatesCore'])return;VisuMZ[_0x323b1e(0x9b1)](_0x33e81c,_0x33e81c);const _0x498a9a=VisuMZ[_0x323b1e(0x8bd)](_0x33e81c[_0x323b1e(0x5bc)]),_0x1c7c3b=Number(_0x33e81c[_0x323b1e(0x76c)]),_0x58aa2f=Number(_0x33e81c[_0x323b1e(0x433)]),_0x4bd283=_0x33e81c[_0x323b1e(0x4a8)];for(const _0x44db8b of _0x498a9a){if(!_0x44db8b)continue;_0x4bd283&&!_0x44db8b['isStateAffected'](_0x1c7c3b)?(_0x44db8b[_0x323b1e(0x4b9)](_0x1c7c3b),_0x44db8b[_0x323b1e(0x313)](_0x1c7c3b,_0x58aa2f)):_0x44db8b['addStateTurns'](_0x1c7c3b,_0x58aa2f);}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x797),_0x4b20f0=>{const _0x104171=_0x4bcec6;if(!SceneManager[_0x104171(0x772)]())return;if(!Imported[_0x104171(0x1f4)])return;VisuMZ['ConvertParams'](_0x4b20f0,_0x4b20f0);const _0x325874=VisuMZ['CreateActionSequenceTargets'](_0x4b20f0[_0x104171(0x5bc)]),_0x5aa747=Number(_0x4b20f0[_0x104171(0x76c)]),_0x12bb49=Math[_0x104171(0x4d5)](Number(_0x4b20f0[_0x104171(0x433)]),0x0),_0x3c1698=_0x4b20f0[_0x104171(0x4a8)];for(const _0x1711e4 of _0x325874){if(!_0x1711e4)continue;_0x3c1698&&!_0x1711e4[_0x104171(0x489)](_0x5aa747)&&_0x1711e4[_0x104171(0x4b9)](_0x5aa747),_0x1711e4[_0x104171(0x313)](_0x5aa747,_0x12bb49);}}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],'ActSeq_Mechanics_StbExploit',_0x4dd6dd=>{const _0x32dbf3=_0x4bcec6;if(!SceneManager[_0x32dbf3(0x772)]())return;if(!Imported[_0x32dbf3(0x55d)])return;if(!BattleManager[_0x32dbf3(0x914)]())return;VisuMZ[_0x32dbf3(0x9b1)](_0x4dd6dd,_0x4dd6dd);const _0x10bf26=_0x4dd6dd[_0x32dbf3(0x3b5)],_0x29d616=VisuMZ['CreateActionSequenceTargets'](_0x4dd6dd[_0x32dbf3(0x5bc)]),_0x1652cb=_0x4dd6dd[_0x32dbf3(0x5ec)],_0x2f09ed=_0x4dd6dd[_0x32dbf3(0x3dd)],_0x569f7b=_0x4dd6dd[_0x32dbf3(0x537)],_0x3a29f2=BattleManager[_0x32dbf3(0x3fd)];if(_0x10bf26)for(const _0x254ab0 of _0x29d616){if(!_0x254ab0)continue;if(_0x254ab0===BattleManager[_0x32dbf3(0xba3)])continue;if(_0x1652cb)_0x254ab0[_0x32dbf3(0x6e4)](![]);_0x254ab0[_0x32dbf3(0x237)](BattleManager['_subject'],_0x3a29f2);}if(_0x2f09ed&&BattleManager[_0x32dbf3(0xba3)]){if(_0x569f7b)BattleManager['_subject']['setSTBExploited'](![]);const _0x55f1db=_0x29d616[0x0];BattleManager[_0x32dbf3(0xba3)][_0x32dbf3(0x698)](_0x55f1db,_0x3a29f2);}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x805),_0x5b8c09=>{const _0x19b01f=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x19b01f(0x55d)])return;if(!BattleManager[_0x19b01f(0x914)]())return;VisuMZ[_0x19b01f(0x9b1)](_0x5b8c09,_0x5b8c09);const _0x316137=_0x5b8c09[_0x19b01f(0x9b6)];BattleManager[_0x19b01f(0xba3)]&&BattleManager[_0x19b01f(0xba3)][_0x19b01f(0x89e)](_0x316137);}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xb0b),_0x16a7d4=>{const _0x1745dd=_0x4bcec6;if(!SceneManager[_0x1745dd(0x772)]())return;if(!Imported[_0x1745dd(0x55d)])return;if(!BattleManager[_0x1745dd(0x914)]())return;VisuMZ[_0x1745dd(0x9b1)](_0x16a7d4,_0x16a7d4);let _0x5439f0=_0x16a7d4[_0x1745dd(0x9b6)];if(BattleManager[_0x1745dd(0xba3)]){BattleManager['_subject'][_0x1745dd(0x107)]=BattleManager[_0x1745dd(0xba3)][_0x1745dd(0x107)]||[];while(_0x5439f0--){if(BattleManager[_0x1745dd(0xba3)]['_actions'][_0x1745dd(0x64b)]<=0x0)break;BattleManager[_0x1745dd(0xba3)][_0x1745dd(0x107)][_0x1745dd(0x9a0)]();}}}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x255),_0x22feb9=>{const _0x522bed=_0x4bcec6;if(!SceneManager[_0x522bed(0x772)]())return;if(!Imported[_0x522bed(0x6b8)])return;VisuMZ[_0x522bed(0x9b1)](_0x22feb9,_0x22feb9);const _0x20558d=VisuMZ['CreateActionSequenceTargets'](_0x22feb9[_0x522bed(0x5bc)]),_0x2e71ad=_0x22feb9[_0x522bed(0x17e)];for(const _0x161586 of _0x20558d){if(!_0x161586)continue;if(!_0x161586[_0x522bed(0xbf8)]())continue;_0x161586[_0x522bed(0x245)](_0x2e71ad);}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Mechanics_TextPopup',_0x59dac2=>{const _0x33b227=_0x4bcec6;if(!SceneManager[_0x33b227(0x772)]())return;VisuMZ['ConvertParams'](_0x59dac2,_0x59dac2);const _0x4b94d6=VisuMZ[_0x33b227(0x8bd)](_0x59dac2[_0x33b227(0x5bc)]),_0x400d49=_0x59dac2[_0x33b227(0x35a)],_0x2d75f8={'textColor':ColorManager[_0x33b227(0xaaa)](_0x59dac2[_0x33b227(0x776)]),'flashColor':_0x59dac2[_0x33b227(0x53e)],'flashDuration':_0x59dac2[_0x33b227(0x40f)]};for(const _0x2bf27f of _0x4b94d6){if(!_0x2bf27f)continue;_0x2bf27f[_0x33b227(0x2ae)](_0x400d49,_0x2d75f8);}}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Mechanics_VariablePopup',_0x5277ac=>{const _0x4c771e=_0x4bcec6;if(!SceneManager[_0x4c771e(0x772)]())return;VisuMZ['ConvertParams'](_0x5277ac,_0x5277ac);const _0x5c055b=VisuMZ[_0x4c771e(0x8bd)](_0x5277ac[_0x4c771e(0x5bc)]);let _0x337c17=$gameVariables[_0x4c771e(0x6d9)](_0x5277ac[_0x4c771e(0x54f)]);Imported[_0x4c771e(0xa19)]&&_0x5277ac[_0x4c771e(0x9b8)]&&(_0x337c17=VisuMZ[_0x4c771e(0x574)](_0x337c17));const _0x1da7d1=String(_0x337c17),_0x872a1c={'textColor':ColorManager[_0x4c771e(0xaaa)](_0x5277ac[_0x4c771e(0x776)]),'flashColor':_0x5277ac[_0x4c771e(0x53e)],'flashDuration':_0x5277ac[_0x4c771e(0x40f)]};for(const _0x26063b of _0x5c055b){if(!_0x26063b)continue;_0x26063b[_0x4c771e(0x2ae)](_0x1da7d1,_0x872a1c);}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x927),_0x470396=>{const _0x370642=_0x4bcec6;if(!SceneManager[_0x370642(0x772)]())return;const _0xb32450=$gameTemp['getLastPluginCommandInterpreter']();if(!_0xb32450)return;_0xb32450[_0x370642(0x23d)]('battleEffect');}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Motion_ClearFreezeFrame',_0x3d554d=>{const _0x2d0314=_0x4bcec6;if(!SceneManager[_0x2d0314(0x772)]())return;VisuMZ['ConvertParams'](_0x3d554d,_0x3d554d);const _0x29f693=VisuMZ[_0x2d0314(0x8bd)](_0x3d554d['Targets']);for(const _0x42a84c of _0x29f693){if(!_0x42a84c)continue;_0x42a84c[_0x2d0314(0x3ff)]();}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Motion_FreezeMotionFrame',_0x4c7e2d=>{const _0x2c2992=_0x4bcec6;if(!SceneManager[_0x2c2992(0x772)]())return;VisuMZ['ConvertParams'](_0x4c7e2d,_0x4c7e2d);const _0x15409d=VisuMZ[_0x2c2992(0x8bd)](_0x4c7e2d[_0x2c2992(0x5bc)]),_0x3c0e7b=_0x4c7e2d['MotionType'][_0x2c2992(0xb8f)]()[_0x2c2992(0x7d5)]();let _0xdc8aa6=_0x4c7e2d[_0x2c2992(0x8f2)];const _0x5df8a5=_0x4c7e2d['Frame'];![_0x2c2992(0x856),_0x2c2992(0x4db),_0x2c2992(0x8bb),'missile'][_0x2c2992(0x5e4)](_0x3c0e7b)&&(_0xdc8aa6=![]);for(const _0x3ca7ec of _0x15409d){if(!_0x3ca7ec)continue;_0x3ca7ec['freezeMotion'](_0x3c0e7b,_0xdc8aa6,_0x5df8a5);}}),PluginManager['registerCommand'](pluginData['name'],'ActSeq_Motion_MotionType',_0x47d267=>{const _0x393cd5=_0x4bcec6;if(!SceneManager[_0x393cd5(0x772)]())return;VisuMZ['ConvertParams'](_0x47d267,_0x47d267);const _0x3a51b2=VisuMZ[_0x393cd5(0x8bd)](_0x47d267['Targets']),_0x27496a=_0x47d267[_0x393cd5(0x594)][_0x393cd5(0xb8f)]()['trim'](),_0xfb2e7=_0x47d267[_0x393cd5(0x8f2)];for(const _0x3ec2bd of _0x3a51b2){if(!_0x3ec2bd)continue;_0x3ec2bd[_0x393cd5(0x494)]=_0xfb2e7;if(_0x27496a['match'](/ATTACK[ ](\d+)/i))_0x3ec2bd['performAttackSlot'](Number(RegExp['$1']));else _0x27496a==='attack'?_0x3ec2bd[_0x393cd5(0x40b)]():_0x3ec2bd['requestMotion'](_0x27496a);if(!_0xfb2e7)_0x3ec2bd[_0x393cd5(0x523)](0x0);else{if(_0xfb2e7&&[_0x393cd5(0x4db),'swing','missle'][_0x393cd5(0x5e4)](_0x27496a)){}}_0x3ec2bd[_0x393cd5(0x494)]=undefined;}}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x522),_0xc19464=>{const _0x3721d1=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x3721d1(0x9b1)](_0xc19464,_0xc19464);const _0x4934b9=BattleManager[_0x3721d1(0x3fd)];if(!_0x4934b9)return;if(!_0x4934b9[_0x3721d1(0x93c)]())return;const _0x2a09aa=VisuMZ[_0x3721d1(0x8bd)](_0xc19464[_0x3721d1(0x5bc)]);for(const _0x5d13b5 of _0x2a09aa){if(!_0x5d13b5)continue;_0x5d13b5[_0x3721d1(0x2ba)](_0x4934b9);}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Motion_RefreshMotion',_0x556a87=>{const _0x14f320=_0x4bcec6;if(!SceneManager[_0x14f320(0x772)]())return;VisuMZ[_0x14f320(0x9b1)](_0x556a87,_0x556a87);const _0x15102e=VisuMZ[_0x14f320(0x8bd)](_0x556a87[_0x14f320(0x5bc)]);for(const _0x533620 of _0x15102e){if(!_0x533620)continue;if(!_0x533620[_0x14f320(0x171)]())continue;_0x533620[_0x14f320(0x171)]()['refreshMotion']();}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x3ef),_0x4d80a6=>{const _0x398f49=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x4d80a6,_0x4d80a6);const _0x144bc0=$gameTemp[_0x398f49(0x475)](),_0x2d4a16=_0x4d80a6[_0x398f49(0x851)]*Sprite_Battler[_0x398f49(0x88a)];_0x144bc0[_0x398f49(0x4b6)](_0x2d4a16);}),PluginManager['registerCommand'](pluginData['name'],'ActSeq_Movement_BattleStep',_0x5780eb=>{const _0x47d8e1=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x5780eb,_0x5780eb);const _0x146a5f=$gameTemp['getLastPluginCommandInterpreter'](),_0x585902=BattleManager[_0x47d8e1(0x3fd)];if(!_0x146a5f||!_0x585902)return;if(!_0x585902['item']())return;const _0x538159=VisuMZ[_0x47d8e1(0x8bd)](_0x5780eb['Targets']);for(const _0xc19c11 of _0x538159){if(!_0xc19c11)continue;_0xc19c11[_0x47d8e1(0x9c3)](_0x585902);}if(_0x5780eb[_0x47d8e1(0x303)])_0x146a5f[_0x47d8e1(0x23d)](_0x47d8e1(0x983));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x669),_0x32c831=>{const _0xed72=_0x4bcec6;if(!SceneManager[_0xed72(0x772)]())return;if(!$gameSystem[_0xed72(0xa77)]())return;VisuMZ[_0xed72(0x9b1)](_0x32c831,_0x32c831);const _0x128d45=$gameTemp[_0xed72(0x475)](),_0x1891cc=VisuMZ[_0xed72(0x8bd)](_0x32c831[_0xed72(0x5bc)]),_0x28116f=_0x32c831[_0xed72(0xb37)],_0x24890c=_0x32c831['DistanceX'],_0x41a06c=_0x32c831[_0xed72(0x853)],_0xfb1c90=_0x32c831[_0xed72(0x161)],_0x28d688=_0x32c831['FaceDirection'],_0x15bc3b=_0x32c831[_0xed72(0x1c0)],_0x2e479b=_0x32c831[_0xed72(0x594)],_0x1bcd85=_0x32c831[_0xed72(0x303)];if(!_0x128d45)return;for(const _0x2d5d3f of _0x1891cc){if(!_0x2d5d3f)continue;let _0x21d9ad=_0x24890c,_0xf1b0f8=_0x41a06c;if(_0x28116f[_0xed72(0x820)](/horz/i))_0x21d9ad*=_0x2d5d3f['isActor']()?-0x1:0x1;if(_0x28116f['match'](/vert/i))_0xf1b0f8*=_0x2d5d3f['isActor']()?-0x1:0x1;_0x2d5d3f['moveBattlerHomeDistance'](_0x21d9ad,_0xf1b0f8,_0xfb1c90,_0x28d688,_0x15bc3b),_0x2d5d3f[_0xed72(0x7ae)](_0x2e479b);}if(_0x1bcd85)_0x128d45['setWaitMode'](_0xed72(0x983));}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x1a7),_0x100cfd=>{const _0x5bf74e=_0x4bcec6;if(!SceneManager[_0x5bf74e(0x772)]())return;if(!$gameSystem[_0x5bf74e(0xa77)]())return;VisuMZ[_0x5bf74e(0x9b1)](_0x100cfd,_0x100cfd);const _0x37bdc4=$gameTemp[_0x5bf74e(0x475)](),_0x510d86=VisuMZ[_0x5bf74e(0x8bd)](_0x100cfd[_0x5bf74e(0x5bc)]),_0x310dc5=_0x100cfd[_0x5bf74e(0xa7e)],_0x3bb579=_0x100cfd[_0x5bf74e(0x2ca)],_0x3b2605=_0x100cfd[_0x5bf74e(0x651)],_0x2eb5a6=_0x100cfd['Duration'],_0x32594a=_0x100cfd['FaceDirection'],_0x46933a=_0x100cfd[_0x5bf74e(0x1c0)],_0x4f6f3d=_0x100cfd[_0x5bf74e(0x594)],_0x97b0f=_0x100cfd[_0x5bf74e(0x303)];if(!_0x37bdc4)return;for(const _0x6fbcd of _0x510d86){if(!_0x6fbcd)continue;const _0x29b558=_0x100cfd[_0x5bf74e(0x314)](_0x6fbcd)||{'x':0x0,'y':0x0};let _0x58dc3f=_0x29b558['x'],_0x56506f=_0x29b558['y'];if(_0x310dc5[_0x5bf74e(0x820)](/none/i))_0x58dc3f+=_0x3bb579,_0x56506f+=_0x3b2605;else{if(_0x310dc5[_0x5bf74e(0x820)](/horz/i)&&_0x310dc5[_0x5bf74e(0x820)](/vert/i))_0x58dc3f+=_0x6fbcd['isActor']()?-_0x3bb579:_0x3bb579,_0x56506f+=_0x6fbcd[_0x5bf74e(0xbf8)]()?-_0x3b2605:_0x3b2605;else{if(_0x310dc5[_0x5bf74e(0x820)](/horz/i))_0x58dc3f+=_0x6fbcd['isActor']()?-_0x3bb579:_0x3bb579,_0x56506f+=_0x3b2605;else _0x310dc5[_0x5bf74e(0x820)](/vert/i)&&(_0x58dc3f+=_0x3bb579,_0x56506f+=_0x6fbcd[_0x5bf74e(0xbf8)]()?-_0x3b2605:_0x3b2605);}}_0x6fbcd[_0x5bf74e(0x995)](_0x58dc3f,_0x56506f,_0x2eb5a6,_0x32594a,_0x46933a,-0x1),_0x6fbcd[_0x5bf74e(0x7ae)](_0x4f6f3d);}if(_0x97b0f)_0x37bdc4[_0x5bf74e(0x23d)](_0x5bf74e(0x983));}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x876),_0x43ac6f=>{const _0x57766a=_0x4bcec6;if(!SceneManager[_0x57766a(0x772)]())return;if(!$gameSystem['isSideView']())return;VisuMZ['ConvertParams'](_0x43ac6f,_0x43ac6f);const _0x1c070f=$gameTemp['getLastPluginCommandInterpreter'](),_0x15cdc7=VisuMZ[_0x57766a(0x8bd)](_0x43ac6f[_0x57766a(0x5bc)]),_0x844582=_0x43ac6f['Destination'],_0x38ed81=_0x43ac6f[_0x57766a(0xa7e)],_0x7ea1b7=_0x43ac6f[_0x57766a(0x2ca)],_0x438c37=_0x43ac6f['OffsetY'],_0x40cb5e=_0x43ac6f['Duration'],_0x3702e9=_0x43ac6f[_0x57766a(0x559)],_0x54f5ac=_0x43ac6f[_0x57766a(0x1c0)],_0x13fe5d=_0x43ac6f[_0x57766a(0x594)],_0x1c0857=_0x43ac6f[_0x57766a(0x303)];if(!_0x1c070f)return;for(const _0xfe9c2e of _0x15cdc7){if(!_0xfe9c2e)continue;let _0x52d4a2=_0xfe9c2e['battler']()[_0x57766a(0x7e7)],_0x2352d4=_0xfe9c2e[_0x57766a(0x171)]()['_baseY'];if(_0x844582[_0x57766a(0x820)](/home/i))_0x52d4a2=_0xfe9c2e[_0x57766a(0x171)]()[_0x57766a(0xb14)],_0x2352d4=_0xfe9c2e['battler']()[_0x57766a(0xbb3)];else{if(_0x844582[_0x57766a(0x820)](/center/i))_0x52d4a2=Graphics[_0x57766a(0x825)]/0x2,_0x2352d4=Graphics[_0x57766a(0x61b)]/0x2;else _0x844582[_0x57766a(0x820)](/point (\d+), (\d+)/i)&&(_0x52d4a2=Number(RegExp['$1']),_0x2352d4=Number(RegExp['$2']));}if(_0x38ed81['match'](/none/i))_0x52d4a2+=_0x7ea1b7,_0x2352d4+=_0x438c37;else{if(_0x38ed81[_0x57766a(0x820)](/horz/i)&&_0x38ed81[_0x57766a(0x820)](/vert/i))_0x52d4a2+=_0xfe9c2e[_0x57766a(0xbf8)]()?-_0x7ea1b7:_0x7ea1b7,_0x2352d4+=_0xfe9c2e[_0x57766a(0xbf8)]()?-_0x438c37:_0x438c37;else{if(_0x38ed81[_0x57766a(0x820)](/horz/i))_0x52d4a2+=_0xfe9c2e[_0x57766a(0xbf8)]()?-_0x7ea1b7:_0x7ea1b7,_0x2352d4+=_0x438c37;else _0x38ed81[_0x57766a(0x820)](/vert/i)&&(_0x52d4a2+=_0x7ea1b7,_0x2352d4+=_0xfe9c2e['isActor']()?-_0x438c37:_0x438c37);}}_0xfe9c2e['moveBattlerHomeToPoint'](_0x52d4a2,_0x2352d4,_0x40cb5e,_0x3702e9,_0x54f5ac,-0x1),_0xfe9c2e['requestMotion'](_0x13fe5d);}if(_0x1c0857)_0x1c070f['setWaitMode'](_0x57766a(0x983));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xbe9),_0x293d7e=>{const _0x3bb1fc=_0x4bcec6;if(!SceneManager[_0x3bb1fc(0x772)]())return;if(!$gameSystem[_0x3bb1fc(0xa77)]())return;VisuMZ[_0x3bb1fc(0x9b1)](_0x293d7e,_0x293d7e);const _0x4ef068=$gameTemp[_0x3bb1fc(0x475)](),_0x361347=VisuMZ[_0x3bb1fc(0x8bd)](_0x293d7e[_0x3bb1fc(0x9cf)]),_0x139645=VisuMZ['CreateActionSequenceTargets'](_0x293d7e['Targets2']),_0x548b72=_0x293d7e[_0x3bb1fc(0x169)];let _0x5a3bf5=_0x293d7e[_0x3bb1fc(0xa36)];const _0x5b5d56=_0x293d7e['OffsetAdjust'],_0x284166=_0x293d7e[_0x3bb1fc(0x2ca)],_0x63ad12=_0x293d7e['OffsetY'],_0x4b7123=_0x293d7e['Duration'],_0x48a184=_0x293d7e[_0x3bb1fc(0x559)],_0x1a853f=_0x293d7e[_0x3bb1fc(0x1c0)],_0x2ffdda=_0x293d7e[_0x3bb1fc(0x594)],_0x4bffb5=_0x293d7e[_0x3bb1fc(0x303)],_0x18f544=Math[_0x3bb1fc(0x540)](..._0x139645[_0x3bb1fc(0x228)](_0x189b34=>_0x189b34['battler']()[_0x3bb1fc(0x7e7)]-_0x189b34[_0x3bb1fc(0x171)]()[_0x3bb1fc(0x758)]()/0x2)),_0x521bc6=Math[_0x3bb1fc(0x4d5)](..._0x139645['map'](_0x19a858=>_0x19a858['battler']()[_0x3bb1fc(0x7e7)]+_0x19a858['battler']()[_0x3bb1fc(0x758)]()/0x2)),_0x2ef6f1=Math[_0x3bb1fc(0x540)](..._0x139645[_0x3bb1fc(0x228)](_0x35d4cb=>_0x35d4cb[_0x3bb1fc(0x171)]()[_0x3bb1fc(0xbb1)]-_0x35d4cb['battler']()[_0x3bb1fc(0x11a)]())),_0x389a44=Math['max'](..._0x139645[_0x3bb1fc(0x228)](_0x595c60=>_0x595c60[_0x3bb1fc(0x171)]()['_baseY'])),_0xf8f462=_0x139645['filter'](_0x5350dd=>_0x5350dd[_0x3bb1fc(0xbf8)]())[_0x3bb1fc(0x64b)],_0xb7f00a=_0x139645[_0x3bb1fc(0x9f4)](_0x432c2a=>_0x432c2a[_0x3bb1fc(0x52e)]())['length'];let _0x1a1364=0x0,_0x73c627=0x0;if(_0x548b72['match'](/front/i))_0x1a1364=_0xf8f462>=_0xb7f00a?_0x18f544:_0x521bc6;else{if(_0x548b72[_0x3bb1fc(0x820)](/middle/i))_0x1a1364=(_0x18f544+_0x521bc6)/0x2,_0x5a3bf5=-0x1;else _0x548b72[_0x3bb1fc(0x820)](/back/i)&&(_0x1a1364=_0xf8f462>=_0xb7f00a?_0x521bc6:_0x18f544);}if(_0x548b72[_0x3bb1fc(0x820)](/head/i))_0x73c627=_0x2ef6f1;else{if(_0x548b72[_0x3bb1fc(0x820)](/center/i))_0x73c627=(_0x2ef6f1+_0x389a44)/0x2;else _0x548b72['match'](/base/i)&&(_0x73c627=_0x389a44);}if(!_0x4ef068)return;for(const _0x378c21 of _0x361347){if(!_0x378c21)continue;let _0x519b0a=_0x1a1364,_0x4d8dcf=_0x73c627;if(_0x5b5d56[_0x3bb1fc(0x820)](/none/i))_0x519b0a+=_0x284166,_0x4d8dcf+=_0x63ad12;else{if(_0x5b5d56[_0x3bb1fc(0x820)](/horz/i)&&_0x5b5d56[_0x3bb1fc(0x820)](/vert/i))_0x519b0a+=_0x378c21[_0x3bb1fc(0xbf8)]()?-_0x284166:_0x284166,_0x4d8dcf+=_0x378c21[_0x3bb1fc(0xbf8)]()?-_0x63ad12:_0x63ad12;else{if(_0x5b5d56[_0x3bb1fc(0x820)](/horz/i))_0x519b0a+=_0x378c21[_0x3bb1fc(0xbf8)]()?-_0x284166:_0x284166,_0x4d8dcf+=_0x63ad12;else _0x5b5d56[_0x3bb1fc(0x820)](/vert/i)&&(_0x519b0a+=_0x284166,_0x4d8dcf+=_0x378c21['isActor']()?-_0x63ad12:_0x63ad12);}}_0x378c21[_0x3bb1fc(0x995)](_0x519b0a,_0x4d8dcf,_0x4b7123,_0x48a184,_0x1a853f,_0x5a3bf5),_0x378c21[_0x3bb1fc(0x7ae)](_0x2ffdda);}if(_0x4bffb5)_0x4ef068[_0x3bb1fc(0x23d)]('battleMove');}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xa1e),_0x2276e3=>{const _0x3f4312=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem[_0x3f4312(0xa77)]())return;VisuMZ[_0x3f4312(0x9b1)](_0x2276e3,_0x2276e3);const _0x4f54f2=VisuMZ[_0x3f4312(0x8bd)](_0x2276e3[_0x3f4312(0x5bc)]);let _0x11c547=_0x2276e3[_0x3f4312(0x38c)]['match'](/back/i);for(const _0x289284 of _0x4f54f2){if(!_0x289284)continue;if(_0x2276e3[_0x3f4312(0x38c)]['match'](/rand/i))_0x11c547=Math['randomInt'](0x2);_0x289284['setBattlerFlip'](!!_0x11c547);}}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x2c7),_0x2c19de=>{const _0x5129fb=_0x4bcec6;if(!SceneManager[_0x5129fb(0x772)]())return;if(!$gameSystem[_0x5129fb(0xa77)]())return;VisuMZ[_0x5129fb(0x9b1)](_0x2c19de,_0x2c19de);const _0x141fae=VisuMZ['CreateActionSequenceTargets'](_0x2c19de['Targets']),_0x1282df=_0x2c19de['FaceAway'];for(const _0x37d9fd of _0x141fae){if(!_0x37d9fd)continue;const _0x627073=_0x2c19de[_0x5129fb(0x28d)](_0x37d9fd)||{'x':0x0,'y':0x0};let _0x23710f=_0x627073['x'],_0x1e829d=_0x627073['y'];_0x37d9fd['setBattlerFacePoint'](Math[_0x5129fb(0x7f7)](_0x23710f),Math[_0x5129fb(0x7f7)](_0x1e829d),!!_0x1282df);}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xb50),_0x2c5bd7=>{const _0x37c95a=_0x4bcec6;if(!SceneManager[_0x37c95a(0x772)]())return;if(!$gameSystem[_0x37c95a(0xa77)]())return;VisuMZ[_0x37c95a(0x9b1)](_0x2c5bd7,_0x2c5bd7);const _0x2ea82e=VisuMZ[_0x37c95a(0x8bd)](_0x2c5bd7['Targets']);let _0x54e1b3=_0x2c5bd7[_0x37c95a(0x33d)];const _0xbbd894=_0x2c5bd7[_0x37c95a(0x203)];for(const _0x4ec77f of _0x2ea82e){if(!_0x4ec77f)continue;let _0x57f8af=_0x4ec77f['battler']()[_0x37c95a(0x7e7)],_0x2f5bf5=_0x4ec77f[_0x37c95a(0x171)]()['_baseY'];if(_0x54e1b3[_0x37c95a(0x820)](/home/i))_0x57f8af=_0x4ec77f['battler']()['_homeX'],_0x2f5bf5=_0x4ec77f[_0x37c95a(0x171)]()[_0x37c95a(0xbb3)];else{if(_0x54e1b3[_0x37c95a(0x820)](/center/i))_0x57f8af=Graphics[_0x37c95a(0x825)]/0x2,_0x2f5bf5=Graphics[_0x37c95a(0x61b)]/0x2;else _0x54e1b3[_0x37c95a(0x820)](/point (\d+), (\d+)/i)&&(_0x57f8af=Number(RegExp['$1']),_0x2f5bf5=Number(RegExp['$2']));}_0x4ec77f[_0x37c95a(0x251)](Math[_0x37c95a(0x7f7)](_0x57f8af),Math[_0x37c95a(0x7f7)](_0x2f5bf5),!!_0xbbd894);}}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x6df),_0x5e95be=>{const _0x5b37d7=_0x4bcec6;if(!SceneManager[_0x5b37d7(0x772)]())return;if(!$gameSystem[_0x5b37d7(0xa77)]())return;VisuMZ[_0x5b37d7(0x9b1)](_0x5e95be,_0x5e95be);const _0x2a4f05=VisuMZ[_0x5b37d7(0x8bd)](_0x5e95be['Targets1']),_0x1910d2=VisuMZ[_0x5b37d7(0x8bd)](_0x5e95be[_0x5b37d7(0xa87)]),_0x59c956=_0x1910d2[_0x5b37d7(0x228)](_0x1d8e45=>_0x1d8e45&&_0x1d8e45[_0x5b37d7(0x171)]()?_0x1d8e45['battler']()[_0x5b37d7(0x7e7)]:0x0)/(_0x1910d2[_0x5b37d7(0x64b)]||0x1),_0x351757=_0x1910d2[_0x5b37d7(0x228)](_0x306524=>_0x306524&&_0x306524[_0x5b37d7(0x171)]()?_0x306524[_0x5b37d7(0x171)]()[_0x5b37d7(0xbb1)]:0x0)/(_0x1910d2['length']||0x1),_0x4b2288=_0x5e95be['FaceAway'];for(const _0x138ce of _0x2a4f05){if(!_0x138ce)continue;_0x138ce[_0x5b37d7(0x251)](Math[_0x5b37d7(0x7f7)](_0x59c956),Math[_0x5b37d7(0x7f7)](_0x351757),!!_0x4b2288);}}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Movement_Float',_0x40e865=>{const _0x4db53b=_0x4bcec6;if(!SceneManager[_0x4db53b(0x772)]())return;VisuMZ[_0x4db53b(0x9b1)](_0x40e865,_0x40e865);const _0xa8ce12=$gameTemp[_0x4db53b(0x475)](),_0x49f774=VisuMZ[_0x4db53b(0x8bd)](_0x40e865[_0x4db53b(0x5bc)]),_0x512c4f=_0x40e865['Height'],_0x2c0a47=_0x40e865[_0x4db53b(0x161)],_0x32451c=_0x40e865['EasingType'],_0x4b9d92=_0x40e865['WaitForFloat'];if(!_0xa8ce12)return;for(const _0x5ec0b2 of _0x49f774){if(!_0x5ec0b2)continue;_0x5ec0b2['floatBattler'](_0x512c4f,_0x2c0a47,_0x32451c);}if(_0x4b9d92)_0xa8ce12[_0x4db53b(0x23d)]('battleFloat');}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xa9d),_0x5a7452=>{const _0x117787=_0x4bcec6;if(!SceneManager[_0x117787(0x772)]())return;VisuMZ['ConvertParams'](_0x5a7452,_0x5a7452);const _0xfda6d0=$gameTemp['getLastPluginCommandInterpreter']();if(!_0xfda6d0)return;const _0x15a147=VisuMZ[_0x117787(0x8bd)](_0x5a7452[_0x117787(0x5bc)]);for(const _0x45dd27 of _0x15a147){if(!_0x45dd27)continue;_0x45dd27['performActionEndMembers']();}BattleManager[_0x117787(0xba3)]&&BattleManager[_0x117787(0xba3)]['performActionEnd']();if(_0x5a7452[_0x117787(0x303)])_0xfda6d0[_0x117787(0x23d)](_0x117787(0x983));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x13f),_0x26d8e9=>{const _0x412bc8=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x26d8e9,_0x26d8e9);const _0x15841b=$gameTemp[_0x412bc8(0x475)](),_0x53f9ad=VisuMZ[_0x412bc8(0x8bd)](_0x26d8e9['Targets']),_0x344954=_0x26d8e9[_0x412bc8(0x94c)],_0x53e23c=_0x26d8e9[_0x412bc8(0x161)],_0x2e923a=_0x26d8e9[_0x412bc8(0xb95)];if(!_0x15841b)return;for(const _0x572dda of _0x53f9ad){if(!_0x572dda)continue;_0x572dda[_0x412bc8(0x70d)](_0x344954,_0x53e23c);}if(_0x2e923a)_0x15841b[_0x412bc8(0x23d)](_0x412bc8(0x872));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Movement_MoveBy',_0x19bd7e=>{const _0x3e68f7=_0x4bcec6;if(!SceneManager[_0x3e68f7(0x772)]())return;if(!$gameSystem[_0x3e68f7(0xa77)]())return;VisuMZ[_0x3e68f7(0x9b1)](_0x19bd7e,_0x19bd7e);const _0x1c1b5d=$gameTemp[_0x3e68f7(0x475)](),_0x28c338=VisuMZ[_0x3e68f7(0x8bd)](_0x19bd7e[_0x3e68f7(0x5bc)]),_0x54653b=_0x19bd7e[_0x3e68f7(0xb37)],_0x19a4a9=_0x19bd7e[_0x3e68f7(0x6f5)],_0x527e83=_0x19bd7e[_0x3e68f7(0x853)],_0x41eb58=_0x19bd7e[_0x3e68f7(0x161)],_0x12bbca=_0x19bd7e[_0x3e68f7(0x559)],_0x2bcf11=_0x19bd7e[_0x3e68f7(0x1c0)],_0x47a54e=_0x19bd7e[_0x3e68f7(0x594)],_0x5ca116=_0x19bd7e[_0x3e68f7(0x303)];if(!_0x1c1b5d)return;for(const _0xbec35b of _0x28c338){if(!_0xbec35b)continue;let _0x1fd04b=_0x19a4a9,_0x39080f=_0x527e83;if(_0x54653b[_0x3e68f7(0x820)](/horz/i))_0x1fd04b*=_0xbec35b['isActor']()?-0x1:0x1;if(_0x54653b[_0x3e68f7(0x820)](/vert/i))_0x39080f*=_0xbec35b[_0x3e68f7(0xbf8)]()?-0x1:0x1;_0xbec35b[_0x3e68f7(0x128)](_0x1fd04b,_0x39080f,_0x41eb58,_0x12bbca,_0x2bcf11),_0xbec35b[_0x3e68f7(0x7ae)](_0x47a54e);}if(_0x5ca116)_0x1c1b5d['setWaitMode'](_0x3e68f7(0x983));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x391),_0x351386=>{const _0xc3d0c0=_0x4bcec6;if(!SceneManager[_0xc3d0c0(0x772)]())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0xc3d0c0(0x9b1)](_0x351386,_0x351386);const _0x23d155=$gameTemp[_0xc3d0c0(0x475)](),_0x460a8a=VisuMZ['CreateActionSequenceTargets'](_0x351386['Targets']),_0x5edccd=_0x351386[_0xc3d0c0(0xa7e)],_0x5236a8=_0x351386['OffsetX'],_0x14201e=_0x351386['OffsetY'],_0x1a6d71=_0x351386[_0xc3d0c0(0x161)],_0x636ab2=_0x351386[_0xc3d0c0(0x559)],_0x5a6d16=_0x351386[_0xc3d0c0(0x1c0)],_0x5b2085=_0x351386['MotionType'],_0x3b0cc2=_0x351386[_0xc3d0c0(0x303)];if(!_0x23d155)return;for(const _0x16f6df of _0x460a8a){if(!_0x16f6df)continue;const _0x28167a=_0x351386[_0xc3d0c0(0x314)](_0x16f6df)||{'x':0x0,'y':0x0};let _0x2b42d3=_0x28167a['x'],_0x2263b2=_0x28167a['y'];if(_0x5edccd[_0xc3d0c0(0x820)](/none/i))_0x2b42d3+=_0x5236a8,_0x2263b2+=_0x14201e;else{if(_0x5edccd[_0xc3d0c0(0x820)](/horz/i)&&_0x5edccd[_0xc3d0c0(0x820)](/vert/i))_0x2b42d3+=_0x16f6df['isActor']()?-_0x5236a8:_0x5236a8,_0x2263b2+=_0x16f6df['isActor']()?-_0x14201e:_0x14201e;else{if(_0x5edccd[_0xc3d0c0(0x820)](/horz/i))_0x2b42d3+=_0x16f6df[_0xc3d0c0(0xbf8)]()?-_0x5236a8:_0x5236a8,_0x2263b2+=_0x14201e;else _0x5edccd[_0xc3d0c0(0x820)](/vert/i)&&(_0x2b42d3+=_0x5236a8,_0x2263b2+=_0x16f6df['isActor']()?-_0x14201e:_0x14201e);}}_0x16f6df[_0xc3d0c0(0xac3)](_0x2b42d3,_0x2263b2,_0x1a6d71,_0x636ab2,_0x5a6d16,-0x1),_0x16f6df['requestMotion'](_0x5b2085);}if(_0x3b0cc2)_0x23d155[_0xc3d0c0(0x23d)](_0xc3d0c0(0x983));}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],'ActSeq_Movement_MoveToPoint',_0x56d449=>{const _0x358f53=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x358f53(0x9b1)](_0x56d449,_0x56d449);const _0x3ff74c=$gameTemp[_0x358f53(0x475)](),_0x11ccfa=VisuMZ[_0x358f53(0x8bd)](_0x56d449['Targets']),_0x446e4e=_0x56d449[_0x358f53(0xad9)],_0x439fcf=_0x56d449['OffsetAdjust'],_0x55646a=_0x56d449[_0x358f53(0x2ca)],_0x34dc57=_0x56d449[_0x358f53(0x651)],_0x8d0fe=_0x56d449[_0x358f53(0x161)],_0x1b7a5f=_0x56d449['FaceDirection'],_0x2a24d4=_0x56d449[_0x358f53(0x1c0)],_0x3c3453=_0x56d449[_0x358f53(0x594)],_0x349de7=_0x56d449['WaitForMovement'];if(!_0x3ff74c)return;for(const _0x455224 of _0x11ccfa){if(!_0x455224)continue;let _0x358a9b=_0x455224[_0x358f53(0x171)]()['_baseX'],_0x5185d9=_0x455224[_0x358f53(0x171)]()[_0x358f53(0xbb1)];if(_0x446e4e[_0x358f53(0x820)](/home/i))_0x358a9b=_0x455224[_0x358f53(0x171)]()[_0x358f53(0xb14)],_0x5185d9=_0x455224['battler']()[_0x358f53(0xbb3)];else{if(_0x446e4e['match'](/center/i))_0x358a9b=Graphics[_0x358f53(0x825)]/0x2,_0x5185d9=Graphics['boxHeight']/0x2;else _0x446e4e[_0x358f53(0x820)](/point (\d+), (\d+)/i)&&(_0x358a9b=Number(RegExp['$1']),_0x5185d9=Number(RegExp['$2']));}if(_0x439fcf[_0x358f53(0x820)](/none/i))_0x358a9b+=_0x55646a,_0x5185d9+=_0x34dc57;else{if(_0x439fcf[_0x358f53(0x820)](/horz/i)&&_0x439fcf[_0x358f53(0x820)](/vert/i))_0x358a9b+=_0x455224[_0x358f53(0xbf8)]()?-_0x55646a:_0x55646a,_0x5185d9+=_0x455224[_0x358f53(0xbf8)]()?-_0x34dc57:_0x34dc57;else{if(_0x439fcf[_0x358f53(0x820)](/horz/i))_0x358a9b+=_0x455224['isActor']()?-_0x55646a:_0x55646a,_0x5185d9+=_0x34dc57;else _0x439fcf[_0x358f53(0x820)](/vert/i)&&(_0x358a9b+=_0x55646a,_0x5185d9+=_0x455224[_0x358f53(0xbf8)]()?-_0x34dc57:_0x34dc57);}}_0x455224['moveBattlerToPoint'](_0x358a9b,_0x5185d9,_0x8d0fe,_0x1b7a5f,_0x2a24d4,-0x1),_0x455224[_0x358f53(0x7ae)](_0x3c3453);}if(_0x349de7)_0x3ff74c['setWaitMode']('battleMove');}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x664),_0x27d0e8=>{const _0x306eb9=_0x4bcec6;if(!SceneManager[_0x306eb9(0x772)]())return;if(!$gameSystem['isSideView']())return;VisuMZ['ConvertParams'](_0x27d0e8,_0x27d0e8);const _0x4db139=$gameTemp[_0x306eb9(0x475)](),_0x584c99=VisuMZ['CreateActionSequenceTargets'](_0x27d0e8[_0x306eb9(0x9cf)]),_0x20e1a8=VisuMZ['CreateActionSequenceTargets'](_0x27d0e8[_0x306eb9(0xa87)]),_0x59f61c=_0x27d0e8[_0x306eb9(0x169)];let _0xa9253f=_0x27d0e8[_0x306eb9(0xa36)];const _0x1a32f5=_0x27d0e8['OffsetAdjust'],_0x106ae4=_0x27d0e8[_0x306eb9(0x2ca)],_0x101ad4=_0x27d0e8[_0x306eb9(0x651)],_0x326ddb=_0x27d0e8[_0x306eb9(0x161)],_0x259658=_0x27d0e8[_0x306eb9(0x559)],_0x316d86=_0x27d0e8[_0x306eb9(0x1c0)],_0x27aeff=_0x27d0e8[_0x306eb9(0x594)],_0x1714cb=_0x27d0e8[_0x306eb9(0x303)],_0xf07392=Math[_0x306eb9(0x540)](..._0x20e1a8['map'](_0x624355=>_0x624355[_0x306eb9(0x171)]()[_0x306eb9(0x7e7)]-_0x624355['battler']()[_0x306eb9(0x758)]()/0x2)),_0x1620b8=Math[_0x306eb9(0x4d5)](..._0x20e1a8[_0x306eb9(0x228)](_0x50d9d8=>_0x50d9d8['battler']()['_baseX']+_0x50d9d8[_0x306eb9(0x171)]()[_0x306eb9(0x758)]()/0x2)),_0x5dc221=Math['min'](..._0x20e1a8[_0x306eb9(0x228)](_0x5dd344=>_0x5dd344[_0x306eb9(0x171)]()[_0x306eb9(0xbb1)]-_0x5dd344[_0x306eb9(0x171)]()[_0x306eb9(0x11a)]())),_0x305646=Math[_0x306eb9(0x4d5)](..._0x20e1a8[_0x306eb9(0x228)](_0x2ef3a1=>_0x2ef3a1[_0x306eb9(0x171)]()[_0x306eb9(0xbb1)])),_0x8fed94=_0x20e1a8['filter'](_0x46818a=>_0x46818a[_0x306eb9(0xbf8)]())['length'],_0x169d36=_0x20e1a8[_0x306eb9(0x9f4)](_0x3d2686=>_0x3d2686['isEnemy']())[_0x306eb9(0x64b)];let _0x27ebea=0x0,_0x53555a=0x0;if(_0x59f61c[_0x306eb9(0x820)](/front/i))_0x27ebea=_0x8fed94>=_0x169d36?_0xf07392:_0x1620b8;else{if(_0x59f61c['match'](/middle/i))_0x27ebea=(_0xf07392+_0x1620b8)/0x2,_0xa9253f=-0x1;else _0x59f61c[_0x306eb9(0x820)](/back/i)&&(_0x27ebea=_0x8fed94>=_0x169d36?_0x1620b8:_0xf07392);}if(_0x59f61c[_0x306eb9(0x820)](/head/i))_0x53555a=_0x5dc221;else{if(_0x59f61c[_0x306eb9(0x820)](/center/i))_0x53555a=(_0x5dc221+_0x305646)/0x2;else _0x59f61c[_0x306eb9(0x820)](/base/i)&&(_0x53555a=_0x305646);}if(!_0x4db139)return;for(const _0x4ef5dd of _0x584c99){if(!_0x4ef5dd)continue;let _0x1ff593=_0x27ebea,_0x3900ed=_0x53555a;if(_0x1a32f5[_0x306eb9(0x820)](/none/i))_0x1ff593+=_0x106ae4,_0x3900ed+=_0x101ad4;else{if(_0x1a32f5[_0x306eb9(0x820)](/horz/i)&&_0x1a32f5[_0x306eb9(0x820)](/vert/i))_0x1ff593+=_0x4ef5dd['isActor']()?-_0x106ae4:_0x106ae4,_0x3900ed+=_0x4ef5dd[_0x306eb9(0xbf8)]()?-_0x101ad4:_0x101ad4;else{if(_0x1a32f5[_0x306eb9(0x820)](/horz/i))_0x1ff593+=_0x4ef5dd[_0x306eb9(0xbf8)]()?-_0x106ae4:_0x106ae4,_0x3900ed+=_0x101ad4;else _0x1a32f5[_0x306eb9(0x820)](/vert/i)&&(_0x1ff593+=_0x106ae4,_0x3900ed+=_0x4ef5dd['isActor']()?-_0x101ad4:_0x101ad4);}}_0x4ef5dd[_0x306eb9(0xac3)](_0x1ff593,_0x3900ed,_0x326ddb,_0x259658,_0x316d86,_0xa9253f),_0x4ef5dd[_0x306eb9(0x7ae)](_0x27aeff);}if(_0x1714cb)_0x4db139[_0x306eb9(0x23d)]('battleMove');}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x8e0),_0x1adca1=>{const _0x1c1931=_0x4bcec6;if(!SceneManager[_0x1c1931(0x772)]())return;VisuMZ[_0x1c1931(0x9b1)](_0x1adca1,_0x1adca1);const _0x5bc264=$gameTemp[_0x1c1931(0x475)](),_0xf07df2=VisuMZ[_0x1c1931(0x8bd)](_0x1adca1[_0x1c1931(0x5bc)]),_0x4067aa=_0x1adca1[_0x1c1931(0x7c7)],_0x41ae21=_0x1adca1[_0x1c1931(0x161)],_0x1303b9=_0x1adca1['EasingType'],_0x15c88e=_0x1adca1[_0x1c1931(0x47e)];if(!_0x5bc264)return;for(const _0x31051f of _0xf07df2){if(!_0x31051f)continue;_0x31051f[_0x1c1931(0x765)](_0x4067aa,_0x41ae21,_0x1303b9);}if(_0x15c88e)_0x5bc264[_0x1c1931(0x23d)]('battleOpacity');}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x7f5),_0x1721f9=>{const _0x33a9d0=_0x4bcec6;if(!SceneManager[_0x33a9d0(0x772)]())return;VisuMZ[_0x33a9d0(0x9b1)](_0x1721f9,_0x1721f9);const _0x222ba9=$gameTemp[_0x33a9d0(0x475)](),_0x3e7ec2=VisuMZ[_0x33a9d0(0x8bd)](_0x1721f9[_0x33a9d0(0x5bc)]),_0x18d2bc=_0x1721f9['ScaleX'],_0x501124=_0x1721f9[_0x33a9d0(0x6b0)],_0x189cf4=_0x1721f9['Duration'],_0x33b1c7=_0x1721f9[_0x33a9d0(0x1c0)],_0x490b4=_0x1721f9[_0x33a9d0(0x4d0)];if(!_0x222ba9)return;for(const _0x5bd516 of _0x3e7ec2){if(!_0x5bd516)continue;_0x5bd516[_0x33a9d0(0xaa0)](_0x18d2bc,_0x501124,_0x189cf4,_0x33b1c7);}if(_0x490b4)_0x222ba9['setWaitMode'](_0x33a9d0(0x41d));}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x586),_0x4dadd6=>{const _0x11b932=_0x4bcec6;if(!SceneManager[_0x11b932(0x772)]())return;VisuMZ[_0x11b932(0x9b1)](_0x4dadd6,_0x4dadd6);const _0x2e7fff=$gameTemp['getLastPluginCommandInterpreter'](),_0x59e626=VisuMZ[_0x11b932(0x8bd)](_0x4dadd6['Targets']),_0x4fd071=_0x4dadd6['SkewX'],_0x255fee=_0x4dadd6[_0x11b932(0x3af)],_0x56f390=_0x4dadd6[_0x11b932(0x161)],_0x3062e0=_0x4dadd6['EasingType'],_0x2eac99=_0x4dadd6[_0x11b932(0x439)];if(!_0x2e7fff)return;for(const _0x5563a7 of _0x59e626){if(!_0x5563a7)continue;_0x5563a7[_0x11b932(0x6f2)](_0x4fd071,_0x255fee,_0x56f390,_0x3062e0);}if(_0x2eac99)_0x2e7fff[_0x11b932(0x23d)](_0x11b932(0x951));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x576),_0x31d9d1=>{const _0x501996=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x501996(0x9b1)](_0x31d9d1,_0x31d9d1);const _0x46c208=$gameTemp[_0x501996(0x475)](),_0x384464=VisuMZ['CreateActionSequenceTargets'](_0x31d9d1['Targets']),_0x59446a=_0x31d9d1[_0x501996(0xaa1)],_0x4ba15b=_0x31d9d1[_0x501996(0x161)],_0xbc7e3b=_0x31d9d1['EasingType'],_0x4c9954=_0x31d9d1[_0x501996(0xabc)],_0x24d807=_0x31d9d1[_0x501996(0x323)];if(!_0x46c208)return;for(const _0x472868 of _0x384464){if(!_0x472868)continue;_0x472868[_0x501996(0x70e)](_0x59446a,_0x4ba15b,_0xbc7e3b,_0x4c9954);}if(_0x24d807)_0x46c208['setWaitMode']('battleSpin');}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x3be),_0x287b2f=>{const _0x426ccd=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;const _0x758268=$gameTemp[_0x426ccd(0x475)]();if(!_0x758268)return;_0x758268[_0x426ccd(0x23d)](_0x426ccd(0xa8c));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x51b),_0x47c4fd=>{const _0x25962c=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;const _0x35f136=$gameTemp[_0x25962c(0x475)]();if(!_0x35f136)return;_0x35f136['setWaitMode'](_0x25962c(0x872));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x5a7),_0x18baef=>{const _0x287ef9=_0x4bcec6;if(!SceneManager[_0x287ef9(0x772)]())return;const _0x3e806e=$gameTemp[_0x287ef9(0x475)]();if(!_0x3e806e)return;_0x3e806e[_0x287ef9(0x23d)]('battleMove');}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Movement_WaitForOpacity',_0x47e1d2=>{const _0x1738b5=_0x4bcec6;if(!SceneManager[_0x1738b5(0x772)]())return;const _0x29149b=$gameTemp[_0x1738b5(0x475)]();if(!_0x29149b)return;_0x29149b['setWaitMode'](_0x1738b5(0x263));}),PluginManager['registerCommand'](pluginData['name'],_0x4bcec6(0x72b),_0x3bd959=>{const _0x142cfa=_0x4bcec6;if(!SceneManager[_0x142cfa(0x772)]())return;const _0x460b82=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x460b82)return;_0x460b82[_0x142cfa(0x23d)](_0x142cfa(0x41d));}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],'ActSeq_Movement_WaitForSkew',_0xfd91aa=>{const _0x7e6c12=_0x4bcec6;if(!SceneManager[_0x7e6c12(0x772)]())return;const _0x43df5a=$gameTemp[_0x7e6c12(0x475)]();if(!_0x43df5a)return;_0x43df5a[_0x7e6c12(0x23d)]('battleSpriteSkew');}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xa2f),_0x428a3a=>{const _0x21d0af=_0x4bcec6;if(!SceneManager[_0x21d0af(0x772)]())return;const _0xcfbae9=$gameTemp[_0x21d0af(0x475)]();if(!_0xcfbae9)return;_0xcfbae9[_0x21d0af(0x23d)](_0x21d0af(0x9c9));}),VisuMZ['BattleCore'][_0x4bcec6(0x552)]=function(){const _0x3166bd=_0x4bcec6;if(!Imported[_0x3166bd(0x609)])return;if(VisuMZ[_0x3166bd(0x6ec)][_0x3166bd(0x6e5)]<1.08){let _0x42815c='';_0x42815c+=_0x3166bd(0x1d7),_0x42815c+=_0x3166bd(0x2fa),alert(_0x42815c),SceneManager[_0x3166bd(0x410)]();}},PluginManager['registerCommand'](pluginData['name'],_0x4bcec6(0xaac),_0x1944a7=>{const _0x37c968=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_3_ActSeqProjectiles'])return;VisuMZ[_0x37c968(0x9b1)](_0x1944a7,_0x1944a7),VisuMZ[_0x37c968(0x377)][_0x37c968(0x552)]();const _0x26e3dd=$gameTemp[_0x37c968(0x475)](),_0x2c9971=_0x1944a7[_0x37c968(0x899)];if(!_0x26e3dd)return;const _0x371a50=BattleManager['_spriteset'];if(!_0x371a50)return;_0x371a50[_0x37c968(0x4bc)](_0x1944a7);if(_0x2c9971)_0x26e3dd[_0x37c968(0x23d)](_0x37c968(0xb6a));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x5c8),_0x148101=>{const _0x2ec6bb=_0x4bcec6;if(!SceneManager[_0x2ec6bb(0x772)]())return;if(!Imported[_0x2ec6bb(0x609)])return;VisuMZ[_0x2ec6bb(0x9b1)](_0x148101,_0x148101),VisuMZ['BattleCore']['CheckActSeqProjectileVersion']();const _0x145729=$gameTemp['getLastPluginCommandInterpreter'](),_0x34a041=_0x148101[_0x2ec6bb(0x899)];if(!_0x145729)return;const _0xe78051=BattleManager['_spriteset'];if(!_0xe78051)return;_0xe78051[_0x2ec6bb(0x4bc)](_0x148101);if(_0x34a041)_0x145729[_0x2ec6bb(0x23d)](_0x2ec6bb(0xb6a));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x52f),_0x2d17bc=>{const _0x5d93ad=_0x4bcec6;if(!SceneManager[_0x5d93ad(0x772)]())return;if(!Imported[_0x5d93ad(0x609)])return;VisuMZ['ConvertParams'](_0x2d17bc,_0x2d17bc),VisuMZ[_0x5d93ad(0x377)][_0x5d93ad(0x552)]();const _0x1368e3=$gameTemp['getLastPluginCommandInterpreter'](),_0x41261d=_0x2d17bc[_0x5d93ad(0x899)];if(!_0x1368e3)return;const _0x3a2ad1=BattleManager[_0x5d93ad(0x8c8)];if(!_0x3a2ad1)return;_0x3a2ad1[_0x5d93ad(0x4bc)](_0x2d17bc);if(_0x41261d)_0x1368e3[_0x5d93ad(0x23d)](_0x5d93ad(0xb6a));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xb59),_0x2e86a6=>{const _0x3b8e24=_0x4bcec6;if(!SceneManager[_0x3b8e24(0x772)]())return;if(!Imported[_0x3b8e24(0x3f5)])return;VisuMZ['ConvertParams'](_0x2e86a6,_0x2e86a6);const _0x343932=$gameTemp[_0x3b8e24(0x475)](),_0x1cba3a=_0x2e86a6['WaitForSkew'];if(!_0x343932)return;$gameScreen[_0x3b8e24(0xbf0)](_0x2e86a6['SkewX'],_0x2e86a6[_0x3b8e24(0x3af)],_0x2e86a6[_0x3b8e24(0x161)],_0x2e86a6[_0x3b8e24(0x1c0)]);if(_0x1cba3a)_0x343932[_0x3b8e24(0x23d)]('battleSkew');}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],'ActSeq_Skew_Reset',_0x432ae7=>{const _0x1e0c64=_0x4bcec6;if(!SceneManager[_0x1e0c64(0x772)]())return;if(!Imported[_0x1e0c64(0x3f5)])return;VisuMZ[_0x1e0c64(0x9b1)](_0x432ae7,_0x432ae7);const _0x4f8349=$gameTemp[_0x1e0c64(0x475)](),_0x28737f=_0x432ae7['WaitForSkew'];if(!_0x4f8349)return;$gameScreen[_0x1e0c64(0xbf0)](0x0,0x0,_0x432ae7[_0x1e0c64(0x161)],_0x432ae7[_0x1e0c64(0x1c0)]);if(_0x28737f)_0x4f8349[_0x1e0c64(0x23d)](_0x1e0c64(0x30d));}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x36d),_0x13df42=>{const _0x2ad295=_0x4bcec6;if(!SceneManager[_0x2ad295(0x772)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;const _0x53bdbc=$gameTemp[_0x2ad295(0x475)]();if(!_0x53bdbc)return;_0x53bdbc['setWaitMode']('battleSkew');}),PluginManager['registerCommand'](pluginData['name'],_0x4bcec6(0x572),_0x3e955a=>{const _0x2abd4b=_0x4bcec6;if(!SceneManager[_0x2abd4b(0x772)]())return;VisuMZ[_0x2abd4b(0x9b1)](_0x3e955a,_0x3e955a);const _0x4096b4=$gameTemp['getLastPluginCommandInterpreter'](),_0x1d7568=_0x3e955a['Index'],_0x30045b=_0x3e955a[_0x2abd4b(0x81d)];if(!_0x4096b4)return;BattleManager[_0x2abd4b(0x7fd)]=_0x1d7568,BattleManager['_target']=BattleManager[_0x2abd4b(0x361)]?BattleManager['_allTargets'][BattleManager[_0x2abd4b(0x7fd)]]||null:null,BattleManager[_0x2abd4b(0x78f)]&&_0x30045b['toUpperCase']()[_0x2abd4b(0x7d5)]()!=='UNTITLED'&&_0x4096b4[_0x2abd4b(0x52c)]([_0x30045b]);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xf5),_0x1fe53a=>{const _0x37df67=_0x4bcec6;if(!SceneManager[_0x37df67(0x772)]())return;VisuMZ[_0x37df67(0x9b1)](_0x1fe53a,_0x1fe53a);const _0x41e368=$gameTemp['getLastPluginCommandInterpreter'](),_0x32fe98=_0x1fe53a[_0x37df67(0x81d)];if(!_0x41e368)return;BattleManager[_0x37df67(0x7fd)]++,BattleManager[_0x37df67(0x78f)]=BattleManager[_0x37df67(0x361)][BattleManager[_0x37df67(0x7fd)]]||null,BattleManager['_target']&&_0x32fe98['toUpperCase']()[_0x37df67(0x7d5)]()!=='UNTITLED'&&_0x41e368[_0x37df67(0x52c)]([_0x32fe98]);}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x1ce),_0x242708=>{const _0x246d30=_0x4bcec6;if(!SceneManager[_0x246d30(0x772)]())return;VisuMZ['ConvertParams'](_0x242708,_0x242708);const _0x3f3fd1=$gameTemp[_0x246d30(0x475)](),_0x575cad=_0x242708['JumpToLabel'];if(!_0x3f3fd1)return;BattleManager[_0x246d30(0x7fd)]--,BattleManager[_0x246d30(0x78f)]=BattleManager['_allTargets'][BattleManager['_targetIndex']]||null,BattleManager[_0x246d30(0x78f)]&&_0x575cad[_0x246d30(0x1fd)]()[_0x246d30(0x7d5)]()!==_0x246d30(0x2bf)&&_0x3f3fd1[_0x246d30(0x52c)]([_0x575cad]);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x975),_0x4003ad=>{const _0x1ae3a0=_0x4bcec6;if(!SceneManager[_0x1ae3a0(0x772)]())return;VisuMZ['ConvertParams'](_0x4003ad,_0x4003ad);const _0x571fc5=$gameTemp[_0x1ae3a0(0x475)](),_0xa524e0=_0x4003ad['ForceRandom'],_0x31dc09=_0x4003ad['JumpToLabel'];if(!_0x571fc5)return;const _0x4c9b77=BattleManager[_0x1ae3a0(0x7fd)];for(;;){BattleManager[_0x1ae3a0(0x7fd)]=Math[_0x1ae3a0(0x989)](BattleManager[_0x1ae3a0(0x361)][_0x1ae3a0(0x64b)]);if(!_0xa524e0)break;if(BattleManager['_targetIndex']!==_0x4c9b77)break;if(BattleManager[_0x1ae3a0(0x361)][_0x1ae3a0(0x64b)]<=0x1){BattleManager[_0x1ae3a0(0x7fd)]=0x0;break;}}BattleManager[_0x1ae3a0(0x78f)]=BattleManager[_0x1ae3a0(0x361)][BattleManager[_0x1ae3a0(0x7fd)]]||null,BattleManager[_0x1ae3a0(0x78f)]&&_0x31dc09[_0x1ae3a0(0x1fd)]()['trim']()!==_0x1ae3a0(0x2bf)&&_0x571fc5['command119']([_0x31dc09]);}),PluginManager['registerCommand'](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x84a),_0x56c1c2=>{const _0x352479=_0x4bcec6;if(!SceneManager[_0x352479(0x772)]())return;if(!Imported['VisuMZ_3_BattleVoices'])return;if(!ConfigManager['battleVoices'])return;VisuMZ[_0x352479(0x9b1)](_0x56c1c2,_0x56c1c2);const _0x5f4734=VisuMZ[_0x352479(0x8bd)](_0x56c1c2[_0x352479(0x5bc)]);let _0x5a3aa9=_0x56c1c2[_0x352479(0x157)]||'';for(const _0x3c20c6 of _0x5f4734){if(!_0x3c20c6)continue;_0x3c20c6[_0x352479(0x39c)](_0x5a3aa9);}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xb4c),_0x5ebcb3=>{const _0x24e374=_0x4bcec6;if(!SceneManager[_0x24e374(0x772)]())return;if(!Imported[_0x24e374(0x408)])return;if(!ConfigManager['battleVoices'])return;VisuMZ['ConvertParams'](_0x5ebcb3,_0x5ebcb3);const _0x31313f=VisuMZ[_0x24e374(0x8bd)](_0x5ebcb3[_0x24e374(0x5bc)]);let _0x2337d6=(_0x5ebcb3[_0x24e374(0x333)]||'')+(_0x5ebcb3[_0x24e374(0xab9)]||'');for(const _0x46cd06 of _0x31313f){if(!_0x46cd06)continue;_0x46cd06[_0x24e374(0x39c)](_0x2337d6);}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x1de),_0x472395=>{const _0x3db7cb=_0x4bcec6;if(!SceneManager[_0x3db7cb(0x772)]())return;VisuMZ[_0x3db7cb(0x9b1)](_0x472395,_0x472395);const _0x2701cd=VisuMZ[_0x3db7cb(0x8bd)](_0x472395['Targets']);for(const _0x2528e3 of _0x2701cd){if(!_0x2528e3)continue;if(!_0x2528e3[_0x3db7cb(0xbf8)]())continue;_0x2528e3[_0x3db7cb(0x138)]();}}),PluginManager[_0x4bcec6(0x44d)](pluginData['name'],_0x4bcec6(0x617),_0xf9beea=>{const _0x46540a=_0x4bcec6;if(!SceneManager[_0x46540a(0x772)]())return;VisuMZ[_0x46540a(0x9b1)](_0xf9beea,_0xf9beea);const _0x3c74f4=$gameTemp[_0x46540a(0x475)]();let _0x2a0228=![];const _0x437972=_0xf9beea[_0x46540a(0x81d)],_0xd2ce3d=VisuMZ['CreateActionSequenceTargets'](_0xf9beea['Targets']);for(const _0x27fea7 of _0xd2ce3d){if(!_0x27fea7)continue;if(!_0x27fea7[_0x46540a(0xbf8)]())continue;_0x27fea7[_0x46540a(0xb56)](),_0x27fea7['weapons']()[_0x46540a(0x64b)]>0x0?_0x2a0228=!![]:_0x27fea7[_0x46540a(0x138)]();}_0x2a0228&&_0x437972[_0x46540a(0x1fd)]()['trim']()!==_0x46540a(0x2bf)&&_0x3c74f4['command119']([_0x437972]);}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0xa59),_0x11b0b1=>{const _0x2e93d8=_0x4bcec6;if(!SceneManager[_0x2e93d8(0x772)]())return;VisuMZ[_0x2e93d8(0x9b1)](_0x11b0b1,_0x11b0b1);let _0x5ebdf3=_0x11b0b1[_0x2e93d8(0x3e2)];_0x5ebdf3--,_0x5ebdf3=Math[_0x2e93d8(0x4d5)](_0x5ebdf3,0x0);const _0xf9cf14=VisuMZ[_0x2e93d8(0x8bd)](_0x11b0b1[_0x2e93d8(0x5bc)]);for(const _0x4c51aa of _0xf9cf14){if(!_0x4c51aa)continue;if(!_0x4c51aa[_0x2e93d8(0xbf8)]())continue;_0x4c51aa[_0x2e93d8(0x4d2)](_0x5ebdf3);}}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x195),_0x2d66fb=>{const _0x159cc2=_0x4bcec6;if(!SceneManager[_0x159cc2(0x772)]())return;if(!Imported[_0x159cc2(0x3f5)])return;VisuMZ[_0x159cc2(0x9b1)](_0x2d66fb,_0x2d66fb);const _0x3ae956=$gameTemp['getLastPluginCommandInterpreter'](),_0x2a5728=_0x2d66fb[_0x159cc2(0x5a3)];if(!_0x3ae956)return;$gameScreen[_0x159cc2(0x3ab)](_0x2d66fb['Scale'],_0x2d66fb[_0x159cc2(0x161)],_0x2d66fb[_0x159cc2(0x1c0)]);if(_0x2a5728)_0x3ae956['setWaitMode'](_0x159cc2(0x449));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x3b4),_0x3bdd2a=>{const _0x114de9=_0x4bcec6;if(!SceneManager[_0x114de9(0x772)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ[_0x114de9(0x9b1)](_0x3bdd2a,_0x3bdd2a);const _0x19b6ff=$gameTemp['getLastPluginCommandInterpreter'](),_0x5e4896=_0x3bdd2a[_0x114de9(0x5a3)];if(!_0x19b6ff)return;$gameScreen[_0x114de9(0x3ab)](0x1,_0x3bdd2a[_0x114de9(0x161)],_0x3bdd2a[_0x114de9(0x1c0)]);if(_0x5e4896)_0x19b6ff[_0x114de9(0x23d)](_0x114de9(0x449));}),PluginManager[_0x4bcec6(0x44d)](pluginData[_0x4bcec6(0x4fc)],_0x4bcec6(0x604),_0x5c7383=>{const _0x1000b4=_0x4bcec6;if(!SceneManager[_0x1000b4(0x772)]())return;if(!Imported[_0x1000b4(0x3f5)])return;const _0x4ae4aa=$gameTemp[_0x1000b4(0x475)]();if(!_0x4ae4aa)return;_0x4ae4aa['setWaitMode'](_0x1000b4(0x449));}),VisuMZ[_0x4bcec6(0x377)]['Scene_Boot_onDatabaseLoaded']=Scene_Boot[_0x4bcec6(0x38e)][_0x4bcec6(0x6fa)],Scene_Boot['prototype'][_0x4bcec6(0x6fa)]=function(){const _0x2258bd=_0x4bcec6;this[_0x2258bd(0x873)](),this[_0x2258bd(0x372)](),this[_0x2258bd(0x10a)](),this['process_VisuMZ_BattleCore_CreateRegExp'](),VisuMZ['BattleCore']['Scene_Boot_onDatabaseLoaded'][_0x2258bd(0x20f)](this),this['process_VisuMZ_BattleCore_Notetags'](),this[_0x2258bd(0x6cc)](),this[_0x2258bd(0x46e)](),this[_0x2258bd(0xbbd)]();},Scene_Boot[_0x4bcec6(0x38e)][_0x4bcec6(0x61e)]=function(){const _0x38a469=_0x4bcec6;if(VisuMZ[_0x38a469(0xbd8)])return;this[_0x38a469(0x7ad)](),this[_0x38a469(0x5d0)](),this[_0x38a469(0x601)]();},Scene_Boot[_0x4bcec6(0x38e)][_0x4bcec6(0x873)]=function(){const _0x1d6967=_0x4bcec6,_0x3336f0=$dataSystem[_0x1d6967(0x8eb)][_0x1d6967(0x64b)];for(let _0x1f736b=0x0;_0x1f736b<_0x3336f0;_0x1f736b++){const _0x1d5650=$dataSystem[_0x1d6967(0x749)][_0x1f736b];if(_0x1d5650)continue;$dataSystem[_0x1d6967(0x749)][_0x1f736b]={'type':0x1,'weaponImageId':0x1};}},Scene_Boot[_0x4bcec6(0x38e)][_0x4bcec6(0x372)]=function(){const _0x457e0d=_0x4bcec6,_0x4704b5=VisuMZ['BattleCore'][_0x457e0d(0x187)];_0x4704b5['Damage'][_0x457e0d(0x164)]===undefined&&(_0x4704b5[_0x457e0d(0x8ba)][_0x457e0d(0x164)]=_0x457e0d(0x5a2)),_0x4704b5[_0x457e0d(0x956)][_0x457e0d(0x2a8)]===undefined&&(_0x4704b5[_0x457e0d(0x956)]['SmoothImage']=![]),_0x4704b5[_0x457e0d(0x5fb)][_0x457e0d(0x2a8)]===undefined&&(_0x4704b5['Enemy'][_0x457e0d(0x2a8)]=!![]),_0x4704b5[_0x457e0d(0x956)][_0x457e0d(0x4c7)]===undefined&&(_0x4704b5[_0x457e0d(0x956)][_0x457e0d(0x4c7)]=![]),_0x4704b5[_0x457e0d(0x956)][_0x457e0d(0x4f9)]===undefined&&(_0x4704b5[_0x457e0d(0x956)]['PrioritySortActors']=!![]);},VisuMZ[_0x4bcec6(0xa6e)]={},Scene_Boot['prototype']['process_VisuMZ_BattleCore_DamageStyles']=function(){const _0x2ae8e0=_0x4bcec6;for(const _0x115806 of VisuMZ['BattleCore'][_0x2ae8e0(0x187)][_0x2ae8e0(0x8ba)][_0x2ae8e0(0xb68)]){if(!_0x115806)continue;const _0x1a7bdd=_0x115806[_0x2ae8e0(0xa65)][_0x2ae8e0(0x1fd)]()['trim']();VisuMZ[_0x2ae8e0(0xa6e)][_0x1a7bdd]=_0x115806;}},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x66f)]={'jsAccuracy':/<JS (?:ACCURACY|ACC|HIT|EVA)>\s*([\s\S]*?)\s*<\/JS (?:ACCURACY|ACC|HIT|EVA)>/i,'jsAccuracyAsUser':/<JS (?:ACCURACY|ACC|HIT|EVA) AS USER>\s*([\s\S]*?)\s*<\/JS (?:ACCURACY|ACC|HIT|EVA) AS USER>/i,'jsAccuracyAsTarget':/<JS (?:ACCURACY|ACC|HIT|EVA) AS TARGET>\s*([\s\S]*?)\s*<\/JS (?:ACCURACY|ACC|HIT|EVA) AS TARGET>/i,'jsCritRateAsUser':/<JS (?:CRITICAL RATE|CRI) AS USER>\s*([\s\S]*?)\s*<\/JS (?:CRITICAL RATE|CRI) AS USER>/i,'jsCritRateAsTarget':/<JS (?:CRITICAL RATE|CRI) AS TARGET>\s*([\s\S]*?)\s*<\/JS (?:CRITICAL RATE|CRI) AS TARGET>/i},Scene_Boot[_0x4bcec6(0x38e)][_0x4bcec6(0x3a4)]=function(){const _0x23c112=_0x4bcec6,_0x3f28e6=VisuMZ[_0x23c112(0x377)][_0x23c112(0x66f)],_0x1ef074=_0x23c112(0x93d),_0x1fff87=[[_0x23c112(0x4e1),_0x23c112(0x949)],['Post',_0x23c112(0xbd2)]],_0x4b5748=[[_0x23c112(0x806),'JS\x20%1APPLY\x20%2'],[_0x23c112(0xb6e),'JS\x20%1DAMAGE\x20%2']],_0x29ecaa=[['',''],[_0x23c112(0x7e8),'AS\x20USER'],[_0x23c112(0x8ab),_0x23c112(0x66a)]];for(const _0x14188d of _0x4b5748){for(const _0x3ee8e6 of _0x29ecaa){for(const _0x322309 of _0x1fff87){const _0x24b971=_0x14188d[0x0][_0x23c112(0xb12)](_0x322309[0x0],_0x3ee8e6[0x0]),_0x1c7880=_0x14188d[0x1][_0x23c112(0xb12)](_0x322309[0x1],_0x3ee8e6[0x1])[_0x23c112(0x7d5)](),_0x502914=new RegExp(_0x1ef074['format'](_0x1c7880),'i');_0x3f28e6[_0x24b971]=_0x502914;}}}const _0x2ee16a=[['%1StartActionJS',_0x23c112(0x329)],['%1EndActionJS',_0x23c112(0x84b)]];for(const _0x2d74b2 of _0x2ee16a){for(const _0x54a68c of _0x1fff87){const _0x46d5c5=_0x2d74b2[0x0][_0x23c112(0xb12)](_0x54a68c[0x0]),_0x345c9f=_0x2d74b2[0x1][_0x23c112(0xb12)](_0x54a68c[0x1]),_0x32e823=new RegExp(_0x1ef074[_0x23c112(0xb12)](_0x345c9f),'i');_0x3f28e6[_0x46d5c5]=_0x32e823;}}const _0xa2cd95=[['%1StartBattleJS',_0x23c112(0xa9c)],[_0x23c112(0x843),_0x23c112(0x80f)],[_0x23c112(0x8a2),_0x23c112(0x249)],[_0x23c112(0x501),'JS\x20BATTLE\x20DEFEAT'],[_0x23c112(0x2c5),_0x23c112(0x83f)],[_0x23c112(0x8b0),_0x23c112(0x18f)],[_0x23c112(0x12a),_0x23c112(0x39f)],[_0x23c112(0x392),_0x23c112(0xf9)],[_0x23c112(0x459),_0x23c112(0x509)]];for(const _0x163601 of _0xa2cd95){for(const _0x5050b8 of _0x1fff87){const _0x56930d=_0x163601[0x0]['format'](_0x5050b8[0x0]),_0x2eaf15=_0x163601[0x1][_0x23c112(0xb12)](_0x5050b8[0x1]),_0xc9f6eb=new RegExp(_0x1ef074[_0x23c112(0xb12)](_0x2eaf15),'i');_0x3f28e6[_0x56930d]=_0xc9f6eb;}}},Scene_Boot['prototype'][_0x4bcec6(0x7ad)]=function(){const _0x2719b8=_0x4bcec6,_0x7370fc=$dataSkills[_0x2719b8(0x5cb)]($dataItems);for(const _0x2a197d of _0x7370fc){if(!_0x2a197d)continue;VisuMZ[_0x2719b8(0x377)]['Parse_Notetags_Action'](_0x2a197d);}},Scene_Boot[_0x4bcec6(0x38e)][_0x4bcec6(0x5d0)]=function(){const _0x261d2d=_0x4bcec6,_0x3664ae=$dataActors['concat']($dataClasses,$dataWeapons,$dataArmors,$dataEnemies,$dataStates);for(const _0x393531 of _0x3664ae){if(!_0x393531)continue;VisuMZ[_0x261d2d(0x377)][_0x261d2d(0x3b0)](_0x393531),_0x393531[_0x261d2d(0x95e)]!==undefined&&VisuMZ['BattleCore'][_0x261d2d(0x3bf)](_0x393531);}},Scene_Boot['prototype'][_0x4bcec6(0x6cc)]=function(){const _0x2d32b2=_0x4bcec6,_0x1b9bc1=VisuMZ['BattleCore'][_0x2d32b2(0x187)][_0x2d32b2(0xbbe)][_0x2d32b2(0x7ee)],_0x27d450=[];for(const _0xe4dba3 of _0x1b9bc1){const _0x2a0464=$dataTroops[_0xe4dba3];if(_0x2a0464)_0x27d450[_0x2d32b2(0x27a)](JsonEx['makeDeepCopy'](_0x2a0464));}for(const _0x33105a of $dataTroops){if(!_0x33105a)continue;for(const _0x1fd2d9 of _0x27d450){if(_0x1fd2d9['id']===_0x33105a['id'])continue;_0x33105a['pages']=_0x33105a[_0x2d32b2(0x5e1)][_0x2d32b2(0x5cb)](_0x1fd2d9[_0x2d32b2(0x5e1)]);}}},Scene_Boot[_0x4bcec6(0x38e)][_0x4bcec6(0x46e)]=function(){const _0x408679=_0x4bcec6,_0x5c56bf=VisuMZ[_0x408679(0x377)]['Settings'][_0x408679(0xbbe)];if(_0x5c56bf[_0x408679(0x7ca)]>0x0&&$dataCommonEvents[_0x5c56bf['BattleStartEvent']]){const _0x3cca44=$dataCommonEvents[_0x5c56bf[_0x408679(0x7ca)]],_0x287bd2=_0x3cca44[_0x408679(0x3e5)]['length']-0x2,_0x39609f=_0x3cca44[_0x408679(0x3e5)][_0x287bd2];if(_0x39609f&&_0x39609f[_0x408679(0xc06)]!==0xe6){const _0x519181={'code':0xe6,'indent':0x0,'parameters':[0x1]},_0xd5a197=_0x3cca44[_0x408679(0x3e5)][_0x408679(0x199)]();_0x3cca44[_0x408679(0x3e5)][_0x408679(0x1b9)](_0x519181),_0x3cca44[_0x408679(0x3e5)]['unshift'](_0xd5a197);}}},Scene_Boot[_0x4bcec6(0x38e)]['process_VisuMZ_BattleCore_CommonEventKeys']=function(){const _0x551d09=_0x4bcec6;VisuMZ[_0x551d09(0x377)][_0x551d09(0x804)](),VisuMZ[_0x551d09(0x377)][_0x551d09(0x1df)]($dataSkills),VisuMZ['BattleCore'][_0x551d09(0x1df)]($dataItems);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x804)]=function(){const _0x30eabf=_0x4bcec6;VisuMZ[_0x30eabf(0x377)][_0x30eabf(0x90c)]={};for(const _0x2e48f4 of $dataCommonEvents){if(!_0x2e48f4)continue;if(_0x2e48f4[_0x30eabf(0x4fc)][_0x30eabf(0x820)](/\[(.*)\]/i)){let _0x57f9f9=String(RegExp['$1'])['replace'](/,/g,'')[_0x30eabf(0x1fd)]()[_0x30eabf(0x7d5)]();VisuMZ[_0x30eabf(0x377)][_0x30eabf(0x90c)][_0x57f9f9]=_0x2e48f4['id'];}}},VisuMZ['BattleCore'][_0x4bcec6(0x1df)]=function(_0x1322a3){const _0x518e89=_0x4bcec6;for(const _0x1b85d3 of _0x1322a3){if(!_0x1b85d3)continue;VisuMZ['BattleCore'][_0x518e89(0x442)](_0x1b85d3);}},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x442)]=function(_0x4c058e){const _0x333785=_0x4bcec6;if(!_0x4c058e)return;if(!_0x4c058e[_0x333785(0x993)])return;VisuMZ[_0x333785(0x377)][_0x333785(0x90c)]=VisuMZ[_0x333785(0x377)]['_commonEventKey']||{};const _0x1144ef=/<COMMON EVENT (?:KEY|KEYS):[ ](.*)>/gi,_0x3edfb8=/<COMMON EVENT (?:KEY|KEYS)>\s*([\s\S]*)\s*<\/COMMON EVENT (?:KEY|KEYS)>/i;let _0xb1bcc3=[];const _0xfe8fb4=_0x4c058e[_0x333785(0x131)][_0x333785(0x820)](_0x1144ef);if(_0xfe8fb4){for(const _0x2a2c59 of _0xfe8fb4){_0x2a2c59[_0x333785(0x820)](_0x1144ef);const _0x38b5ca=String(RegExp['$1'])[_0x333785(0x256)](',')['map'](_0x5bff9c=>String(_0x5bff9c)[_0x333785(0x1fd)]()[_0x333785(0x7d5)]());_0xb1bcc3=_0xb1bcc3[_0x333785(0x5cb)](_0x38b5ca);}!_0x4c058e[_0x333785(0x131)]['match'](/<CUSTOM ACTION SEQUENCE>/i)&&(_0x4c058e[_0x333785(0x131)]+=_0x333785(0x3e1));;}if(_0x4c058e['note'][_0x333785(0x820)](_0x3edfb8)){const _0x4156c1=String(RegExp['$1'])['split'](/[\r\n]+/)[_0x333785(0x228)](_0x368386=>String(_0x368386)['toUpperCase']()['trim']());_0xb1bcc3=_0xb1bcc3['concat'](_0x4156c1);!_0x4c058e['note'][_0x333785(0x820)](/<CUSTOM ACTION SEQUENCE>/i)&&(_0x4c058e['note']+=_0x333785(0x3e1));;}for(const _0x1c033a of _0xb1bcc3){if(VisuMZ['BattleCore'][_0x333785(0x90c)][_0x1c033a]){const _0x452e42=VisuMZ['BattleCore'][_0x333785(0x90c)][_0x1c033a],_0x35efe5={'code':0x2c,'dataId':_0x452e42,'value1':0x1,'value2':0x0};_0x4c058e['effects'][_0x333785(0x27a)](_0x35efe5);}}},Scene_Boot[_0x4bcec6(0x38e)]['process_VisuMZ_BattleCore_jsFunctions']=function(){const _0xf10734=_0x4bcec6,_0x51e2fb=$dataSkills[_0xf10734(0x5cb)]($dataItems);for(const _0x119a8f of _0x51e2fb){if(!_0x119a8f)continue;VisuMZ[_0xf10734(0x377)][_0xf10734(0x6b5)](_0x119a8f);}},VisuMZ['BattleCore'][_0x4bcec6(0xa6f)]=VisuMZ[_0x4bcec6(0xa6f)],VisuMZ[_0x4bcec6(0xa6f)]=function(_0x56db3d){const _0x1fb9c5=_0x4bcec6;VisuMZ['BattleCore'][_0x1fb9c5(0xa6f)]&&VisuMZ[_0x1fb9c5(0x377)][_0x1fb9c5(0xa6f)][_0x1fb9c5(0x20f)](this,_0x56db3d),VisuMZ['BattleCore'][_0x1fb9c5(0x3b0)](_0x56db3d);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x74c)]=VisuMZ[_0x4bcec6(0x74c)],VisuMZ[_0x4bcec6(0x74c)]=function(_0x54462b){const _0x44c206=_0x4bcec6;VisuMZ[_0x44c206(0x377)][_0x44c206(0x74c)]&&VisuMZ[_0x44c206(0x377)][_0x44c206(0x74c)][_0x44c206(0x20f)](this,_0x54462b),VisuMZ[_0x44c206(0x377)][_0x44c206(0x3b0)](_0x54462b);},VisuMZ['BattleCore']['ParseSkillNotetags']=VisuMZ[_0x4bcec6(0x65f)],VisuMZ[_0x4bcec6(0x65f)]=function(_0x40013c){const _0x211a36=_0x4bcec6;VisuMZ[_0x211a36(0x377)][_0x211a36(0x65f)]&&VisuMZ[_0x211a36(0x377)]['ParseSkillNotetags'][_0x211a36(0x20f)](this,_0x40013c),VisuMZ[_0x211a36(0x377)][_0x211a36(0x55c)](_0x40013c),VisuMZ['BattleCore']['Parse_Notetags_Targets'](_0x40013c);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x6c2)]=VisuMZ[_0x4bcec6(0x6c2)],VisuMZ['ParseItemNotetags']=function(_0x77c859){const _0x4d5620=_0x4bcec6;VisuMZ[_0x4d5620(0x377)]['ParseItemNotetags']&&VisuMZ['BattleCore'][_0x4d5620(0x6c2)][_0x4d5620(0x20f)](this,_0x77c859),VisuMZ[_0x4d5620(0x377)][_0x4d5620(0x55c)](_0x77c859),VisuMZ[_0x4d5620(0x377)][_0x4d5620(0x6b5)](_0x77c859);},VisuMZ[_0x4bcec6(0x377)]['ParseWeaponNotetags']=VisuMZ['ParseWeaponNotetags'],VisuMZ[_0x4bcec6(0x73b)]=function(_0x5db8a1){const _0x2b64c1=_0x4bcec6;VisuMZ[_0x2b64c1(0x377)][_0x2b64c1(0x73b)]&&VisuMZ['BattleCore'][_0x2b64c1(0x73b)]['call'](this,_0x5db8a1),VisuMZ[_0x2b64c1(0x377)][_0x2b64c1(0x3b0)](_0x5db8a1);},VisuMZ[_0x4bcec6(0x377)]['ParseArmorNotetags']=VisuMZ[_0x4bcec6(0xb6f)],VisuMZ['ParseArmorNotetags']=function(_0x181baa){const _0x2ea66c=_0x4bcec6;VisuMZ[_0x2ea66c(0x377)][_0x2ea66c(0xb6f)]&&VisuMZ[_0x2ea66c(0x377)][_0x2ea66c(0xb6f)][_0x2ea66c(0x20f)](this,_0x181baa),VisuMZ[_0x2ea66c(0x377)][_0x2ea66c(0x3b0)](_0x181baa);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x98d)]=VisuMZ[_0x4bcec6(0x98d)],VisuMZ[_0x4bcec6(0x98d)]=function(_0x20845a){const _0x5b882f=_0x4bcec6;VisuMZ['BattleCore'][_0x5b882f(0x98d)]&&VisuMZ[_0x5b882f(0x377)]['ParseEnemyNotetags'][_0x5b882f(0x20f)](this,_0x20845a),VisuMZ[_0x5b882f(0x377)]['Parse_Notetags_TraitObjects'](_0x20845a);},VisuMZ[_0x4bcec6(0x377)]['ParseStateNotetags']=VisuMZ[_0x4bcec6(0xc0c)],VisuMZ['ParseStateNotetags']=function(_0x396789){const _0x21e9b1=_0x4bcec6;VisuMZ[_0x21e9b1(0x377)][_0x21e9b1(0xc0c)]&&VisuMZ[_0x21e9b1(0x377)][_0x21e9b1(0xc0c)]['call'](this,_0x396789),VisuMZ[_0x21e9b1(0x377)][_0x21e9b1(0x3b0)](_0x396789),VisuMZ[_0x21e9b1(0x377)][_0x21e9b1(0x3bf)](_0x396789);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x55c)]=function(_0x490750){const _0x29cc9a=_0x4bcec6,_0x42ec78=['PreApplyJS','PostApplyJS',_0x29cc9a(0xa5e),_0x29cc9a(0x503),_0x29cc9a(0x3c8),'PostStartActionJS','PreEndActionJS',_0x29cc9a(0xa17)];for(const _0x413e7b of _0x42ec78){VisuMZ['BattleCore']['createJS'](_0x490750,_0x413e7b);}const _0x4b731f=_0x490750[_0x29cc9a(0x131)];_0x4b731f[_0x29cc9a(0x820)](/<ALWAYS CRITICAL/i)&&(_0x490750[_0x29cc9a(0x714)][_0x29cc9a(0x98a)]=!![]),_0x4b731f[_0x29cc9a(0x820)](/<(?:REPEAT|REPEATS|REPEAT HITS):[ ](\d+)/i)&&(_0x490750[_0x29cc9a(0x2db)]=Math[_0x29cc9a(0x4d5)](0x1,Number(RegExp['$1']))),_0x4b731f[_0x29cc9a(0x820)](/<TARGET:[ ](.*)>/i)&&(_0x490750[_0x29cc9a(0x717)]=String(RegExp['$1'])['toUpperCase']()[_0x29cc9a(0x7d5)]());},VisuMZ[_0x4bcec6(0x377)]['Parse_Notetags_TraitObjects']=function(_0x538ca5){const _0x515382=_0x4bcec6,_0x24fe16=['PreApplyAsUserJS',_0x515382(0x5e9),'PreDamageAsUserJS',_0x515382(0x9ea),_0x515382(0x9d3),'PostApplyAsTargetJS','PreDamageAsTargetJS',_0x515382(0xb55),_0x515382(0x3c8),_0x515382(0x2bd),_0x515382(0x79c),'PostEndActionJS','PreStartBattleJS',_0x515382(0xa72),'PreEndBattleJS','PostEndBattleJS',_0x515382(0x8a2),_0x515382(0x501),_0x515382(0x2c5),_0x515382(0x8b0),_0x515382(0x671),'PostStartTurnJS',_0x515382(0x5dc),_0x515382(0x98b),_0x515382(0xb5f),_0x515382(0x5e2)];for(const _0x25fe53 of _0x24fe16){VisuMZ[_0x515382(0x377)][_0x515382(0x43b)](_0x538ca5,_0x25fe53);}const _0x1fb088=['jsAccuracy',_0x515382(0xa60),'jsAccuracyAsTarget','jsCritRateAsUser',_0x515382(0x55e)];for(const _0x3f7c9a of _0x1fb088){VisuMZ['BattleCore'][_0x515382(0x6d2)](_0x538ca5,_0x3f7c9a);}},VisuMZ[_0x4bcec6(0x377)]['Parse_Notetags_Targets']=function(_0x2a017e){const _0xa8c9a3=_0x4bcec6,_0x47d4b5=_0x2a017e[_0xa8c9a3(0x131)];if(_0x47d4b5[_0xa8c9a3(0x820)](/<JS TARGETS>\s*([\s\S]*)\s*<\/JS TARGETS>/i)){const _0x493b8e=String(RegExp['$1']),_0x4cb077=VisuMZ[_0xa8c9a3(0x377)]['createKeyJS'](_0x2a017e,_0xa8c9a3(0x5bc));VisuMZ[_0xa8c9a3(0x377)]['createTargetsJS'](_0x493b8e,_0x4cb077);}if(_0x47d4b5[_0xa8c9a3(0x820)](/<JS COMMAND (?:VISIBLE|SHOW|HIDE)>\s*([\s\S]*)\s*<\/JS COMMAND (?:VISIBLE|SHOW|HIDE)>/i)){const _0x21dbc7=String(RegExp['$1']),_0x2fb1fe=VisuMZ['BattleCore'][_0xa8c9a3(0x689)](_0x2a017e,_0xa8c9a3(0x364));VisuMZ[_0xa8c9a3(0x377)][_0xa8c9a3(0x7c8)](_0x21dbc7,_0x2fb1fe);}},VisuMZ[_0x4bcec6(0x377)]['JS']={},VisuMZ['BattleCore'][_0x4bcec6(0x43b)]=function(_0xc18a8b,_0x2b1740){const _0x6f9825=_0x4bcec6,_0x12df57=_0xc18a8b['note'];if(_0x12df57['match'](VisuMZ[_0x6f9825(0x377)][_0x6f9825(0x66f)][_0x2b1740])){const _0x5b5eb9=RegExp['$1'],_0x470c4a=_0x6f9825(0x89c)['format'](_0x5b5eb9),_0x58d4e0=VisuMZ['BattleCore'][_0x6f9825(0x689)](_0xc18a8b,_0x2b1740);VisuMZ['BattleCore']['JS'][_0x58d4e0]=new Function(_0x470c4a);}},VisuMZ[_0x4bcec6(0x377)]['createKeyJS']=function(_0x19ce95,_0x11cfea){const _0x499aa1=_0x4bcec6;if(VisuMZ[_0x499aa1(0x689)])return VisuMZ[_0x499aa1(0x689)](_0x19ce95,_0x11cfea);let _0x5ec90c='';if($dataActors[_0x499aa1(0x5e4)](_0x19ce95))_0x5ec90c=_0x499aa1(0x3c7)[_0x499aa1(0xb12)](_0x19ce95['id'],_0x11cfea);if($dataClasses[_0x499aa1(0x5e4)](_0x19ce95))_0x5ec90c=_0x499aa1(0x880)['format'](_0x19ce95['id'],_0x11cfea);if($dataSkills[_0x499aa1(0x5e4)](_0x19ce95))_0x5ec90c=_0x499aa1(0x97c)[_0x499aa1(0xb12)](_0x19ce95['id'],_0x11cfea);if($dataItems['includes'](_0x19ce95))_0x5ec90c='Item-%1-%2'[_0x499aa1(0xb12)](_0x19ce95['id'],_0x11cfea);if($dataWeapons['includes'](_0x19ce95))_0x5ec90c=_0x499aa1(0xb8c)[_0x499aa1(0xb12)](_0x19ce95['id'],_0x11cfea);if($dataArmors[_0x499aa1(0x5e4)](_0x19ce95))_0x5ec90c=_0x499aa1(0x911)[_0x499aa1(0xb12)](_0x19ce95['id'],_0x11cfea);if($dataEnemies[_0x499aa1(0x5e4)](_0x19ce95))_0x5ec90c=_0x499aa1(0x334)[_0x499aa1(0xb12)](_0x19ce95['id'],_0x11cfea);if($dataStates[_0x499aa1(0x5e4)](_0x19ce95))_0x5ec90c='State-%1-%2'['format'](_0x19ce95['id'],_0x11cfea);return _0x5ec90c;},VisuMZ[_0x4bcec6(0x377)]['createTargetsJS']=function(_0x5206fe,_0x499923){const _0x94d760=_0x4bcec6,_0x3f91db=_0x94d760(0x77e)[_0x94d760(0xb12)](_0x5206fe);VisuMZ[_0x94d760(0x377)]['JS'][_0x499923]=new Function(_0x3f91db);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x7c8)]=function(_0x383450,_0xfc617a){const _0x548fcd=_0x4bcec6,_0x47972e=_0x548fcd(0x8e7)['format'](_0x383450);VisuMZ[_0x548fcd(0x377)]['JS'][_0xfc617a]=new Function(_0x47972e);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x6d2)]=function(_0x4c19b0,_0x208041){const _0x5f2094=_0x4bcec6,_0x20cfea=_0x4c19b0[_0x5f2094(0x131)];if(_0x20cfea['match'](VisuMZ['BattleCore'][_0x5f2094(0x66f)][_0x208041])){const _0x2c1b28=RegExp['$1'],_0x438dce='\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Arguments\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20arguments[1];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20obj\x20=\x20arguments[2];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20rate\x20=\x20arguments[3]\x20||\x200;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20originalRate\x20=\x20rate;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Constants\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20action\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this\x20:\x20user.currentAction();\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20attacker\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20defender\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20healer\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20receiver\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20actor\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20currentClass\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20skill\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this.item()\x20:\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20item\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this.item()\x20:\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20weapon\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20armor\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20enemy\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20state\x20=\x20obj;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Create\x20Compatibility\x20Variables\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20origin\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(Imported.VisuMZ_1_SkillsStatesCore\x20&&\x20$dataStates.includes(obj))\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20origin\x20=\x20target.getStateOrigin(obj.id);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20NaN\x20Check\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(isNaN(rate)){\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27NaN\x20rate\x20created\x20by\x20%2\x27.format(\x27\x27,obj.name));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27Restoring\x20rate\x20to\x20%2\x27.format(\x27\x27,originalRate));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20value\x20=\x20originalRate;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20rate\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20rate;\x0a\x20\x20\x20\x20\x20\x20\x20\x20'['format'](_0x2c1b28),_0x83a199=VisuMZ['BattleCore'][_0x5f2094(0x689)](_0x4c19b0,_0x208041);VisuMZ[_0x5f2094(0x377)]['JS'][_0x83a199]=new Function(_0x438dce);}},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x3bf)]=function(_0x4f1732){const _0x2bbdcd=_0x4bcec6;_0x4f1732[_0x2bbdcd(0x726)]='-';const _0x1a91cb=_0x4f1732[_0x2bbdcd(0x131)];_0x1a91cb[_0x2bbdcd(0x820)](/<(?:HELP|HELP DESCRIPTION|DESCRIPTION)>\s*([\s\S]*)\s*<\/(?:HELP|HELP DESCRIPTION|DESCRIPTION)>/i)&&(_0x4f1732[_0x2bbdcd(0x726)]=String(RegExp['$1'])[_0x2bbdcd(0x7d5)]()),_0x1a91cb[_0x2bbdcd(0x820)](/<(?:IN-BATTLE |)STATUS DESCRIPTION>\s*([\s\S]*)\s*<\/(?:IN-BATTLE |)STATUS DESCRIPTION>/i)&&(_0x4f1732[_0x2bbdcd(0x493)]=String(RegExp['$1'])[_0x2bbdcd(0x7d5)]()),_0x1a91cb['match'](/<EXCLUDE FROM (?:HELP|STATUS|STATUS LIST|LISTING)>/i)&&(_0x4f1732[_0x2bbdcd(0xb6b)]=!![]);},TextManager[_0x4bcec6(0x54a)]=VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x187)][_0x4bcec6(0x508)][_0x4bcec6(0x354)],TextManager[_0x4bcec6(0x4fa)]=VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x187)][_0x4bcec6(0x318)][_0x4bcec6(0xa2e)],TextManager[_0x4bcec6(0xb2c)]=VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x187)][_0x4bcec6(0x318)][_0x4bcec6(0x8b2)],TextManager[_0x4bcec6(0x6c4)]=VisuMZ['BattleCore'][_0x4bcec6(0x187)][_0x4bcec6(0x61d)][_0x4bcec6(0xa65)],ColorManager[_0x4bcec6(0xaaa)]=function(_0x2e6a75){const _0x42617e=_0x4bcec6;return _0x2e6a75=String(_0x2e6a75),_0x2e6a75['match'](/#(.*)/i)?'#%1'[_0x42617e(0xb12)](String(RegExp['$1'])):this[_0x42617e(0x1a9)](Number(_0x2e6a75));},DataManager[_0x4bcec6(0x5b6)]=function(_0x4868a2){const _0x35b553=_0x4bcec6;if(_0x4868a2[_0x35b553(0x131)][_0x35b553(0x820)](/<DAMAGE STYLE:[ ](.*)>/i)){const _0x579e9e=String(RegExp['$1'])['toUpperCase']()[_0x35b553(0x7d5)]();if(_0x579e9e===_0x35b553(0x6bc))return _0x35b553(0x6bc);if(VisuMZ[_0x35b553(0xa6e)][_0x579e9e])return _0x579e9e;}const _0x1ff5f8=VisuMZ['BattleCore'][_0x35b553(0x187)][_0x35b553(0x8ba)][_0x35b553(0x897)][_0x35b553(0x1fd)]()['trim']();if(VisuMZ[_0x35b553(0xa6e)][_0x1ff5f8])return _0x1ff5f8;return _0x35b553(0x6bc);},DataManager[_0x4bcec6(0x1eb)]=function(_0x6ea3dd){const _0x169cb7=_0x4bcec6;_0x6ea3dd=_0x6ea3dd[_0x169cb7(0x1fd)]()['trim'](),this['_stypeIDs']=this[_0x169cb7(0x490)]||{};if(this[_0x169cb7(0x490)][_0x6ea3dd])return this[_0x169cb7(0x490)][_0x6ea3dd];for(let _0x27a676=0x1;_0x27a676<0x64;_0x27a676++){if(!$dataSystem[_0x169cb7(0x1fb)][_0x27a676])continue;let _0x20e907=$dataSystem['skillTypes'][_0x27a676][_0x169cb7(0x1fd)]()[_0x169cb7(0x7d5)]();_0x20e907=_0x20e907[_0x169cb7(0x560)](/\x1I\[(\d+)\]/gi,''),_0x20e907=_0x20e907[_0x169cb7(0x560)](/\\I\[(\d+)\]/gi,''),this[_0x169cb7(0x490)][_0x20e907]=_0x27a676;}return this[_0x169cb7(0x490)][_0x6ea3dd]||0x0;},DataManager[_0x4bcec6(0x24e)]=function(_0x13f732){const _0x134a38=_0x4bcec6;_0x13f732=_0x13f732[_0x134a38(0x1fd)]()[_0x134a38(0x7d5)](),this[_0x134a38(0x863)]=this[_0x134a38(0x863)]||{};if(this['_skillIDs'][_0x13f732])return this[_0x134a38(0x863)][_0x13f732];for(const _0x4e1117 of $dataSkills){if(!_0x4e1117)continue;this['_skillIDs'][_0x4e1117[_0x134a38(0x4fc)]['toUpperCase']()[_0x134a38(0x7d5)]()]=_0x4e1117['id'];}return this['_skillIDs'][_0x13f732]||0x0;},DataManager[_0x4bcec6(0xb1a)]=function(_0x1d9971){const _0x21430f=_0x4bcec6;_0x1d9971=_0x1d9971[_0x21430f(0x1fd)]()['trim'](),this[_0x21430f(0x5fa)]=this[_0x21430f(0x5fa)]||{};if(this[_0x21430f(0x5fa)][_0x1d9971])return this[_0x21430f(0x5fa)][_0x1d9971];for(const _0x5406d4 of $dataEnemies){if(!_0x5406d4)continue;this[_0x21430f(0x5fa)][_0x5406d4['name'][_0x21430f(0x1fd)]()['trim']()]=_0x5406d4['id'];}return this[_0x21430f(0x5fa)][_0x1d9971]||0x0;},DataManager[_0x4bcec6(0xb08)]=function(_0x12de92){const _0x198ab6=_0x4bcec6;_0x12de92=_0x12de92[_0x198ab6(0x1fd)]()[_0x198ab6(0x7d5)](),this['_wtypeIDs']=this[_0x198ab6(0x177)]||{};if(this[_0x198ab6(0x177)][_0x12de92])return this[_0x198ab6(0x177)][_0x12de92];for(let _0x45c2f9=0x1;_0x45c2f9<0x64;_0x45c2f9++){if(!$dataSystem[_0x198ab6(0x8eb)][_0x45c2f9])continue;let _0x3b759f=$dataSystem[_0x198ab6(0x8eb)][_0x45c2f9][_0x198ab6(0x1fd)]()[_0x198ab6(0x7d5)]();_0x3b759f=_0x3b759f[_0x198ab6(0x560)](/\x1I\[(\d+)\]/gi,''),_0x3b759f=_0x3b759f[_0x198ab6(0x560)](/\\I\[(\d+)\]/gi,''),this['_wtypeIDs'][_0x3b759f]=_0x45c2f9;}return this[_0x198ab6(0x177)][_0x198ab6(0x312)]=0x0,this[_0x198ab6(0x177)][_0x12de92]||0x0;},DataManager[_0x4bcec6(0x3fb)]=function(_0x1adfa9){const _0x231465=_0x4bcec6,_0x247699='\x5cI[%1]%2';let _0x7c701a=_0x1adfa9[_0x231465(0x47d)],_0x17f513=_0x1adfa9['name'];const _0x187b94=_0x1adfa9[_0x231465(0x131)];return _0x187b94['match'](/<DISPLAY ICON: (\d+)>/i)&&(_0x7c701a=Number(RegExp['$1'])),_0x187b94[_0x231465(0x820)](/<DISPLAY TEXT: (.*)>/i)&&(_0x17f513=String(RegExp['$1'])),_0x247699['format'](_0x7c701a,_0x17f513);},DataManager['battleCommandName']=function(_0x5dff18){const _0x28fd74=_0x4bcec6;return _0x5dff18[_0x28fd74(0x131)]['match'](/<COMMAND TEXT: (.*)>/i)?String(RegExp['$1']):_0x5dff18[_0x28fd74(0x4fc)];},DataManager['battleCommandIcon']=function(_0x8e17fc){const _0x38abb6=_0x4bcec6;return _0x8e17fc[_0x38abb6(0x131)][_0x38abb6(0x820)](/<COMMAND ICON: (\d+)>/i)?Number(RegExp['$1']):_0x8e17fc[_0x38abb6(0x47d)];},DataManager['swapEnemyIDs']=function(_0x5bbd39){const _0x56c7ae=_0x4bcec6,_0x3c14af=$dataEnemies[_0x5bbd39];if(_0x3c14af){if(_0x3c14af[_0x56c7ae(0x131)][_0x56c7ae(0x820)](/<SWAP ENEMIES>\s*([\s\S]*)\s*<\/SWAP ENEMIES>/i)){const _0x442e4f=String(RegExp['$1'])[_0x56c7ae(0x256)](/[\r\n]+/)[_0x56c7ae(0x8b7)](''),_0x1e3e4b=this['processRandomizedData'](_0x442e4f);_0x5bbd39=this[_0x56c7ae(0xb1a)](_0x1e3e4b)||_0x5bbd39,_0x5bbd39=DataManager[_0x56c7ae(0x82a)](_0x5bbd39);}}return _0x5bbd39;},DataManager['processRandomizedData']=function(_0x17c678){const _0x523682=_0x4bcec6;let _0x4ba136=0x0;const _0x3cbb7c={};for(const _0x23b48d of _0x17c678){if(_0x23b48d['match'](/(.*):[ ](\d+)/i)){const _0x2f04ac=String(RegExp['$1'])[_0x523682(0x7d5)](),_0x539158=Number(RegExp['$2']);_0x3cbb7c[_0x2f04ac]=_0x539158,_0x4ba136+=_0x539158;}else{if(_0x23b48d[_0x523682(0x820)](/(.*):[ ](\d+\.?\d+)/i)){const _0x4337fa=String(RegExp['$1'])[_0x523682(0x7d5)](),_0x49a4b2=Number(RegExp['$2']);_0x3cbb7c[_0x4337fa]=_0x49a4b2,_0x4ba136+=_0x49a4b2;}else _0x23b48d!==''&&(_0x3cbb7c[_0x23b48d]=0x1,_0x4ba136++);}}if(_0x4ba136<=0x0)return'';let _0x24dfe9=Math[_0x523682(0x2e2)]()*_0x4ba136;for(const _0x2c9ba0 in _0x3cbb7c){_0x24dfe9-=_0x3cbb7c[_0x2c9ba0];if(_0x24dfe9<=0x0)return _0x2c9ba0;}return'';},DataManager[_0x4bcec6(0x3d5)]=function(_0x1f2cc1){const _0x36c168=_0x4bcec6;if(!_0x1f2cc1)return![];if(!VisuMZ[_0x36c168(0x377)][_0x36c168(0x187)]['ActionSequence'][_0x36c168(0x1f9)])return![];if(_0x1f2cc1[_0x36c168(0x131)][_0x36c168(0x820)](/<AUTO ACTION SEQUENCE>/i))return![];if(_0x1f2cc1[_0x36c168(0x131)][_0x36c168(0x820)](/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi))return!![];for(const _0x593651 of _0x1f2cc1[_0x36c168(0x993)]){if(!_0x593651)continue;if(_0x593651[_0x36c168(0xc06)]===Game_Action[_0x36c168(0x479)])return!![];}return![];},DataManager[_0x4bcec6(0x307)]=function(_0x303093){const _0xc85369=_0x4bcec6,_0x167c69=$dataTroops[_0x303093];if(!_0x167c69)return'';let _0x2360b3='';_0x2360b3+=_0x167c69[_0xc85369(0x4fc)];for(const _0x446c18 of _0x167c69['pages']){for(const _0x4e6e50 of _0x446c18['list']){[0x6c,0x198][_0xc85369(0x5e4)](_0x4e6e50['code'])&&(_0x2360b3+='\x0a',_0x2360b3+=_0x4e6e50[_0xc85369(0x6e7)][0x0]);}}return _0x2360b3;},ConfigManager[_0x4bcec6(0x83b)]=ConfigManager[_0x4bcec6(0x83b)]??![],ConfigManager[_0x4bcec6(0x881)]=ConfigManager[_0x4bcec6(0x881)]??![],ConfigManager[_0x4bcec6(0x6c4)]=ConfigManager[_0x4bcec6(0x6c4)]??!![],VisuMZ[_0x4bcec6(0x377)]['ConfigManager_makeData']=ConfigManager[_0x4bcec6(0x33f)],ConfigManager[_0x4bcec6(0x33f)]=function(){const _0x1f3028=_0x4bcec6,_0x2776dc=VisuMZ['BattleCore'][_0x1f3028(0x154)][_0x1f3028(0x20f)](this);return _0x2776dc[_0x1f3028(0x83b)]=this[_0x1f3028(0x83b)],_0x2776dc['autoBattleUseSkills']=this['autoBattleUseSkills'],_0x2776dc[_0x1f3028(0x6c4)]=this[_0x1f3028(0x6c4)],_0x2776dc;},VisuMZ[_0x4bcec6(0x377)]['ConfigManager_applyData']=ConfigManager[_0x4bcec6(0x2aa)],ConfigManager[_0x4bcec6(0x2aa)]=function(_0x586ee2){const _0x211c2d=_0x4bcec6;VisuMZ[_0x211c2d(0x377)][_0x211c2d(0x9e0)]['call'](this,_0x586ee2),_0x211c2d(0x83b)in _0x586ee2?this[_0x211c2d(0x83b)]=_0x586ee2['autoBattleAtStart']:this['autoBattleAtStart']=![],_0x211c2d(0x881)in _0x586ee2?this[_0x211c2d(0x881)]=_0x586ee2[_0x211c2d(0x881)]:this['autoBattleUseSkills']=![],'visualHpGauge'in _0x586ee2?this[_0x211c2d(0x6c4)]=_0x586ee2[_0x211c2d(0x6c4)]:this[_0x211c2d(0x6c4)]=!![];},ImageManager[_0x4bcec6(0x935)]=ImageManager[_0x4bcec6(0x935)]||0x9,ImageManager[_0x4bcec6(0x21a)]=ImageManager[_0x4bcec6(0x21a)]||0x6,VisuMZ['BattleCore'][_0x4bcec6(0x75e)]=BattleManager[_0x4bcec6(0xb27)],BattleManager[_0x4bcec6(0xb27)]=function(_0x2f7a63,_0x8cbef4,_0x7647d3){const _0x5e5128=_0x4bcec6;VisuMZ['BattleCore'][_0x5e5128(0x75e)][_0x5e5128(0x20f)](this,_0x2f7a63,_0x8cbef4,_0x7647d3),this[_0x5e5128(0x5b8)]={};},VisuMZ[_0x4bcec6(0x377)]['BattleManager_initMembers']=BattleManager[_0x4bcec6(0x679)],BattleManager['initMembers']=function(){const _0x285a4d=_0x4bcec6;VisuMZ['BattleCore'][_0x285a4d(0x554)][_0x285a4d(0x20f)](this),this[_0x285a4d(0x77f)]=[];},BattleManager[_0x4bcec6(0xbc3)]=function(){const _0x4ec8c5=_0x4bcec6;if(!SceneManager[_0x4ec8c5(0x772)]())return;const _0xd9cf04=SceneManager[_0x4ec8c5(0xb7c)][_0x4ec8c5(0x4ba)];if(_0xd9cf04)_0xd9cf04[_0x4ec8c5(0x93e)]();},BattleManager[_0x4bcec6(0xf7)]=function(){const _0x4fe28f=_0x4bcec6;if(BattleManager[_0x4fe28f(0x22c)]())return _0x4fe28f(0x123);return'DTB';},BattleManager[_0x4bcec6(0x947)]=function(_0x6b47ac){const _0x1258dd=_0x4bcec6;return _0x6b47ac=_0x6b47ac[_0x1258dd(0x1fd)]()[_0x1258dd(0x7d5)](),this[_0x1258dd(0xf7)]()===_0x6b47ac;},BattleManager[_0x4bcec6(0x8dd)]=function(){const _0x565851=_0x4bcec6;return this[_0x565851(0x947)](_0x565851(0x84e));},BattleManager[_0x4bcec6(0x211)]=function(){const _0x58d51a=_0x4bcec6;return this[_0x58d51a(0x8dd)]();},BattleManager[_0x4bcec6(0x1c9)]=function(){const _0x7d098e=_0x4bcec6;return!this[_0x7d098e(0x211)]();},BattleManager[_0x4bcec6(0x185)]=function(){const _0x142cf3=_0x4bcec6;return!this[_0x142cf3(0x211)]()&&!this[_0x142cf3(0x1c9)]();},BattleManager[_0x4bcec6(0x566)]=function(_0x529c13){const _0x5e11c9=_0x4bcec6;this[_0x5e11c9(0x5b8)]=this[_0x5e11c9(0x5b8)]||{};if(this[_0x5e11c9(0x5b8)][_0x529c13]!==undefined)return this[_0x5e11c9(0x5b8)][_0x529c13];this[_0x5e11c9(0x5b8)][_0x529c13]=null;const _0x3e4be6=this[_0x5e11c9(0x404)](),_0x5cb49e=_0x3e4be6[_0x5e11c9(0x32b)](_0x223855=>_0x223855['battlerKey']()===_0x529c13);if(_0x5cb49e)this[_0x5e11c9(0x5b8)][_0x529c13]=_0x5cb49e;return this[_0x5e11c9(0x5b8)][_0x529c13];},Game_BattlerBase[_0x4bcec6(0x38e)][_0x4bcec6(0x2a2)]=function(){const _0x3b8bdc=_0x4bcec6;return _0x3b8bdc(0xaf5)[_0x3b8bdc(0xb12)](this[_0x3b8bdc(0xbf8)]()?_0x3b8bdc(0x37d):_0x3b8bdc(0x8ad),this[_0x3b8bdc(0x4fc)]()+'-'+(this[_0x3b8bdc(0xbf8)]()?this[_0x3b8bdc(0xb3b)]():this[_0x3b8bdc(0x575)]()));},Game_Action['prototype'][_0x4bcec6(0x6f0)]=function(_0x4d49e5){const _0x1a1f61=_0x4bcec6;if(this[_0x1a1f61(0x5f4)]!=='')return;typeof _0x4d49e5===_0x1a1f61(0xa55)?this['_targetBattlerKey']=_0x4d49e5[_0x1a1f61(0xb8f)]()[_0x1a1f61(0x7d5)]():this[_0x1a1f61(0x5f4)]=_0x4d49e5['battlerKey']();},Game_Action[_0x4bcec6(0x38e)]['getBattlerKeyTargets']=function(){const _0x45458f=_0x4bcec6;return[this[_0x45458f(0xabb)]()];},Game_Action['prototype'][_0x4bcec6(0xabb)]=function(){const _0x4c0f80=_0x4bcec6,_0x4d2347=this[_0x4c0f80(0x5f4)]||'',_0x2aa985=BattleManager[_0x4c0f80(0x566)](_0x4d2347);if(!_0x2aa985)return this[_0x4c0f80(0x904)]();if(!_0x2aa985[_0x4c0f80(0x694)]())return this[_0x4c0f80(0x904)]();return _0x2aa985;},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x904)]=function(){const _0x2f3c5e=_0x4bcec6,_0x410b85=this[_0x2f3c5e(0x5f4)];return _0x410b85[_0x2f3c5e(0x820)](/ACTOR/i)?this[_0x2f3c5e(0xbdc)]()[_0x2f3c5e(0x156)]():this[_0x2f3c5e(0x43f)]()['trueRandomTarget']();},BattleManager[_0x4bcec6(0x2f4)]=function(){const _0x54ebb0=_0x4bcec6;return this[_0x54ebb0(0x404)]()[_0x54ebb0(0x9f4)](_0x11d9ad=>_0x11d9ad[_0x54ebb0(0x7b9)]());},BattleManager[_0x4bcec6(0x573)]=function(_0x32b1e5){const _0x33d30e=_0x4bcec6;_0x32b1e5==='BattleVictoryJS'&&(this[_0x33d30e(0x715)]=!![]),$gameParty[_0x33d30e(0x573)](_0x32b1e5),$gameTroop[_0x33d30e(0x573)](_0x32b1e5);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x627)]=BattleManager[_0x4bcec6(0x620)],BattleManager[_0x4bcec6(0x620)]=function(){const _0x43f5ab=_0x4bcec6;this['_endBattle']=![],this['_autoBattle']=ConfigManager['autoBattleAtStart'],this['_endingBattle']=![],this[_0x43f5ab(0x573)](_0x43f5ab(0xaed)),VisuMZ[_0x43f5ab(0x377)][_0x43f5ab(0x627)]['call'](this),this['processBattleCoreJS'](_0x43f5ab(0xa72));},BattleManager[_0x4bcec6(0x7f4)]=function(_0x1422b0){const _0x173bb8=_0x4bcec6,_0x3e4831=VisuMZ[_0x173bb8(0x377)][_0x173bb8(0x187)][_0x173bb8(0xbbe)];_0x1422b0!=='EscapeFail'&&_0x3e4831[_0x173bb8(0x186)]&&VisuMZ[_0x173bb8(0x377)][_0x173bb8(0x738)](_0x3e4831[_0x173bb8(0x186)])&&$gameTemp[_0x173bb8(0x92f)](_0x3e4831[_0x173bb8(0x186)]);const _0x38a7f1='%1Event'[_0x173bb8(0xb12)](_0x1422b0);_0x3e4831[_0x38a7f1]&&VisuMZ['BattleCore']['CheckMapBattleEventValid'](_0x3e4831[_0x38a7f1])&&$gameTemp[_0x173bb8(0x92f)](_0x3e4831[_0x38a7f1]);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x3f8)]=BattleManager['abort'],BattleManager['abort']=function(){const _0x31670f=_0x4bcec6;VisuMZ[_0x31670f(0x377)][_0x31670f(0x3f8)][_0x31670f(0x20f)](this),SceneManager[_0x31670f(0x772)]()&&BattleManager[_0x31670f(0x87e)]();},VisuMZ['BattleCore'][_0x4bcec6(0xa8f)]=BattleManager['checkBattleEnd'],BattleManager[_0x4bcec6(0x268)]=function(){const _0x46e28c=_0x4bcec6;if(this[_0x46e28c(0x58e)]===_0x46e28c(0x2b9)){if($gameTemp['isCommonEventReserved']())return![];}return VisuMZ[_0x46e28c(0x377)][_0x46e28c(0xa8f)][_0x46e28c(0x20f)](this);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x9df)]=BattleManager[_0x4bcec6(0x5ad)],BattleManager[_0x4bcec6(0x5ad)]=function(){const _0x81c68d=_0x4bcec6;this[_0x81c68d(0x715)]=!![],this['processBattleCoreJS']('BattleVictoryJS'),VisuMZ[_0x81c68d(0x377)]['BattleManager_processVictory'][_0x81c68d(0x20f)](this),this[_0x81c68d(0x7f4)](_0x81c68d(0x6ac));},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x64f)]=BattleManager['processAbort'],BattleManager['processAbort']=function(){const _0x4b139f=_0x4bcec6;this[_0x4b139f(0x715)]=!![],VisuMZ['BattleCore'][_0x4b139f(0x64f)]['call'](this);},VisuMZ[_0x4bcec6(0x377)]['BattleManager_processDefeat']=BattleManager[_0x4bcec6(0xaae)],BattleManager['processDefeat']=function(){const _0x15caec=_0x4bcec6;this[_0x15caec(0x715)]=!![],this[_0x15caec(0x573)](_0x15caec(0x501)),VisuMZ['BattleCore'][_0x15caec(0xa78)]['call'](this),this[_0x15caec(0x7f4)]('Defeat');},VisuMZ['BattleCore'][_0x4bcec6(0x6d3)]=BattleManager['endBattle'],BattleManager['endBattle']=function(_0xc401b8){const _0x7fe119=_0x4bcec6;this[_0x7fe119(0x4cd)]=!![],this['_autoBattle']=![],this[_0x7fe119(0x573)]('PreEndBattleJS'),VisuMZ[_0x7fe119(0x377)][_0x7fe119(0x6d3)]['call'](this,_0xc401b8),this[_0x7fe119(0x573)](_0x7fe119(0x8fc));},VisuMZ['BattleCore'][_0x4bcec6(0xa95)]=BattleManager[_0x4bcec6(0x72e)],BattleManager[_0x4bcec6(0x72e)]=function(){const _0x49173f=_0x4bcec6;if(this['isTurnBased']())this['processBattleCoreJS'](_0x49173f(0x671));VisuMZ[_0x49173f(0x377)][_0x49173f(0xa95)][_0x49173f(0x20f)](this);if(this['isTurnBased']())this[_0x49173f(0x573)](_0x49173f(0x693));},BattleManager[_0x4bcec6(0x69e)]=function(){const _0x18c996=_0x4bcec6,_0x2c49d3=this[_0x18c996(0xba3)],_0x3a31a1=_0x2c49d3['currentAction']();_0x3a31a1?(_0x3a31a1[_0x18c996(0x920)](),_0x3a31a1[_0x18c996(0xabe)]()?(this[_0x18c996(0x516)](),_0x2c49d3[_0x18c996(0xa63)]()):(_0x2c49d3['removeCurrentAction'](),this['endAction']())):(this[_0x18c996(0xb07)](),this[_0x18c996(0xba3)]=null);},VisuMZ[_0x4bcec6(0x377)]['BattleManager_startAction']=BattleManager[_0x4bcec6(0x516)],BattleManager[_0x4bcec6(0x516)]=function(){const _0x3c284c=_0x4bcec6,_0x288376=this[_0x3c284c(0xba3)][_0x3c284c(0x467)](),_0x4257de=this[_0x3c284c(0xba3)];_0x288376&&_0x288376['subject']()===_0x4257de&&_0x288376['actionBattleCoreJS']('PreStartActionJS'),VisuMZ['BattleCore'][_0x3c284c(0x984)][_0x3c284c(0x20f)](this),_0x288376&&_0x288376[_0x3c284c(0x90b)]()===_0x4257de&&_0x288376[_0x3c284c(0x700)](_0x3c284c(0x2bd));},VisuMZ[_0x4bcec6(0x377)]['BattleManager_endAction']=BattleManager[_0x4bcec6(0xb07)],BattleManager[_0x4bcec6(0xb07)]=function(){const _0x5d2267=_0x4bcec6,_0x310c34=this['_action'],_0x2ee443=this[_0x5d2267(0xba3)];_0x310c34&&_0x310c34!==this[_0x5d2267(0x727)]&&_0x310c34[_0x5d2267(0x90b)]()===_0x2ee443&&_0x310c34[_0x5d2267(0x700)]('PreEndActionJS'),this[_0x5d2267(0xba3)]?VisuMZ[_0x5d2267(0x377)][_0x5d2267(0xad2)][_0x5d2267(0x20f)](this):this[_0x5d2267(0x58e)]=_0x5d2267(0x2b9),_0x310c34&&_0x310c34!==this[_0x5d2267(0x727)]&&_0x310c34[_0x5d2267(0x90b)]()===_0x2ee443&&_0x310c34['actionBattleCoreJS'](_0x5d2267(0xa17)),this[_0x5d2267(0x902)](this['allBattleMembers']()),this[_0x5d2267(0x727)]=this['_action'];},BattleManager['refreshBattlerMotions']=function(_0x4452b3){const _0x363641=_0x4bcec6;for(const _0x1702e1 of _0x4452b3){if(!_0x1702e1)continue;if(!_0x1702e1[_0x363641(0x171)]())continue;_0x1702e1[_0x363641(0x171)]()[_0x363641(0xac9)]();}},BattleManager[_0x4bcec6(0xaf8)]=function(){const _0x5c2f02=_0x4bcec6;!this['_logWindow'][_0x5c2f02(0xbe1)]()&&this[_0x5c2f02(0xb07)]();},Game_Battler['prototype'][_0x4bcec6(0xafb)]=function(){const _0x5859dd=_0x4bcec6;this[_0x5859dd(0x94f)]();if(Imported['VisuMZ_1_SkillsStatesCore']){const _0x2790e0=VisuMZ[_0x5859dd(0x841)][_0x5859dd(0x187)][_0x5859dd(0xba5)];_0x2790e0&&_0x2790e0[_0x5859dd(0x4f2)]===![]&&this[_0x5859dd(0xb51)](0x1);}else this['removeStatesAuto'](0x1);this[_0x5859dd(0x912)]();},VisuMZ[_0x4bcec6(0x377)]['BattleManager_invokeCounterAttack']=BattleManager['invokeCounterAttack'],BattleManager[_0x4bcec6(0x8d5)]=function(_0x33c692,_0x40b7bc){const _0xab2505=_0x4bcec6;this['_bypassCanCounterCheck']=!![],VisuMZ[_0xab2505(0x377)][_0xab2505(0xa1f)][_0xab2505(0x20f)](this,_0x33c692,_0x40b7bc),this[_0xab2505(0x622)]=undefined;},BattleManager['makeEscapeRatio']=function(){const _0x559103=_0x4bcec6;this[_0x559103(0x788)]=VisuMZ['BattleCore']['Settings']['Mechanics'][_0x559103(0x7f6)][_0x559103(0x20f)](this);},VisuMZ[_0x4bcec6(0x377)]['BattleManager_onEscapeSuccess']=BattleManager[_0x4bcec6(0x5a0)],BattleManager['onEscapeSuccess']=function(){const _0x2de83e=_0x4bcec6;this['processBattleCoreJS'](_0x2de83e(0x2c5)),BattleManager[_0x2de83e(0x8c8)]['processEscape'](),VisuMZ['BattleCore']['BattleManager_onEscapeSuccess'][_0x2de83e(0x20f)](this),this[_0x2de83e(0x7f4)](_0x2de83e(0xad3));},VisuMZ[_0x4bcec6(0x377)]['BattleManager_onEscapeFailure']=BattleManager['onEscapeFailure'],BattleManager[_0x4bcec6(0x81e)]=function(){const _0x46b519=_0x4bcec6;this[_0x46b519(0x573)]('EscapeFailureJS');const _0x5b0dfc=this[_0x46b519(0x788)];VisuMZ[_0x46b519(0x377)][_0x46b519(0xb61)][_0x46b519(0x20f)](this),this[_0x46b519(0x788)]=_0x5b0dfc+VisuMZ[_0x46b519(0x377)]['Settings'][_0x46b519(0xbbe)][_0x46b519(0x992)][_0x46b519(0x20f)](this),this[_0x46b519(0x2a7)]=![],this[_0x46b519(0x7f4)](_0x46b519(0xbf1));},BattleManager['displayStartMessages']=function(){const _0x18b66f=_0x4bcec6;let _0x4bba42=![];if(this[_0x18b66f(0x713)]())for(const _0x374468 of $gameTroop[_0x18b66f(0x49d)]()){this[_0x18b66f(0x7ed)][_0x18b66f(0x27a)](_0x18b66f(0xc01),TextManager[_0x18b66f(0x2e1)][_0x18b66f(0xb12)](_0x374468)),this['_logWindow'][_0x18b66f(0x27a)](_0x18b66f(0x4b6)),_0x4bba42=!![];}if(this['_preemptive'])this[_0x18b66f(0x7ed)][_0x18b66f(0x27a)](_0x18b66f(0xc01),TextManager['preemptive'][_0x18b66f(0xb12)]($gameParty[_0x18b66f(0x4fc)]())),this[_0x18b66f(0x7ed)][_0x18b66f(0x27a)](_0x18b66f(0x4b6));else this[_0x18b66f(0x236)]&&(this[_0x18b66f(0x7ed)][_0x18b66f(0x27a)]('addText',TextManager[_0x18b66f(0x31f)]['format']($gameParty[_0x18b66f(0x4fc)]())),this['_logWindow'][_0x18b66f(0x27a)](_0x18b66f(0x4b6)));_0x4bba42&&(this[_0x18b66f(0x7ed)][_0x18b66f(0x27a)](_0x18b66f(0x4b6)),this[_0x18b66f(0x7ed)][_0x18b66f(0x27a)]('clear')),this[_0x18b66f(0x22c)]()&&this['isSkipPartyCommandWindow']()&&(this[_0x18b66f(0x871)]=![]);},BattleManager[_0x4bcec6(0x713)]=function(){const _0x1da37a=_0x4bcec6;if(BattleManager[_0x1da37a(0x382)])return![];return VisuMZ[_0x1da37a(0x377)][_0x1da37a(0x187)][_0x1da37a(0x5fb)][_0x1da37a(0xaf2)];},VisuMZ['BattleCore']['BattleManager_startInput']=BattleManager[_0x4bcec6(0x30e)],BattleManager[_0x4bcec6(0x30e)]=function(){const _0xc02817=_0x4bcec6;VisuMZ['BattleCore'][_0xc02817(0x8c1)][_0xc02817(0x20f)](this),this[_0xc02817(0x8dd)]()&&this['isSkipPartyCommandWindow']()&&!this['_surprise']&&$gameParty['canInput']()&&this['selectNextCommand']();},BattleManager[_0x4bcec6(0xaf7)]=function(){const _0x144146=_0x4bcec6;return VisuMZ['BattleCore']['Settings'][_0x144146(0x508)][_0x144146(0x720)];},BattleManager['checkTpbInputOpen']=function(){const _0x11e330=_0x4bcec6;this[_0x11e330(0x311)]()&&this[_0x11e330(0x39b)]();},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x1aa)]=Scene_Battle[_0x4bcec6(0x38e)]['startActorCommandSelection'],Scene_Battle[_0x4bcec6(0x38e)][_0x4bcec6(0x347)]=function(){const _0xb1894d=_0x4bcec6;VisuMZ['BattleCore'][_0xb1894d(0x1aa)][_0xb1894d(0x20f)](this),BattleManager[_0xb1894d(0x22c)]()&&BattleManager['_tpbNeedsPartyCommand']&&(BattleManager['_tpbNeedsPartyCommand']=![],this[_0xb1894d(0x973)]());},BattleManager[_0x4bcec6(0x703)]=function(_0x4a1ebb,_0x16ccbb,_0x780ab2){const _0x3da048=_0x4bcec6;if(!_0x780ab2)return;if(!_0x4a1ebb)return;if(!_0x16ccbb)return;const _0x3d1fe1=this['_action'];this[_0x3da048(0x3fd)]=new Game_Action(_0x4a1ebb);if(DataManager[_0x3da048(0x288)](_0x780ab2))this[_0x3da048(0x3fd)]['setItem'](_0x780ab2['id']);if(DataManager['isSkill'](_0x780ab2))this[_0x3da048(0x3fd)][_0x3da048(0x7af)](_0x780ab2['id']);if(this['_action']['item']())BattleManager[_0x3da048(0x45b)](_0x4a1ebb,_0x16ccbb);this['_action']=_0x3d1fe1;},BattleManager[_0x4bcec6(0x35e)]=function(_0x547b95,_0x29fcb0){const _0x436249=_0x4bcec6;this[_0x436249(0x3fd)][_0x436249(0x380)]=_0x29fcb0,this[_0x436249(0x7ed)]['displayReflection'](_0x29fcb0),this[_0x436249(0x7ed)]['displayReflectionPlayBack'](_0x547b95,this[_0x436249(0x3fd)]),this[_0x436249(0x3fd)][_0x436249(0xb1f)](_0x547b95),this[_0x436249(0x7ed)][_0x436249(0xa38)](_0x547b95,_0x547b95);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x2d3)]=BattleManager[_0x4bcec6(0x3e4)],BattleManager['makeActionOrders']=function(){const _0x2414da=_0x4bcec6;VisuMZ[_0x2414da(0x377)][_0x2414da(0x2d3)][_0x2414da(0x20f)](this),this['_actionBattlers']=this[_0x2414da(0x59f)][_0x2414da(0x9f4)](_0x59e082=>_0x59e082&&_0x59e082[_0x2414da(0x2e8)]());},VisuMZ['BattleCore'][_0x4bcec6(0x4cc)]=BattleManager['updatePhase'],BattleManager[_0x4bcec6(0x742)]=function(_0x4e7990){const _0x2e6ba6=_0x4bcec6;if(this[_0x2e6ba6(0x58e)]===_0x2e6ba6(0x5c2))this[_0x2e6ba6(0xa35)]();else this['_phase']==='forceAction'?this[_0x2e6ba6(0xab3)]():VisuMZ['BattleCore'][_0x2e6ba6(0x4cc)][_0x2e6ba6(0x20f)](this,_0x4e7990);},BattleManager[_0x4bcec6(0x414)]=function(){const _0x5f0ef6=_0x4bcec6;this[_0x5f0ef6(0x361)]=this[_0x5f0ef6(0x635)][_0x5f0ef6(0x9dd)](0x0),this[_0x5f0ef6(0x7fd)]=0x0,this[_0x5f0ef6(0x78f)]=this[_0x5f0ef6(0x361)][0x0]||null,this['_phase']=_0x5f0ef6(0x5c2);},BattleManager[_0x4bcec6(0xa35)]=function(){const _0xcbc788=_0x4bcec6;!this[_0xcbc788(0x762)]()&&!this[_0xcbc788(0x7ed)][_0xcbc788(0xbe1)]()&&(this[_0xcbc788(0x58e)]=_0xcbc788(0x4e9));},BattleManager[_0x4bcec6(0x5da)]=function(_0xc2538d){const _0x6d6f9a=_0x4bcec6;this[_0x6d6f9a(0x59f)][_0x6d6f9a(0x8b7)](_0xc2538d);if(_0xc2538d===this['_subject'])return;const _0xf99ebc=JsonEx[_0x6d6f9a(0x41e)](_0xc2538d[_0x6d6f9a(0x467)]());this[_0x6d6f9a(0x77f)][_0x6d6f9a(0x27a)]([_0xc2538d,_0xf99ebc]);},BattleManager[_0x4bcec6(0x6e1)]=function(){},BattleManager['updateStart']=function(){const _0x14ed18=_0x4bcec6;if(this[_0x14ed18(0x22c)]())this['_phase']=_0x14ed18(0x2b9);else this['_forcedBattlers'][_0x14ed18(0x64b)]>0x0?this['_phase']='turn':this[_0x14ed18(0x30e)]();},BattleManager[_0x4bcec6(0xa16)]=function(){const _0x3e0b8d=_0x4bcec6,_0x128bf1=this[_0x3e0b8d(0xba3)];_0x128bf1&&this[_0x3e0b8d(0x22c)]()&&_0x128bf1[_0x3e0b8d(0x340)]('undecided');for(;;){const _0x3ae99e=this['getNextSubjectFromPool']();if(!_0x3ae99e)return null;if(_0x3ae99e['isBattleMember']()&&_0x3ae99e['isAlive']())return _0x3ae99e;}},BattleManager[_0x4bcec6(0x5f1)]=function(){const _0x3ae0d3=_0x4bcec6;if(this[_0x3ae0d3(0x77f)]['length']>0x0){const _0x5a4e76=this[_0x3ae0d3(0x77f)]['shift'](),_0x3b9a3d=_0x5a4e76[0x0];return _0x3b9a3d[_0x3ae0d3(0x107)]=_0x3b9a3d[_0x3ae0d3(0x107)]||[],_0x3b9a3d['_actions'][0x0]=_0x5a4e76[0x1],_0x3b9a3d;}else return this[_0x3ae0d3(0x59f)]['shift']();},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x155)]=Game_Battler[_0x4bcec6(0x38e)][_0x4bcec6(0x5da)],Game_Battler[_0x4bcec6(0x38e)][_0x4bcec6(0x5da)]=function(_0x4d9558,_0x23a481){const _0x2f8f03=_0x4bcec6;VisuMZ[_0x2f8f03(0x377)][_0x2f8f03(0x155)]['call'](this,_0x4d9558,_0x23a481),this[_0x2f8f03(0x107)][this['_actions'][_0x2f8f03(0x64b)]-0x1][_0x2f8f03(0xb36)]=!![];},Game_Interpreter['prototype'][_0x4bcec6(0x276)]=function(_0x31e6e4){return this['iterateBattler'](_0x31e6e4[0x0],_0x31e6e4[0x1],_0x4faeea=>{const _0x2aabf3=_0x2f5c;!_0x4faeea[_0x2aabf3(0x18c)]()&&(_0x4faeea[_0x2aabf3(0x5da)](_0x31e6e4[0x2],_0x31e6e4[0x3]),BattleManager[_0x2aabf3(0x5da)](_0x4faeea));}),!![];},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x71c)]=Game_Battler[_0x4bcec6(0x38e)][_0x4bcec6(0xbb0)],Game_Battler[_0x4bcec6(0x38e)]['makeSpeed']=function(){const _0x5b2358=_0x4bcec6;VisuMZ['BattleCore']['Game_Battler_makeSpeed'][_0x5b2358(0x20f)](this),this[_0x5b2358(0x107)]['length']<=0x0&&(this['_speed']=Number[_0x5b2358(0x767)]);},BattleManager[_0x4bcec6(0x3c0)]=function(){const _0xaa57ac=_0x4bcec6;if(VisuMZ['BattleCore'][_0xaa57ac(0x187)]['Damage'][_0xaa57ac(0x505)]??!![])return![];return SceneManager[_0xaa57ac(0x772)]()&&this[_0xaa57ac(0x715)];},VisuMZ['BattleCore'][_0x4bcec6(0x8dc)]=BattleManager[_0x4bcec6(0x39b)],BattleManager['selectNextCommand']=function(){const _0x9bf5f8=_0x4bcec6;this[_0x9bf5f8(0x22c)]()?this['selectNextCommandTpb']():VisuMZ[_0x9bf5f8(0x377)]['BattleManager_selectNextCommand']['call'](this);},BattleManager['selectNextCommandTpb']=function(){const _0x4b6c46=_0x4bcec6;if(this[_0x4b6c46(0x159)]){if(this[_0x4b6c46(0x159)][_0x4b6c46(0x39b)]())return;this['finishActorInput'](),this['checkTpbInputClose'](),!this[_0x4b6c46(0xba3)]&&!this[_0x4b6c46(0x159)]&&SceneManager[_0x4b6c46(0xb7c)][_0x4b6c46(0x77a)]();}else!this[_0x4b6c46(0xba3)]&&this['selectNextActor']();},BattleManager[_0x4bcec6(0x1d0)]=function(){const _0x182934=_0x4bcec6;(!this['isPartyTpbInputtable']()||this['needsActorInputCancel']())&&(this[_0x182934(0x67c)]&&(!$gameParty[_0x182934(0x55b)]()['includes'](this[_0x182934(0x67c)])&&(this[_0x182934(0x67c)]=null)),!this['_tpbSceneChangeCacheActor']?(this[_0x182934(0x603)](),this[_0x182934(0x159)]=null,this[_0x182934(0x2a7)]=![]):this[_0x182934(0x487)]());},BattleManager[_0x4bcec6(0x487)]=function(){const _0x20938c=_0x4bcec6;!$gameParty['battleMembers']()[_0x20938c(0x5e4)](this[_0x20938c(0x67c)])&&(this[_0x20938c(0x67c)]=null),this[_0x20938c(0x67c)]?(this[_0x20938c(0x159)]=this[_0x20938c(0x67c)],this['_currentActor']['_tpbState']=_0x20938c(0x944),this[_0x20938c(0x2a7)]=!![],this['_tpbSceneChangeCacheActor']=null):(this[_0x20938c(0x603)](),this[_0x20938c(0x159)]=null,this[_0x20938c(0x2a7)]=![]);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x8d2)]=BattleManager[_0x4bcec6(0x919)],BattleManager[_0x4bcec6(0x919)]=function(){const _0x57bb01=_0x4bcec6;return this['_phase']===_0x57bb01(0x5c2)?this[_0x57bb01(0xa28)]():VisuMZ['BattleCore'][_0x57bb01(0x8d2)][_0x57bb01(0x20f)](this);},BattleManager[_0x4bcec6(0xa28)]=function(){return this['isActiveTpb']();},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x9e5)]=BattleManager[_0x4bcec6(0x603)],BattleManager[_0x4bcec6(0x603)]=function(){const _0x427d12=_0x4bcec6;this[_0x427d12(0x22c)]()&&this[_0x427d12(0x58e)]==='battleEnd'&&(this[_0x427d12(0x159)]=null),VisuMZ['BattleCore'][_0x427d12(0x9e5)][_0x427d12(0x20f)](this);},VisuMZ['BattleCore'][_0x4bcec6(0x48e)]=BattleManager['inputtingAction'],BattleManager[_0x4bcec6(0xaf9)]=function(){const _0x520a27=_0x4bcec6,_0x3c9d57=this[_0x520a27(0x159)];if(_0x3c9d57&&!_0x3c9d57[_0x520a27(0xaf9)]()){const _0x2ca3df=_0x3c9d57[_0x520a27(0x57f)];_0x3c9d57[_0x520a27(0x107)][_0x2ca3df]=new Game_Action(_0x3c9d57);}return VisuMZ[_0x520a27(0x377)][_0x520a27(0x48e)][_0x520a27(0x20f)](this);},VisuMZ[_0x4bcec6(0x377)]['BattleManager_checkSubstitute']=BattleManager[_0x4bcec6(0x13b)],BattleManager[_0x4bcec6(0x13b)]=function(_0x213fa6){const _0x3646b0=_0x4bcec6;if(this[_0x3646b0(0x3fd)][_0x3646b0(0xb79)]())return![];return VisuMZ[_0x3646b0(0x377)][_0x3646b0(0x28a)][_0x3646b0(0x20f)](this,_0x213fa6);},SceneManager[_0x4bcec6(0x772)]=function(){const _0x1613a2=_0x4bcec6;return this[_0x1613a2(0xb7c)]&&this[_0x1613a2(0xb7c)][_0x1613a2(0x99d)]===Scene_Battle;},SceneManager[_0x4bcec6(0x90a)]=function(){const _0x3be960=_0x4bcec6;return Spriteset_Battle[_0x3be960(0x38e)][_0x3be960(0xbcf)]();},SceneManager[_0x4bcec6(0x133)]=function(){const _0x1c4862=_0x4bcec6;if(SceneManager[_0x1c4862(0x71a)](Scene_Options))return!![];return![];},SceneManager[_0x4bcec6(0x7fb)]=function(){const _0x272a11=_0x4bcec6;if(SceneManager[_0x272a11(0xb7a)](Scene_Options))return!![];return![];},SceneManager['checkSceneBattleTransitionable']=function(_0x84e64c){const _0xe478c2=_0x4bcec6;if(!SceneManager['isSceneBattle']())return!![];const _0x2c276e=[_0xe478c2(0x3d4),'Scene_Party',_0xe478c2(0x3c3)];return _0x2c276e[_0xe478c2(0x5e4)](_0x84e64c[_0xe478c2(0x4fc)]);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x270)]=SceneManager[_0x4bcec6(0x27a)],SceneManager[_0x4bcec6(0x27a)]=function(_0x297008){const _0xc4484e=_0x4bcec6;if(!SceneManager[_0xc4484e(0xa89)](_0x297008))return this[_0xc4484e(0xbd9)](_0x297008);VisuMZ[_0xc4484e(0x377)][_0xc4484e(0x270)][_0xc4484e(0x20f)](this,_0x297008);},SceneManager[_0x4bcec6(0xbd9)]=function(_0x2933b9){const _0x2a6036=_0x4bcec6;if(!$gameTemp['isPlaytest']())return;if(this['_displayBattleCoreTransitionErrorMsg'])return;this[_0x2a6036(0xa6a)]=!![];let _0x4be739='';_0x4be739+=_0x2a6036(0x8f1),_0x4be739+=_0x2a6036(0x4e8)['format'](_0x2933b9[_0x2a6036(0x4fc)]),alert(_0x4be739);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0xa5a)]=Game_Temp[_0x4bcec6(0x38e)][_0x4bcec6(0xadd)],Game_Temp['prototype']['initialize']=function(){const _0x44f5f3=_0x4bcec6;VisuMZ['BattleCore']['Game_Temp_initialize'][_0x44f5f3(0x20f)](this),this[_0x44f5f3(0x511)]=[];},VisuMZ['BattleCore'][_0x4bcec6(0x45d)]=Game_Temp[_0x4bcec6(0x38e)][_0x4bcec6(0x6f8)],Game_Temp[_0x4bcec6(0x38e)][_0x4bcec6(0x6f8)]=function(_0x5b69ed,_0x3b9bff,_0x334c20){const _0x2b5f23=_0x4bcec6;_0x5b69ed=_0x5b69ed['filter']((_0x45254e,_0x3c3932,_0x5cabd1)=>_0x5cabd1[_0x2b5f23(0x4fd)](_0x45254e)===_0x3c3932);SceneManager['isSceneBattle']()&&SceneManager[_0x2b5f23(0x90a)]()&&(_0x334c20=!_0x334c20);VisuMZ[_0x2b5f23(0x377)][_0x2b5f23(0x45d)][_0x2b5f23(0x20f)](this,_0x5b69ed,_0x3b9bff,_0x334c20);SceneManager['isSceneBattle']()&&BattleManager[_0x2b5f23(0x8c8)][_0x2b5f23(0x7e1)]();for(const _0x131852 of _0x5b69ed){_0x131852&&_0x131852[_0x2b5f23(0x52e)]&&_0x131852[_0x2b5f23(0x52e)]()&&_0x131852[_0x2b5f23(0xb92)]();}},Game_Temp['prototype'][_0x4bcec6(0x56d)]=function(_0x12c1ec){const _0x58de36=_0x4bcec6;this[_0x58de36(0xbfa)]=_0x12c1ec;},Game_Temp[_0x4bcec6(0x38e)][_0x4bcec6(0x475)]=function(){const _0x38083d=_0x4bcec6;return this[_0x38083d(0xbfa)];},Game_Temp['prototype'][_0x4bcec6(0x73f)]=function(){const _0x465366=_0x4bcec6;this[_0x465366(0x85c)]=undefined;},Game_Temp[_0x4bcec6(0x38e)][_0x4bcec6(0x7a8)]=function(_0x2d58a6){const _0x33d0c1=_0x4bcec6;$gameMap&&$dataMap&&$dataMap[_0x33d0c1(0x131)]&&this[_0x33d0c1(0x3d3)]($dataMap[_0x33d0c1(0x131)]);const _0x1ba5bb=$dataTroops[_0x2d58a6];if(_0x1ba5bb){let _0x2422f6=DataManager[_0x33d0c1(0x307)](_0x1ba5bb['id']);this[_0x33d0c1(0x3d3)](_0x2422f6);}},Game_Temp['prototype'][_0x4bcec6(0x3d3)]=function(_0x40c1f5){const _0x5db960=_0x4bcec6;if(!_0x40c1f5)return;if(_0x40c1f5[_0x5db960(0x820)](/<(?:BATTLELAYOUT|BATTLE LAYOUT|LAYOUT):[ ](.*?)>/i)){const _0x1143fb=String(RegExp['$1']);if(_0x1143fb[_0x5db960(0x820)](/DEFAULT/i))this[_0x5db960(0x85c)]=_0x5db960(0x395);else{if(_0x1143fb['match'](/LIST/i))this[_0x5db960(0x85c)]='list';else{if(_0x1143fb[_0x5db960(0x820)](/XP/i))this[_0x5db960(0x85c)]='xp';else{if(_0x1143fb[_0x5db960(0x820)](/PORTRAIT/i))this[_0x5db960(0x85c)]='portrait';else{if(_0x1143fb[_0x5db960(0x820)](/BORDER/i))this['_forcedBattleLayout']=_0x5db960(0x65b);else{if(_0x1143fb[_0x5db960(0x820)](/(?:SIDEVIEW UI|SIDEVIEW)/i))Imported[_0x5db960(0x2bc)]?this['_forcedBattleLayout']=_0x5db960(0xb47):this['_forcedBattleLayout']='default';else _0x1143fb[_0x5db960(0x820)](/(?:FRONTVIEW UI|FRONTVIEW)/i)&&(Imported[_0x5db960(0x435)]?this[_0x5db960(0x85c)]='frontview_ui':this[_0x5db960(0x85c)]='default');}}}}}}},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x79f)]=Game_Temp[_0x4bcec6(0x38e)][_0x4bcec6(0x2a0)],Game_Temp[_0x4bcec6(0x38e)][_0x4bcec6(0x2a0)]=function(_0x219488,_0x49d40e){const _0x134373=_0x4bcec6;SceneManager[_0x134373(0x772)]()?this['requestBattleBalloon'](_0x219488,_0x49d40e):VisuMZ[_0x134373(0x377)]['Game_Temp_requestBalloon'][_0x134373(0x20f)](this,_0x219488,_0x49d40e);},Game_Temp['prototype'][_0x4bcec6(0x659)]=function(_0x43180b,_0x3363f1){const _0x1db37e=_0x4bcec6,_0x36fdab={'target':_0x43180b,'balloonId':_0x3363f1};this[_0x1db37e(0x511)]=this[_0x1db37e(0x511)]||[],this[_0x1db37e(0x511)][_0x1db37e(0x27a)](_0x36fdab);},Game_Temp[_0x4bcec6(0x38e)][_0x4bcec6(0x889)]=function(){const _0x3bb68a=_0x4bcec6;return this[_0x3bb68a(0x511)]=this['_battleBalloonQueue']||[],this[_0x3bb68a(0x511)][_0x3bb68a(0x9a0)]();},Game_Temp[_0x4bcec6(0x38e)]['clearBattleBalloons']=function(){const _0x5c0345=_0x4bcec6;this[_0x5c0345(0x511)]=[];},Spriteset_Battle[_0x4bcec6(0x38e)][_0x4bcec6(0x7d3)]=function(){const _0x44f792=_0x4bcec6;this[_0x44f792(0x4b0)]===undefined&&(this[_0x44f792(0x4b0)]=[]);for(const _0x5c019b of this['_battleBalloonSprites']){!_0x5c019b[_0x44f792(0x76b)]()&&this['removeBattleBalloon'](_0x5c019b);}this['processBattleBalloonRequests']();},Spriteset_Battle[_0x4bcec6(0x38e)][_0x4bcec6(0x553)]=function(){const _0x462757=_0x4bcec6;for(;;){const _0x1d45e2=$gameTemp[_0x462757(0x889)]();if(_0x1d45e2)this['createBattleBalloon'](_0x1d45e2);else break;}},Spriteset_Battle['prototype']['createBattleBalloon']=function(_0x479eb6){const _0x34424b=_0x4bcec6,_0x1cfc8f=this[_0x34424b(0x848)](_0x479eb6[_0x34424b(0x887)]);if(_0x1cfc8f){let _0x213be1=null;Imported[_0x34424b(0x2fd)]&&Array[_0x34424b(0x731)](_0x479eb6[_0x34424b(0x754)])?_0x213be1=new Sprite_IconBalloon():_0x213be1=new Sprite_Balloon(),_0x213be1[_0x34424b(0x3b8)]=_0x479eb6[_0x34424b(0x887)],_0x213be1[_0x34424b(0x78f)]=_0x1cfc8f,_0x213be1['_target'][_0x34424b(0x23e)]=_0x1cfc8f,_0x213be1[_0x34424b(0xb27)](_0x1cfc8f,_0x479eb6[_0x34424b(0x754)]),BattleManager[_0x34424b(0x95b)](_0x213be1),this[_0x34424b(0x4b0)][_0x34424b(0x27a)](_0x213be1);}},Spriteset_Battle[_0x4bcec6(0x38e)][_0x4bcec6(0x9dc)]=function(_0x100aa6){const _0x52baff=_0x4bcec6;this[_0x52baff(0x4b0)]['remove'](_0x100aa6),BattleManager[_0x52baff(0x6c6)](_0x100aa6),_0x100aa6[_0x52baff(0x16b)]();},Sprite_Battler[_0x4bcec6(0x38e)][_0x4bcec6(0x26d)]=function(_0x305978,_0x840dfe){},Sprite_Battler[_0x4bcec6(0x38e)][_0x4bcec6(0x141)]=function(){return![];},Spriteset_Battle[_0x4bcec6(0x38e)][_0x4bcec6(0x67a)]=function(){const _0x486c8b=_0x4bcec6;return this['_battleBalloonSprites']=this[_0x486c8b(0x4b0)]||[],this[_0x486c8b(0x4b0)]['length']>0x0;},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x9b3)]=Game_System[_0x4bcec6(0x38e)][_0x4bcec6(0xadd)],Game_System[_0x4bcec6(0x38e)][_0x4bcec6(0xadd)]=function(){const _0x4195ea=_0x4bcec6;VisuMZ[_0x4195ea(0x377)][_0x4195ea(0x9b3)][_0x4195ea(0x20f)](this),this[_0x4195ea(0xa5b)]();},Game_System[_0x4bcec6(0x38e)][_0x4bcec6(0xa5b)]=function(){const _0x3647f6=_0x4bcec6;this[_0x3647f6(0x8de)]=this[_0x3647f6(0x8de)]||[];},Game_System[_0x4bcec6(0x38e)][_0x4bcec6(0x43d)]=function(){const _0x259806=_0x4bcec6;if(this['_defeatedEnemies']===undefined)this[_0x259806(0xa5b)]();return this['_defeatedEnemies'];},Game_System[_0x4bcec6(0x38e)][_0x4bcec6(0x4d7)]=function(_0x4e5ed5){const _0x206894=_0x4bcec6;if(this['_defeatedEnemies']===undefined)this[_0x206894(0xa5b)]();if(!_0x4e5ed5)return;if(this[_0x206894(0x8de)][_0x206894(0x5e4)](_0x4e5ed5))return;this[_0x206894(0x8de)]['push'](_0x4e5ed5),this[_0x206894(0x8de)][_0x206894(0x3ec)]((_0x2c32f1,_0x34e732)=>_0x2c32f1-_0x34e732);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x53f)]=Game_BattlerBase[_0x4bcec6(0x38e)][_0x4bcec6(0xb8a)],Game_BattlerBase[_0x4bcec6(0x38e)][_0x4bcec6(0xb8a)]=function(_0x3b594a){const _0x156d44=_0x4bcec6,_0x210b27=this[_0x156d44(0x694)](),_0x3bd47e=this['stateMotionIndex']();VisuMZ[_0x156d44(0x377)]['Game_BattlerBase_addNewState'][_0x156d44(0x20f)](this,_0x3b594a),this[_0x156d44(0x52e)]()&&_0x210b27&&this[_0x156d44(0x4a5)]()&&(this[_0x156d44(0xafc)]=!this['hasBeenDefeatedBefore'](),$gameSystem[_0x156d44(0x4d7)](this['enemyId']())),SceneManager[_0x156d44(0x772)]()&&_0x3bd47e!==this[_0x156d44(0x976)]()&&(this[_0x156d44(0x171)]()&&this[_0x156d44(0x171)]()[_0x156d44(0xac9)]());},Game_Enemy['prototype'][_0x4bcec6(0xb4e)]=function(){const _0x195f9a=_0x4bcec6;return $gameSystem[_0x195f9a(0x43d)]()[_0x195f9a(0x5e4)](this[_0x195f9a(0xbfb)]);},VisuMZ[_0x4bcec6(0x377)]['Game_BattlerBase_eraseState']=Game_BattlerBase[_0x4bcec6(0x38e)][_0x4bcec6(0x37e)],Game_BattlerBase['prototype']['eraseState']=function(_0x1a5ac3){const _0x357617=_0x4bcec6;VisuMZ['BattleCore'][_0x357617(0x7ce)][_0x357617(0x20f)](this,_0x1a5ac3),this[_0x357617(0x52e)]()&&_0x1a5ac3===this[_0x357617(0x9ee)]()&&this[_0x357617(0x694)]()&&(this[_0x357617(0xafc)]=![]),!this[_0x357617(0x2f7)]&&!this['_tempBattler']&&SceneManager[_0x357617(0x772)]()&&this[_0x357617(0xace)]();},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x46a)]=Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x885)],Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x885)]=function(){const _0x23c7e8=_0x4bcec6;VisuMZ[_0x23c7e8(0x377)][_0x23c7e8(0x46a)][_0x23c7e8(0x20f)](this),this[_0x23c7e8(0xad1)]={'arPenRate':0x0,'arPenFlat':0x0,'arRedRate':0x0,'arRedFlat':0x0},this[_0x23c7e8(0x4a6)]={'criticalHitRate':0x1,'criticalHitFlat':0x0,'criticalDmgRate':0x1,'criticalDmgFlat':0x0,'damageRate':0x1,'damageFlat':0x0,'hitRate':0x1,'hitFlat':0x0},this[_0x23c7e8(0xad8)]=_0x23c7e8(0x395),this['clearTargetBattlerKey']();},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x91c)]=function(){const _0x44180a=_0x4bcec6;this[_0x44180a(0x5f4)]='';},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x529)]=Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x4ae)],Game_Action[_0x4bcec6(0x38e)]['setSubject']=function(_0x4c7b93){const _0x530a2b=_0x4bcec6;VisuMZ[_0x530a2b(0x377)]['Game_Action_setSubject'][_0x530a2b(0x20f)](this,_0x4c7b93),this[_0x530a2b(0x91c)]();},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x4c3)]=Game_Action['prototype'][_0x4bcec6(0x7af)],Game_Action['prototype'][_0x4bcec6(0x7af)]=function(_0x1dfec0){const _0x2439d0=_0x4bcec6;VisuMZ['BattleCore']['Game_Action_setSkill']['call'](this,_0x1dfec0),this[_0x2439d0(0x91c)]();},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x7f1)]=Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x1e3)],Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x1e3)]=function(_0x4b324a){const _0x23d17a=_0x4bcec6;VisuMZ[_0x23d17a(0x377)]['Game_Action_setItem'][_0x23d17a(0x20f)](this,_0x4b324a),this[_0x23d17a(0x91c)]();},Game_Action['prototype'][_0x4bcec6(0x891)]=function(_0x5d1ec8,_0x692184){const _0x155ed8=_0x4bcec6;return VisuMZ[_0x155ed8(0x377)][_0x155ed8(0x187)]['Damage'][_0x155ed8(0x25e)][_0x155ed8(0x20f)](this,_0x5d1ec8,_0x692184);},Game_Action['prototype']['applyVariance']=function(_0x394f68,_0x2ad4e1){const _0x5aca87=_0x4bcec6;return VisuMZ[_0x5aca87(0x377)][_0x5aca87(0x187)][_0x5aca87(0x8ba)][_0x5aca87(0x610)]['call'](this,_0x394f68,_0x2ad4e1);},Game_Action['prototype'][_0x4bcec6(0x763)]=function(_0x53ec83,_0x4fc6f1){const _0x8280d4=_0x4bcec6;return VisuMZ[_0x8280d4(0x377)][_0x8280d4(0x187)][_0x8280d4(0x8ba)][_0x8280d4(0x4d8)][_0x8280d4(0x20f)](this,_0x53ec83,_0x4fc6f1);},VisuMZ['BattleCore'][_0x4bcec6(0x65c)]=Game_Action['prototype'][_0x4bcec6(0x4ab)],Game_Action['prototype'][_0x4bcec6(0x4ab)]=function(_0x77499){const _0x373c37=_0x4bcec6,_0x25bfb5=this[_0x373c37(0x93c)]()[_0x373c37(0x131)];if(_0x25bfb5[_0x373c37(0x820)](/<ALWAYS HIT>/i))return 0x1;else{if(_0x25bfb5['match'](/<ALWAYS HIT RATE: (\d+)([%％])>/i))return Number(RegExp['$1'])/0x64;else{let _0x4bc734=VisuMZ[_0x373c37(0x377)]['Game_Action_itemHit'][_0x373c37(0x20f)](this,_0x77499);return _0x4bc734=this[_0x373c37(0x4a6)][_0x373c37(0x62f)]*_0x4bc734+this[_0x373c37(0x4a6)][_0x373c37(0x835)],$gameParty['inBattle']()&&(_0x4bc734=this[_0x373c37(0x14e)](_0x4bc734,_0x77499)),_0x4bc734;}}},VisuMZ['BattleCore'][_0x4bcec6(0x6e9)]=Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0xaf0)],Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0xaf0)]=function(_0x39c6f5){const _0x5dde15=_0x4bcec6;this[_0x5dde15(0x898)]=!![],VisuMZ[_0x5dde15(0x377)][_0x5dde15(0x6e9)]['call'](this,_0x39c6f5),this[_0x5dde15(0x898)]=undefined;},Game_Action['prototype'][_0x4bcec6(0x570)]=function(_0x1e278b){const _0x251616=_0x4bcec6;window['action']=this,window['a']=this[_0x251616(0x90b)](),window['b']=_0x1e278b,window[_0x251616(0x147)]=this['subject'](),window[_0x251616(0x887)]=_0x1e278b,window[_0x251616(0xa3f)]=this[_0x251616(0x93c)](),window['skill']=this[_0x251616(0x93c)](),window[_0x251616(0x93c)]=this[_0x251616(0x93c)]();},Game_Action['prototype'][_0x4bcec6(0x70a)]=function(_0x431388){const _0x3f1c8d=_0x4bcec6;window[_0x3f1c8d(0x4e9)]=undefined,window['a']=undefined,window['b']=undefined,window[_0x3f1c8d(0x147)]=undefined,window['target']=undefined,window[_0x3f1c8d(0xa3f)]=undefined,window[_0x3f1c8d(0x31a)]=undefined,window[_0x3f1c8d(0x93c)]=undefined;},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x14e)]=function(_0x5d7cd9,_0x3d6889){const _0x5a4637=_0x4bcec6;if(this[_0x5a4637(0x898)])return _0x5d7cd9;this['declareGlobalVariables'](_0x3d6889);if(this[_0x5a4637(0x93c)]()){let _0x93ab82=VisuMZ['BattleCore'][_0x5a4637(0x689)](this[_0x5a4637(0x93c)](),'jsAccuracy');VisuMZ['BattleCore']['JS'][_0x93ab82]&&(_0x5d7cd9=VisuMZ[_0x5a4637(0x377)]['JS'][_0x93ab82][_0x5a4637(0x20f)](this,this[_0x5a4637(0x90b)](),_0x3d6889,this['item'](),_0x5d7cd9));}for(const _0x5b5f88 of this['subject']()[_0x5a4637(0x589)]()){if(!_0x5b5f88)continue;key=VisuMZ[_0x5a4637(0x377)]['createKeyJS'](_0x5b5f88,_0x5a4637(0xa60)),VisuMZ[_0x5a4637(0x377)]['JS'][key]&&(_0x5d7cd9=VisuMZ[_0x5a4637(0x377)]['JS'][key][_0x5a4637(0x20f)](this,this[_0x5a4637(0x90b)](),_0x3d6889,this['item'](),_0x5d7cd9));}for(const _0x521a63 of _0x3d6889[_0x5a4637(0x589)]()){if(!_0x521a63)continue;key=VisuMZ[_0x5a4637(0x377)][_0x5a4637(0x689)](_0x521a63,_0x5a4637(0x896)),VisuMZ['BattleCore']['JS'][key]&&(_0x5d7cd9=VisuMZ[_0x5a4637(0x377)]['JS'][key][_0x5a4637(0x20f)](this,this[_0x5a4637(0x90b)](),_0x3d6889,this[_0x5a4637(0x93c)](),_0x5d7cd9));}return this[_0x5a4637(0x70a)](_0x3d6889),_0x5d7cd9;},Game_Action['prototype'][_0x4bcec6(0xb0f)]=function(_0x828359){const _0x2f6ee8=_0x4bcec6;if(!this[_0x2f6ee8(0x93c)]()[_0x2f6ee8(0x714)]['critical'])return 0x0;let _0x4a5397=VisuMZ[_0x2f6ee8(0x377)]['Settings']['Damage'][_0x2f6ee8(0x7e9)][_0x2f6ee8(0x20f)](this,_0x828359);return _0x4a5397=this[_0x2f6ee8(0x4a6)]['criticalHitRate']*_0x4a5397+this[_0x2f6ee8(0x4a6)][_0x2f6ee8(0x58c)],$gameParty[_0x2f6ee8(0x7d0)]()&&(_0x4a5397=this[_0x2f6ee8(0x302)](_0x4a5397,_0x828359)),_0x4a5397;},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x302)]=function(_0x45936c,_0x4dd7ec){const _0x3b8f28=_0x4bcec6;this[_0x3b8f28(0x570)](_0x4dd7ec),window[_0x3b8f28(0x9eb)]=_0x45936c;{const _0x1bd3bb=this[_0x3b8f28(0x90b)]()['traitObjects']();for(const _0x3ba122 of _0x1bd3bb){if(!_0x3ba122)continue;if(_0x3ba122['note'][_0x3b8f28(0x820)](/<JS (?:CRITICAL RATE|CRI) AS USER>\s*([\s\S]*?)\s*<\/JS (?:CRITICAL RATE|CRI) AS USER>/i)){const _0x39edbc=String(RegExp['$1']);try{eval(_0x39edbc);}catch(_0x2eef84){if($gameTemp['isPlaytest']())console['log'](_0x2eef84);}}}}{const _0x1f1dc0=_0x4dd7ec[_0x3b8f28(0x589)]();for(const _0x90c99f of _0x1f1dc0){if(!_0x90c99f)continue;if(_0x90c99f[_0x3b8f28(0x131)][_0x3b8f28(0x820)](/<JS (?:CRITICAL RATE|CRI) AS TARGET>\s*([\s\S]*?)\s*<\/JS (?:CRITICAL RATE|CRI) AS TARGET>/i)){const _0x13806b=String(RegExp['$1']);try{eval(_0x13806b);}catch(_0x4da17e){if($gameTemp[_0x3b8f28(0x345)]())console[_0x3b8f28(0xc07)](_0x4da17e);}}}}return _0x45936c=window['rate'],this[_0x3b8f28(0x70a)](_0x4dd7ec),_0x45936c;},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x302)]=function(_0x2987ab,_0x45c9b2){const _0x454175=_0x4bcec6;this[_0x454175(0x570)](_0x45c9b2);for(const _0x14096b of this['subject']()[_0x454175(0x589)]()){if(!_0x14096b)continue;key=VisuMZ[_0x454175(0x377)][_0x454175(0x689)](_0x14096b,_0x454175(0x3c9)),VisuMZ[_0x454175(0x377)]['JS'][key]&&(_0x2987ab=VisuMZ['BattleCore']['JS'][key][_0x454175(0x20f)](this,this[_0x454175(0x90b)](),_0x45c9b2,this[_0x454175(0x93c)](),_0x2987ab));}for(const _0x3c7387 of _0x45c9b2[_0x454175(0x589)]()){if(!_0x3c7387)continue;key=VisuMZ[_0x454175(0x377)][_0x454175(0x689)](_0x3c7387,_0x454175(0x55e)),VisuMZ['BattleCore']['JS'][key]&&(_0x2987ab=VisuMZ['BattleCore']['JS'][key][_0x454175(0x20f)](this,this[_0x454175(0x90b)](),_0x45c9b2,this['item'](),_0x2987ab));}return this['clearGlobalVariables'](_0x45c9b2),_0x2987ab;},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x2da)]=function(_0x38523b){const _0x55e18d=_0x4bcec6;return _0x38523b=VisuMZ[_0x55e18d(0x377)]['Settings'][_0x55e18d(0x8ba)][_0x55e18d(0x687)][_0x55e18d(0x20f)](this,_0x38523b),_0x38523b=this[_0x55e18d(0x4a6)][_0x55e18d(0x29d)]*_0x38523b+this[_0x55e18d(0x4a6)][_0x55e18d(0x33e)],_0x38523b;},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x7b3)]=Game_Action['prototype'][_0x4bcec6(0xbec)],Game_Action['prototype'][_0x4bcec6(0xbec)]=function(_0x32f121){const _0x597e95=_0x4bcec6;if(this[_0x597e95(0xad8)]!=='default')return this[_0x597e95(0x5ff)](_0x32f121);else return DataManager[_0x597e95(0x5b6)](this[_0x597e95(0x93c)]())===_0x597e95(0x6bc)?VisuMZ[_0x597e95(0x377)]['Game_Action_evalDamageFormula'][_0x597e95(0x20f)](this,_0x32f121):this[_0x597e95(0x7a0)](_0x32f121);},Game_Action['prototype'][_0x4bcec6(0xb75)]=function(_0x2201ab){const _0x2c4ced=_0x4bcec6;this[_0x2c4ced(0xad8)]=_0x2201ab;},Game_Action['prototype']['customDamageFormula']=function(_0x5dbc70){const _0x348943=_0x4bcec6,_0x2db82e=this[_0x348943(0x93c)](),_0x3132de=_0x2db82e[_0x348943(0x714)][_0x348943(0x94d)];_0x2db82e[_0x348943(0x714)][_0x348943(0x94d)]=this[_0x348943(0xad8)];let _0x174789=VisuMZ['BattleCore'][_0x348943(0x7b3)]['call'](this,_0x5dbc70);return _0x2db82e['damage'][_0x348943(0x94d)]=_0x3132de,_0x174789;},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x190)]=function(){const _0x79eb8e=_0x4bcec6;if(this[_0x79eb8e(0x93c)]()[_0x79eb8e(0x131)][_0x79eb8e(0x820)](/<DAMAGE STYLE:[ ](.*)>/i)){const _0x57e42c=String(RegExp['$1'])[_0x79eb8e(0x1fd)]()[_0x79eb8e(0x7d5)]();return _0x57e42c;}return'MANUAL';},Game_Action[_0x4bcec6(0x38e)]['evalDamageFormulaBattleCore']=function(_0x3c3748){const _0x3e3daf=_0x4bcec6,_0x9f95a1=DataManager[_0x3e3daf(0x5b6)](this[_0x3e3daf(0x93c)]()),_0x3e368e=VisuMZ['DamageStyles'][_0x9f95a1];try{return _0x3e368e[_0x3e3daf(0x7bb)][_0x3e3daf(0x20f)](this,_0x3c3748);}catch(_0x4d7f07){if($gameTemp[_0x3e3daf(0x345)]())console[_0x3e3daf(0xc07)](_0x4d7f07);return VisuMZ['BattleCore'][_0x3e3daf(0x7b3)][_0x3e3daf(0x20f)](this);}},Game_Action[_0x4bcec6(0x38e)]['applyArmorModifiers']=function(_0x20909c,_0x3a5432){const _0x451468=_0x4bcec6;if(this[_0x451468(0x532)]())return _0x3a5432;const _0x2f8c87=this[_0x451468(0x90b)](),_0x5b5b5f=_0x20909c;let _0x474897=[],_0x1cd379=[];_0x474897[_0x451468(0x27a)](this[_0x451468(0xad1)][_0x451468(0x71e)],this['_armorPenetration'][_0x451468(0x40c)]),_0x1cd379[_0x451468(0x27a)](this[_0x451468(0xad1)][_0x451468(0x1ff)],this[_0x451468(0xad1)][_0x451468(0x789)]);const _0x46052e=this[_0x451468(0x7a7)]()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)>/i,_0x136688=this['isPhysical']()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)([%％])>/i,_0x173c1c=this[_0x451468(0x7a7)]()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)>/i,_0x10030d=this['isPhysical']()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)([%％])>/i;return _0x474897=_0x474897['concat'](_0x5b5b5f['traitObjects']()[_0x451468(0x228)](_0xb7b79e=>_0xb7b79e&&_0xb7b79e[_0x451468(0x131)][_0x451468(0x820)](_0x46052e)?Number(RegExp['$1']):0x0)),_0x1cd379=_0x1cd379['concat'](_0x5b5b5f['traitObjects']()[_0x451468(0x228)](_0x2423ad=>_0x2423ad&&_0x2423ad[_0x451468(0x131)][_0x451468(0x820)](_0x136688)?Number(RegExp['$1'])/0x64:0x0)),_0x474897=_0x474897[_0x451468(0x5cb)](_0x2f8c87[_0x451468(0x589)]()[_0x451468(0x228)](_0x51079b=>_0x51079b&&_0x51079b[_0x451468(0x131)][_0x451468(0x820)](_0x173c1c)?Number(RegExp['$1']):0x0)),_0x1cd379=_0x1cd379[_0x451468(0x5cb)](_0x2f8c87[_0x451468(0x589)]()[_0x451468(0x228)](_0x3c0132=>_0x3c0132&&_0x3c0132[_0x451468(0x131)][_0x451468(0x820)](_0x10030d)?Number(RegExp['$1'])/0x64:0x0)),this[_0x451468(0x93c)]()[_0x451468(0x131)][_0x451468(0x820)](_0x173c1c)&&_0x474897[_0x451468(0x27a)](Number(RegExp['$1'])),this[_0x451468(0x93c)]()[_0x451468(0x131)][_0x451468(0x820)](_0x10030d)&&_0x1cd379[_0x451468(0x27a)](Number(RegExp['$1'])),_0x3a5432=_0x474897[_0x451468(0x3aa)]((_0x35edb5,_0x36241a)=>_0x35edb5-_0x36241a,_0x3a5432),_0x3a5432>0x0&&(_0x3a5432=_0x1cd379[_0x451468(0x3aa)]((_0x4237b9,_0x484055)=>_0x4237b9*(0x1-_0x484055),_0x3a5432)),_0x3a5432;},VisuMZ[_0x4bcec6(0x377)]['Game_Action_executeDamage']=Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0xb18)],Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0xb18)]=function(_0xe83a32,_0x16c1bc){const _0x18f9cf=_0x4bcec6;_0x16c1bc=_0x16c1bc*this['_multipliers']['damageRate'],_0x16c1bc+=this[_0x18f9cf(0x4a6)][_0x18f9cf(0x530)]*(_0x16c1bc>=0x0?0x1:-0x1),_0x16c1bc=this[_0x18f9cf(0x4b4)]('PreDamage%1JS',_0xe83a32,_0x16c1bc,![]),_0x16c1bc=this[_0x18f9cf(0xa1d)](_0x16c1bc),_0x16c1bc>0x0?_0x16c1bc=Math[_0x18f9cf(0x4c5)](_0x16c1bc):_0x16c1bc=Math[_0x18f9cf(0xbc2)](_0x16c1bc),this[_0x18f9cf(0xad0)]=_0x16c1bc,this[_0x18f9cf(0x4a0)]=this['_totalValue']||0x0,this[_0x18f9cf(0x4a0)]+=_0x16c1bc,VisuMZ[_0x18f9cf(0x377)]['Game_Action_executeDamage']['call'](this,_0xe83a32,_0x16c1bc),this['applyBattleCoreJS'](_0x18f9cf(0x6be),_0xe83a32,_0x16c1bc,!![]);},Game_Action[_0x4bcec6(0x38e)]['applyDamageCaps']=function(_0x2cd2fb){const _0xad85ac=_0x4bcec6;if(this[_0xad85ac(0x5a6)]())return _0x2cd2fb;return _0x2cd2fb=this[_0xad85ac(0xbda)](_0x2cd2fb),_0x2cd2fb=this[_0xad85ac(0x2c9)](_0x2cd2fb),_0x2cd2fb;},Game_Action['prototype'][_0x4bcec6(0x5a6)]=function(){const _0x2eae3f=_0x4bcec6,_0x359282=/<BYPASS DAMAGE CAP>/i;if(this[_0x2eae3f(0x93c)]()[_0x2eae3f(0x131)][_0x2eae3f(0x820)](_0x359282))return!![];if(this['subject']()['traitObjects']()[_0x2eae3f(0x3ed)](_0x3337f0=>_0x3337f0&&_0x3337f0['note']['match'](_0x359282)))return!![];return!VisuMZ[_0x2eae3f(0x377)]['Settings'][_0x2eae3f(0x8ba)][_0x2eae3f(0x63c)];},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0xbda)]=function(_0x3f0b3c){const _0x248581=_0x4bcec6;if(!VisuMZ[_0x248581(0x377)][_0x248581(0x187)][_0x248581(0x8ba)][_0x248581(0x411)])return _0x3f0b3c;const _0x1fc3ec=/<BYPASS SOFT DAMAGE CAP>/i;if(this['item']()[_0x248581(0x131)]['match'](_0x1fc3ec))return _0x3f0b3c;if(this[_0x248581(0x90b)]()[_0x248581(0x589)]()[_0x248581(0x3ed)](_0x166258=>_0x166258&&_0x166258['note']['match'](_0x1fc3ec)))return _0x3f0b3c;const _0x300e58=_0x3f0b3c<0x0?-0x1:0x1;_0x3f0b3c=Math[_0x248581(0x291)](_0x3f0b3c);let _0x225059=this[_0x248581(0x90b)]()[_0x248581(0x9de)]();this[_0x248581(0x93c)]()['note'][_0x248581(0x820)](/<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i)&&(_0x225059+=Number(RegExp['$1'])/0x64);_0x225059=_0x225059[_0x248581(0x775)](0.01,0x1);const _0x33bf3e=this[_0x248581(0x33a)](),_0x15262d=_0x225059*_0x33bf3e;if(_0x3f0b3c>_0x15262d&&_0x33bf3e>_0x15262d){_0x3f0b3c-=_0x15262d;const _0x309875=VisuMZ[_0x248581(0x377)][_0x248581(0x187)]['Damage'][_0x248581(0x30b)],_0x5f083e=Math[_0x248581(0x4d5)](0x1-_0x3f0b3c/((_0x33bf3e-_0x15262d)*_0x309875+_0x3f0b3c),0.01);_0x3f0b3c*=_0x5f083e,_0x3f0b3c+=_0x15262d;}return _0x3f0b3c*_0x300e58;},Game_Action[_0x4bcec6(0x38e)]['getHardDamageCap']=function(){const _0x2959fd=_0x4bcec6;return this[_0x2959fd(0x93c)]()[_0x2959fd(0x131)]['match'](/<DAMAGE CAP:[ ](\d+)>/i)?Number(RegExp['$1']):this[_0x2959fd(0x90b)]()['hardDamageCap']();},Game_Action['prototype'][_0x4bcec6(0x2c9)]=function(_0x155274){const _0x5422bb=_0x4bcec6;let _0x5c6981=this[_0x5422bb(0x33a)]();return _0x155274[_0x5422bb(0x775)](-_0x5c6981,_0x5c6981);},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x5aa)]=function(){const _0x3de522=_0x4bcec6;if(!this[_0x3de522(0x93c)]())return![];if(!$gameParty[_0x3de522(0x7d0)]())return![];return(this['item']()[_0x3de522(0x131)]||'')['match'](/<DISPERSE DAMAGE>/i);},Game_Action['prototype'][_0x4bcec6(0x6ef)]=function(_0x5eedde){const _0x2e7d12=_0x4bcec6;if(this[_0x2e7d12(0x5aa)]()){let _0x24830d=BattleManager[_0x2e7d12(0x635)];_0x5eedde/=_0x24830d['length'],this[_0x2e7d12(0x1e7)]()&&(_0x5eedde*=this[_0x2e7d12(0x90b)]()[_0x2e7d12(0x108)]()+0x1),_0x5eedde=_0x5eedde>0x0?Math[_0x2e7d12(0x4c5)](_0x5eedde):Math[_0x2e7d12(0xbc2)](_0x5eedde);}return _0x5eedde;},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x220)]=Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x891)],Game_Action['prototype']['makeDamageValue']=function(_0x28c763,_0x5c8b77){const _0x38cd9f=_0x4bcec6;let _0x5a3b80=VisuMZ[_0x38cd9f(0x377)]['Game_Action_makeDamageValueDisperse'][_0x38cd9f(0x20f)](this,_0x28c763,_0x5c8b77);return this[_0x38cd9f(0x6ef)](_0x5a3b80);},Game_Action[_0x4bcec6(0x38e)]['itemEffectRecoverHp']=function(_0x1b11aa,_0x339165){const _0x28d5aa=_0x4bcec6;let _0x19c83e=(_0x1b11aa[_0x28d5aa(0xae6)]*_0x339165[_0x28d5aa(0x65d)]+_0x339165[_0x28d5aa(0xb2d)])*_0x1b11aa['rec'];_0x19c83e=this[_0x28d5aa(0x6ef)](_0x19c83e),this[_0x28d5aa(0x288)]()&&(_0x19c83e*=this['subject']()[_0x28d5aa(0xa2a)]),_0x19c83e=Math[_0x28d5aa(0xbc2)](_0x19c83e),_0x19c83e!==0x0&&(_0x1b11aa['gainHp'](_0x19c83e),this[_0x28d5aa(0x1cc)](_0x1b11aa));},Game_Action[_0x4bcec6(0x38e)]['itemEffectRecoverMp']=function(_0x5b0023,_0x1a75bd){const _0x2253ee=_0x4bcec6;let _0x150e70=(_0x5b0023[_0x2253ee(0x6a3)]*_0x1a75bd['value1']+_0x1a75bd[_0x2253ee(0xb2d)])*_0x5b0023[_0x2253ee(0x955)];_0x150e70=this[_0x2253ee(0x6ef)](_0x150e70),this[_0x2253ee(0x288)]()&&(_0x150e70*=this[_0x2253ee(0x90b)]()[_0x2253ee(0xa2a)]),_0x150e70=Math[_0x2253ee(0xbc2)](_0x150e70),_0x150e70!==0x0&&(_0x5b0023[_0x2253ee(0x4ac)](_0x150e70),this[_0x2253ee(0x1cc)](_0x5b0023));},Game_Action['prototype']['itemEffectGainTp']=function(_0x3f091b,_0x1fa224){const _0x474bea=_0x4bcec6;let _0x482137=Math[_0x474bea(0xbc2)](_0x1fa224[_0x474bea(0x65d)]);_0x482137=this[_0x474bea(0x6ef)](_0x482137),_0x482137!==0x0&&(_0x3f091b[_0x474bea(0x707)](_0x482137),this[_0x474bea(0x1cc)](_0x3f091b));},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x37b)]=Game_Action['prototype']['apply'],Game_Action[_0x4bcec6(0x38e)]['apply']=function(_0x1a9274){const _0xd66690=_0x4bcec6;if(_0x1a9274&&_0x1a9274[_0xd66690(0x52e)]())_0x1a9274[_0xd66690(0xb92)]();this[_0xd66690(0x4b4)](_0xd66690(0x829),_0x1a9274,0x0,!![]),VisuMZ[_0xd66690(0x377)][_0xd66690(0x37b)][_0xd66690(0x20f)](this,_0x1a9274),this[_0xd66690(0x4b4)](_0xd66690(0x146),_0x1a9274,this[_0xd66690(0xad0)]||0x0,!![]),this[_0xd66690(0x118)](_0x1a9274);},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x4b4)]=function(_0x5d2137,_0x208ba3,_0xc156fc,_0xde261a){const _0x274085=_0x4bcec6;if(this[_0x274085(0x568)]||this[_0x274085(0x2f7)])return;_0xc156fc=_0xc156fc||0x0;const _0x556951=_0xc156fc,_0x5b1a19=VisuMZ[_0x274085(0x377)]['Settings'][_0x274085(0xbbe)],_0x1729cd=_0x5d2137[_0x274085(0xb12)]('');if(_0x5b1a19[_0x1729cd]){_0xc156fc=_0x5b1a19[_0x1729cd][_0x274085(0x20f)](this,_0xc156fc,_0x208ba3);if(_0xde261a)_0xc156fc=_0x556951;}let _0xe05b2d=VisuMZ[_0x274085(0x377)][_0x274085(0x689)](this[_0x274085(0x93c)](),_0x5d2137[_0x274085(0xb12)](''));if(VisuMZ['BattleCore']['JS'][_0xe05b2d]){_0xc156fc=VisuMZ[_0x274085(0x377)]['JS'][_0xe05b2d]['call'](this,this[_0x274085(0x90b)](),_0x208ba3,this[_0x274085(0x93c)](),_0xc156fc);if(_0xde261a)_0xc156fc=_0x556951;}for(const _0x10a9ac of this['subject']()[_0x274085(0x589)]()){if(!_0x10a9ac)continue;_0xe05b2d=VisuMZ[_0x274085(0x377)]['createKeyJS'](_0x10a9ac,_0x5d2137[_0x274085(0xb12)](_0x274085(0x7e8)));if(VisuMZ[_0x274085(0x377)]['JS'][_0xe05b2d]){_0xc156fc=VisuMZ['BattleCore']['JS'][_0xe05b2d][_0x274085(0x20f)](this,this['subject'](),_0x208ba3,_0x10a9ac,_0xc156fc);if(_0xde261a)_0xc156fc=_0x556951;}}for(const _0x524bae of _0x208ba3[_0x274085(0x589)]()){if(!_0x524bae)continue;_0xe05b2d=VisuMZ[_0x274085(0x377)][_0x274085(0x689)](_0x524bae,_0x5d2137[_0x274085(0xb12)](_0x274085(0x8ab)));if(VisuMZ['BattleCore']['JS'][_0xe05b2d]){_0xc156fc=VisuMZ[_0x274085(0x377)]['JS'][_0xe05b2d]['call'](this,this[_0x274085(0x90b)](),_0x208ba3,_0x524bae,_0xc156fc);if(_0xde261a)_0xc156fc=_0x556951;}}return _0xc156fc;},Game_Action['prototype'][_0x4bcec6(0x700)]=function(_0x33eb11){const _0x1b106b=_0x4bcec6,_0x501818=this[_0x1b106b(0x4a0)]||0x0,_0x8d122=VisuMZ[_0x1b106b(0x377)][_0x1b106b(0x187)][_0x1b106b(0xbbe)],_0x26c7e5=_0x33eb11[_0x1b106b(0xb12)]('');_0x8d122[_0x26c7e5]&&_0x8d122[_0x26c7e5]['call'](this,_0x501818);let _0x397007=VisuMZ[_0x1b106b(0x377)][_0x1b106b(0x689)](this[_0x1b106b(0x93c)](),_0x33eb11);VisuMZ[_0x1b106b(0x377)]['JS'][_0x397007]&&VisuMZ[_0x1b106b(0x377)]['JS'][_0x397007][_0x1b106b(0x20f)](this,this[_0x1b106b(0x90b)](),this['subject'](),this[_0x1b106b(0x93c)](),_0x501818);for(const _0x1aa8fc of this['subject']()[_0x1b106b(0x589)]()){if(!_0x1aa8fc)continue;_0x397007=VisuMZ['BattleCore'][_0x1b106b(0x689)](_0x1aa8fc,_0x33eb11),VisuMZ['BattleCore']['JS'][_0x397007]&&VisuMZ[_0x1b106b(0x377)]['JS'][_0x397007][_0x1b106b(0x20f)](this,this[_0x1b106b(0x90b)](),this['subject'](),_0x1aa8fc,_0x501818);}},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0xab6)]=function(){const _0x35033d=_0x4bcec6;return VisuMZ[_0x35033d(0x377)]['Settings'][_0x35033d(0xbbe)]['CalcActionSpeedJS'][_0x35033d(0x20f)](this);},Game_Action['prototype'][_0x4bcec6(0x25b)]=function(){const _0x549d41=_0x4bcec6;return VisuMZ[_0x549d41(0x377)]['Settings'][_0x549d41(0xbbe)][_0x549d41(0xb7b)];},Game_Action['prototype'][_0x4bcec6(0x24b)]=function(){const _0x330fd6=_0x4bcec6;if(this[_0x330fd6(0x5f4)]===_0x330fd6(0x2b1))return![];if(this[_0x330fd6(0x5f4)]===_0x330fd6(0x261))return![];if(!this[_0x330fd6(0x93c)]())return![];return this['item']()[_0x330fd6(0x131)]['match'](/<JS TARGETS>/i);},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x82d)]=function(){const _0x201caa=_0x4bcec6;if(this[_0x201caa(0x5f4)]==='all\x20actors')return![];if(this['_targetBattlerKey']===_0x201caa(0x261))return![];if(!this[_0x201caa(0x75b)]&&this[_0x201caa(0x90b)]()['isConfused']())return![];if(this[_0x201caa(0x24b)]())return!![];if(!this[_0x201caa(0x93c)]())return![];return typeof this[_0x201caa(0x93c)]()[_0x201caa(0x717)]==='string';},VisuMZ[_0x4bcec6(0x377)]['Game_Action_isForOpponent']=Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x61a)],Game_Action[_0x4bcec6(0x38e)]['isForOpponent']=function(){const _0x563f44=_0x4bcec6;if(this[_0x563f44(0x5f4)]===_0x563f44(0x2b1))return![];if(this[_0x563f44(0x5f4)]===_0x563f44(0x261))return!![];return this['isBattleCoreTargetScope']()&&!this['isCustomBattleScope']()?this['isForOpponentBattleCore']():VisuMZ[_0x563f44(0x377)][_0x563f44(0x224)][_0x563f44(0x20f)](this);},Game_Action['prototype']['isForOpponentBattleCore']=function(){const _0x112c27=_0x4bcec6,_0x144aee=String(this['item']()[_0x112c27(0x717)]);if(_0x144aee[_0x112c27(0x820)](/ANY/i))return!![];return _0x144aee[_0x112c27(0x820)](/(?:ENEMY|ENEMIES|FOE|FOES)/i);},VisuMZ[_0x4bcec6(0x377)]['Game_Action_isForFriend']=Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0xb79)],Game_Action['prototype'][_0x4bcec6(0xb79)]=function(){const _0x1153b3=_0x4bcec6;if(this[_0x1153b3(0x5f4)]===_0x1153b3(0x2b1))return!![];if(this['_targetBattlerKey']===_0x1153b3(0x261))return![];return this[_0x1153b3(0x82d)]()&&!this[_0x1153b3(0x24b)]()?this[_0x1153b3(0xb98)]():VisuMZ[_0x1153b3(0x377)][_0x1153b3(0x23f)][_0x1153b3(0x20f)](this);},Game_Action[_0x4bcec6(0x38e)]['isForFriendBattleCore']=function(){const _0x3817c4=_0x4bcec6,_0xda2cc6=String(this[_0x3817c4(0x93c)]()[_0x3817c4(0x717)]);return _0xda2cc6[_0x3817c4(0x820)](/(?:ALLY|ALLIES|FRIEND|FRIENDS)/i);},Game_Action['prototype'][_0x4bcec6(0x667)]=function(){const _0x476843=_0x4bcec6;if(this['isBattleCoreTargetScope']()&&!this['isCustomBattleScope']()){const _0x1b7de5=String(this['item']()['scope']);return _0x1b7de5[_0x476843(0x820)](/(?:ENEMY|FOE)/i)&&_0x1b7de5[_0x476843(0x820)](/OR/i)&&_0x1b7de5[_0x476843(0x820)](/(?:ALLY|FRIEND)/i);}else return![];},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0xa54)]=function(){const _0x4f87b8=_0x4bcec6;if(this[_0x4f87b8(0x667)]()){const _0x4421ce=String(this[_0x4f87b8(0x93c)]()[_0x4f87b8(0x717)]);if(_0x4421ce['match'](/(?:ALLY|FRIEND) OR (?:ENEMY|FOE)/i))return!![];}return![];},Game_Action['prototype'][_0x4bcec6(0xb71)]=function(){const _0x399a31=_0x4bcec6;if(this[_0x399a31(0x667)]()){const _0x46d8a1=String(this['item']()[_0x399a31(0x717)]);if(_0x46d8a1['match'](/(?:ENEMY|FOE) OR (?:ALLY|FRIEND)/i))return!![];}return![];},VisuMZ[_0x4bcec6(0x377)]['Game_Action_isForAliveFriend']=Game_Action['prototype'][_0x4bcec6(0x51f)],Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x51f)]=function(){const _0x3f9cf2=_0x4bcec6;if(this[_0x3f9cf2(0x5f4)]==='all\x20actors')return!![];return this[_0x3f9cf2(0x82d)]()&&!this[_0x3f9cf2(0x24b)]()?this[_0x3f9cf2(0x241)]():VisuMZ['BattleCore'][_0x3f9cf2(0x495)][_0x3f9cf2(0x20f)](this);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0xa75)]=Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x2f3)],Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x2f3)]=function(){const _0x2f6ee4=_0x4bcec6;if(this['_targetBattlerKey']===_0x2f6ee4(0x2b1))return VisuMZ[_0x2f6ee4(0x377)]['Game_Action_isForDeadFriend'][_0x2f6ee4(0x20f)](this);return VisuMZ['BattleCore']['Game_Action_isForDeadFriend']['call'](this);},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x241)]=function(){if(this['isForAnyone']())return!![];return![];},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x900)]=function(){const _0x43f245=_0x4bcec6;return this[_0x43f245(0x93c)]()&&this[_0x43f245(0x93c)]()[_0x43f245(0x131)][_0x43f245(0x820)](/<CANNOT TARGET (?:USER|SELF)>/i);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x3ac)]=Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x428)],Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x428)]=function(){const _0x3d77da=_0x4bcec6;if(this[_0x3d77da(0x5f4)]===_0x3d77da(0x2b1))return![];if(this['_targetBattlerKey']==='all\x20enemies')return![];return this[_0x3d77da(0x82d)]()&&!this[_0x3d77da(0x24b)]()?this[_0x3d77da(0x35f)]():VisuMZ[_0x3d77da(0x377)][_0x3d77da(0x3ac)][_0x3d77da(0x20f)](this);},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x35f)]=function(){const _0x4d2f6b=_0x4bcec6;if(this[_0x4d2f6b(0x667)]())return!![];return![];},VisuMZ['BattleCore']['Game_Action_isForRandom']=Game_Action['prototype'][_0x4bcec6(0x69b)],Game_Action['prototype'][_0x4bcec6(0x69b)]=function(){const _0x211db2=_0x4bcec6;if(this['_targetBattlerKey']==='all\x20actors')return![];if(this['_targetBattlerKey']===_0x211db2(0x261))return![];return this[_0x211db2(0x82d)]()&&!this['isCustomBattleScope']()?this[_0x211db2(0xbcb)]():VisuMZ[_0x211db2(0x377)][_0x211db2(0x15e)][_0x211db2(0x20f)](this);},Game_Action[_0x4bcec6(0x38e)]['isForRandomBattleCore']=function(){const _0x2be452=_0x4bcec6,_0x2e139e=String(this['item']()[_0x2be452(0x717)]);return _0x2e139e['match'](/(?:RAND|RANDOM)/i);},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x6c1)]=Game_Action['prototype'][_0x4bcec6(0x278)],Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x278)]=function(){const _0x460131=_0x4bcec6;if(this[_0x460131(0x5f4)]===_0x460131(0x2b1))return!![];if(this[_0x460131(0x5f4)]==='all\x20enemies')return!![];return VisuMZ[_0x460131(0x377)][_0x460131(0x6c1)][_0x460131(0x20f)](this);},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x335)]=function(){const _0x183806=_0x4bcec6;if(!this['item']())return![];if(this[_0x183806(0x2f3)]())return![];return(this[_0x183806(0x93c)]()['note']||'')[_0x183806(0x820)](/<SINGLE OR MULTIPLE SELECT>/i);},VisuMZ['BattleCore'][_0x4bcec6(0x300)]=Game_Action[_0x4bcec6(0x38e)]['testApply'],Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x874)]=function(_0x2cf44d){const _0x39a21b=_0x4bcec6;if(this[_0x39a21b(0x900)]()&&_0x2cf44d===this[_0x39a21b(0x90b)]())return![];return VisuMZ[_0x39a21b(0x377)][_0x39a21b(0x300)][_0x39a21b(0x20f)](this,_0x2cf44d);},VisuMZ[_0x4bcec6(0x377)]['Game_Action_itemTargetCandidates']=Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0xb7f)],Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0xb7f)]=function(){const _0x51de62=_0x4bcec6,_0xe8c134=VisuMZ[_0x51de62(0x377)][_0x51de62(0x58d)][_0x51de62(0x20f)](this);if(this['isForNotUser']())_0xe8c134[_0x51de62(0x8b7)](this[_0x51de62(0x90b)]());return _0xe8c134;},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x1dc)]=Game_Action['prototype'][_0x4bcec6(0x5f3)],Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x5f3)]=function(){const _0x2a7e27=_0x4bcec6;return this[_0x2a7e27(0x82d)]()&&!this[_0x2a7e27(0x24b)]()?this[_0x2a7e27(0xbc0)]():VisuMZ['BattleCore']['Game_Action_needsSelection'][_0x2a7e27(0x20f)](this);},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0xbc0)]=function(){const _0x318c5a=_0x4bcec6,_0x141177=String(this[_0x318c5a(0x93c)]()[_0x318c5a(0x717)]);if(_0x141177[_0x318c5a(0x820)](/RANDOM/i))return![];if(_0x141177[_0x318c5a(0x820)](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS)/i))return![];if(_0x141177[_0x318c5a(0x820)](/ALL (?:ENEMY|ENEMIES|FOE|FOES)/i))return![];if(_0x141177[_0x318c5a(0x820)](/(?:ENEMY|FOE) OR (?:ALLY|FRIEND)/i))return!![];if(_0x141177[_0x318c5a(0x820)](/(?:ALLY|FRIEND) OR (?:ENEMY|FOE)/i))return!![];return VisuMZ[_0x318c5a(0x377)][_0x318c5a(0x1dc)][_0x318c5a(0x20f)](this);},VisuMZ[_0x4bcec6(0x377)]['Game_Action_makeTargets']=Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x542)],Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x542)]=function(){const _0x4a610c=_0x4bcec6;let _0x59cbf2=[];return this[_0x4a610c(0x82d)]()?this[_0x4a610c(0x24b)]()?_0x59cbf2=this[_0x4a610c(0x781)]():_0x59cbf2=this[_0x4a610c(0x290)]():_0x59cbf2=VisuMZ['BattleCore'][_0x4a610c(0x958)][_0x4a610c(0x20f)](this),_0x59cbf2=this[_0x4a610c(0x2d7)](_0x59cbf2),_0x59cbf2;},Game_Action['prototype'][_0x4bcec6(0x7f0)]=function(){const _0x512a4a=_0x4bcec6;return this['subject']()[_0x512a4a(0xbf8)]()&&!this[_0x512a4a(0x90b)]()[_0x512a4a(0x44a)]();},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x781)]=function(){const _0x1c9f4a=_0x4bcec6,_0x3f466b=VisuMZ[_0x1c9f4a(0x377)][_0x1c9f4a(0x689)](this[_0x1c9f4a(0x93c)](),_0x1c9f4a(0x5bc));if(VisuMZ[_0x1c9f4a(0x377)]['JS'][_0x3f466b]){targets=VisuMZ['BattleCore'][_0x1c9f4a(0x958)][_0x1c9f4a(0x20f)](this);const _0x31d536=VisuMZ[_0x1c9f4a(0x377)][_0x1c9f4a(0x689)](this[_0x1c9f4a(0x93c)](),_0x1c9f4a(0x5bc));return targets=VisuMZ[_0x1c9f4a(0x377)]['JS'][_0x31d536]['call'](this,this['subject'](),targets),this['repeatTargets'](targets);}return this[_0x1c9f4a(0x290)]();},Game_Action['prototype'][_0x4bcec6(0x290)]=function(){const _0x477197=_0x4bcec6;let _0x5da9bf=[];const _0x5f58aa=String(this[_0x477197(0x93c)]()['scope']);if(this[_0x477197(0xb71)]())return this[_0x477197(0x7f0)]()?(_0x5da9bf=this[_0x477197(0xbdf)](),this['repeatTargets'](_0x5da9bf)):(this[_0x477197(0x7fd)]=-0x1,_0x5da9bf[_0x477197(0x27a)](...this['targetsForOpponents']()),this['repeatTargets'](_0x5da9bf));if(this[_0x477197(0xa54)]()){if(this[_0x477197(0x7f0)]())return _0x5da9bf=this[_0x477197(0xbdf)](),this[_0x477197(0x6ca)](_0x5da9bf);else{if(Imported[_0x477197(0x43a)]){if(VisuMZ['BattleAI'][_0x477197(0x6e5)]<1.19){let _0x2b9fc0='';_0x2b9fc0+=_0x477197(0x88c),_0x2b9fc0+=_0x477197(0x15d),_0x2b9fc0+=_0x477197(0x92c),alert(_0x2b9fc0),SceneManager[_0x477197(0x410)]();}}return this['_targetIndex']=-0x1,_0x5da9bf[_0x477197(0x27a)](...this[_0x477197(0xb1e)]()),this[_0x477197(0x6ca)](_0x5da9bf);}}if(_0x5f58aa['match'](/(\d+) RANDOM ANY/i)){let _0xc0073e=Number(RegExp['$1']);while(_0xc0073e--){const _0x310acf=Math[_0x477197(0x989)](0x2)===0x0?this[_0x477197(0x43f)]():this[_0x477197(0xbdc)]();_0x5da9bf[_0x477197(0x27a)](_0x310acf['trueRandomTarget']());}return this['repeatTargets'](_0x5da9bf);}if(_0x5f58aa['match'](/(\d+) RANDOM (?:ENEMY|ENEMIES|FOE|FOES)/i)){let _0x1e0f71=Number(RegExp['$1']);while(_0x1e0f71--){_0x5da9bf[_0x477197(0x27a)](this[_0x477197(0x43f)]()[_0x477197(0x156)]());}return this[_0x477197(0x6ca)](_0x5da9bf);}if(_0x5f58aa[_0x477197(0x820)](/(\d+) RANDOM (?:ALLY|ALLIES|FRIEND|FRIENDS)/i)){let _0x14ef09=Number(RegExp['$1']);while(_0x14ef09--){_0x5da9bf[_0x477197(0x27a)](this[_0x477197(0xbdc)]()['trueRandomTarget']());}return this[_0x477197(0x6ca)](_0x5da9bf);}if(_0x5f58aa[_0x477197(0x820)](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS) (?:BUT|EXCEPT) (?:USER|SELF)/i))return _0x5da9bf[_0x477197(0x27a)](...this[_0x477197(0xbdc)]()['aliveMembers']()[_0x477197(0x9f4)](_0x16c491=>_0x16c491!==this[_0x477197(0x90b)]())),this['repeatTargets'](_0x5da9bf);return VisuMZ[_0x477197(0x377)][_0x477197(0x958)][_0x477197(0x20f)](this);},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x9b5)]=function(_0x57fd3c){const _0x6903ee=_0x4bcec6,_0x59f56f=[];for(let _0x1015ed=0x0;_0x1015ed<this['numTargets']();_0x1015ed++){_0x59f56f[_0x6903ee(0x27a)](_0x57fd3c['trueRandomTarget']());}return _0x59f56f;},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x2d7)]=function(_0x4aa087){const _0x18f797=_0x4bcec6;if(!this[_0x18f797(0x93c)]())return _0x4aa087;const _0x67510=this[_0x18f797(0x93c)]()['note'];if(this[_0x18f797(0x900)]()){this['isForAll']()&&_0x4aa087[_0x18f797(0x8b7)](this[_0x18f797(0x90b)]());if(_0x4aa087[_0x18f797(0x5e4)](this[_0x18f797(0x90b)]())){const _0x522e60=this[_0x18f797(0xbdc)]()[_0x18f797(0x14b)]()[_0x18f797(0x8b7)](this[_0x18f797(0x90b)]());if(_0x522e60[_0x18f797(0x64b)]>0x0){_0x522e60[_0x18f797(0x3ec)]((_0xe374a,_0x451186)=>_0xe374a[_0x18f797(0x25f)]()-_0x451186[_0x18f797(0x25f)]());while(_0x4aa087[_0x18f797(0x5e4)](this['subject']())){const _0x4eec5d=_0x4aa087[_0x18f797(0x4fd)](this[_0x18f797(0x90b)]());_0x4aa087[_0x4eec5d]=_0x522e60[Math[_0x18f797(0x989)](_0x522e60[_0x18f797(0x64b)])];}}else _0x4aa087[_0x18f797(0x8b7)](this[_0x18f797(0x90b)]());}}return _0x4aa087;},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x53b)]=Game_Action[_0x4bcec6(0x38e)]['itemEffectAddAttackState'],Game_Action[_0x4bcec6(0x38e)]['itemEffectAddAttackState']=function(_0x1ec4e9,_0x31907a){const _0x500778=_0x4bcec6;VisuMZ[_0x500778(0x377)][_0x500778(0x53b)][_0x500778(0x20f)](this,_0x1ec4e9,_0x31907a);if(!_0x1ec4e9[_0x500778(0x483)]())return;for(const _0x4fe606 of this[_0x500778(0x90b)]()[_0x500778(0xbb2)]()){if(_0x4fe606===_0x1ec4e9[_0x500778(0x9ee)]()){let _0x2544d0=_0x31907a[_0x500778(0x65d)];_0x2544d0*=_0x1ec4e9[_0x500778(0x661)](_0x4fe606),_0x2544d0*=this['subject']()[_0x500778(0x5fe)](_0x4fe606),_0x2544d0*=this[_0x500778(0x3a7)](_0x1ec4e9),Math[_0x500778(0x2e2)]()<_0x2544d0&&(_0x1ec4e9['_deathStateApplied']=!![],this[_0x500778(0x1cc)](_0x1ec4e9));}}},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0x29f)]=Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x5e6)],Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x5e6)]=function(_0x36a52a,_0x2af3f6){const _0x2b6272=_0x4bcec6;VisuMZ['BattleCore'][_0x2b6272(0x29f)]['call'](this,_0x36a52a,_0x2af3f6);if(!_0x36a52a[_0x2b6272(0x483)]())return;if(_0x2af3f6['dataId']!==_0x36a52a[_0x2b6272(0x9ee)]())return;let _0x16a99e=_0x2af3f6[_0x2b6272(0x65d)];!this['isCertainHit']()&&(_0x16a99e*=_0x36a52a[_0x2b6272(0x661)](_0x2af3f6['dataId']),_0x16a99e*=this[_0x2b6272(0x3a7)](_0x36a52a)),Math[_0x2b6272(0x2e2)]()<_0x16a99e&&(_0x36a52a[_0x2b6272(0x4bf)]=!![],this[_0x2b6272(0x1cc)](_0x36a52a));},VisuMZ['BattleCore'][_0x4bcec6(0x7b4)]=Game_Action['prototype'][_0x4bcec6(0x97a)],Game_Action[_0x4bcec6(0x38e)]['applyGlobal']=function(){const _0x392ec2=_0x4bcec6;VisuMZ[_0x392ec2(0x377)][_0x392ec2(0x7b4)][_0x392ec2(0x20f)](this),this['applyGlobalCommonEventNotetags'](),this['resetResultSwitches']();},Game_Action['prototype'][_0x4bcec6(0x7c1)]=function(){const _0x125e31=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;const _0x26b863=/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi,_0x4e9ed1=this['item']()[_0x125e31(0x131)][_0x125e31(0x820)](_0x26b863);if(_0x4e9ed1)for(const _0x4a4790 of _0x4e9ed1){if(!_0x4a4790)continue;_0x4a4790[_0x125e31(0x820)](_0x26b863);const _0x186523=String(RegExp['$1'])['split'](',')[_0x125e31(0x228)](_0x548de1=>String(_0x548de1)['trim']()),_0x5036e9=_0x186523[_0x125e31(0x228)](_0x50d14c=>DataManager[_0x125e31(0x1ab)](_0x50d14c));for(const _0x37eee0 of _0x5036e9){const _0x2fa1ec=$dataCommonEvents[_0x37eee0];_0x2fa1ec&&$gameTemp['reserveCommonEvent'](_0x37eee0);}}},DataManager[_0x4bcec6(0x1ab)]=function(_0xf0e6c8){const _0xffb910=_0x4bcec6;_0xf0e6c8=_0xf0e6c8[_0xffb910(0x1fd)]()[_0xffb910(0x7d5)](),this[_0xffb910(0x96b)]=this[_0xffb910(0x96b)]||{};if(this[_0xffb910(0x96b)][_0xf0e6c8])return this[_0xffb910(0x96b)][_0xf0e6c8];for(const _0x11d180 of $dataCommonEvents){if(!_0x11d180)continue;let _0x512bb7=_0x11d180[_0xffb910(0x4fc)];_0x512bb7=_0x512bb7['replace'](/\x1I\[(\d+)\]/gi,''),_0x512bb7=_0x512bb7[_0xffb910(0x560)](/\\I\[(\d+)\]/gi,''),this[_0xffb910(0x96b)][_0x512bb7['toUpperCase']()[_0xffb910(0x7d5)]()]=_0x11d180['id'];}return this[_0xffb910(0x96b)][_0xf0e6c8]||0x0;},Game_Action[_0x4bcec6(0x38e)]['resetResultSwitches']=function(){const _0x2d483b=_0x4bcec6;if(!SceneManager[_0x2d483b(0x772)]())return;const _0x2e20f8=VisuMZ[_0x2d483b(0x377)][_0x2d483b(0x187)][_0x2d483b(0xbbe)];_0x2e20f8[_0x2d483b(0x866)]&&$gameSwitches[_0x2d483b(0x681)](_0x2e20f8[_0x2d483b(0x866)],![]),_0x2e20f8[_0x2d483b(0x48a)]&&$gameSwitches[_0x2d483b(0x681)](_0x2e20f8[_0x2d483b(0x48a)],![]),_0x2e20f8[_0x2d483b(0x1c7)]&&$gameVariables['setValue'](_0x2e20f8['VariableDmg'],0x0),_0x2e20f8['VariableHeal']&&$gameVariables[_0x2d483b(0x681)](_0x2e20f8[_0x2d483b(0x18a)],0x0);},Game_Action['prototype'][_0x4bcec6(0x118)]=function(_0x2700c6){const _0x8a20f=_0x4bcec6;if(!SceneManager['isSceneBattle']())return;if(!_0x2700c6)return;const _0x1559bf=_0x2700c6[_0x8a20f(0xb23)](),_0x24c88c=VisuMZ[_0x8a20f(0x377)][_0x8a20f(0x187)][_0x8a20f(0xbbe)];_0x24c88c['SwitchCritical']&&_0x1559bf[_0x8a20f(0x98a)]&&$gameSwitches[_0x8a20f(0x681)](_0x24c88c[_0x8a20f(0x866)],!![]);_0x24c88c[_0x8a20f(0x48a)]&&(_0x1559bf['missed']||_0x1559bf[_0x8a20f(0xb88)])&&$gameSwitches[_0x8a20f(0x681)](_0x24c88c[_0x8a20f(0x48a)],!![]);if(_0x24c88c[_0x8a20f(0x1c7)]){let _0x3ff6b3=$gameVariables[_0x8a20f(0x6d9)](_0x24c88c[_0x8a20f(0x1c7)]);_0x1559bf['hpDamage']>0x0&&(_0x3ff6b3+=Math[_0x8a20f(0x291)](_0x1559bf['hpDamage'])),$gameVariables['setValue'](_0x24c88c[_0x8a20f(0x1c7)],_0x3ff6b3);}if(_0x24c88c[_0x8a20f(0x18a)]){let _0x1f3fc0=$gameVariables['value'](_0x24c88c[_0x8a20f(0x18a)]);_0x1559bf[_0x8a20f(0x818)]<0x0&&(_0x1f3fc0+=Math['abs'](_0x1559bf[_0x8a20f(0x818)])),$gameVariables[_0x8a20f(0x681)](_0x24c88c['VariableHeal'],_0x1f3fc0);}},VisuMZ[_0x4bcec6(0x377)][_0x4bcec6(0xaec)]={'lifeSteaItem':/<(.*?) (?:LIFE|MANA) STEAL:[ ](\d+)([%％])>/gi,'lifeStealTrait':/<(.*?) (?:LIFE|MANA) STEAL (.*?):[ ]([\+\-]\d+)([%％])>/gi,'cancelLifeSteal':/<CANCEL LIFE STEAL>/i,'cancelHpLifeSteal':/<CANCEL HP LIFE STEAL>/i,'cancelMpLifeSteal':/<CANCEL MP LIFE STEAL>/i,'guardLifeSteal':/<GUARD LIFE STEAL>/i,'guardHpLifeSteal':/<GUARD HP LIFE STEAL>/i,'guardMpLifeSteal':/<GUARD MP LIFE STEAL>/i,'disarmLifeSteal':/<DISARM LIFE STEAL>/i,'disarmHpLifeSteal':/<DISARM HP LIFE STEAL>/i,'disarmMpLifeSteal':/<DISARM MP LIFE STEAL>/i,'negativeLifeSteal':/<REVERSE LIFE STEAL>/i,'negativeHpLifeSteal':/<REVERSE HP LIFE STEAL>/i,'negativeMpLifeSteal':/<REVERSE MP LIFE STEAL>/i},VisuMZ['BattleCore'][_0x4bcec6(0x8d8)]=Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x4e6)],Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x4e6)]=function(_0x10f6c8,_0x285634){const _0x2b5508=_0x4bcec6;VisuMZ[_0x2b5508(0x377)][_0x2b5508(0x8d8)][_0x2b5508(0x20f)](this,_0x10f6c8,_0x285634);!this[_0x2b5508(0x9d2)]()&&_0x10f6c8&&_0x10f6c8[_0x2b5508(0xb23)]()['hpDamage']>0x0&&this['performLifeSteal']('HP',_0x10f6c8,_0x10f6c8[_0x2b5508(0xb23)]()[_0x2b5508(0x818)]);if(_0x10f6c8){this[_0x2b5508(0x2f2)]=this['_executeHpDamage']||{};const _0x5db19b=_0x10f6c8[_0x2b5508(0x2a2)]();this[_0x2b5508(0x2f2)][_0x5db19b]=_0x285634;}},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x3c5)]=function(_0x46b355){const _0xaaef33=_0x4bcec6;this[_0xaaef33(0x2f2)]=this[_0xaaef33(0x2f2)]||{};const _0x59a15a=_0x46b355[_0xaaef33(0x2a2)]();return this[_0xaaef33(0x2f2)][_0x59a15a]||0x0;},VisuMZ[_0x4bcec6(0x377)]['Game_Action_executeMpDamage']=Game_Action[_0x4bcec6(0x38e)]['executeMpDamage'],Game_Action['prototype'][_0x4bcec6(0x422)]=function(_0x371f93,_0x1ac782){const _0x16334e=_0x4bcec6;VisuMZ['BattleCore'][_0x16334e(0x997)]['call'](this,_0x371f93,_0x1ac782),!this[_0x16334e(0x9d2)]()&&_0x371f93&&_0x371f93['result']()[_0x16334e(0xb3a)]>0x0&&this[_0x16334e(0x471)]('MP',_0x371f93,_0x371f93['result']()[_0x16334e(0xb3a)]);},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x471)]=function(_0x4affb3,_0x281532,_0xb31b18){const _0x36195a=_0x4bcec6;_0x4affb3=_0x4affb3[_0x36195a(0x1fd)]()[_0x36195a(0x7d5)]();const _0x41727b=this['lifeStealRate'](_0x4affb3,_0x281532);if(_0x41727b<=0x0)return;const _0x521671=Math[_0x36195a(0x7f7)](_0xb31b18*_0x41727b);if(_0x521671<=0x0)return;let _0x52e60e=this['subject']();if(this[_0x36195a(0x380)])_0x52e60e=this['_reflectionTarget'];const _0x2e285c=_0x281532[_0x36195a(0x4b3)](_0x4affb3)?-0x1:0x1;if(_0x4affb3==='HP')_0x52e60e[_0x36195a(0x740)](_0x2e285c*_0x521671);if(_0x4affb3==='MP')_0x52e60e[_0x36195a(0x4ac)](_0x2e285c*_0x521671);},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x657)]=function(_0x1dd9f2,_0x2c8954){const _0x2b9acd=_0x4bcec6;if(this['isCancelLifeSteal'](_0x1dd9f2))return 0x0;if(this[_0x2b9acd(0x90b)]()['isDisarmLifeSteal'](_0x1dd9f2))return 0x0;if(_0x2c8954['isGuardLifeSteal'](_0x1dd9f2))return 0x0;let _0x442581=0x0;return _0x442581+=this[_0x2b9acd(0x167)](_0x1dd9f2),_0x442581+=this[_0x2b9acd(0x90b)]()[_0x2b9acd(0x657)](_0x1dd9f2,this['item']()[_0x2b9acd(0x47a)]),_0x442581[_0x2b9acd(0x775)](0x0,0x1);},Game_Action['prototype']['isCancelLifeSteal']=function(_0x2b4726){const _0x196919=_0x4bcec6;_0x2b4726=_0x2b4726[_0x196919(0x1fd)]()['trim']();const _0x4350cf=VisuMZ[_0x196919(0x377)]['LifeStealRegExp'],_0x572132=this[_0x196919(0x93c)]()[_0x196919(0x131)]||'';if(_0x572132['match'](_0x4350cf[_0x196919(0x81a)]))return!![];if(_0x2b4726==='HP'&&_0x572132['match'](_0x4350cf[_0x196919(0x46b)]))return!![];if(_0x2b4726==='MP'&&_0x572132['match'](_0x4350cf[_0x196919(0x966)]))return!![];return![];},Game_Action[_0x4bcec6(0x38e)][_0x4bcec6(0x167)]=function(_0x2563c8){const _0x155da6=_0x4bcec6,_0x3b63ae=VisuMZ[_0x155da6(0x377)]['LifeStealRegExp'],_0x29caa2=this['item']()[_0x155da6(0x131)]||'';_0x2563c8=_0x2563c8[_0x155da6(0x1fd)]()[_0x155da6(0x7d5)]();const _0x561446=_0x29caa2[_0x155da6(0x820)](_0x3b63ae[_0x155da6(0x68d)]);if(_0x561446)for(const _0x2019c7 of _0x561446){_0x2019c7[_0x155da6(0x820)](_0x3b63ae['lifeSteaItem']);const _0x579aa0=String(RegExp['$1'])[_0x155da6(0x1fd)]()[_0x155da6(0x7d5)](),_0x183fc5=Number(RegExp['$2'])*0.01;if(_0x579aa0!==_0x2563c8)continue;return _0x183fc5;}return 0x0;},Game_BattlerBase[_0x4bcec6(0x38e)][_0x4bcec6(0x657)]=function(_0x2056bc,_0x46fd3b){const _0x458cdc=_0x4bcec6,_0x5b747e=VisuMZ[_0x458cdc(0x377)][_0x458cdc(0xaec)];let _0x4f3265=0x0;_0x2056bc=_0x2056bc['toUpperCase']()[_0x458cdc(0x7d5)]();for(const _0x17dc3b of this[_0x458cdc(0x589)]()){if(!_0x17dc3b)continue;const _0x403a5a=_0x17dc3b[_0x458cdc(0x131)]||'',_0x3d4ff1=_0x403a5a[_0x458cdc(0x820)](_0x5b747e['lifeStealTrait']);if(_0x3d4ff1)for(const _0x4e1068 of _0x3d4ff1){_0x4e1068[_0x458cdc(0x820)](_0x5b747e[_0x458cdc(0x70f)]);const _0x4d5d85=String(RegExp['$1'])[_0x458cdc(0x1fd)]()[_0x458cdc(0x7d5)](),_0x26b36f=String(RegExp['$2']),_0x4ae54a=Number(RegExp['$3'])*0.01;if(_0x4d5d85!==_0x2056bc)continue;if(_0x46fd3b===Game_Action[_0x458cdc(0x26c)]&&_0x26b36f[_0x458cdc(0x820)](/CERTAIN/i))_0x4f3265+=_0x4ae54a;else{if(_0x46fd3b===Game_Action['HITTYPE_PHYSICAL']&&_0x26b36f['match'](/PHYS/i))_0x4f3265+=_0x4ae54a;else _0x46fd3b===Game_Action['HITTYPE_MAGICAL']&&_0x26b36f[_0x458cdc(0x820)](/MAGIC/i)&&(_0x4f3265+=_0x4ae54a);}}}return _0x4f3265;},Game_BattlerBase[_0x4bcec6(0x38e)][_0x4bcec6(0xaba)]=function(_0x129252){const _0x585200=_0x4bcec6;_0x129252=_0x129252[_0x585200(0x1fd)]()[_0x585200(0x7d5)]();const _0x5e97d0=VisuMZ['BattleCore'][_0x585200(0xaec)];for(const _0x16f69b of this[_0x585200(0x589)]()){if(!_0x16f69b)continue;const _0x29fd5f=_0x16f69b['note']||'';if(_0x29fd5f[_0x585200(0x820)](_0x5e97d0[_0x585200(0xb1b)]))return!![];if(_0x129252==='HP'&&_0x29fd5f['match'](_0x5e97d0[_0x585200(0x218)]))return!![];if(_0x129252==='MP'&&_0x29fd5f[_0x585200(0x820)](_0x5e97d0[_0x585200(0x484)]))return!![];}return![];},Game_BattlerBase[_0x4bcec6(0x38e)][_0x4bcec6(0x4b3)]=function(_0x3192d7){const _0x5dcc78=_0x4bcec6;_0x3192d7=_0x3192d7[_0x5dcc78(0x1fd)]()[_0x5dcc78(0x7d5)]();const _0x48d363=VisuMZ[_0x5dcc78(0x377)][_0x5dcc78(0xaec)];for(const _0x296538 of t